/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.response;

import java.io.IOException;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.rest.Redirect;
import org.apache.juneau.rest.ResponseHandler;
import org.apache.juneau.rest.RestException;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestResponse;

public final class RedirectHandler
implements ResponseHandler {
    @Override
    public boolean handle(RestRequest req, RestResponse res, Object output) throws IOException, RestException {
        if (output instanceof Redirect) {
            Redirect r = (Redirect)output;
            String uri = r.toUrl(res.getUrlEncodingSerializer());
            if (StringUtils.isEmpty((String)uri)) {
                uri = req.getServletURI();
            } else {
                char c;
                char c2 = c = uri.length() > 0 ? uri.charAt(0) : (char)'\u0000';
                if (c != '/' && uri.indexOf("://") == -1) {
                    uri = req.getServletURIBuilder().append('/').append(uri).toString();
                }
            }
            int rc = r.getHttpResponseCode();
            if (rc != 0) {
                res.setStatus(rc);
            }
            res.sendRedirect(uri);
            return true;
        }
        return false;
    }
}

