/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.labels;

import org.apache.juneau.dto.Link;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.labels.NameDescription;

public final class ResourceDescription
extends NameDescription
implements Comparable<ResourceDescription> {
    public ResourceDescription(String rootUrl, String name, String description) {
        super(new Link(name, (rootUrl.equals("/") || rootUrl.isEmpty() ? "/" : rootUrl + "/") + StringUtils.urlEncode((String)name), new Object[0]), description);
    }

    public ResourceDescription(RestRequest req, String childPath, String description) {
        super(new Link(ResourceDescription.calcName(childPath), ResourceDescription.calcHref(req, childPath), new Object[0]), description);
    }

    private static String calcName(String childPath) {
        return StringUtils.urlDecode((String)(childPath.indexOf(47) == -1 ? childPath : childPath.substring(childPath.lastIndexOf(47) + 1)));
    }

    private static String calcHref(RestRequest req, String childPath) {
        return req.getServletURIBuilder().append('/').append(childPath).toString();
    }

    public ResourceDescription(String name, String description) {
        super(new Link(name, name, new Object[0]), description);
    }

    public ResourceDescription() {
    }

    public Link getName() {
        return (Link)super.getName();
    }

    public void setName(Link name) {
        super.setName(name);
    }

    @Override
    public int compareTo(ResourceDescription o) {
        return this.getName().compareTo(o.getName());
    }

    public boolean equals(Object o) {
        return o instanceof ResourceDescription && ((ResourceDescription)o).getName().equals((Object)this.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }
}

