/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.juneau.MediaType;
import org.apache.juneau.Streamable;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.internal.StringUtils;

public class StreamResource
implements Streamable {
    private final MediaType mediaType;
    private final byte[][] contents;
    private final Map<String, String> headers;

    public StreamResource(MediaType mediaType, Object ... contents) throws IOException {
        this(mediaType, null, contents);
    }

    public StreamResource(MediaType mediaType, Map<String, Object> headers, Object ... contents) throws IOException {
        this.mediaType = mediaType;
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        if (headers != null) {
            for (Map.Entry<String, Object> e : headers.entrySet()) {
                m.put(e.getKey(), StringUtils.toString((Object)e.getValue()));
            }
        }
        this.headers = Collections.unmodifiableMap(m);
        this.contents = new byte[contents.length][];
        for (int i = 0; i < contents.length; ++i) {
            Object c = contents[i];
            if (c == null) {
                this.contents[i] = new byte[0];
                continue;
            }
            if (c instanceof byte[]) {
                this.contents[i] = (byte[])c;
                continue;
            }
            if (c instanceof InputStream) {
                this.contents[i] = IOUtils.readBytes((InputStream)((InputStream)c), (int)1024);
                continue;
            }
            if (c instanceof File) {
                this.contents[i] = IOUtils.readBytes((File)((File)c));
                continue;
            }
            if (c instanceof Reader) {
                this.contents[i] = IOUtils.read((Reader)((Reader)c)).getBytes(IOUtils.UTF8);
                continue;
            }
            if (c instanceof CharSequence) {
                this.contents[i] = ((CharSequence)c).toString().getBytes(IOUtils.UTF8);
                continue;
            }
            throw new IOException("Invalid class type passed to StreamResource: " + c.getClass().getName());
        }
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void streamTo(OutputStream os) throws IOException {
        for (byte[] b : this.contents) {
            os.write(b);
        }
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public static class Builder {
        ArrayList<Object> contents = new ArrayList();
        MediaType mediaType;
        Map<String, String> headers = new LinkedHashMap<String, String>();

        public Builder mediaType(String mediaType) {
            this.mediaType = MediaType.forString((String)mediaType);
            return this;
        }

        public Builder mediaType(MediaType mediaType) {
            this.mediaType = mediaType;
            return this;
        }

        public Builder contents(Object ... contents) {
            this.contents.addAll(Arrays.asList(contents));
            return this;
        }

        public Builder header(String name, Object value) {
            this.headers.put(name, StringUtils.toString((Object)value));
            return this;
        }

        public Builder headers(Map<String, Object> headers) {
            for (Map.Entry<String, Object> e : headers.entrySet()) {
                this.header(e.getKey(), e.getValue());
            }
            return this;
        }

        public StreamResource build() throws IOException {
            return new StreamResource(this.mediaType, new Object[]{this.headers, this.contents.toArray()});
        }
    }
}

