/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.juneau.utils.AMap;

public final class RestUtils {
    private static Map<Integer, String> httpMsgs = new AMap().append((Object)200, (Object)"OK").append((Object)201, (Object)"Created").append((Object)202, (Object)"Accepted").append((Object)203, (Object)"Non-Authoritative Information").append((Object)204, (Object)"No Content").append((Object)205, (Object)"Reset Content").append((Object)206, (Object)"Partial Content").append((Object)300, (Object)"Multiple Choices").append((Object)301, (Object)"Moved Permanently").append((Object)302, (Object)"Temporary Redirect").append((Object)303, (Object)"See Other").append((Object)304, (Object)"Not Modified").append((Object)305, (Object)"Use Proxy").append((Object)307, (Object)"Temporary Redirect").append((Object)400, (Object)"Bad Request").append((Object)401, (Object)"Unauthorized").append((Object)402, (Object)"Payment Required").append((Object)403, (Object)"Forbidden").append((Object)404, (Object)"Not Found").append((Object)405, (Object)"Method Not Allowed").append((Object)406, (Object)"Not Acceptable").append((Object)407, (Object)"Proxy Authentication Required").append((Object)408, (Object)"Request Time-Out").append((Object)409, (Object)"Conflict").append((Object)410, (Object)"Gone").append((Object)411, (Object)"Length Required").append((Object)412, (Object)"Precondition Failed").append((Object)413, (Object)"Request Entity Too Large").append((Object)414, (Object)"Request-URI Too Large").append((Object)415, (Object)"Unsupported Media Type").append((Object)500, (Object)"Internal Server Error").append((Object)501, (Object)"Not Implemented").append((Object)502, (Object)"Bad Gateway").append((Object)503, (Object)"Service Unavailable").append((Object)504, (Object)"Gateway Timeout").append((Object)505, (Object)"HTTP Version Not Supported");

    public static String getHttpResponseText(int rc) {
        return httpMsgs.get(rc);
    }

    public static String getPathInfoUndecoded(HttpServletRequest req) {
        String requestURI = req.getRequestURI();
        String contextPath = req.getContextPath();
        String servletPath = req.getServletPath();
        int l = contextPath.length() + servletPath.length();
        if (requestURI.length() == l) {
            return null;
        }
        return requestURI.substring(l);
    }

    public static StringBuffer trimPathInfo(StringBuffer requestURI, String contextPath, String servletPath) {
        if (servletPath.equals("/")) {
            servletPath = "";
        }
        if (contextPath.equals("/")) {
            contextPath = "";
        }
        try {
            int sc = 0;
            for (int i = 0; i < requestURI.length(); ++i) {
                int c = requestURI.charAt(i);
                if (c == 47) {
                    int j;
                    if (++sc != 3) continue;
                    if (servletPath.isEmpty()) {
                        requestURI.setLength(i);
                        return requestURI;
                    }
                    for (j = 0; j < contextPath.length(); ++j) {
                        if (requestURI.charAt(i) != contextPath.charAt(j)) {
                            throw new Exception("case=1");
                        }
                        ++i;
                    }
                    for (j = 0; j < servletPath.length(); ++j) {
                        if (requestURI.charAt(i) != servletPath.charAt(j)) {
                            throw new Exception("case=2");
                        }
                        ++i;
                    }
                    int n = c = requestURI.length() == i ? 47 : (int)requestURI.charAt(i);
                    if (c == 47 || c == 63) {
                        requestURI.setLength(i);
                        return requestURI;
                    }
                    throw new Exception("case=3");
                }
                if (c != 63) continue;
                if (sc != 2) {
                    throw new Exception("case=4");
                }
                if (servletPath.isEmpty()) {
                    requestURI.setLength(i);
                    return requestURI;
                }
                throw new Exception("case=5");
            }
            if (servletPath.isEmpty()) {
                return requestURI;
            }
            throw new Exception("case=6");
        }
        catch (Exception e) {
            throw new RuntimeException("Could not find servlet path in request URI.  URI=[" + requestURI + "], servletPath=[" + servletPath + "]", e);
        }
    }

    static String[] parseHeader(String s) {
        int i = s.indexOf(58);
        if (i == -1) {
            return null;
        }
        String name = s.substring(0, i).trim().toLowerCase(Locale.ENGLISH);
        String val = s.substring(i + 1).trim();
        return new String[]{name, val};
    }
}

