/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.io.IOException;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.juneau.BeanContext;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.rest.RestConfig;
import org.apache.juneau.rest.RestContext;
import org.apache.juneau.rest.RestException;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.utils.MessageBundle;

public abstract class RestServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private RestConfig config;
    private RestContext context;
    private boolean isInitialized = false;
    private Exception initException;

    public final synchronized void init(ServletConfig servletConfig) throws ServletException {
        try {
            RestConfig rsc = new RestConfig(servletConfig, ((Object)((Object)this)).getClass(), null);
            this.init(rsc);
            if (!this.isInitialized) {
                this.createContext(rsc);
                super.init(servletConfig);
            }
        }
        catch (RestException e) {
            this.initException = e;
            this.log(Level.SEVERE, e, "Servlet init error on class ''{0}''", ((Object)((Object)this)).getClass().getName());
        }
        catch (ServletException e) {
            this.initException = e;
            this.log(Level.SEVERE, e, "Servlet init error on class ''{0}''", ((Object)((Object)this)).getClass().getName());
            throw e;
        }
        catch (Exception e) {
            this.initException = e;
            this.log(Level.SEVERE, e, "Servlet init error on class ''{0}''", ((Object)((Object)this)).getClass().getName());
            throw new ServletException((Throwable)e);
        }
        catch (Throwable e) {
            this.initException = new Exception(e);
            this.log(Level.SEVERE, e, "Servlet init error on class ''{0}''", ((Object)((Object)this)).getClass().getName());
            throw new ServletException(e);
        }
        finally {
            this.isInitialized = true;
        }
    }

    public synchronized void init(RestConfig config) throws Exception {
        if (this.isInitialized) {
            return;
        }
        this.createContext(config);
        super.init((ServletConfig)config);
        this.init(this.context);
    }

    public synchronized void init(RestContext context) throws Exception {
    }

    private synchronized void createContext(RestConfig config) throws Exception {
        if (this.isInitialized) {
            return;
        }
        this.config = config;
        this.context = new RestContext((Object)this, config);
        this.isInitialized = true;
    }

    public void service(HttpServletRequest r1, HttpServletResponse r2) throws ServletException, IOException {
        try {
            if (this.initException != null) {
                if (this.initException instanceof RestException) {
                    throw (RestException)this.initException;
                }
                throw new RestException(500, (Throwable)this.initException);
            }
            if (this.context == null) {
                throw new RestException(500, "Servlet not initialized.  init(RestServletConfig) was not called.", new Object[0]);
            }
            if (!this.isInitialized) {
                throw new RestException(500, "Servlet has not been initialized", new Object[0]);
            }
            this.context.getCallHandler().service(r1, r2);
        }
        catch (RestException e) {
            r2.sendError(500, e.getLocalizedMessage());
        }
        catch (Throwable e) {
            r2.sendError(500, e.getLocalizedMessage());
        }
    }

    protected RestContext getContext() {
        return this.context;
    }

    protected void onSuccess(RestRequest req, RestResponse res, long time) {
    }

    protected void onPreCall(RestRequest req) throws RestException {
    }

    protected void onPostCall(RestRequest req, RestResponse res) throws RestException {
    }

    protected void log(Level level, String msg, Object ... args) {
        if (this.context != null) {
            this.context.getLogger().log(level, msg, args);
        }
    }

    protected void log(Level level, Throwable cause, String msg, Object ... args) {
        if (this.context != null) {
            this.context.getLogger().log(level, cause, msg, args);
        }
    }

    public RestConfig getServletConfig() {
        return this.config;
    }

    public void destroy() {
        if (this.context != null) {
            this.context.destroy();
        }
        super.destroy();
    }

    public MessageBundle getMessages() {
        return this.context.getMessages();
    }

    public ObjectMap getProperties() {
        return this.getContext().getProperties();
    }

    public BeanContext getBeanContext() {
        return this.getContext().getBeanContext();
    }
}

