/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.juneau.internal.JuneauLogger;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.rest.RestException;

public abstract class RestLogger {
    protected abstract Logger getLogger();

    protected abstract void log(Level var1, Throwable var2, String var3, Object ... var4);

    protected void log(Level level, String msg, Object ... args) {
        this.log(level, null, msg, args);
    }

    protected void logObjects(Level level, String msg, Object ... args) {
        for (int i = 0; i < args.length; ++i) {
            args[i] = JsonSerializer.DEFAULT_LAX_READABLE.toStringObject(args[i]);
        }
        this.log(level, null, msg, args);
    }

    protected void onError(HttpServletRequest req, HttpServletResponse res, RestException e) {
        if (this.shouldLog(req, res, e)) {
            String qs = req.getQueryString();
            String msg = "HTTP " + req.getMethod() + " " + e.getStatus() + " " + req.getRequestURI() + (qs == null ? "" : "?" + qs);
            int c = e.getOccurrence();
            if (this.shouldLogStackTrace(req, res, e)) {
                msg = '[' + Integer.toHexString(e.hashCode()) + '.' + e.getStatus() + '.' + c + "] " + msg;
                this.log(Level.WARNING, e, msg, new Object[0]);
            } else {
                msg = '[' + Integer.toHexString(e.hashCode()) + '.' + e.getStatus() + '.' + c + "] " + msg + ", " + e.getLocalizedMessage();
                this.log(Level.WARNING, msg, new Object[0]);
            }
        }
    }

    protected boolean shouldLog(HttpServletRequest req, HttpServletResponse res, RestException e) {
        return !RestLogger.isNoTrace(req) || RestLogger.isDebug(req);
    }

    protected boolean shouldLogStackTrace(HttpServletRequest req, HttpServletResponse res, RestException e) {
        if (e.getOccurrence() == 1) {
            switch (e.getStatus()) {
                case 401: 
                case 403: 
                case 404: {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private static boolean isNoTrace(HttpServletRequest req) {
        return "true".equals(req.getHeader("No-Trace")) || req.getQueryString() != null && req.getQueryString().contains("noTrace=true");
    }

    private static boolean isDebug(HttpServletRequest req) {
        return "true".equals(req.getHeader("Debug"));
    }

    public static class Normal
    extends RestLogger {
        private final JuneauLogger logger = JuneauLogger.getLogger(this.getClass());

        @Override
        protected Logger getLogger() {
            return this.logger;
        }

        @Override
        protected void log(Level level, Throwable cause, String msg, Object ... args) {
            if (args.length > 0) {
                msg = MessageFormat.format(msg, args);
            }
            this.getLogger().log(level, msg, cause);
        }
    }

    public static class NoOp
    extends RestLogger {
        @Override
        protected Logger getLogger() {
            return null;
        }

        @Override
        protected void log(Level level, Throwable cause, String msg, Object ... args) {
        }
    }
}

