/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.MediaType;
import org.apache.juneau.dto.swagger.Contact;
import org.apache.juneau.dto.swagger.ExternalDocumentation;
import org.apache.juneau.dto.swagger.Info;
import org.apache.juneau.dto.swagger.License;
import org.apache.juneau.dto.swagger.Operation;
import org.apache.juneau.dto.swagger.Swagger;
import org.apache.juneau.dto.swagger.SwaggerBuilder;
import org.apache.juneau.dto.swagger.Tag;
import org.apache.juneau.internal.ReflectionUtils;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.rest.CallMethod;
import org.apache.juneau.rest.RestContext;
import org.apache.juneau.rest.RestException;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.annotation.RestResource;
import org.apache.juneau.svl.VarResolverSession;

public class RestInfoProvider {
    private final RestContext context;
    private final String title;
    private final String description;
    private final String termsOfService;
    private final String contact;
    private final String license;
    private final String version;
    private final String tags;
    private final String externalDocs;
    private final ConcurrentHashMap<Locale, Swagger> swaggers = new ConcurrentHashMap();

    public RestInfoProvider(RestContext context) {
        this.context = context;
        Builder b = new Builder(context);
        this.title = b.title;
        this.description = b.description;
        this.termsOfService = b.termsOfService;
        this.contact = b.contact;
        this.license = b.license;
        this.version = b.version;
        this.tags = b.tags;
        this.externalDocs = b.externalDocs;
    }

    protected Swagger getSwagger(RestRequest req) throws RestException {
        try {
            Swagger s = req.getSwaggerFromFile();
            if (s != null) {
                return s;
            }
            s = SwaggerBuilder.swagger((Info)SwaggerBuilder.info((String)this.getTitle(req), (String)this.getVersion(req)).contact(this.getContact(req)).license(this.getLicense(req)).description(this.getDescription(req)).termsOfService(this.getTermsOfService(req))).consumes(this.context.getSupportedAcceptTypes()).produces(this.context.getSupportedContentTypes()).tags(this.getTags(req)).externalDocs(this.getExternalDocs(req));
            for (CallMethod sm : this.context.getCallMethods().values()) {
                if (!sm.isRequestAllowed(req)) continue;
                Operation o = sm.getSwaggerOperation(req);
                s.path(sm.getPathPattern(), sm.getHttpMethod().toLowerCase(), o);
            }
            return s;
        }
        catch (RestException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RestException(500, (Throwable)e);
        }
    }

    protected Swagger getSwaggerFromFile(Locale locale) throws RestException {
        Swagger s = this.swaggers.get(locale);
        if (s == null) {
            try {
                s = this.context.getResource(Swagger.class, MediaType.JSON, this.getClass().getSimpleName() + ".json", locale);
                this.swaggers.putIfAbsent(locale, s == null ? Swagger.NULL : s);
            }
            catch (Exception e) {
                throw new RestException(500, (Throwable)e);
            }
        }
        return s == Swagger.NULL ? null : s;
    }

    public String getMethodSummary(String javaMethodName, RestRequest req) {
        CallMethod m = this.context.getCallMethods().get(javaMethodName);
        if (m != null) {
            return m.getSummary(req);
        }
        return "";
    }

    protected String getMethodDescription(String javaMethodName, RestRequest req) {
        CallMethod m = this.context.getCallMethods().get(javaMethodName);
        if (m != null) {
            return m.getDescription(req);
        }
        return "";
    }

    public String getTitle(RestRequest req) {
        VarResolverSession vr = req.getVarResolverSession();
        if (this.title != null) {
            return vr.resolve(this.title);
        }
        String title = this.context.getMessages().findFirstString(req.getLocale(), new String[]{"title"});
        if (title != null) {
            return vr.resolve(title);
        }
        Swagger s = req.getSwaggerFromFile();
        if (s != null && s.getInfo() != null) {
            return s.getInfo().getTitle();
        }
        return null;
    }

    public String getDescription(RestRequest req) {
        VarResolverSession vr = req.getVarResolverSession();
        if (this.description != null) {
            return vr.resolve(this.description);
        }
        String description = this.context.getMessages().findFirstString(req.getLocale(), new String[]{"description"});
        if (description != null) {
            return vr.resolve(description);
        }
        Swagger s = req.getSwaggerFromFile();
        if (s != null && s.getInfo() != null) {
            return s.getInfo().getDescription();
        }
        return null;
    }

    public Contact getContact(RestRequest req) {
        VarResolverSession vr = req.getVarResolverSession();
        JsonParser jp = JsonParser.DEFAULT;
        try {
            if (this.contact != null) {
                return (Contact)jp.parse((Object)vr.resolve(this.contact), Contact.class);
            }
            String contact = this.context.getMessages().findFirstString(req.getLocale(), new String[]{"contact"});
            if (contact != null) {
                return (Contact)jp.parse((Object)vr.resolve(contact), Contact.class);
            }
            Swagger s = req.getSwaggerFromFile();
            if (s != null && s.getInfo() != null) {
                return s.getInfo().getContact();
            }
            return null;
        }
        catch (ParseException e) {
            throw new RestException(500, (Throwable)e);
        }
    }

    public License getLicense(RestRequest req) {
        VarResolverSession vr = req.getVarResolverSession();
        JsonParser jp = JsonParser.DEFAULT;
        try {
            if (this.license != null) {
                return (License)jp.parse((Object)vr.resolve(this.license), License.class);
            }
            String license = this.context.getMessages().findFirstString(req.getLocale(), new String[]{"license"});
            if (license != null) {
                return (License)jp.parse((Object)vr.resolve(license), License.class);
            }
            Swagger s = req.getSwaggerFromFile();
            if (s != null && s.getInfo() != null) {
                return s.getInfo().getLicense();
            }
            return null;
        }
        catch (ParseException e) {
            throw new RestException(500, (Throwable)e);
        }
    }

    public String getTermsOfService(RestRequest req) {
        VarResolverSession vr = req.getVarResolverSession();
        if (this.termsOfService != null) {
            return vr.resolve(this.termsOfService);
        }
        String termsOfService = this.context.getMessages().findFirstString(req.getLocale(), new String[]{"termsOfService"});
        if (termsOfService != null) {
            return vr.resolve(termsOfService);
        }
        Swagger s = req.getSwaggerFromFile();
        if (s != null && s.getInfo() != null) {
            return s.getInfo().getTermsOfService();
        }
        return null;
    }

    public String getVersion(RestRequest req) {
        VarResolverSession vr = req.getVarResolverSession();
        if (this.version != null) {
            return vr.resolve(this.version);
        }
        String version = this.context.getMessages().findFirstString(req.getLocale(), new String[]{"version"});
        if (version != null) {
            return vr.resolve(version);
        }
        Swagger s = req.getSwaggerFromFile();
        if (s != null && s.getInfo() != null) {
            return s.getInfo().getVersion();
        }
        return null;
    }

    public List<Tag> getTags(RestRequest req) {
        VarResolverSession vr = req.getVarResolverSession();
        JsonParser jp = JsonParser.DEFAULT;
        try {
            if (this.tags != null) {
                return (List)jp.parse((Object)vr.resolve(this.tags), ArrayList.class, new Type[]{Tag.class});
            }
            String tags = this.context.getMessages().findFirstString(req.getLocale(), new String[]{"tags"});
            if (tags != null) {
                return (List)jp.parse((Object)vr.resolve(tags), ArrayList.class, new Type[]{Tag.class});
            }
            Swagger s = req.getSwaggerFromFile();
            if (s != null) {
                return s.getTags();
            }
            return null;
        }
        catch (Exception e) {
            throw new RestException(500, (Throwable)e);
        }
    }

    public ExternalDocumentation getExternalDocs(RestRequest req) {
        VarResolverSession vr = req.getVarResolverSession();
        JsonParser jp = JsonParser.DEFAULT;
        try {
            if (this.externalDocs != null) {
                return (ExternalDocumentation)jp.parse((Object)vr.resolve(this.externalDocs), ExternalDocumentation.class);
            }
            String externalDocs = this.context.getMessages().findFirstString(req.getLocale(), new String[]{"externalDocs"});
            if (externalDocs != null) {
                return (ExternalDocumentation)jp.parse((Object)vr.resolve(externalDocs), ExternalDocumentation.class);
            }
            Swagger s = req.getSwaggerFromFile();
            if (s != null) {
                return s.getExternalDocs();
            }
            return null;
        }
        catch (Exception e) {
            throw new RestException(500, (Throwable)e);
        }
    }

    private static class Builder {
        private String title;
        private String description;
        private String termsOfService;
        private String contact;
        private String license;
        private String version;
        private String tags;
        private String externalDocs;

        Builder(RestContext context) {
            LinkedHashMap restResourceAnnotationsParentFirst = ReflectionUtils.findAnnotationsMapParentFirst(RestResource.class, context.getResource().getClass());
            for (RestResource r : restResourceAnnotationsParentFirst.values()) {
                if (!r.title().isEmpty()) {
                    this.title = r.title();
                }
                if (!r.description().isEmpty()) {
                    this.description = r.description();
                }
                if (!r.termsOfService().isEmpty()) {
                    this.termsOfService = r.termsOfService();
                }
                if (!r.contact().isEmpty()) {
                    this.contact = r.contact();
                }
                if (!r.license().isEmpty()) {
                    this.license = r.license();
                }
                if (!r.version().isEmpty()) {
                    this.version = r.version();
                }
                if (!r.tags().isEmpty()) {
                    this.tags = r.tags();
                }
                if (r.externalDocs().isEmpty()) continue;
                this.externalDocs = r.externalDocs();
            }
        }
    }
}

