/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.rest.CallRouter;
import org.apache.juneau.rest.ResponseHandler;
import org.apache.juneau.rest.RestContext;
import org.apache.juneau.rest.RestConverter;
import org.apache.juneau.rest.RestException;
import org.apache.juneau.rest.RestLogger;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.rest.RestServlet;
import org.apache.juneau.rest.RestUtils;
import org.apache.juneau.rest.StreamResource;

public class RestCallHandler {
    private final RestContext context;
    private final RestLogger logger;
    private final RestServlet restServlet;
    private final Map<String, CallRouter> callRouters;

    public RestCallHandler(RestContext context) {
        this.context = context;
        this.logger = context.getLogger();
        this.callRouters = context.getCallRouters();
        this.restServlet = context.getRestServlet();
    }

    protected RestRequest createRequest(HttpServletRequest req) throws ServletException {
        return new RestRequest(this.context, req);
    }

    protected RestResponse createResponse(RestRequest req, HttpServletResponse res) throws ServletException {
        return new RestResponse(this.context, req, res);
    }

    protected void service(HttpServletRequest r1, HttpServletResponse r2) throws ServletException, IOException {
        this.logger.log(Level.FINE, "HTTP: {0} {1}", r1.getMethod(), r1.getRequestURI());
        long startTime = System.currentTimeMillis();
        try {
            int i;
            String pathInfoPart;
            RestContext childResource;
            this.context.checkForInitException();
            String pathInfo = RestUtils.getPathInfoUndecoded(r1);
            if (pathInfo != null && this.context.hasChildResources() && !pathInfo.equals("/") && (childResource = this.context.getChildResource(pathInfoPart = (i = pathInfo.indexOf(47, 1)) == -1 ? pathInfo.substring(1) : pathInfo.substring(1, i))) != null) {
                final String pathInfoRemainder = i == -1 ? null : pathInfo.substring(i);
                final String servletPath = r1.getServletPath() + "/" + pathInfoPart;
                HttpServletRequestWrapper childRequest = new HttpServletRequestWrapper(r1){

                    public String getPathInfo() {
                        return StringUtils.urlDecode((String)pathInfoRemainder);
                    }

                    public String getServletPath() {
                        return servletPath;
                    }
                };
                childResource.getCallHandler().service((HttpServletRequest)childRequest, r2);
                return;
            }
            RestRequest req = this.createRequest(r1);
            RestResponse res = this.createResponse(req, r2);
            String method = req.getMethod();
            String methodUC = method.toUpperCase(Locale.ENGLISH);
            StreamResource r = null;
            if (pathInfo != null) {
                String p = pathInfo.substring(1);
                if (p.equals("favicon.ico")) {
                    r = this.context.getFavIcon();
                } else if (p.equals("style.css")) {
                    r = this.context.getStyleSheet();
                } else if (this.context.isStaticFile(p)) {
                    r = this.context.resolveStaticFile(p);
                }
            }
            if (r != null) {
                res.setStatus(200);
                res.setOutput(r);
            } else {
                int rc = 405;
                if (this.callRouters.containsKey(methodUC)) {
                    rc = this.callRouters.get(methodUC).invoke(pathInfo, req, res);
                } else if (this.callRouters.containsKey("*")) {
                    rc = this.callRouters.get("*").invoke(pathInfo, req, res);
                }
                if (rc != 200) {
                    this.handleNotFound(rc, req, res);
                }
            }
            if (res.hasOutput()) {
                Object output = res.getOutput();
                for (RestConverter converter : this.context.getConverters()) {
                    output = converter.convert(req, output, this.context.getBeanContext().getClassMetaForObject(output));
                }
                res.setOutput(output);
                this.handleResponse(req, res, output);
            }
            this.onSuccess(req, res, System.currentTimeMillis() - startTime);
        }
        catch (RestException e) {
            this.handleError(r1, r2, e);
        }
        catch (Throwable e) {
            this.handleError(r1, r2, new RestException(500, e));
        }
        this.logger.log(Level.FINE, "HTTP: [{0} {1}] finished in {2}ms", r1.getMethod(), r1.getRequestURI(), System.currentTimeMillis() - startTime);
    }

    protected void handleResponse(RestRequest req, RestResponse res, Object output) throws IOException, RestException {
        for (ResponseHandler h : this.context.getResponseHandlers()) {
            if (!h.handle(req, res, output)) continue;
            return;
        }
        throw new RestException(501, "No response handlers found to process output of type '" + (output == null ? null : output.getClass().getName()) + "'", new Object[0]);
    }

    protected void handleNotFound(int rc, RestRequest req, RestResponse res) throws Exception {
        String onPath;
        String pathInfo = req.getPathInfo();
        String methodUC = req.getMethod();
        String string = onPath = pathInfo == null ? " on no pathInfo" : String.format(" on path '%s'", pathInfo);
        if (rc == 404) {
            throw new RestException(rc, "Method ''{0}'' not found on resource with matching pattern{1}.", methodUC, onPath);
        }
        if (rc == 412) {
            throw new RestException(rc, "Method ''{0}'' not found on resource{1} with matching matcher.", methodUC, onPath);
        }
        if (rc == 405) {
            throw new RestException(rc, "Method ''{0}'' not found on resource.", methodUC);
        }
        throw new ServletException("Invalid method response: " + rc);
    }

    protected synchronized void handleError(HttpServletRequest req, HttpServletResponse res, RestException e) throws IOException {
        e.setOccurrence(this.context == null ? 0 : this.context.getStackTraceOccurrence(e));
        this.logger.onError(req, res, e);
        this.renderError(req, res, e);
    }

    protected void renderError(HttpServletRequest req, HttpServletResponse res, RestException e) throws IOException {
        int status = e.getStatus();
        res.setStatus(status);
        res.setContentType("text/plain");
        res.setHeader("Content-Encoding", "identity");
        Throwable t = e.getRootCause();
        if (t != null) {
            res.setHeader("Exception-Name", t.getClass().getName());
            res.setHeader("Exception-Message", t.getMessage());
        }
        PrintWriter w = null;
        try {
            w = res.getWriter();
        }
        catch (IllegalStateException e2) {
            w = new PrintWriter(new OutputStreamWriter((OutputStream)res.getOutputStream(), IOUtils.UTF8));
        }
        String httpMessage = RestUtils.getHttpResponseText(status);
        if (httpMessage != null) {
            w.append("HTTP ").append(String.valueOf(status)).append(": ").append(httpMessage).append("\n\n");
        }
        if (this.context != null && this.context.isRenderResponseStackTraces()) {
            e.printStackTrace(w);
        } else {
            w.append(e.getFullStackMessage(true));
        }
        w.flush();
        w.close();
    }

    protected void onSuccess(RestRequest req, RestResponse res, long time) {
        if (this.restServlet != null) {
            this.restServlet.onSuccess(req, res, time);
        }
    }

    protected void onPreCall(RestRequest req) throws RestException {
        if (this.restServlet != null) {
            this.restServlet.onPreCall(req);
        }
    }

    protected void onPostCall(RestRequest req, RestResponse res) throws RestException {
        if (this.restServlet != null) {
            this.restServlet.onPostCall(req, res);
        }
    }

    public Map<String, Object> getSessionObjects(RestRequest req) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("req", (Object)req);
        return m;
    }
}

