/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.InvalidDataConversionException;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.dto.swagger.ExternalDocumentation;
import org.apache.juneau.dto.swagger.HeaderInfo;
import org.apache.juneau.dto.swagger.Items;
import org.apache.juneau.dto.swagger.Operation;
import org.apache.juneau.dto.swagger.ParameterInfo;
import org.apache.juneau.dto.swagger.ResponseInfo;
import org.apache.juneau.dto.swagger.SchemaInfo;
import org.apache.juneau.dto.swagger.Swagger;
import org.apache.juneau.dto.swagger.SwaggerBuilder;
import org.apache.juneau.encoders.Encoder;
import org.apache.juneau.encoders.EncoderGroup;
import org.apache.juneau.encoders.EncoderGroupBuilder;
import org.apache.juneau.encoders.IdentityEncoder;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.internal.Utils;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.ParserGroup;
import org.apache.juneau.parser.ParserGroupBuilder;
import org.apache.juneau.rest.ClientVersionMatcher;
import org.apache.juneau.rest.RestContext;
import org.apache.juneau.rest.RestConverter;
import org.apache.juneau.rest.RestException;
import org.apache.juneau.rest.RestGuard;
import org.apache.juneau.rest.RestMatcher;
import org.apache.juneau.rest.RestMatcherReflecting;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.rest.RestServletException;
import org.apache.juneau.rest.RestUtils;
import org.apache.juneau.rest.UrlPathPattern;
import org.apache.juneau.rest.annotation.Body;
import org.apache.juneau.rest.annotation.FormData;
import org.apache.juneau.rest.annotation.HasFormData;
import org.apache.juneau.rest.annotation.HasQuery;
import org.apache.juneau.rest.annotation.Header;
import org.apache.juneau.rest.annotation.Inherit;
import org.apache.juneau.rest.annotation.Messages;
import org.apache.juneau.rest.annotation.Method;
import org.apache.juneau.rest.annotation.Parameter;
import org.apache.juneau.rest.annotation.Path;
import org.apache.juneau.rest.annotation.PathRemainder;
import org.apache.juneau.rest.annotation.Properties;
import org.apache.juneau.rest.annotation.Property;
import org.apache.juneau.rest.annotation.Query;
import org.apache.juneau.rest.annotation.Response;
import org.apache.juneau.rest.annotation.RestMethod;
import org.apache.juneau.serializer.SerializerGroup;
import org.apache.juneau.serializer.SerializerGroupBuilder;
import org.apache.juneau.svl.VarResolverSession;
import org.apache.juneau.urlencoding.UrlEncodingParser;
import org.apache.juneau.urlencoding.UrlEncodingParserBuilder;
import org.apache.juneau.urlencoding.UrlEncodingSerializer;

class CallMethod
implements Comparable<CallMethod> {
    private final java.lang.reflect.Method method;
    private final String httpMethod;
    private final UrlPathPattern pathPattern;
    private final MethodParam[] params;
    private final RestGuard[] guards;
    private final RestMatcher[] optionalMatchers;
    private final RestMatcher[] requiredMatchers;
    private final RestConverter[] converters;
    private final SerializerGroup serializers;
    private final ParserGroup parsers;
    private final EncoderGroup encoders;
    private final UrlEncodingParser urlEncodingParser;
    private final UrlEncodingSerializer urlEncodingSerializer;
    private final ObjectMap properties;
    private final Map<String, String> defaultRequestHeaders;
    private final String defaultCharset;
    private final boolean deprecated;
    private final String description;
    private final String tags;
    private final String summary;
    private final String externalDocs;
    private final Integer priority;
    private final Parameter[] parameters;
    private final Response[] responses;
    private final RestContext context;
    private final String pageTitle;
    private final String pageText;
    private final String pageLinks;

    CallMethod(Object servlet, java.lang.reflect.Method method, RestContext context) throws RestServletException {
        Builder b = new Builder(servlet, method, context);
        this.context = context;
        this.method = method;
        this.httpMethod = b.httpMethod;
        this.pathPattern = b.pathPattern;
        this.params = b.params;
        this.guards = b.guards;
        this.optionalMatchers = b.optionalMatchers;
        this.requiredMatchers = b.requiredMatchers;
        this.converters = b.converters;
        this.serializers = b.serializers;
        this.parsers = b.parsers;
        this.encoders = b.encoders;
        this.urlEncodingParser = b.urlEncodingParser;
        this.urlEncodingSerializer = b.urlEncodingSerializer;
        this.properties = b.properties;
        this.defaultRequestHeaders = b.defaultRequestHeaders;
        this.defaultCharset = b.defaultCharset;
        this.deprecated = b.deprecated;
        this.description = b.description;
        this.tags = b.tags;
        this.summary = b.summary;
        this.externalDocs = b.externalDocs;
        this.priority = b.priority;
        this.parameters = b.parameters;
        this.responses = b.responses;
        this.pageTitle = b.pageTitle;
        this.pageText = b.pageText;
        this.pageLinks = b.pageLinks;
    }

    boolean hasGuardsOrMatchers() {
        return this.guards.length != 0 || this.requiredMatchers.length != 0 || this.optionalMatchers.length != 0;
    }

    String getHttpMethod() {
        return this.httpMethod;
    }

    String getPathPattern() {
        return this.pathPattern.toString();
    }

    Operation getSwaggerOperation(RestRequest req) throws ParseException {
        Operation o = SwaggerBuilder.operation().operationId(this.method.getName()).description(this.getDescription(req)).tags(this.getTags(req)).summary(this.getSummary(req)).externalDocs(this.getExternalDocs(req)).parameters(this.getParameters(req)).responses(this.getResponses(req));
        if (this.isDeprecated()) {
            o.deprecated(Boolean.valueOf(true));
        }
        if (!this.parsers.getSupportedMediaTypes().equals(this.context.getParsers().getSupportedMediaTypes())) {
            o.consumes((Collection)this.parsers.getSupportedMediaTypes());
        }
        if (!this.serializers.getSupportedMediaTypes().equals(this.context.getSerializers().getSupportedMediaTypes())) {
            o.produces((Collection)this.serializers.getSupportedMediaTypes());
        }
        return o;
    }

    private Operation getSwaggerOperationFromFile(RestRequest req) {
        Swagger s = req.getSwaggerFromFile();
        if (s != null && s.getPaths() != null && s.getPaths().get(this.pathPattern.getPatternString()) != null) {
            return (Operation)((Map)s.getPaths().get(this.pathPattern.getPatternString())).get(this.httpMethod);
        }
        return null;
    }

    String getSummary(RestRequest req) {
        VarResolverSession vr = req.getVarResolverSession();
        if (this.summary != null) {
            return vr.resolve(this.summary);
        }
        String summary = this.context.getMessages().findFirstString(req.getLocale(), new String[]{this.method.getName() + ".summary"});
        if (summary != null) {
            return vr.resolve(summary);
        }
        Operation o = this.getSwaggerOperationFromFile(req);
        if (o != null) {
            return o.getSummary();
        }
        return null;
    }

    String getDescription(RestRequest req) {
        VarResolverSession vr = req.getVarResolverSession();
        if (this.description != null) {
            return vr.resolve(this.description);
        }
        String description = this.context.getMessages().findFirstString(req.getLocale(), new String[]{this.method.getName() + ".description"});
        if (description != null) {
            return vr.resolve(description);
        }
        Operation o = this.getSwaggerOperationFromFile(req);
        if (o != null) {
            return o.getDescription();
        }
        return null;
    }

    private List<String> getTags(RestRequest req) {
        VarResolverSession vr = req.getVarResolverSession();
        JsonParser jp = JsonParser.DEFAULT;
        try {
            if (this.tags != null) {
                return (List)jp.parse((Object)vr.resolve(this.tags), ArrayList.class, new Type[]{String.class});
            }
            String tags = this.context.getMessages().findFirstString(req.getLocale(), new String[]{this.method.getName() + ".tags"});
            if (tags != null) {
                return (List)jp.parse((Object)vr.resolve(tags), ArrayList.class, new Type[]{String.class});
            }
            Operation o = this.getSwaggerOperationFromFile(req);
            if (o != null) {
                return o.getTags();
            }
            return null;
        }
        catch (Exception e) {
            throw new RestException(500, (Throwable)e);
        }
    }

    private ExternalDocumentation getExternalDocs(RestRequest req) {
        VarResolverSession vr = req.getVarResolverSession();
        JsonParser jp = JsonParser.DEFAULT;
        try {
            if (this.externalDocs != null) {
                return (ExternalDocumentation)jp.parse((Object)vr.resolve(this.externalDocs), ExternalDocumentation.class);
            }
            String externalDocs = this.context.getMessages().findFirstString(req.getLocale(), new String[]{this.method.getName() + ".externalDocs"});
            if (externalDocs != null) {
                return (ExternalDocumentation)jp.parse((Object)vr.resolve(externalDocs), ExternalDocumentation.class);
            }
            Operation o = this.getSwaggerOperationFromFile(req);
            if (o != null) {
                return o.getExternalDocs();
            }
            return null;
        }
        catch (Exception e) {
            throw new RestException(500, (Throwable)e);
        }
    }

    private boolean isDeprecated() {
        return this.deprecated;
    }

    private List<ParameterInfo> getParameters(RestRequest req) throws ParseException {
        String in;
        Operation o = this.getSwaggerOperationFromFile(req);
        if (o != null && o.getParameters() != null) {
            return o.getParameters();
        }
        VarResolverSession vr = req.getVarResolverSession();
        JsonParser jp = JsonParser.DEFAULT;
        TreeMap<String, ParameterInfo> m = new TreeMap<String, ParameterInfo>();
        for (Parameter v : this.parameters) {
            String in2 = vr.resolve(v.in());
            ParameterInfo p = SwaggerBuilder.parameterInfo((String)in2, (String)vr.resolve(v.name()));
            if (!v.description().isEmpty()) {
                p.description(vr.resolve(v.description()));
            }
            if (v.required()) {
                p.required(Boolean.valueOf(v.required()));
            }
            if ("body".equals(in2)) {
                if (!v.schema().isEmpty()) {
                    p.schema((SchemaInfo)jp.parse((Object)vr.resolve(v.schema()), SchemaInfo.class));
                }
            } else {
                if (v.allowEmptyValue()) {
                    p.allowEmptyValue(Boolean.valueOf(v.allowEmptyValue()));
                }
                if (!v.collectionFormat().isEmpty()) {
                    p.collectionFormat(vr.resolve(v.collectionFormat()));
                }
                if (!v._default().isEmpty()) {
                    p._default((Object)vr.resolve(v._default()));
                }
                if (!v.format().isEmpty()) {
                    p.format(vr.resolve(v.format()));
                }
                if (!v.items().isEmpty()) {
                    p.items((Items)jp.parse((Object)vr.resolve(v.items()), Items.class));
                }
                p.type(vr.resolve(v.type()));
            }
            m.put(p.getIn() + '.' + p.getName(), p);
        }
        String prefix = this.method.getName() + ".req";
        for (String key : this.context.getMessages().keySet(prefix)) {
            boolean isBody;
            if (key.length() <= prefix.length()) continue;
            String value = vr.resolve(this.context.getMessages().getString(key));
            String[] parts = key.substring(prefix.length() + 1).split("\\.");
            if (parts.length == ((isBody = "body".equals(in = parts[0])) ? 2 : 3)) {
                String field;
                String name;
                if ("body".equals(in)) {
                    name = null;
                    field = parts[1];
                } else {
                    name = parts[1];
                    field = parts[2];
                }
                String k2 = in + '.' + name;
                ParameterInfo p = (ParameterInfo)m.get(k2);
                if (p == null) {
                    p = SwaggerBuilder.parameterInfoStrict((String)in, (String)name);
                    m.put(k2, p);
                }
                if (field.equals("description")) {
                    p.description(value);
                } else if (field.equals("required")) {
                    p.required(Boolean.valueOf(value));
                }
                if ("body".equals(in)) {
                    if (!field.equals("schema")) continue;
                    p.schema((SchemaInfo)jp.parse((Object)value, SchemaInfo.class));
                    continue;
                }
                if (field.equals("allowEmptyValue")) {
                    p.allowEmptyValue(Boolean.valueOf(value));
                    continue;
                }
                if (field.equals("collectionFormat")) {
                    p.collectionFormat(value);
                    continue;
                }
                if (field.equals("default")) {
                    p._default((Object)value);
                    continue;
                }
                if (field.equals("format")) {
                    p.format(value);
                    continue;
                }
                if (field.equals("items")) {
                    p.items((Items)jp.parse((Object)value, Items.class));
                    continue;
                }
                if (!field.equals("type")) continue;
                p.type(value);
                continue;
            }
            System.err.println("Unknown bundle key '" + key + "'");
        }
        for (MethodParam mp : this.params) {
            String k2;
            ParameterInfo p;
            in = mp.paramType.getSwaggerParameterType();
            if (in == null || (p = (ParameterInfo)m.get(k2 = in + '.' + ("body".equals(in) ? null : mp.name))) != null) continue;
            p = SwaggerBuilder.parameterInfoStrict((String)in, (String)mp.name);
            m.put(k2, p);
        }
        if (m.isEmpty()) {
            return null;
        }
        return new ArrayList<ParameterInfo>(m.values());
    }

    private Map<Integer, ResponseInfo> getResponses(RestRequest req) throws ParseException {
        HeaderInfo h;
        ResponseInfo r2;
        Operation o = this.getSwaggerOperationFromFile(req);
        if (o != null && o.getResponses() != null) {
            return o.getResponses();
        }
        VarResolverSession vr = req.getVarResolverSession();
        JsonParser jp = JsonParser.DEFAULT;
        TreeMap<Integer, ResponseInfo> m = new TreeMap<Integer, ResponseInfo>();
        TreeMap<String, HeaderInfo> m2 = new TreeMap<String, HeaderInfo>();
        for (Response r : this.responses) {
            int httpCode = r.value();
            String description = r.description().isEmpty() ? RestUtils.getHttpResponseText(r.value()) : vr.resolve(r.description());
            r2 = SwaggerBuilder.responseInfo((String)description);
            if (r.headers().length > 0) {
                for (Parameter v : r.headers()) {
                    h = SwaggerBuilder.headerInfoStrict((String)vr.resolve(v.type()));
                    if (!v.collectionFormat().isEmpty()) {
                        h.collectionFormat(vr.resolve(v.collectionFormat()));
                    }
                    if (!v._default().isEmpty()) {
                        h._default((Object)vr.resolve(v._default()));
                    }
                    if (!v.description().isEmpty()) {
                        h.description(vr.resolve(v.description()));
                    }
                    if (!v.format().isEmpty()) {
                        h.format(vr.resolve(v.format()));
                    }
                    if (!v.items().isEmpty()) {
                        h.items((Items)jp.parse((Object)vr.resolve(v.items()), Items.class));
                    }
                    r2.header(v.name(), h);
                    m2.put(httpCode + 46 + v.name(), h);
                }
            }
            m.put(httpCode, r2);
        }
        String prefix = this.method.getName() + ".res";
        for (String key : this.context.getMessages().keySet(prefix)) {
            String name;
            if (key.length() <= prefix.length()) continue;
            String value = vr.resolve(this.context.getMessages().getString(key));
            String[] parts = key.substring(prefix.length() + 1).split("\\.");
            int httpCode = Integer.parseInt(parts[0]);
            r2 = (ResponseInfo)m.get(httpCode);
            if (r2 == null) {
                r2 = SwaggerBuilder.responseInfo(null);
                m.put(httpCode, r2);
            }
            String string = name = parts.length > 1 ? parts[1] : "";
            if ("header".equals(name) && parts.length > 3) {
                String headerName = parts[2];
                String field = parts[3];
                String k2 = httpCode + 46 + headerName;
                h = (HeaderInfo)m2.get(k2);
                if (h == null) {
                    h = SwaggerBuilder.headerInfoStrict((String)"string");
                    m2.put(k2, h);
                    r2.header(name, h);
                }
                if (field.equals("collectionFormat")) {
                    h.collectionFormat(value);
                    continue;
                }
                if (field.equals("default")) {
                    h._default((Object)value);
                    continue;
                }
                if (field.equals("description")) {
                    h.description(value);
                    continue;
                }
                if (field.equals("format")) {
                    h.format(value);
                    continue;
                }
                if (field.equals("items")) {
                    h.items((Items)jp.parse((Object)value, Items.class));
                    continue;
                }
                if (!field.equals("type")) continue;
                h.type(value);
                continue;
            }
            if ("description".equals(name)) {
                r2.description(value);
                continue;
            }
            if ("schema".equals(name)) {
                r2.schema((SchemaInfo)jp.parse((Object)value, SchemaInfo.class));
                continue;
            }
            if ("examples".equals(name)) {
                r2.examples((Map)jp.parse((Object)value, TreeMap.class));
                continue;
            }
            System.err.println("Unknown bundle key '" + key + "'");
        }
        return m.isEmpty() ? null : m;
    }

    boolean isRequestAllowed(RestRequest req) {
        for (RestGuard guard : this.guards) {
            req.setJavaMethod(this.method);
            if (guard.isRequestAllowed(req)) continue;
            return false;
        }
        return true;
    }

    int invoke(String pathInfo, RestRequest req, RestResponse res) throws RestException {
        String[] patternVals = this.pathPattern.match(pathInfo);
        if (patternVals == null) {
            return 404;
        }
        String remainder = null;
        if (patternVals.length > this.pathPattern.getVars().length) {
            remainder = patternVals[this.pathPattern.getVars().length];
        }
        for (int i = 0; i < this.pathPattern.getVars().length; ++i) {
            req.setPathParameter(this.pathPattern.getVars()[i], patternVals[i]);
        }
        ObjectMap requestProperties = this.createRequestProperties(this.properties, req);
        req.init(this.method, remainder, requestProperties, this.defaultRequestHeaders, this.defaultCharset, this.serializers, this.parsers, this.urlEncodingParser, this.encoders, this.pageTitle, this.pageText, this.pageLinks);
        res.init(requestProperties, this.defaultCharset, this.serializers, this.urlEncodingSerializer, this.encoders);
        for (RestGuard guard : this.context.getGuards()) {
            if (guard.guard(req, res)) continue;
            return 401;
        }
        for (RestMatcher m : this.requiredMatchers) {
            if (m.matches(req)) continue;
            return 412;
        }
        if (this.optionalMatchers.length > 0) {
            boolean matches = false;
            for (RestMatcher m : this.optionalMatchers) {
                matches |= m.matches(req);
            }
            if (!matches) {
                return 412;
            }
        }
        this.context.getCallHandler().onPreCall(req);
        Object[] args = new Object[this.params.length];
        for (int i = 0; i < this.params.length; ++i) {
            try {
                args[i] = this.params[i].getValue(req, res);
                continue;
            }
            catch (RestException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RestException(400, "Invalid data conversion.  Could not convert {0} ''{1}'' to type ''{2}'' on method ''{3}.{4}''.", this.params[i].paramType.name(), this.params[i].name, this.params[i].type, this.method.getDeclaringClass().getName(), this.method.getName()).initCause(e);
            }
        }
        try {
            for (RestGuard guard : this.guards) {
                if (guard.guard(req, res)) continue;
                return 200;
            }
            Object output = this.method.invoke(this.context.getResource(), args);
            if (!(this.method.getReturnType().equals(Void.TYPE) || output == null && res.getOutputStreamCalled())) {
                res.setOutput(output);
            }
            this.context.getCallHandler().onPostCall(req, res);
            if (res.hasOutput()) {
                output = res.getOutput();
                for (RestConverter converter : this.converters) {
                    output = converter.convert(req, output, this.context.getBeanContext().getClassMetaForObject(output));
                }
                res.setOutput(output);
            }
        }
        catch (IllegalArgumentException e) {
            throw new RestException(400, "Invalid argument type passed to the following method: ''{0}''.\n\tArgument types: {1}", this.method.toString(), ClassUtils.getReadableClassNames((Object[])args));
        }
        catch (InvocationTargetException e) {
            Throwable e2 = e.getTargetException();
            if (e2 instanceof RestException) {
                throw (RestException)e2;
            }
            if (e2 instanceof ParseException) {
                throw new RestException(400, e2);
            }
            if (e2 instanceof InvalidDataConversionException) {
                throw new RestException(400, e2);
            }
            throw new RestException(500, e2);
        }
        catch (RestException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RestException(500, (Throwable)e);
        }
        return 200;
    }

    ObjectMap createRequestProperties(ObjectMap methodProperties, final RestRequest req) {
        ObjectMap m = new ObjectMap(){

            public Object get(Object key) {
                Object o = super.get(key);
                if (o == null) {
                    String k = key.toString();
                    if (k.indexOf(46) != -1) {
                        String prefix = k.substring(0, k.indexOf(46));
                        String remainder = k.substring(k.indexOf(46) + 1);
                        if ("path".equals(prefix)) {
                            return req.getPathParameter(remainder);
                        }
                        if ("query".equals(prefix)) {
                            return req.getQueryParameter(remainder);
                        }
                        if ("formData".equals(prefix)) {
                            return req.getFormDataParameter(remainder);
                        }
                        if ("header".equals(prefix)) {
                            return req.getHeader(remainder);
                        }
                    }
                    if (k.equals("Serializer.absolutePathUriBase")) {
                        int serverPort = req.getServerPort();
                        String serverName = req.getServerName();
                        return req.getScheme() + "://" + serverName + (serverPort == 80 || serverPort == 443 ? "" : ":" + serverPort);
                    }
                    if (k.equals("RestServlet.servletPath")) {
                        return req.getServletPath();
                    }
                    if (k.equals("RestServlet.servletURI")) {
                        return req.getServletURI();
                    }
                    if (k.equals("RestServlet.relativeServletURI")) {
                        return req.getRelativeServletURI();
                    }
                    if (k.equals("RestServlet.pathInfo")) {
                        return req.getPathInfo();
                    }
                    if (k.equals("RestServlet.requestURI")) {
                        return req.getRequestURI();
                    }
                    if (k.equals("RestServlet.method")) {
                        return req.getMethod();
                    }
                    if (k.equals("RestServlet.servletTitle")) {
                        return req.getServletTitle();
                    }
                    if (k.equals("RestServlet.servletDescription")) {
                        return req.getServletDescription();
                    }
                    if (k.equals("RestServlet.methodSummary")) {
                        return req.getMethodSummary();
                    }
                    if (k.equals("RestServlet.methodDescription")) {
                        return req.getMethodDescription();
                    }
                    if (k.equals("HtmlSerializer.title")) {
                        return req.getPageTitle();
                    }
                    if (k.equals("HtmlSerializer.description")) {
                        return req.getPageText();
                    }
                    if (k.equals("HtmlDocSerializer.links.map")) {
                        return req.getPageLinks();
                    }
                    o = req.getPathParameter(k);
                    if (o == null) {
                        o = req.getHeader(k);
                    }
                }
                if (o instanceof String) {
                    o = req.getVarResolverSession().resolve(o.toString());
                }
                return o;
            }
        };
        m.setInner(methodProperties);
        return m;
    }

    public String toString() {
        return "SimpleMethod: name=" + this.httpMethod + ", path=" + this.pathPattern.getPatternString();
    }

    @Override
    public int compareTo(CallMethod o) {
        int c = this.priority.compareTo(o.priority);
        if (c != 0) {
            return c;
        }
        c = this.pathPattern.compareTo(o.pathPattern);
        if (c != 0) {
            return c;
        }
        c = Utils.compare((int)o.requiredMatchers.length, (int)this.requiredMatchers.length);
        if (c != 0) {
            return c;
        }
        c = Utils.compare((int)o.optionalMatchers.length, (int)this.optionalMatchers.length);
        if (c != 0) {
            return c;
        }
        c = Utils.compare((int)o.guards.length, (int)this.guards.length);
        if (c != 0) {
            return c;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (!(o instanceof CallMethod)) {
            return false;
        }
        return this.compareTo((CallMethod)o) == 0;
    }

    public int hashCode() {
        return super.hashCode();
    }

    static enum ParamType {
        REQ,
        RES,
        PATH,
        BODY,
        HEADER,
        METHOD,
        FORMDATA,
        QUERY,
        HASFORMDATA,
        HASQUERY,
        PATHREMAINDER,
        PROPS,
        MESSAGES;


        private String getSwaggerParameterType() {
            switch (this) {
                case PATH: {
                    return "path";
                }
                case HEADER: {
                    return "header";
                }
                case FORMDATA: {
                    return "formData";
                }
                case QUERY: {
                    return "query";
                }
                case BODY: {
                    return "body";
                }
            }
            return null;
        }
    }

    private static class MethodParam {
        private final ParamType paramType;
        private final Type type;
        private final String name;
        private final boolean multiPart;
        private final boolean plainParams;
        private final int attrIdx;

        private MethodParam(Type type, java.lang.reflect.Method method, Annotation[] annotations, boolean methodPlainParams, UrlPathPattern pathPattern, int attrIdx) throws ServletException {
            this.type = type;
            ParamType _paramType = null;
            String _name = "";
            boolean _multiPart = false;
            boolean _plainParams = false;
            boolean isClass = type instanceof Class;
            if (isClass && ClassUtils.isParentClass(HttpServletRequest.class, (Class)((Class)type))) {
                _paramType = ParamType.REQ;
            } else if (isClass && ClassUtils.isParentClass(HttpServletResponse.class, (Class)((Class)type))) {
                _paramType = ParamType.RES;
            } else {
                for (Annotation a : annotations) {
                    Annotation p;
                    if (a instanceof Path) {
                        Path a2 = (Path)a;
                        _paramType = ParamType.PATH;
                        _name = a2.value();
                        continue;
                    }
                    if (a instanceof Header) {
                        Header h = (Header)a;
                        _paramType = ParamType.HEADER;
                        _name = h.value();
                        continue;
                    }
                    if (a instanceof FormData) {
                        p = (FormData)a;
                        if (p.multipart()) {
                            MethodParam.assertCollection(type, method);
                        }
                        _paramType = ParamType.FORMDATA;
                        _multiPart = p.multipart();
                        _plainParams = p.format().equals("INHERIT") ? methodPlainParams : p.format().equals("PLAIN");
                        _name = p.value();
                        continue;
                    }
                    if (a instanceof Query) {
                        p = (Query)a;
                        if (p.multipart()) {
                            MethodParam.assertCollection(type, method);
                        }
                        _paramType = ParamType.QUERY;
                        _multiPart = p.multipart();
                        _plainParams = p.format().equals("INHERIT") ? methodPlainParams : p.format().equals("PLAIN");
                        _name = p.value();
                        continue;
                    }
                    if (a instanceof HasFormData) {
                        p = (HasFormData)a;
                        _paramType = ParamType.HASFORMDATA;
                        _name = p.value();
                        continue;
                    }
                    if (a instanceof HasQuery) {
                        p = (HasQuery)a;
                        _paramType = ParamType.HASQUERY;
                        _name = p.value();
                        continue;
                    }
                    if (a instanceof Body) {
                        _paramType = ParamType.BODY;
                        continue;
                    }
                    if (a instanceof Method) {
                        _paramType = ParamType.METHOD;
                        if (type == String.class) continue;
                        throw new ServletException("@Method parameters must be of type String");
                    }
                    if (a instanceof PathRemainder) {
                        _paramType = ParamType.PATHREMAINDER;
                        if (type == String.class) continue;
                        throw new ServletException("@PathRemainder parameters must be of type String");
                    }
                    if (a instanceof Properties) {
                        _paramType = ParamType.PROPS;
                        _name = "PROPERTIES";
                        continue;
                    }
                    if (!(a instanceof Messages)) continue;
                    _paramType = ParamType.MESSAGES;
                    _name = "MESSAGES";
                }
            }
            if (_paramType == null) {
                _paramType = ParamType.PATH;
            }
            if (_paramType == ParamType.PATH && _name.isEmpty()) {
                int idx = attrIdx++;
                String[] vars = pathPattern.getVars();
                if (vars.length <= idx) {
                    throw new RestServletException("Number of attribute parameters in method ''{0}'' exceeds the number of URL pattern variables.", method.getName());
                }
                String idxs = String.valueOf(idx);
                for (int i = 0; i < vars.length; ++i) {
                    if (!StringUtils.isNumeric((String)vars[i]) || !vars[i].equals(idxs)) continue;
                    _name = vars[i];
                }
                if (_name.isEmpty()) {
                    _name = pathPattern.getVars()[idx];
                }
            }
            this.paramType = _paramType;
            this.name = _name;
            this.multiPart = _multiPart;
            this.plainParams = _plainParams;
            this.attrIdx = attrIdx;
        }

        private static void assertCollection(Type t, java.lang.reflect.Method m) throws ServletException {
            ClassMeta cm = BeanContext.DEFAULT.getClassMeta(t, new Type[0]);
            if (!cm.isCollectionOrArray()) {
                throw new ServletException("Use of multipart flag on parameter that's not an array or Collection on method" + m);
            }
        }

        private Object getValue(RestRequest req, RestResponse res) throws Exception {
            BeanSession session = req.getBeanSession();
            switch (this.paramType) {
                case REQ: {
                    return req;
                }
                case RES: {
                    return res;
                }
                case PATH: {
                    return req.getPathParameter(this.name, this.type, new Type[0]);
                }
                case BODY: {
                    return req.getBody(this.type, new Type[0]);
                }
                case HEADER: {
                    return req.getHeader(this.name, this.type, new Type[0]);
                }
                case METHOD: {
                    return req.getMethod();
                }
                case FORMDATA: {
                    if (this.multiPart) {
                        return req.getFormDataParameters(this.name, this.type, new Type[0]);
                    }
                    if (this.plainParams) {
                        return session.convertToType((Object)req.getFormDataParameter(this.name), session.getClassMeta(this.type, new Type[0]));
                    }
                    return req.getFormDataParameter(this.name, this.type, new Type[0]);
                }
                case QUERY: {
                    if (this.multiPart) {
                        return req.getQueryParameters(this.name, this.type, new Type[0]);
                    }
                    if (this.plainParams) {
                        return session.convertToType((Object)req.getQueryParameter(this.name), session.getClassMeta(this.type, new Type[0]));
                    }
                    return req.getQueryParameter(this.name, this.type, new Type[0]);
                }
                case HASFORMDATA: {
                    return session.convertToType((Object)req.hasFormDataParameter(this.name), session.getClassMeta(this.type, new Type[0]));
                }
                case HASQUERY: {
                    return session.convertToType((Object)req.hasQueryParameter(this.name), session.getClassMeta(this.type, new Type[0]));
                }
                case PATHREMAINDER: {
                    return req.getPathRemainder();
                }
                case PROPS: {
                    return res.getProperties();
                }
                case MESSAGES: {
                    return req.getResourceBundle();
                }
            }
            return null;
        }
    }

    private static class Builder {
        private String httpMethod;
        private String defaultCharset;
        private String description;
        private String tags;
        private String summary;
        private String externalDocs;
        private String pageTitle;
        private String pageText;
        private String pageLinks;
        private UrlPathPattern pathPattern;
        private MethodParam[] params;
        private RestGuard[] guards;
        private RestMatcher[] optionalMatchers;
        private RestMatcher[] requiredMatchers;
        private RestConverter[] converters;
        private SerializerGroup serializers;
        private ParserGroup parsers;
        private EncoderGroup encoders;
        private UrlEncodingParser urlEncodingParser;
        private UrlEncodingSerializer urlEncodingSerializer;
        private ObjectMap properties;
        private Map<String, String> defaultRequestHeaders;
        private boolean plainParams;
        private boolean deprecated;
        private Integer priority;
        private Parameter[] parameters;
        private Response[] responses;

        private Builder(Object servlet, java.lang.reflect.Method method, RestContext context) throws RestServletException {
            try {
                Property p1;
                int n;
                int n2;
                Object matcher;
                int i;
                RestMethod m = method.getAnnotation(RestMethod.class);
                if (m == null) {
                    throw new RestServletException("@RestMethod annotation not found on method ''{0}.{1}''", method.getDeclaringClass().getName(), method.getName());
                }
                if (!m.description().isEmpty()) {
                    this.description = m.description();
                }
                if (!m.tags().isEmpty()) {
                    this.tags = m.tags();
                }
                if (!m.summary().isEmpty()) {
                    this.summary = m.summary();
                }
                if (!m.externalDocs().isEmpty()) {
                    this.externalDocs = m.externalDocs();
                }
                this.deprecated = m.deprecated();
                this.parameters = m.parameters();
                this.responses = m.responses();
                this.serializers = context.getSerializers();
                this.parsers = context.getParsers();
                this.urlEncodingSerializer = context.getUrlEncodingSerializer();
                this.urlEncodingParser = context.getUrlEncodingParser();
                this.encoders = context.getEncoders();
                this.properties = context.getProperties();
                this.pageTitle = m.pageTitle().isEmpty() ? context.getPageTitle() : m.pageTitle();
                this.pageText = m.pageText().isEmpty() ? context.getPageText() : m.pageText();
                this.pageLinks = m.pageLinks().isEmpty() ? context.getPageLinks() : m.pageLinks();
                List<Inherit> si = Arrays.asList(m.serializersInherit());
                List<Inherit> pi = Arrays.asList(m.parsersInherit());
                SerializerGroupBuilder sgb = null;
                ParserGroupBuilder pgb = null;
                UrlEncodingParserBuilder uepb = null;
                if (m.serializers().length > 0 || m.parsers().length > 0 || m.properties().length > 0 || m.beanFilters().length > 0 || m.pojoSwaps().length > 0) {
                    sgb = new SerializerGroupBuilder();
                    pgb = new ParserGroupBuilder();
                    uepb = new UrlEncodingParserBuilder(this.urlEncodingParser.createPropertyStore());
                    if (si.contains((Object)Inherit.SERIALIZERS) || m.serializers().length == 0) {
                        sgb.append(this.serializers.getSerializers());
                    }
                    if (pi.contains((Object)Inherit.PARSERS) || m.parsers().length == 0) {
                        pgb.append(this.parsers.getParsers());
                    }
                }
                this.httpMethod = m.name().toUpperCase(Locale.ENGLISH);
                if (this.httpMethod.equals("") && method.getName().startsWith("do")) {
                    this.httpMethod = method.getName().substring(2).toUpperCase(Locale.ENGLISH);
                }
                if (this.httpMethod.equals("")) {
                    this.httpMethod = "GET";
                }
                if (this.httpMethod.equals("METHOD")) {
                    this.httpMethod = "*";
                }
                this.priority = m.priority();
                String p = m.path();
                this.converters = new RestConverter[m.converters().length];
                for (i = 0; i < this.converters.length; ++i) {
                    this.converters[i] = m.converters()[i].newInstance();
                }
                this.guards = new RestGuard[m.guards().length];
                for (i = 0; i < this.guards.length; ++i) {
                    this.guards[i] = m.guards()[i].newInstance();
                }
                LinkedList<Property[]> optionalMatchers = new LinkedList<Property[]>();
                LinkedList<Object> requiredMatchers = new LinkedList<Object>();
                for (int i2 = 0; i2 < m.matchers().length; ++i2) {
                    Class<? extends RestMatcher> c = m.matchers()[i2];
                    matcher = null;
                    matcher = ClassUtils.isParentClass(RestMatcherReflecting.class, c) ? c.getConstructor(Object.class, java.lang.reflect.Method.class).newInstance(servlet, method) : c.newInstance();
                    if (matcher.mustMatch()) {
                        requiredMatchers.add(matcher);
                        continue;
                    }
                    optionalMatchers.add((Property[])matcher);
                }
                if (!m.clientVersion().isEmpty()) {
                    requiredMatchers.add(new ClientVersionMatcher(context.getClientVersionHeader(), method));
                }
                this.requiredMatchers = requiredMatchers.toArray(new RestMatcher[requiredMatchers.size()]);
                this.optionalMatchers = optionalMatchers.toArray(new RestMatcher[optionalMatchers.size()]);
                Class[] beanFilters = context.getBeanFilters();
                Class[] pojoSwaps = context.getPojoSwaps();
                if (sgb != null) {
                    sgb.append((Class[])m.serializers());
                    if (si.contains((Object)Inherit.TRANSFORMS)) {
                        sgb.beanFilters(beanFilters).pojoSwaps(pojoSwaps);
                    }
                    if (si.contains((Object)Inherit.PROPERTIES)) {
                        sgb.properties(this.properties);
                    }
                    matcher = m.properties();
                    n2 = ((Property[])matcher).length;
                    for (n = 0; n < n2; ++n) {
                        p1 = matcher[n];
                        sgb.property(p1.name(), (Object)p1.value());
                    }
                    sgb.beanFilters((Class[])m.beanFilters());
                    sgb.pojoSwaps((Class[])m.pojoSwaps());
                }
                if (pgb != null) {
                    pgb.append((Class[])m.parsers());
                    if (pi.contains((Object)Inherit.TRANSFORMS)) {
                        pgb.beanFilters(beanFilters).pojoSwaps(pojoSwaps);
                    }
                    if (pi.contains((Object)Inherit.PROPERTIES)) {
                        pgb.properties(this.properties);
                    }
                    matcher = m.properties();
                    n2 = ((Property[])matcher).length;
                    for (n = 0; n < n2; ++n) {
                        p1 = matcher[n];
                        pgb.property(p1.name(), (Object)p1.value());
                    }
                    pgb.beanFilters((Class[])m.beanFilters());
                    pgb.pojoSwaps((Class[])m.pojoSwaps());
                }
                if (uepb != null) {
                    matcher = m.properties();
                    n2 = ((Property[])matcher).length;
                    for (n = 0; n < n2; ++n) {
                        p1 = matcher[n];
                        uepb.property(p1.name(), (Object)p1.value());
                    }
                    uepb.beanFilters((Class[])m.beanFilters());
                    uepb.pojoSwaps((Class[])m.pojoSwaps());
                }
                if (m.properties().length > 0) {
                    this.properties = new ObjectMap().setInner(this.properties);
                    matcher = m.properties();
                    n2 = ((Property[])matcher).length;
                    for (n = 0; n < n2; ++n) {
                        p1 = matcher[n];
                        this.properties.put((Object)p1.name(), (Object)p1.value());
                    }
                }
                if (m.encoders().length > 0 || !m.inheritEncoders()) {
                    String[] g = new EncoderGroupBuilder();
                    if (m.inheritEncoders()) {
                        g.append(this.encoders);
                    } else {
                        g.append(new Encoder[]{IdentityEncoder.INSTANCE});
                    }
                    Class<? extends Encoder>[] classArray = m.encoders();
                    n = classArray.length;
                    for (int p12 = 0; p12 < n; ++p12) {
                        Class<? extends Encoder> c = classArray[p12];
                        try {
                            g.append(new Class[]{c});
                            continue;
                        }
                        catch (Exception e) {
                            throw new RestServletException("Exception occurred while trying to instantiate Encoder ''{0}''", c.getSimpleName()).initCause(e);
                        }
                    }
                    this.encoders = g.build();
                }
                this.defaultRequestHeaders = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
                for (String s : m.defaultRequestHeaders()) {
                    String[] h = RestUtils.parseHeader(s);
                    if (h == null) {
                        throw new RestServletException("Invalid default request header specified: ''{0}''.  Must be in the format: ''Header-Name: header-value''", s);
                    }
                    this.defaultRequestHeaders.put(h[0], h[1]);
                }
                this.defaultCharset = this.properties.getString("RestServlet.defaultCharset", context.getDefaultCharset());
                String paramFormat = this.properties.getString("RestServlet.paramFormat", context.getParamFormat());
                this.plainParams = paramFormat.equals("PLAIN");
                this.pathPattern = new UrlPathPattern(p);
                int attrIdx = 0;
                Type[] pt = method.getGenericParameterTypes();
                Annotation[][] pa = method.getParameterAnnotations();
                this.params = new MethodParam[pt.length];
                for (int i3 = 0; i3 < this.params.length; ++i3) {
                    this.params[i3] = new MethodParam(pt[i3], method, pa[i3], this.plainParams, this.pathPattern, attrIdx);
                    attrIdx = this.params[i3].attrIdx;
                }
                if (sgb != null) {
                    this.serializers = sgb.build();
                }
                if (pgb != null) {
                    this.parsers = pgb.build();
                }
                if (uepb != null) {
                    this.urlEncodingParser = uepb.build();
                }
                method.setAccessible(true);
            }
            catch (RestServletException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RestServletException("Exception occurred while initializing method ''{0}''", method.getName()).initCause(e);
            }
        }
    }
}

