/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.xml;

import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.annotation.Beanp;
import org.apache.juneau.jena.annotation.Rdf;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.testutils.TestUtils;
import org.apache.juneau.utils.AList;
import org.apache.juneau.xml.Namespace;
import org.apache.juneau.xml.XmlParser;
import org.apache.juneau.xml.XmlSerializer;
import org.apache.juneau.xml.XmlSerializerBuilder;
import org.apache.juneau.xml.annotation.Xml;
import org.apache.juneau.xml.annotation.XmlFormat;
import org.apache.juneau.xml.xml1a.T1;
import org.apache.juneau.xml.xml1a.T2;
import org.apache.juneau.xml.xml1b.T3;
import org.apache.juneau.xml.xml1b.T4;
import org.apache.juneau.xml.xml1b.T5;
import org.apache.juneau.xml.xml1b.T6;
import org.apache.juneau.xml.xml1b.T7;
import org.apache.juneau.xml.xml1c.T8;
import org.apache.juneau.xml.xml1c.T9;
import org.junit.Assert;
import org.junit.Test;

public class XmlTest {
    @Test
    public void testComparisonWithJson() throws Exception {
        String json1 = "{\n\tname: \"John Smith\",\n\taddress: {\n\t\tstreetAddress: \"21 2nd Street\",\n\t\tcity: \"New York\",\n\t\tstate: \"NY\",\n\t\tpostalCode: 10021\n\t},\n\tphoneNumbers: [\n\t\t\"212 555-1111\",\n\t\t\"212 555-2222\"\n\t],\n\tadditionalInfo: null,\n\tremote: false,\n\theight: 62.4,\n\t\"fico score\": \" > 640\"\n}";
        String xml1 = "<object>\n\t<name>John Smith</name>\n\t<address _type='object'>\n\t\t<streetAddress>21 2nd Street</streetAddress>\n\t\t<city>New York</city>\n\t\t<state>NY</state>\n\t\t<postalCode _type='number'>10021</postalCode>\n\t</address>\n\t<phoneNumbers _type='array'>\n\t\t<string>212 555-1111</string>\n\t\t<string>212 555-2222</string>\n\t</phoneNumbers>\n\t<additionalInfo _type='null'/>\n\t<remote _type='boolean'>false</remote>\n\t<height _type='number'>62.4</height>\n\t<fico_x0020_score>_x0020_&gt; 640</fico_x0020_score>\n</object>\n";
        ObjectMap m = (ObjectMap)XmlParser.DEFAULT.parse(xml1, Object.class);
        String json2 = JsonSerializer.create().simple().ws().trimNullProperties(false).build().serialize((Object)m);
        Assert.assertEquals((Object)json1, (Object)json2);
        m = (ObjectMap)JsonParser.DEFAULT.parse(json1, Object.class);
        String xml2 = XmlSerializer.create().sq().ws().trimNullProperties(false).build().serialize((Object)m);
        Assert.assertEquals((Object)xml1, (Object)xml2);
    }

    @Test
    public void testNamespaces() throws Exception {
        String json1 = "{\n\tname: \"John Smith\", \n\taddress: {\n\t\tstreetAddress: \"21 2nd Street\", \n\t\tcity: \"New York\", \n\t\tstate: \"NY\", \n\t\tpostalCode: 10021\n\t}, \n\tphoneNumbers: [\n\t\t\"212 555-1111\", \n\t\t\"212 555-2222\"\n\t], \n\tadditionalInfo: null, \n\tremote: false, \n\theight: 62.4, \n\t\"fico score\": \" > 640\"\n}";
        String xml1 = "<object xmlns='http://www.apache.org'>\n\t<name>John Smith</name>\n\t<address _type='object'>\n\t\t<streetAddress>21 2nd Street</streetAddress>\n\t\t<city>New York</city>\n\t\t<state>NY</state>\n\t\t<postalCode _type='number'>10021</postalCode>\n\t</address>\n\t<phoneNumbers _type='array'>\n\t\t<string>212 555-1111</string>\n\t\t<string>212 555-2222</string>\n\t</phoneNumbers>\n\t<additionalInfo _type='null'/>\n\t<remote _type='boolean'>false</remote>\n\t<height _type='number'>62.4</height>\n\t<fico_x0020_score>_x0020_&gt; 640</fico_x0020_score>\n</object>\n";
        ObjectMap m = (ObjectMap)JsonParser.DEFAULT.parse(json1, Object.class);
        String r = XmlSerializer.create().ns().sq().ws().addNamespaceUrisToRoot().defaultNamespace("http://www.apache.org").trimNullProperties(false).build().serialize((Object)m);
        Assert.assertEquals((Object)xml1, (Object)r);
    }

    @Test
    public void testBeanNameAnnotation() throws Exception {
        String e = "<Person1>\n\t<name>John Smith</name>\n\t<age>123</age>\n</Person1>\n";
        String r = XmlSerializer.DEFAULT_SQ_READABLE.serialize((Object)new Person1("John Smith", 123));
        Assert.assertEquals((Object)e, (Object)r);
    }

    @Test
    public void testTrimNulls() throws Exception {
        String e = "<Person1>\n\t<age>123</age>\n</Person1>\n";
        String r = XmlSerializer.DEFAULT_SQ_READABLE.serialize((Object)new Person1(null, 123));
        Assert.assertEquals((Object)e, (Object)r);
    }

    @Test
    public void testElementName() throws Exception {
        XmlSerializer s = XmlSerializer.DEFAULT_SQ;
        A t = new A();
        String r = s.serialize((Object)t);
        Assert.assertEquals((Object)"<foo><f1>1</f1></foo>", (Object)r);
        TestUtils.validateXml(t);
    }

    @Test
    public void testElementNameOnSuperclass() throws Exception {
        XmlSerializer s = XmlSerializer.DEFAULT_SQ;
        B2 t = new B2();
        String r = s.serialize((Object)t);
        Assert.assertEquals((Object)"<foo><f1>1</f1></foo>", (Object)r);
        TestUtils.validateXml(t);
    }

    @Test
    public void testElementNameOnInterface() throws Exception {
        XmlSerializer s = XmlSerializer.DEFAULT_SQ;
        C3 t = new C3();
        String r = s.serialize((Object)t);
        Assert.assertEquals((Object)"<foo><f1>1</f1></foo>", (Object)r);
        TestUtils.validateXml(t);
    }

    @Test
    public void testElementNameWithInvalidChars() throws Exception {
        XmlSerializer s = XmlSerializer.DEFAULT_SQ;
        XmlParser p = XmlParser.DEFAULT;
        D t = new D();
        String r = s.serialize((Object)t);
        Assert.assertEquals((Object)"<_x007E__x0021__x0040__x0023__x0024__x0025__x005E__x0026__x002A__x0028__x0029___x002B__x0060_-_x003D__x007B__x007D__x007C__x005B__x005D__x005C__x003A__x0022__x003B__x0027__x003C__x003E__x003F__x002C_._x000A__x000D__x0009__x0008_><f1>1</f1></_x007E__x0021__x0040__x0023__x0024__x0025__x005E__x0026__x002A__x0028__x0029___x002B__x0060_-_x003D__x007B__x007D__x007C__x005B__x005D__x005C__x003A__x0022__x003B__x0027__x003C__x003E__x003F__x002C_._x000A__x000D__x0009__x0008_>", (Object)r);
        t = (D)p.parse(r, D.class);
        TestUtils.validateXml(t);
    }

    @Test
    public void testIgnoreCollectionFieldWithElementName() throws Exception {
        XmlSerializer s = XmlSerializer.DEFAULT_SQ;
        XmlParser p = XmlParser.DEFAULT;
        G t = new G();
        t.f1.add("bar");
        String r = s.serialize((Object)t);
        Assert.assertEquals((Object)"<bar><f1><string>bar</string></f1></bar>", (Object)r);
        t = (G)p.parse(r, G.class);
        TestUtils.validateXml(t);
    }

    @Test
    public void testElementNameOnBeansOfCollection() throws Exception {
        XmlSerializer s = XmlSerializer.DEFAULT_SQ;
        J1 o = new J1();
        String r = s.serialize((Object)o);
        Assert.assertEquals((Object)"<foo><f1><bar><f2>2</f2></bar></f1></foo>", (Object)r);
    }

    @Test
    public void testXmlNsWithoutMatchingNsUri() throws Exception {
        XmlSerializer s = XmlSerializer.DEFAULT_SQ;
        K t = new K();
        try {
            s.serialize((Object)t);
            Assert.fail((String)"Exception not thrown");
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"Found @Xml.prefix annotation with no matching URI.  prefix='foo'", (Object)e.getLocalizedMessage());
        }
    }

    @Test
    public void testXmlFormatAttr() throws Exception {
        XmlSerializer s = XmlSerializer.DEFAULT_SQ;
        XmlParser p = XmlParser.DEFAULT;
        L t = new L();
        String r = s.serialize((Object)t);
        Assert.assertEquals((Object)"<object f2='2'><f1>1</f1><f3>3</f3></object>", (Object)r);
        t.f1 = 4;
        t.f2 = 5;
        t.f3 = 6;
        t = (L)p.parse(s.serialize((Object)t), L.class);
        Assert.assertEquals((long)4L, (long)t.f1);
        Assert.assertEquals((long)5L, (long)t.f2);
        Assert.assertEquals((long)6L, (long)t.f3);
        TestUtils.validateXml(t);
    }

    @Test
    public void testXmlFormatAttrWithNs() throws Exception {
        XmlSerializerBuilder s = XmlSerializer.create().sq();
        XmlParser p = XmlParser.DEFAULT;
        M t = new M();
        String r = null;
        r = s.build().serialize((Object)t);
        Assert.assertEquals((Object)"<object f1='1' f2='2' f3='3'/>", (Object)r);
        s.enableNamespaces(true).addNamespaceUrisToRoot().autoDetectNamespaces(true).trimNullProperties(false);
        t.f1 = 4;
        t.f2 = 5;
        t.f3 = 6;
        r = s.build().serialize((Object)t);
        Assert.assertEquals((Object)"<object xmlns='http://www.apache.org/2013/Juneau' xmlns:bar='http://bar' xmlns:foo='http://foo' xmlns:baz='http://baz' bar:f1='4' foo:f2='5' baz:f3='6'/>", (Object)r);
        t = (M)p.parse(r, M.class);
        Assert.assertEquals((long)4L, (long)t.f1);
        Assert.assertEquals((long)5L, (long)t.f2);
        Assert.assertEquals((long)6L, (long)t.f3);
        TestUtils.validateXml(t, s.build());
    }

    @Test
    public void testXXXXNotation() throws Exception {
        XmlSerializer s = XmlSerializer.DEFAULT_SQ;
        XmlParser p = XmlParser.DEFAULT;
        String in = "\u0001";
        String r = s.serialize((Object)in);
        Assert.assertEquals((Object)"<string>_x0001_</string>", (Object)r);
        in = (String)p.parse(r, String.class);
        Assert.assertEquals((Object)"\u0001", (Object)in);
        in = "_x0001_";
        r = s.serialize((Object)in);
        Assert.assertEquals((Object)"<string>_x005F_x0001_</string>", (Object)r);
        in = (String)p.parse(r, String.class);
        Assert.assertEquals((Object)"_x0001_", (Object)in);
        in = "_x001_";
        r = s.serialize((Object)in);
        Assert.assertEquals((Object)"<string>_x001_</string>", (Object)r);
        in = (String)p.parse(r, String.class);
        Assert.assertEquals((Object)"_x001_", (Object)in);
        in = "_x00001_";
        r = s.serialize((Object)in);
        Assert.assertEquals((Object)"<string>_x00001_</string>", (Object)r);
        in = (String)p.parse(r, String.class);
        Assert.assertEquals((Object)"_x00001_", (Object)in);
        in = "_xx001_";
        r = s.serialize((Object)in);
        Assert.assertEquals((Object)"<string>_xx001_</string>", (Object)r);
        in = (String)p.parse(r, String.class);
        Assert.assertEquals((Object)"_xx001_", (Object)in);
    }

    @Test
    public void testBeanUriAnnotationFormattedAsElement() throws Exception {
        XmlParser p = XmlParser.DEFAULT;
        XmlSerializer s = XmlSerializer.DEFAULT_SQ;
        N t = new N("http://foo", 123, "bar");
        String r = s.serialize((Object)t);
        Assert.assertEquals((Object)"<object><url>http://foo</url><id>123</id><name>bar</name></object>", (Object)r);
        t = (N)p.parse(r, N.class);
        Assert.assertEquals((Object)"http://foo", (Object)t.url.toString());
        Assert.assertEquals((long)123L, (long)t.id);
        Assert.assertEquals((Object)"bar", (Object)t.name);
        TestUtils.validateXml(t, s);
    }

    @Test
    public void testOverriddenBeanUriAsElementNames() throws Exception {
        XmlParser p = XmlParser.DEFAULT;
        XmlSerializer s = XmlSerializer.DEFAULT_SQ;
        O t = new O("http://foo", 123, "bar");
        String r = s.serialize((Object)t);
        Assert.assertEquals((Object)"<object><url2>http://foo</url2><id2>123</id2><name>bar</name></object>", (Object)r);
        t = (O)p.parse(r, O.class);
        Assert.assertEquals((Object)"http://foo", (Object)t.url.toString());
        Assert.assertEquals((long)123L, (long)t.id);
        Assert.assertEquals((Object)"bar", (Object)t.name);
        TestUtils.validateXml(t, s);
    }

    @Test
    public void testOverriddenBeanUriAndIdAnnotations() throws Exception {
        XmlParser p = XmlParser.DEFAULT;
        XmlSerializer s = XmlSerializer.DEFAULT_SQ;
        P t = new P("http://foo", 123, "bar");
        String r = s.serialize((Object)t);
        Assert.assertEquals((Object)"<object url2='http://foo' id2='123'><name>bar</name></object>", (Object)r);
        t = (P)p.parse(r, P.class);
        Assert.assertEquals((Object)"http://foo", (Object)t.url.toString());
        Assert.assertEquals((long)123L, (long)t.id);
        Assert.assertEquals((Object)"bar", (Object)t.name);
        TestUtils.validateXml(t, s);
    }

    @Test
    public void testNsOnClass() throws Exception {
        XmlSerializerBuilder s = XmlSerializer.create().sq().autoDetectNamespaces(false);
        XmlParser p = XmlParser.DEFAULT;
        T1 t = new T1();
        String r = s.build().serialize((Object)t);
        Assert.assertEquals((Object)"<object><f1>1</f1><f2>2</f2><f3>3</f3><f4>4</f4></object>", (Object)r);
        Assert.assertTrue((boolean)t.equals((T1)p.parse(r, T1.class)));
        s.enableNamespaces(true).addNamespaceUrisToRoot(false);
        r = s.build().serialize((Object)t);
        Assert.assertEquals((Object)"<object><foo:f1>1</foo:f1><bar:f2>2</bar:f2><foo:f3>3</foo:f3><baz:f4>4</baz:f4></object>", (Object)r);
        s.addNamespaceUrisToRoot();
        r = s.build().serialize((Object)t);
        Assert.assertEquals((Object)"<object xmlns='http://www.apache.org/2013/Juneau'><foo:f1>1</foo:f1><bar:f2>2</bar:f2><foo:f3>3</foo:f3><baz:f4>4</baz:f4></object>", (Object)r);
        s.namespaces(new Namespace[]{Namespace.create((String)"foo", (String)"http://foo"), Namespace.create((String)"bar", (String)"http://bar"), Namespace.create((String)"baz", (String)"http://baz")});
        r = s.build().serialize((Object)t);
        Assert.assertEquals((Object)"<object xmlns='http://www.apache.org/2013/Juneau' xmlns:foo='http://foo' xmlns:bar='http://bar' xmlns:baz='http://baz'><foo:f1>1</foo:f1><bar:f2>2</bar:f2><foo:f3>3</foo:f3><baz:f4>4</baz:f4></object>", (Object)r);
        Assert.assertTrue((boolean)t.equals((T1)p.parse(r, T1.class)));
        TestUtils.validateXml(t, s.build());
        s = XmlSerializer.create().sq().autoDetectNamespaces(true);
        r = s.build().serialize((Object)t);
        Assert.assertEquals((Object)"<object><f1>1</f1><f2>2</f2><f3>3</f3><f4>4</f4></object>", (Object)r);
        Assert.assertTrue((boolean)t.equals((T1)p.parse(r, T1.class)));
        s.addNamespaceUrisToRoot();
        r = s.build().serialize((Object)t);
        Assert.assertEquals((Object)"<object><f1>1</f1><f2>2</f2><f3>3</f3><f4>4</f4></object>", (Object)r);
        Assert.assertTrue((boolean)t.equals((T1)p.parse(r, T1.class)));
        s.enableNamespaces(true);
        r = s.build().serialize((Object)t);
        Assert.assertEquals((Object)"<object xmlns='http://www.apache.org/2013/Juneau' xmlns:foo='http://foo' xmlns:bar='http://bar' xmlns:baz='http://baz'><foo:f1>1</foo:f1><bar:f2>2</bar:f2><foo:f3>3</foo:f3><baz:f4>4</baz:f4></object>", (Object)r);
        Assert.assertTrue((boolean)t.equals((T1)p.parse(r, T1.class)));
        TestUtils.validateXml(t, s.build());
    }

    @Test
    public void testNsOnClassWithElementName() throws Exception {
        XmlSerializerBuilder s = XmlSerializer.create().sq().autoDetectNamespaces(false);
        XmlParser p = XmlParser.DEFAULT;
        T2 t = new T2();
        String r = s.build().serialize((Object)t);
        Assert.assertEquals((Object)"<T2><f1>1</f1><f2>2</f2><f3>3</f3><f4>4</f4></T2>", (Object)r);
        Assert.assertTrue((boolean)t.equals((T2)p.parse(r, T2.class)));
        s.enableNamespaces(true).addNamespaceUrisToRoot(false);
        r = s.build().serialize((Object)t);
        Assert.assertEquals((Object)"<foo:T2><foo:f1>1</foo:f1><bar:f2>2</bar:f2><foo:f3>3</foo:f3><baz:f4>4</baz:f4></foo:T2>", (Object)r);
        s.addNamespaceUrisToRoot();
        r = s.build().serialize((Object)t);
        Assert.assertEquals((Object)"<foo:T2 xmlns='http://www.apache.org/2013/Juneau'><foo:f1>1</foo:f1><bar:f2>2</bar:f2><foo:f3>3</foo:f3><baz:f4>4</baz:f4></foo:T2>", (Object)r);
        s.namespaces(new Namespace[]{Namespace.create((String)"foo", (String)"http://foo"), Namespace.create((String)"bar", (String)"http://bar"), Namespace.create((String)"baz", (String)"http://baz")});
        r = s.build().serialize((Object)t);
        Assert.assertEquals((Object)"<foo:T2 xmlns='http://www.apache.org/2013/Juneau' xmlns:foo='http://foo' xmlns:bar='http://bar' xmlns:baz='http://baz'><foo:f1>1</foo:f1><bar:f2>2</bar:f2><foo:f3>3</foo:f3><baz:f4>4</baz:f4></foo:T2>", (Object)r);
        Assert.assertTrue((boolean)t.equals((T2)p.parse(r, T2.class)));
        TestUtils.validateXml(t, s.build());
        s = XmlSerializer.create().sq().autoDetectNamespaces(true);
        r = s.build().serialize((Object)t);
        Assert.assertEquals((Object)"<T2><f1>1</f1><f2>2</f2><f3>3</f3><f4>4</f4></T2>", (Object)r);
        s.addNamespaceUrisToRoot();
        r = s.build().serialize((Object)t);
        Assert.assertEquals((Object)"<T2><f1>1</f1><f2>2</f2><f3>3</f3><f4>4</f4></T2>", (Object)r);
        s.enableNamespaces(true);
        r = s.build().serialize((Object)t);
        Assert.assertEquals((Object)"<foo:T2 xmlns='http://www.apache.org/2013/Juneau' xmlns:foo='http://foo' xmlns:bar='http://bar' xmlns:baz='http://baz'><foo:f1>1</foo:f1><bar:f2>2</bar:f2><foo:f3>3</foo:f3><baz:f4>4</baz:f4></foo:T2>", (Object)r);
        Assert.assertTrue((boolean)t.equals((T2)p.parse(r, T2.class)));
        TestUtils.validateXml(t, s.build());
    }

    @Test
    public void testNsOnPackageNoNsOnClass() throws Exception {
        XmlSerializerBuilder s = XmlSerializer.create().sq();
        XmlParser p = XmlParser.DEFAULT;
        T3 t = new T3();
        String r = s.build().serialize((Object)t);
        Assert.assertEquals((Object)"<object><f1>1</f1><f2>2</f2><f3>3</f3><f4>4</f4></object>", (Object)r);
        Assert.assertTrue((boolean)t.equals((T3)p.parse(r, T3.class)));
        TestUtils.validateXml(t, s.build());
        s.enableNamespaces(true).addNamespaceUrisToRoot(false);
        r = s.build().serialize((Object)t);
        Assert.assertEquals((Object)"<object><p1:f1>1</p1:f1><bar:f2>2</bar:f2><p1:f3>3</p1:f3><baz:f4>4</baz:f4></object>", (Object)r);
        s.addNamespaceUrisToRoot().autoDetectNamespaces(false);
        r = s.build().serialize((Object)t);
        Assert.assertEquals((Object)"<object xmlns='http://www.apache.org/2013/Juneau'><p1:f1>1</p1:f1><bar:f2>2</bar:f2><p1:f3>3</p1:f3><baz:f4>4</baz:f4></object>", (Object)r);
        s.autoDetectNamespaces(false);
        s.namespaces(new Namespace[]{Namespace.create((String)"p1", (String)"http://p1"), Namespace.create((String)"bar", (String)"http://bar"), Namespace.create((String)"baz", (String)"http://baz")});
        r = s.build().serialize((Object)t);
        Assert.assertEquals((Object)"<object xmlns='http://www.apache.org/2013/Juneau' xmlns:p1='http://p1' xmlns:bar='http://bar' xmlns:baz='http://baz'><p1:f1>1</p1:f1><bar:f2>2</bar:f2><p1:f3>3</p1:f3><baz:f4>4</baz:f4></object>", (Object)r);
        Assert.assertTrue((boolean)t.equals((T3)p.parse(r, T3.class)));
        TestUtils.validateXml(t, s.build());
        s = XmlSerializer.create().sq().autoDetectNamespaces(true);
        r = s.build().serialize((Object)t);
        Assert.assertEquals((Object)"<object><f1>1</f1><f2>2</f2><f3>3</f3><f4>4</f4></object>", (Object)r);
        s.addNamespaceUrisToRoot();
        r = s.build().serialize((Object)t);
        Assert.assertEquals((Object)"<object><f1>1</f1><f2>2</f2><f3>3</f3><f4>4</f4></object>", (Object)r);
        s.enableNamespaces(true);
        r = s.build().serialize((Object)t);
        Assert.assertEquals((Object)"<object xmlns='http://www.apache.org/2013/Juneau' xmlns:p1='http://p1' xmlns:bar='http://bar' xmlns:baz='http://baz'><p1:f1>1</p1:f1><bar:f2>2</bar:f2><p1:f3>3</p1:f3><baz:f4>4</baz:f4></object>", (Object)r);
        Assert.assertTrue((boolean)t.equals((T3)p.parse(r, T3.class)));
        TestUtils.validateXml(t, s.build());
    }

    @Test
    public void testNsOnPackageNoNsOnClassElementNameOnClass() throws Exception {
        XmlSerializerBuilder s = XmlSerializer.create().sq().autoDetectNamespaces(false);
        XmlParser p = XmlParser.DEFAULT;
        T4 t = new T4();
        String r = s.build().serialize((Object)t);
        Assert.assertEquals((Object)"<T4><f1>1</f1><f2>2</f2><f3>3</f3><f4>4</f4></T4>", (Object)r);
        Assert.assertTrue((boolean)t.equals((T4)p.parse(r, T4.class)));
        s.enableNamespaces(true).addNamespaceUrisToRoot(false);
        r = s.build().serialize((Object)t);
        Assert.assertEquals((Object)"<p1:T4><p1:f1>1</p1:f1><bar:f2>2</bar:f2><p1:f3>3</p1:f3><baz:f4>4</baz:f4></p1:T4>", (Object)r);
        s.addNamespaceUrisToRoot();
        r = s.build().serialize((Object)t);
        Assert.assertEquals((Object)"<p1:T4 xmlns='http://www.apache.org/2013/Juneau'><p1:f1>1</p1:f1><bar:f2>2</bar:f2><p1:f3>3</p1:f3><baz:f4>4</baz:f4></p1:T4>", (Object)r);
        s.namespaces(new Namespace[]{Namespace.create((String)"foo", (String)"http://foo"), Namespace.create((String)"bar", (String)"http://bar"), Namespace.create((String)"baz", (String)"http://baz"), Namespace.create((String)"p1", (String)"http://p1")});
        r = s.build().serialize((Object)t);
        Assert.assertEquals((Object)"<p1:T4 xmlns='http://www.apache.org/2013/Juneau' xmlns:foo='http://foo' xmlns:bar='http://bar' xmlns:baz='http://baz' xmlns:p1='http://p1'><p1:f1>1</p1:f1><bar:f2>2</bar:f2><p1:f3>3</p1:f3><baz:f4>4</baz:f4></p1:T4>", (Object)r);
        Assert.assertTrue((boolean)t.equals((T4)p.parse(r, T4.class)));
        TestUtils.validateXml(t, s.build());
        s = XmlSerializer.create().sq().autoDetectNamespaces(true);
        r = s.build().serialize((Object)t);
        Assert.assertEquals((Object)"<T4><f1>1</f1><f2>2</f2><f3>3</f3><f4>4</f4></T4>", (Object)r);
        s.addNamespaceUrisToRoot();
        r = s.build().serialize((Object)t);
        Assert.assertEquals((Object)"<T4><f1>1</f1><f2>2</f2><f3>3</f3><f4>4</f4></T4>", (Object)r);
        s.enableNamespaces(true);
        r = s.build().serialize((Object)t);
        Assert.assertEquals((Object)"<p1:T4 xmlns='http://www.apache.org/2013/Juneau' xmlns:p1='http://p1' xmlns:bar='http://bar' xmlns:baz='http://baz'><p1:f1>1</p1:f1><bar:f2>2</bar:f2><p1:f3>3</p1:f3><baz:f4>4</baz:f4></p1:T4>", (Object)r);
        Assert.assertTrue((boolean)t.equals((T4)p.parse(r, T4.class)));
        TestUtils.validateXml(t, s.build());
    }

    @Test
    public void testNsOnPackageNsOnClassElementNameOnClass() throws Exception {
        XmlSerializerBuilder s = XmlSerializer.create().sq();
        XmlParser p = XmlParser.DEFAULT;
        T5 t = new T5();
        String r = s.build().serialize((Object)t);
        Assert.assertEquals((Object)"<T5><f1>1</f1><f2>2</f2><f3>3</f3><f4>4</f4></T5>", (Object)r);
        Assert.assertTrue((boolean)t.equals((T5)p.parse(r, T5.class)));
        TestUtils.validateXml(t, s.build());
        s.ns().addNamespaceUrisToRoot(false).autoDetectNamespaces(false);
        r = s.build().serialize((Object)t);
        Assert.assertEquals((Object)"<foo:T5><foo:f1>1</foo:f1><bar:f2>2</bar:f2><foo:f3>3</foo:f3><baz:f4>4</baz:f4></foo:T5>", (Object)r);
        s.addNamespaceUrisToRoot();
        r = s.build().serialize((Object)t);
        Assert.assertEquals((Object)"<foo:T5 xmlns='http://www.apache.org/2013/Juneau'><foo:f1>1</foo:f1><bar:f2>2</bar:f2><foo:f3>3</foo:f3><baz:f4>4</baz:f4></foo:T5>", (Object)r);
        s.namespaces(new Namespace[]{Namespace.create((String)"foo", (String)"http://foo"), Namespace.create((String)"bar", (String)"http://bar"), Namespace.create((String)"baz", (String)"http://baz")});
        r = s.build().serialize((Object)t);
        Assert.assertEquals((Object)"<foo:T5 xmlns='http://www.apache.org/2013/Juneau' xmlns:foo='http://foo' xmlns:bar='http://bar' xmlns:baz='http://baz'><foo:f1>1</foo:f1><bar:f2>2</bar:f2><foo:f3>3</foo:f3><baz:f4>4</baz:f4></foo:T5>", (Object)r);
        Assert.assertTrue((boolean)t.equals((T5)p.parse(r, T5.class)));
        TestUtils.validateXml(t, s.build());
        s = XmlSerializer.create().sq().autoDetectNamespaces(true);
        r = s.build().serialize((Object)t);
        Assert.assertEquals((Object)"<T5><f1>1</f1><f2>2</f2><f3>3</f3><f4>4</f4></T5>", (Object)r);
        TestUtils.validateXml(t, s.build());
        s.addNamespaceUrisToRoot();
        r = s.build().serialize((Object)t);
        Assert.assertEquals((Object)"<T5><f1>1</f1><f2>2</f2><f3>3</f3><f4>4</f4></T5>", (Object)r);
        TestUtils.validateXml(t, s.build());
        s.ns();
        r = s.build().serialize((Object)t);
        Assert.assertEquals((Object)"<foo:T5 xmlns='http://www.apache.org/2013/Juneau' xmlns:foo='http://foo' xmlns:bar='http://bar' xmlns:baz='http://baz'><foo:f1>1</foo:f1><bar:f2>2</bar:f2><foo:f3>3</foo:f3><baz:f4>4</baz:f4></foo:T5>", (Object)r);
        Assert.assertTrue((boolean)t.equals((T5)p.parse(r, T5.class)));
        TestUtils.validateXml(t, s.build());
    }

    @Test
    public void testNsOnPackageNsOnClassNoElementNameOnClass() throws Exception {
        XmlSerializerBuilder s = XmlSerializer.create().sq().autoDetectNamespaces(false);
        XmlParser p = XmlParser.DEFAULT;
        T6 t = new T6();
        String r = s.build().serialize((Object)t);
        Assert.assertEquals((Object)"<object><f1>1</f1><f2>2</f2><f3>3</f3><f4>4</f4></object>", (Object)r);
        Assert.assertTrue((boolean)t.equals((T6)p.parse(r, T6.class)));
        s.ns().addNamespaceUrisToRoot(false);
        r = s.build().serialize((Object)t);
        Assert.assertEquals((Object)"<object><foo:f1>1</foo:f1><bar:f2>2</bar:f2><foo:f3>3</foo:f3><baz:f4>4</baz:f4></object>", (Object)r);
        s.addNamespaceUrisToRoot().autoDetectNamespaces(false);
        r = s.build().serialize((Object)t);
        Assert.assertEquals((Object)"<object xmlns='http://www.apache.org/2013/Juneau'><foo:f1>1</foo:f1><bar:f2>2</bar:f2><foo:f3>3</foo:f3><baz:f4>4</baz:f4></object>", (Object)r);
        s.namespaces(new Namespace[]{Namespace.create((String)"foo", (String)"http://foo"), Namespace.create((String)"bar", (String)"http://bar"), Namespace.create((String)"baz", (String)"http://baz")});
        r = s.build().serialize((Object)t);
        Assert.assertEquals((Object)"<object xmlns='http://www.apache.org/2013/Juneau' xmlns:foo='http://foo' xmlns:bar='http://bar' xmlns:baz='http://baz'><foo:f1>1</foo:f1><bar:f2>2</bar:f2><foo:f3>3</foo:f3><baz:f4>4</baz:f4></object>", (Object)r);
        Assert.assertTrue((boolean)t.equals((T6)p.parse(r, T6.class)));
        TestUtils.validateXml(t, s.build());
        s = XmlSerializer.create().sq().autoDetectNamespaces(true);
        r = s.build().serialize((Object)t);
        Assert.assertEquals((Object)"<object><f1>1</f1><f2>2</f2><f3>3</f3><f4>4</f4></object>", (Object)r);
        TestUtils.validateXml(t, s.build());
        s.addNamespaceUrisToRoot();
        r = s.build().serialize((Object)t);
        Assert.assertEquals((Object)"<object><f1>1</f1><f2>2</f2><f3>3</f3><f4>4</f4></object>", (Object)r);
        TestUtils.validateXml(t, s.build());
        s.ns();
        r = s.build().serialize((Object)t);
        Assert.assertEquals((Object)"<object xmlns='http://www.apache.org/2013/Juneau' xmlns:foo='http://foo' xmlns:bar='http://bar' xmlns:baz='http://baz'><foo:f1>1</foo:f1><bar:f2>2</bar:f2><foo:f3>3</foo:f3><baz:f4>4</baz:f4></object>", (Object)r);
        Assert.assertTrue((boolean)t.equals((T6)p.parse(r, T6.class)));
        TestUtils.validateXml(t, s.build());
    }

    @Test
    public void testComboOfNsAndOverriddenBeanPropertyNames() throws Exception {
        XmlSerializerBuilder s = XmlSerializer.create().sq().autoDetectNamespaces(false);
        XmlParser p = XmlParser.DEFAULT;
        T7 t = new T7();
        String r = s.build().serialize((Object)t);
        Assert.assertEquals((Object)"<object><g1>1</g1><g2>2</g2><g3>3</g3><g4>4</g4></object>", (Object)r);
        Assert.assertTrue((boolean)t.equals((T7)p.parse(r, T7.class)));
        s.enableNamespaces(true).addNamespaceUrisToRoot(false);
        r = s.build().serialize((Object)t);
        Assert.assertEquals((Object)"<object><p1:g1>1</p1:g1><bar:g2>2</bar:g2><p1:g3>3</p1:g3><baz:g4>4</baz:g4></object>", (Object)r);
        s.addNamespaceUrisToRoot().autoDetectNamespaces(false);
        r = s.build().serialize((Object)t);
        Assert.assertEquals((Object)"<object xmlns='http://www.apache.org/2013/Juneau'><p1:g1>1</p1:g1><bar:g2>2</bar:g2><p1:g3>3</p1:g3><baz:g4>4</baz:g4></object>", (Object)r);
        s.namespaces(new Namespace[]{Namespace.create((String)"foo", (String)"http://foo"), Namespace.create((String)"bar", (String)"http://bar"), Namespace.create((String)"baz", (String)"http://baz"), Namespace.create((String)"p1", (String)"http://p1")});
        r = s.build().serialize((Object)t);
        Assert.assertEquals((Object)"<object xmlns='http://www.apache.org/2013/Juneau' xmlns:foo='http://foo' xmlns:bar='http://bar' xmlns:baz='http://baz' xmlns:p1='http://p1'><p1:g1>1</p1:g1><bar:g2>2</bar:g2><p1:g3>3</p1:g3><baz:g4>4</baz:g4></object>", (Object)r);
        Assert.assertTrue((boolean)t.equals((T7)p.parse(r, T7.class)));
        s = XmlSerializer.create().sq().autoDetectNamespaces(true);
        r = s.build().serialize((Object)t);
        Assert.assertEquals((Object)"<object><g1>1</g1><g2>2</g2><g3>3</g3><g4>4</g4></object>", (Object)r);
        s.enableNamespaces(false);
        r = s.build().serialize((Object)t);
        Assert.assertEquals((Object)"<object><g1>1</g1><g2>2</g2><g3>3</g3><g4>4</g4></object>", (Object)r);
        s.ns().addNamespaceUrisToRoot();
        r = s.build().serialize((Object)t);
        Assert.assertEquals((Object)"<object xmlns='http://www.apache.org/2013/Juneau' xmlns:p1='http://p1' xmlns:bar='http://bar' xmlns:baz='http://baz'><p1:g1>1</p1:g1><bar:g2>2</bar:g2><p1:g3>3</p1:g3><baz:g4>4</baz:g4></object>", (Object)r);
        Assert.assertTrue((boolean)t.equals((T7)p.parse(r, T7.class)));
        TestUtils.validateXml(t, s.build());
    }

    @Test
    public void testXmlNsAnnotation() throws Exception {
        XmlSerializerBuilder s = XmlSerializer.create().sq().autoDetectNamespaces(false);
        XmlParser p = XmlParser.DEFAULT;
        T8 t = new T8();
        String r = s.build().serialize((Object)t);
        Assert.assertEquals((Object)"<object><f1>1</f1><f2>2</f2><f3>3</f3><f4>4</f4></object>", (Object)r);
        Assert.assertTrue((boolean)t.equals((T8)p.parse(r, T8.class)));
        s.ns().addNamespaceUrisToRoot(false).autoDetectNamespaces(false);
        r = s.build().serialize((Object)t);
        Assert.assertEquals((Object)"<object><p2:f1>1</p2:f1><p1:f2>2</p1:f2><c1:f3>3</c1:f3><f1:f4>4</f1:f4></object>", (Object)r);
        s.addNamespaceUrisToRoot();
        r = s.build().serialize((Object)t);
        Assert.assertEquals((Object)"<object xmlns='http://www.apache.org/2013/Juneau'><p2:f1>1</p2:f1><p1:f2>2</p1:f2><c1:f3>3</c1:f3><f1:f4>4</f1:f4></object>", (Object)r);
        s.namespaces(new Namespace[]{Namespace.create((String)"foo", (String)"http://foo"), Namespace.create((String)"bar", (String)"http://bar"), Namespace.create((String)"baz", (String)"http://baz")});
        r = s.build().serialize((Object)t);
        Assert.assertEquals((Object)"<object xmlns='http://www.apache.org/2013/Juneau' xmlns:foo='http://foo' xmlns:bar='http://bar' xmlns:baz='http://baz'><p2:f1>1</p2:f1><p1:f2>2</p1:f2><c1:f3>3</c1:f3><f1:f4>4</f1:f4></object>", (Object)r);
        s = XmlSerializer.create().sq().autoDetectNamespaces(true);
        r = s.build().serialize((Object)t);
        Assert.assertEquals((Object)"<object><f1>1</f1><f2>2</f2><f3>3</f3><f4>4</f4></object>", (Object)r);
        Assert.assertTrue((boolean)t.equals((T8)p.parse(r, T8.class)));
        TestUtils.validateXml(t, s.build());
        s.addNamespaceUrisToRoot();
        r = s.build().serialize((Object)t);
        Assert.assertEquals((Object)"<object><f1>1</f1><f2>2</f2><f3>3</f3><f4>4</f4></object>", (Object)r);
        TestUtils.validateXml(t, s.build());
        s.ns();
        r = s.build().serialize((Object)t);
        Assert.assertEquals((Object)"<object xmlns='http://www.apache.org/2013/Juneau' xmlns:p2='http://p2' xmlns:p1='http://p1' xmlns:c1='http://c1' xmlns:f1='http://f1'><p2:f1>1</p2:f1><p1:f2>2</p1:f2><c1:f3>3</c1:f3><f1:f4>4</f1:f4></object>", (Object)r);
        Assert.assertTrue((boolean)t.equals((T8)p.parse(r, T8.class)));
        TestUtils.validateXml(t, s.build());
    }

    @Test
    public void testXmlNsOnPackageNsUriInXmlNs() throws Exception {
        XmlSerializerBuilder s = XmlSerializer.create().sq().autoDetectNamespaces(false);
        XmlParser p = XmlParser.DEFAULT;
        T9 t = new T9();
        String r = s.build().serialize((Object)t);
        Assert.assertEquals((Object)"<object><f1>1</f1></object>", (Object)r);
        Assert.assertTrue((boolean)t.equals((T9)p.parse(r, T9.class)));
        s.ns().autoDetectNamespaces(false).addNamespaceUrisToRoot(false);
        r = s.build().serialize((Object)t);
        Assert.assertEquals((Object)"<object><p1:f1>1</p1:f1></object>", (Object)r);
        s.addNamespaceUrisToRoot();
        r = s.build().serialize((Object)t);
        Assert.assertEquals((Object)"<object xmlns='http://www.apache.org/2013/Juneau'><p1:f1>1</p1:f1></object>", (Object)r);
        s.namespaces(new Namespace[]{Namespace.create((String)"foo", (String)"http://foo"), Namespace.create((String)"bar", (String)"http://bar"), Namespace.create((String)"baz", (String)"http://baz")});
        r = s.build().serialize((Object)t);
        Assert.assertEquals((Object)"<object xmlns='http://www.apache.org/2013/Juneau' xmlns:foo='http://foo' xmlns:bar='http://bar' xmlns:baz='http://baz'><p1:f1>1</p1:f1></object>", (Object)r);
        s = XmlSerializer.create().sq().autoDetectNamespaces(true);
        r = s.build().serialize((Object)t);
        Assert.assertEquals((Object)"<object><f1>1</f1></object>", (Object)r);
        Assert.assertTrue((boolean)t.equals((T9)p.parse(r, T9.class)));
        TestUtils.validateXml(t, s.build());
        s.addNamespaceUrisToRoot();
        r = s.build().serialize((Object)t);
        Assert.assertEquals((Object)"<object><f1>1</f1></object>", (Object)r);
        TestUtils.validateXml(t, s.build());
        s.ns();
        r = s.build().serialize((Object)t);
        Assert.assertEquals((Object)"<object xmlns='http://www.apache.org/2013/Juneau' xmlns:p1='http://p1'><p1:f1>1</p1:f1></object>", (Object)r);
        Assert.assertTrue((boolean)t.equals((T9)p.parse(r, T9.class)));
        TestUtils.validateXml(t, s.build());
    }

    @Test
    public void testXmlAttrs() throws Exception {
        XmlSerializerBuilder s = XmlSerializer.create().sq();
        XmlParser p = XmlParser.DEFAULT;
        Q t = new Q();
        t.f1 = new URL("http://xf1");
        t.f2 = "xf2";
        t.f3 = "xf3";
        String r = s.build().serialize((Object)t);
        Assert.assertEquals((Object)"<object f1='http://xf1' f2='xf2' x3='xf3'/>", (Object)r);
        t = (Q)p.parse(r, Q.class);
        Assert.assertEquals((Object)"http://xf1", (Object)t.f1.toString());
        Assert.assertEquals((Object)"xf2", (Object)t.f2);
        Assert.assertEquals((Object)"xf3", (Object)t.f3);
        s.ns().addNamespaceUrisToRoot().autoDetectNamespaces(true);
        r = s.build().serialize((Object)t);
        Assert.assertEquals((Object)"<object xmlns='http://www.apache.org/2013/Juneau' xmlns:ns='http://ns' xmlns:nsf1='http://nsf1' xmlns:nsf3='http://nsf3' nsf1:f1='http://xf1' ns:f2='xf2' nsf3:x3='xf3'/>", (Object)r);
        TestUtils.validateXml(t, s.build());
        t = (Q)p.parse(r, Q.class);
        Assert.assertEquals((Object)"http://xf1", (Object)t.f1.toString());
        Assert.assertEquals((Object)"xf2", (Object)t.f2);
        Assert.assertEquals((Object)"xf3", (Object)t.f3);
    }

    @Xml(prefix="ns", namespace="http://ns")
    public static class Q {
        @Xml(format=XmlFormat.ATTR, prefix="nsf1", namespace="http://nsf1")
        public URL f1 = new URL("http://f1");
        @Xml(format=XmlFormat.ATTR)
        public String f2 = "f2";
        @Beanp(name="x3")
        @Xml(format=XmlFormat.ATTR, prefix="nsf3", namespace="http://nsf3")
        public String f3 = "f3";
    }

    @Bean(bpi="url2,id2,name")
    public static class P {
        @Beanp(name="url2")
        @Xml(format=XmlFormat.ATTR)
        public URL url;
        @Beanp(name="id2")
        @Xml(format=XmlFormat.ATTR)
        public int id;
        public String name;

        public P() {
        }

        public P(String url, int id, String name) throws Exception {
            this.url = new URL(url);
            this.id = id;
            this.name = name;
        }
    }

    @Bean(bpi="url2,id2,name")
    public static class O {
        @Beanp(name="url2")
        @Xml(format=XmlFormat.ELEMENT)
        public URL url;
        @Beanp(name="id2")
        public int id;
        public String name;

        public O() {
        }

        public O(String url, int id, String name) throws Exception {
            this.url = new URL(url);
            this.id = id;
            this.name = name;
        }
    }

    @Bean(bpi="url,id,name")
    public static class N {
        @Rdf(beanUri=true)
        @Xml(format=XmlFormat.ELEMENT)
        public URL url;
        public int id;
        public String name;

        public N() {
        }

        public N(String url, int id, String name) throws Exception {
            this.url = new URL(url);
            this.id = id;
            this.name = name;
        }
    }

    @Xml(prefix="bar", namespace="http://bar")
    public static class M {
        @Xml(format=XmlFormat.ATTR)
        public int f1 = 1;
        @Xml(prefix="foo", format=XmlFormat.ATTR, namespace="http://foo")
        public int f2 = 2;
        @Xml(prefix="baz", namespace="http://baz", format=XmlFormat.ATTR)
        public int f3 = 3;
    }

    public static class L {
        public int f1 = 1;
        @Xml(format=XmlFormat.ATTR)
        public int f2 = 2;
        public int f3 = 3;
    }

    @Xml(prefix="foo")
    public static class K {
        public int f1;
    }

    @Bean(typeName="bar")
    public static class J2 {
        public int f2 = 2;
        public int f3 = 3;
    }

    @Bean(typeName="foo")
    public static class J1 {
        @Beanp(properties="f2")
        public List<J2> f1 = new AList().append((Object)new J2());
    }

    @Bean(typeName="bar")
    public static class G {
        public F f1 = new F();
    }

    @Bean(typeName="foo")
    public static class F
    extends LinkedList<String> {
    }

    @Bean(typeName="~!@#$%^&*()_+`-={}|[]\\:\";'<>?,.\n\r\t\b")
    public static class D {
        public int f1 = 1;
    }

    public static class C3
    extends C2 {
        public int f1 = 1;
    }

    public static class C2
    implements C1 {
    }

    @Bean(typeName="foo")
    public static interface C1 {
    }

    public static class B2
    extends B1 {
    }

    public static class B1
    extends A {
    }

    @Bean(typeName="foo")
    public static class A {
        public int f1 = 1;
    }

    @Bean(typeName="Person1", bpi="name,age")
    public static class Person1 {
        public int age;
        private String name;

        protected Person1(String name, int age) {
            this.name = name;
            this.age = age;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

