/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.xml;

import org.apache.juneau.ObjectMap;
import org.apache.juneau.xml.XmlParser;
import org.junit.Assert;
import org.junit.Test;

public class XmlParserTest {
    @Test
    public void testGenericAttributes() throws Exception {
        String xml = "<A b='1'><c>2</c></A>";
        ObjectMap m = (ObjectMap)XmlParser.DEFAULT.parse(xml, ObjectMap.class);
        Assert.assertEquals((Object)"{b:'1',c:'2'}", (Object)m.toString());
    }

    @Test
    public void testGenericWithChildElements() throws Exception {
        String xml = "<A><B><C>c</C></B></A>";
        ObjectMap m = (ObjectMap)XmlParser.DEFAULT.parse(xml, ObjectMap.class);
        Assert.assertEquals((Object)"{B:{C:'c'}}", (Object)m.toString());
        xml = "<A><B><C1>c1</C1><C2>c2</C2></B></A>";
        m = (ObjectMap)XmlParser.DEFAULT.parse(xml, ObjectMap.class);
        Assert.assertEquals((Object)"{B:{C1:'c1',C2:'c2'}}", (Object)m.toString());
        xml = "<A><B><C><D1>d1</D1><D2>d2</D2></C></B></A>";
        m = (ObjectMap)XmlParser.DEFAULT.parse(xml, ObjectMap.class);
        Assert.assertEquals((Object)"{B:{C:{D1:'d1',D2:'d2'}}}", (Object)m.toString());
        xml = "<A><B><C><D1 d1a='d1av'><E1>e1</E1></D1><D2 d2a='d2av'><E2>e2</E2></D2></C></B></A>";
        m = (ObjectMap)XmlParser.DEFAULT.parse(xml, ObjectMap.class);
        Assert.assertEquals((Object)"{B:{C:{D1:{d1a:'d1av',E1:'e1'},D2:{d2a:'d2av',E2:'e2'}}}}", (Object)m.toString());
        xml = "<A><B b='b'><C>c</C></B></A>";
        m = (ObjectMap)XmlParser.DEFAULT.parse(xml, ObjectMap.class);
        Assert.assertEquals((Object)"{B:{b:'b',C:'c'}}", (Object)m.toString());
        xml = "<A><B b='b'>c</B></A>";
        m = (ObjectMap)XmlParser.DEFAULT.parse(xml, ObjectMap.class);
        Assert.assertEquals((Object)"{B:{b:'b',contents:'c'}}", (Object)m.toString());
        xml = "<A><B>b1</B><B>b2</B></A>";
        m = (ObjectMap)XmlParser.DEFAULT.parse(xml, ObjectMap.class);
        Assert.assertEquals((Object)"{B:['b1','b2']}", (Object)m.toString());
        xml = "<A><B><C>c1</C><C>c2</C></B></A>";
        m = (ObjectMap)XmlParser.DEFAULT.parse(xml, ObjectMap.class);
        Assert.assertEquals((Object)"{B:{C:['c1','c2']}}", (Object)m.toString());
        xml = "<A><B v='v1'>b1</B><B v='v2'>b2</B></A>";
        m = (ObjectMap)XmlParser.DEFAULT.parse(xml, ObjectMap.class);
        Assert.assertEquals((Object)"{B:[{v:'v1',contents:'b1'},{v:'v2',contents:'b2'}]}", (Object)m.toString());
        xml = "<A><B><C v='v1'>c1</C><C v='v2'>c2</C></B></A>";
        m = (ObjectMap)XmlParser.DEFAULT.parse(xml, ObjectMap.class);
        Assert.assertEquals((Object)"{B:{C:[{v:'v1',contents:'c1'},{v:'v2',contents:'c2'}]}}", (Object)m.toString());
        xml = "<A><B c='c1'><c>c2</c></B></A>";
        m = (ObjectMap)XmlParser.DEFAULT.parse(xml, ObjectMap.class);
        Assert.assertEquals((Object)"{B:{c:['c1','c2']}}", (Object)m.toString());
    }

    @Test
    public void testPreserveRootElement() throws Exception {
        XmlParser p = XmlParser.create().preserveRootElement().build();
        String xml = "<A><B><C>c</C></B></A>";
        ObjectMap m = (ObjectMap)p.parse(xml, ObjectMap.class);
        Assert.assertEquals((Object)"{A:{B:{C:'c'}}}", (Object)m.toString());
        xml = "<A></A>";
        m = (ObjectMap)p.parse(xml, ObjectMap.class);
        Assert.assertEquals((Object)"{A:{}}", (Object)m.toString());
    }
}

