/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.xml;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.juneau.FormattedRuntimeException;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.annotation.Beanp;
import org.apache.juneau.testutils.TestUtils;
import org.apache.juneau.xml.XmlParser;
import org.apache.juneau.xml.annotation.Xml;
import org.apache.juneau.xml.annotation.XmlFormat;
import org.junit.ComparisonFailure;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class XmlIgnoreCommentsTest {
    private String label;
    private Class<?> type;
    private Object expected;
    private String input;
    private boolean skipWsTests;

    @Parameterized.Parameters
    public static Collection<Object[]> getParameters() {
        return Arrays.asList({"SimpleTypes-1", String.class, "foo", "|<string>|foo|</string>|", false}, {"SimpleTypes-2", Boolean.class, true, "|<boolean>|true|</boolean>|", false}, {"SimpleTypes-3", Integer.TYPE, 123, "|<number>|123|</number>|", false}, {"SimpleTypes-4", Float.TYPE, Float.valueOf(1.23f), "|<number>|1.23|</number>|", false}, {"SimpleTypes-5", String.class, null, "|<null/>|", false}, {"Arrays-1", String[].class, new String[]{"foo"}, "|<array>|<string>|foo|</string>|</array>|", false}, {"Arrays-2", String[].class, new String[]{null}, "|<array>|<null/>|</array>|", false}, {"Arrays-3", Object[].class, new Object[]{"foo"}, "|<array>|<string>|foo|</string>|</array>|", false}, {"Arrays-4", int[].class, new int[]{123}, "|<array>|<number>|123|</number>|</array>|", false}, {"Arrays-5", boolean[].class, new boolean[]{true}, "|<array>|<boolean>|true|</boolean>|</array>|", false}, {"Arrays-6", String[][].class, new String[][]{{"foo"}}, "|<array>|<array>|<string>|foo|</string>|</array>|</array>|", false}, {"MapWithStrings", MapWithStrings.class, new MapWithStrings().append("k1", "v1").append("k2", null), "|<object>|<k1>|v1|</k1>|<k2 _type='null'/>|</object>|", false}, {"MapsWithNumbers", MapWithNumbers.class, new MapWithNumbers().append("k1", 123).append("k2", 1.23).append("k3", null), "|<object>|<k1>|123|</k1>|<k2>|1.23|</k2>|<k3 _type='null'/>|</object>|", false}, {"MapWithObjects", MapWithObjects.class, new MapWithObjects().append("k1", "v1").append("k2", 123).append("k3", 1.23).append("k4", true).append("k5", null), "|<object>|<k1>|v1|</k1>|<k2 _type='number'>|123|</k2>|<k3 _type='number'>|1.23|</k3>|<k4 _type='boolean'>|true|</k4>|<k5 _type='null'/>|</object>|", false}, {"ListWithStrings", ListWithStrings.class, new ListWithStrings().append("foo").append(null), "|<array>|<string>|foo|</string>|<null/>|</array>|", false}, {"ListWithNumbers", ListWithNumbers.class, new ListWithNumbers().append(123).append(1.23).append(null), "|<array>|<number>|123|</number>|<number>|1.23|</number>|<null/>|</array>|", false}, {"ListWithObjects", ListWithObjects.class, new ListWithObjects().append("foo").append(123).append(1.23).append(true).append(null), "|<array>|<string>|foo|</string>|<number>|123|</number>|<number>|1.23|</number>|<boolean>|true|</boolean>|<null/>|</array>|", false}, {"BeanWithNormalProperties", BeanWithNormalProperties.class, new BeanWithNormalProperties().init(), "|<object>|<a>|foo|</a>|<b>|123|</b>|<c>|bar|</c>|<d _type='number'>|456|</d>|<e>|<h>|qux|</h>|</e>|<f>|<string>|baz|</string>|</f>|<g>|<number>|789|</number>|</g>|</object>|", false}, {"BeanWithMapProperties", BeanWithMapProperties.class, new BeanWithMapProperties().init(), "|<object>|<a>|<k1>|foo|</k1>|</a>|<b>|<k2>|123|</k2>|</b>|<c>|<k3>|bar|</k3>|<k4 _type='number'>|456|</k4>|<k5 _type='boolean'>|true|</k5>|<k6 _type='null'/>|</c>|</object>|", false}, {"BeanWithTypeName", BeanWithTypeName.class, new BeanWithTypeName().init(), "|<X>|<a>|123|</a>|<b>|foo|</b>|</X>|", false}, {"BeanWithPropertiesWithTypeNames", BeanWithPropertiesWithTypeNames.class, new BeanWithPropertiesWithTypeNames().init(), "|<object>|<b1>|<b>|foo|</b>|</b1>|<b2 _type='B'>|<b>|foo|</b>|</b2>|</object>|", false}, {"BeanWithPropertiesWithArrayTypeNames", BeanWithPropertiesWithArrayTypeNames.class, new BeanWithPropertiesWithArrayTypeNames().init(), "|<object>|<b1>|<B>|<b>|foo|</b>|</B>|</b1>|<b2>|<B>|<b>|foo|</b>|</B>|</b2>|<b3>|<B>|<b>|foo|</b>|</B>|</b3>|</object>|", false}, {"BeanWithPropertiesWithArray2dTypeNames", BeanWithPropertiesWith2dArrayTypeNames.class, new BeanWithPropertiesWith2dArrayTypeNames().init(), "|<object>|<b1>|<array>|<B>|<b>|foo|</b>|</B>|</array>|</b1>|<b2>|<array>|<B>|<b>|foo|</b>|</B>|</array>|</b2>|<b3>|<array>|<B>|<b>|foo|</b>|</B>|</array>|</b3>|</object>|", false}, {"BeanWithPropertiesWithMapTypeNames", BeanWithPropertiesWithMapTypeNames.class, new BeanWithPropertiesWithMapTypeNames().init(), "|<object>|<b1>|<k1>|<b>|foo|</b>|</k1>|</b1>|<b2>|<k2 _type='B'>|<b>|foo|</b>|</k2>|</b2>|</object>|", false}, {"BeanWithChildTypeNames", BeanWithChildTypeNames.class, new BeanWithChildTypeNames().init(), "|<object>|<a>|<fx>|fx1|</fx>|</a>|<b _type='X'>|<fx>|fx1|</fx>|</b>|<c>|<X>|<fx>|fx1|</fx>|</X>|</c>|<d>|<X>|<fx>|fx1|</fx>|</X>|</d>|</object>|", false}, {"BeanWithChildName", BeanWithChildName.class, new BeanWithChildName().init(), "|<object>|<a>|<X>|foo|</X>|<X>|bar|</X>|</a>|<b>|<Y>|123|</Y>|<Y>|456|</Y>|</b>|</object>|", false}, {"BeanWithXmlFormatAttrProperty", BeanWithXmlFormatAttrProperty.class, new BeanWithXmlFormatAttrProperty().init(), "|<object a='foo' b='123'/>|", false}, {"BeanWithXmlFormatAttrs", BeanWithXmlFormatAttrs.class, new BeanWithXmlFormatAttrs().init(), "|<object a='foo' b='123'/>|", false}, {"BeanWithXmlFormatElementProperty", BeanWithXmlFormatElementProperty.class, new BeanWithXmlFormatElementProperty().init(), "|<object a='foo'><b>123</b></object>|", false}, {"BeanWithXmlFormatAttrsProperty", BeanWithXmlFormatAttrsProperty.class, new BeanWithXmlFormatAttrsProperty().init(), "|<object k1='foo' k2='123' b='456'/>|", false}, {"BeanWithXmlFormatCollapsedProperty", BeanWithXmlFormatCollapsedProperty.class, new BeanWithXmlFormatCollapsedProperty().init(), "|<object>|<A>|foo|</A>|<A>|bar|</A>|<B>|123|</B>|<B>|456|</B>|</object>|", false}, {"BeanWithXmlFormatTextProperty", BeanWithXmlFormatTextProperty.class, new BeanWithXmlFormatTextProperty().init(), "|<object a='foo'>|bar|</object>|", false}, {"BeanWithXmlFormatXmlTextProperty", BeanWithXmlFormatXmlTextProperty.class, new BeanWithXmlFormatXmlTextProperty().init(), "|<object a='foo'>|bar|<b>|baz|</b>|qux|</object>|", false}, {"BeanWithXmlFormatElementsPropertyCollection", BeanWithXmlFormatElementsPropertyCollection.class, new BeanWithXmlFormatElementsPropertyCollection().init(), "|<object a='foo'>|<string>|bar|</string>|<string>|baz|</string>|<number>|123|</number>|<boolean>|true|</boolean>|<null/>|</object>|", false}, {"BeanWithMixedContent", BeanWithMixedContent.class, new BeanWithMixedContent().init(), "|<object>|foo|<X fx='fx1'/>|bar|<Y fy='fy1'/>|baz|</object>|", true}, {"BeanWithSpecialCharacters", BeanWithSpecialCharacters.class, new BeanWithSpecialCharacters().init(), "|<object>|<a>|_x0020_ _x0008__x000C_&#x000a;&#x0009;&#x000d; _x0020_|</a>|</object>|", false}, {"BeanWithSpecialCharacters2", BeanWithSpecialCharacters2.class, new BeanWithSpecialCharacters2().init(), "|<_x0020__x0020__x0008__x000C__x000A__x0009__x000D__x0020__x0020_>|<_x0020__x0020__x0008__x000C__x000A__x0009__x000D__x0020__x0020_>|_x0020_ _x0008__x000C_&#x000a;&#x0009;&#x000d; _x0020_|</_x0020__x0020__x0008__x000C__x000A__x0009__x000D__x0020__x0020_>|</_x0020__x0020__x0008__x000C__x000A__x0009__x000D__x0020__x0020_>|", false}, {"BeanWithNullProperties", BeanWithNullProperties.class, new BeanWithNullProperties(), "|<object/>|", false}, {"BeanWithAbstractFields", BeanWithAbstractFields.class, new BeanWithAbstractFields().init(), "|<object>|<a>|<a>|foo|</a>|</a>|<ia _type='A'>|<a>|foo|</a>|</ia>|<aa _type='A'>|<a>|foo|</a>|</aa>|<o _type='A'>|<a>|foo|</a>|</o>|</object>|", false}, {"BeanWithAbstractArrayFields", BeanWithAbstractArrayFields.class, new BeanWithAbstractArrayFields().init(), "|<object>|<a>|<A>|<a>|foo|</a>|</A>|</a>|<ia1>|<A>|<a>|foo|</a>|</A>|</ia1>|<ia2>|<A>|<a>|foo|</a>|</A>|</ia2>|<aa1>|<A>|<a>|foo|</a>|</A>|</aa1>|<aa2>|<A>|<a>|foo|</a>|</A>|</aa2>|<o1>|<A>|<a>|foo|</a>|</A>|</o1>|<o2>|<A>|<a>|foo|</a>|</A>|</o2>|</object>", false}, {"BeanWithAbstractMapFields", BeanWithAbstractMapFields.class, new BeanWithAbstractMapFields().init(), "|<object>|<a>|<k1>|<a>|foo|</a>|</k1>|</a>|<b>|<k2 _type='A'>|<a>|foo|</a>|</k2>|</b>|<c>|<k3 _type='A'>|<a>|foo|</a>|</k3>|</c>|</object>", false}, {"BeanWithAbstractMapArrayFields", BeanWithAbstractMapArrayFields.class, new BeanWithAbstractMapArrayFields().init(), "|<object>|<a>|<a1>|<A>|<a>|foo|</a>|</A>|</a1>|</a>|<ia>|<ia1>|<A>|<a>|foo|</a>|</A>|</ia1>|<ia2>|<A>|<a>|foo|</a>|</A>|</ia2>|</ia>|<aa>|<aa1>|<A>|<a>|foo|</a>|</A>|</aa1>|<aa2>|<A>|<a>|foo|</a>|</A>|</aa2>|</aa>|<o>|<o1>|<A>|<a>|foo|</a>|</A>|</o1>|<o2>|<A>|<a>|foo|</a>|</A>|</o2>|</o>|</object>", false}, {"BeanWithWhitespaceTextFields-1", BeanWithWhitespaceTextFields.class, new BeanWithWhitespaceTextFields().init(null), "|<object/>|", false}, {"BeanWithWhitespaceTextFields-2", BeanWithWhitespaceTextFields.class, new BeanWithWhitespaceTextFields().init(""), "|<object>|_xE000_|</object>|", false}, {"BeanWithWhitespaceTextFields-3", BeanWithWhitespaceTextFields.class, new BeanWithWhitespaceTextFields().init(" "), "|<object>|_x0020_|</object>|", false}, {"BeanWithWhitespaceTextFields-4", BeanWithWhitespaceTextFields.class, new BeanWithWhitespaceTextFields().init("  "), "|<object>|_x0020__x0020_|</object>|", false}, {"BeanWithWhitespaceTextFields-5", BeanWithWhitespaceTextFields.class, new BeanWithWhitespaceTextFields().init(" foo\n\tbar "), "|<object>|_x0020_foo&#x000a;&#x0009;bar_x0020_|</object>|", false}, {"BeanWithWhitespaceTextPwsFields-1", BeanWithWhitespaceTextPwsFields.class, new BeanWithWhitespaceTextPwsFields().init(null), "|<object/>|", false}, {"BeanWithWhitespaceTextPwsFields-2", BeanWithWhitespaceTextPwsFields.class, new BeanWithWhitespaceTextPwsFields().init(""), "|<object>|_xE000_|</object>|", true}, {"BeanWithWhitespaceTextPwsFields-3", BeanWithWhitespaceTextPwsFields.class, new BeanWithWhitespaceTextPwsFields().init(" "), "|<object>| |</object>|", true}, {"BeanWithWhitespaceTextPwsFields-4", BeanWithWhitespaceTextPwsFields.class, new BeanWithWhitespaceTextPwsFields().init("  "), "|<object>|  |</object>|", true}, {"BeanWithWhitespaceTextPwsFields-5", BeanWithWhitespaceTextPwsFields.class, new BeanWithWhitespaceTextPwsFields().init("  foobar  "), "|<object>|  foobar  |</object>|", true}, {"BeanWithWhitespaceMixedFields-1", BeanWithWhitespaceMixedFields.class, new BeanWithWhitespaceMixedFields().init(null), "|<object nil='true'></object>|", false}, {"BeanWithWhitespaceMixedFields-3", BeanWithWhitespaceMixedFields.class, new BeanWithWhitespaceMixedFields().init(new String[]{""}), "|<object>|_xE000_|</object>|", true}, {"BeanWithWhitespaceMixedFields-4", BeanWithWhitespaceMixedFields.class, new BeanWithWhitespaceMixedFields().init(new String[]{" "}), "|<object>|_x0020_|</object>|", true}, {"BeanWithWhitespaceMixedFields-5", BeanWithWhitespaceMixedFields.class, new BeanWithWhitespaceMixedFields().init(new String[]{"  "}), "|<object>|_x0020__x0020_|</object>|", true}, {"BeanWithWhitespaceMixedFields-6", BeanWithWhitespaceMixedFields.class, new BeanWithWhitespaceMixedFields().init(new String[]{"  foobar  "}), "|<object>|_x0020_ foobar _x0020_|</object>|", true}, {"BeanWithWhitespaceMixedPwsFields-1", BeanWithWhitespaceMixedPwsFields.class, new BeanWithWhitespaceMixedPwsFields().init(null), "|<object nil='true'></object>|", false}, {"BeanWithWhitespaceMixedPwsFields-3", BeanWithWhitespaceMixedPwsFields.class, new BeanWithWhitespaceMixedPwsFields().init(new String[]{""}), "|<object>|_xE000_|</object>|", true}, {"BeanWithWhitespaceMixedPwsFields-4", BeanWithWhitespaceMixedPwsFields.class, new BeanWithWhitespaceMixedPwsFields().init(new String[]{" "}), "|<object>| |</object>|", true}, {"BeanWithWhitespaceMixedPwsFields-5", BeanWithWhitespaceMixedPwsFields.class, new BeanWithWhitespaceMixedPwsFields().init(new String[]{"  "}), "|<object>|  |</object>|", true}, {"BeanWithWhitespaceMixedPwsFields-6", BeanWithWhitespaceMixedPwsFields.class, new BeanWithWhitespaceMixedPwsFields().init(new String[]{"  foobar  "}), "|<object>|  foobar  |</object>|", true});
    }

    public XmlIgnoreCommentsTest(String label, Class<?> type, Object expected, String input, boolean skipWsTests) throws Exception {
        this.label = label;
        this.type = type;
        this.expected = expected;
        this.input = input;
        this.skipWsTests = skipWsTests;
    }

    @Test
    public void testNoComment() throws Exception {
        try {
            Object actual = XmlParser.DEFAULT.parse(this.input.replace("|", ""), this.type);
            TestUtils.assertEqualObjects(this.expected, actual);
        }
        catch (ComparisonFailure e) {
            throw new ComparisonFailure(MessageFormat.format("Test ''{0}'' failed with comparison error", this.label), e.getExpected(), e.getActual());
        }
        catch (Exception e) {
            throw new FormattedRuntimeException((Throwable)e, "Test ''{0}'' failed with error ''{1}''", new Object[]{this.label, e.getMessage()});
        }
    }

    @Test
    public void testNormalComment() throws Exception {
        try {
            Object actual = XmlParser.DEFAULT.parse(this.input.replace("|", "<!--x-->"), this.type);
            TestUtils.assertEqualObjects(this.expected, actual);
        }
        catch (ComparisonFailure e) {
            throw new ComparisonFailure(MessageFormat.format("Test ''{0}'' failed with comparison error", this.label), e.getExpected(), e.getActual());
        }
        catch (Exception e) {
            throw new FormattedRuntimeException((Throwable)e, "Test ''{0}'' failed with error ''{1}''", new Object[]{this.label, e.getMessage()});
        }
    }

    @Test
    public void testCommentWithWhitespace() throws Exception {
        try {
            Object actual = XmlParser.DEFAULT.parse(this.input.replace("|", " \n <!-- \n x \n --> \n "), this.type);
            if (!this.skipWsTests) {
                TestUtils.assertEqualObjects(this.expected, actual);
            }
        }
        catch (ComparisonFailure e) {
            throw new ComparisonFailure(MessageFormat.format("Test ''{0}'' failed with comparison error", this.label), e.getExpected(), e.getActual());
        }
        catch (Exception e) {
            throw new FormattedRuntimeException((Throwable)e, "Test ''{0}'' failed with error ''{1}''", new Object[]{this.label, e.getMessage()});
        }
    }

    @Test
    public void testDoubleCommentsWithWhitespace() throws Exception {
        try {
            Object actual = XmlParser.DEFAULT.parse(this.input.replace("|", " \n <!-- \n x \n --> \n \n <!-- \n x \n --> \n "), this.type);
            if (!this.skipWsTests) {
                TestUtils.assertEqualObjects(this.expected, actual);
            }
        }
        catch (ComparisonFailure e) {
            throw new ComparisonFailure(MessageFormat.format("Test ''{0}'' failed with comparison error", this.label), e.getExpected(), e.getActual());
        }
        catch (Exception e) {
            throw new FormattedRuntimeException((Throwable)e, "Test ''{0}'' failed with error ''{1}''", new Object[]{this.label, e.getMessage()});
        }
    }

    public static class BeanWithWhitespaceMixedPwsFields {
        @Xml(format=XmlFormat.MIXED_PWS)
        public String[] a;

        public BeanWithWhitespaceMixedPwsFields init(String[] s) {
            this.a = s;
            return this;
        }
    }

    public static class BeanWithWhitespaceMixedFields {
        @Xml(format=XmlFormat.MIXED)
        public String[] a;

        public BeanWithWhitespaceMixedFields init(String[] s) {
            this.a = s;
            return this;
        }
    }

    public static class BeanWithWhitespaceTextPwsFields {
        @Xml(format=XmlFormat.TEXT_PWS)
        public String a;

        public BeanWithWhitespaceTextPwsFields init(String s) {
            this.a = s;
            return this;
        }
    }

    public static class BeanWithWhitespaceTextFields {
        @Xml(format=XmlFormat.TEXT)
        public String a;

        public BeanWithWhitespaceTextFields init(String s) {
            this.a = s;
            return this;
        }
    }

    @Bean(typeName="A")
    public static class A
    extends AA {
        private String a;

        @Override
        public String getA() {
            return this.a;
        }

        @Override
        public void setA(String a) {
            this.a = a;
        }

        A init() {
            this.a = "foo";
            return this;
        }
    }

    public static abstract class AA
    implements IA {
    }

    public static interface IA {
        public String getA();

        public void setA(String var1);
    }

    @Bean(dictionary={A.class})
    public static class BeanWithAbstractMapArrayFields {
        public Map<String, A[]> a;
        public Map<String, IA[]> ia;
        public Map<String, AA[]> aa;
        public Map<String, Object[]> o;

        BeanWithAbstractMapArrayFields init() {
            this.a = new LinkedHashMap<String, A[]>();
            this.ia = new LinkedHashMap<String, IA[]>();
            this.aa = new LinkedHashMap<String, AA[]>();
            this.o = new LinkedHashMap<String, Object[]>();
            this.a.put("a1", new A[]{new A().init()});
            this.ia.put("ia1", new A[]{new A().init()});
            this.ia.put("ia2", new IA[]{new A().init()});
            this.aa.put("aa1", new A[]{new A().init()});
            this.aa.put("aa2", new AA[]{new A().init()});
            this.o.put("o1", new A[]{new A().init()});
            this.o.put("o2", new Object[]{new A().init()});
            return this;
        }
    }

    @Bean(dictionary={A.class})
    public static class BeanWithAbstractMapFields {
        public Map<String, A> a;
        public Map<String, AA> b;
        public Map<String, Object> c;

        BeanWithAbstractMapFields init() {
            this.a = new HashMap<String, A>();
            this.b = new HashMap<String, AA>();
            this.c = new HashMap<String, Object>();
            this.a.put("k1", new A().init());
            this.b.put("k2", new A().init());
            this.c.put("k3", new A().init());
            return this;
        }
    }

    @Bean(dictionary={A.class})
    public static class BeanWithAbstractArrayFields {
        public A[] a;
        public IA[] ia1;
        public IA[] ia2;
        public AA[] aa1;
        public AA[] aa2;
        public Object[] o1;
        public Object[] o2;

        BeanWithAbstractArrayFields init() {
            this.a = new A[]{new A().init()};
            this.ia1 = new A[]{new A().init()};
            this.aa1 = new A[]{new A().init()};
            this.o1 = new A[]{new A().init()};
            this.ia2 = new IA[]{new A().init()};
            this.aa2 = new AA[]{new A().init()};
            this.o2 = new Object[]{new A().init()};
            return this;
        }
    }

    @Bean(dictionary={A.class})
    public static class BeanWithAbstractFields {
        public A a;
        public IA ia;
        public AA aa;
        public Object o;

        BeanWithAbstractFields init() {
            this.ia = new A().init();
            this.aa = new A().init();
            this.a = new A().init();
            this.o = new A().init();
            return this;
        }
    }

    public static class BeanWithNullProperties {
        public String a;
        public String[] b;
    }

    @Bean(typeName="  \b\f\n\t\r  ")
    public static class BeanWithSpecialCharacters2 {
        @Beanp(name="  \b\f\n\t\r  ")
        public String a;

        BeanWithSpecialCharacters2 init() {
            this.a = "  \b\f\n\t\r  ";
            return this;
        }
    }

    public static class BeanWithSpecialCharacters {
        public String a;

        BeanWithSpecialCharacters init() {
            this.a = "  \b\f\n\t\r  ";
            return this;
        }
    }

    @Bean(typeName="Y")
    public static class BeanYSimple {
        @Xml(format=XmlFormat.ATTR)
        public String fy;

        BeanYSimple init() {
            this.fy = "fy1";
            return this;
        }
    }

    @Bean(typeName="Y")
    public static class BeanY {
        public String fy;

        BeanY init() {
            this.fy = "fy1";
            return this;
        }
    }

    @Bean(typeName="X")
    public static class BeanXSimple {
        @Xml(format=XmlFormat.ATTR)
        public String fx;

        BeanXSimple init() {
            this.fx = "fx1";
            return this;
        }
    }

    @Bean(typeName="X")
    public static class BeanX {
        public String fx;

        BeanX init() {
            this.fx = "fx1";
            return this;
        }
    }

    public static class BeanWithMixedContent {
        @Xml(format=XmlFormat.MIXED)
        @Beanp(dictionary={BeanXSimple.class, BeanYSimple.class})
        public Object[] a;

        BeanWithMixedContent init() {
            this.a = new Object[]{"foo", new BeanXSimple().init(), "bar", new BeanYSimple().init(), "baz"};
            return this;
        }
    }

    public static class BeanWithXmlFormatElementsPropertyCollection {
        @Xml(format=XmlFormat.ATTR)
        public String a;
        @Xml(format=XmlFormat.ELEMENTS)
        public Object[] b;

        BeanWithXmlFormatElementsPropertyCollection init() {
            this.a = "foo";
            this.b = new Object[]{"bar", "baz", 123, true, null};
            return this;
        }
    }

    public static class BeanWithXmlFormatXmlTextProperty {
        @Xml(format=XmlFormat.ATTR)
        public String a;
        @Xml(format=XmlFormat.XMLTEXT)
        public String b;

        BeanWithXmlFormatXmlTextProperty init() {
            this.a = "foo";
            this.b = "bar<b>baz</b>qux";
            return this;
        }
    }

    public static class BeanWithXmlFormatTextProperty {
        @Xml(format=XmlFormat.ATTR)
        public String a;
        @Xml(format=XmlFormat.TEXT)
        public String b;

        BeanWithXmlFormatTextProperty init() {
            this.a = "foo";
            this.b = "bar";
            return this;
        }
    }

    public static class BeanWithXmlFormatCollapsedProperty {
        @Xml(childName="A", format=XmlFormat.COLLAPSED)
        public String[] a;
        @Xml(childName="B", format=XmlFormat.COLLAPSED)
        public int[] b;

        BeanWithXmlFormatCollapsedProperty init() {
            this.a = new String[]{"foo", "bar"};
            this.b = new int[]{123, 456};
            return this;
        }
    }

    public static class BeanWithXmlFormatAttrsProperty {
        @Xml(format=XmlFormat.ATTRS)
        public Map<String, Object> a;
        @Xml(format=XmlFormat.ATTR)
        public int b;

        BeanWithXmlFormatAttrsProperty init() {
            this.a = new ObjectMap().append("k1", (Object)"foo").append("k2", (Object)"123");
            this.b = 456;
            return this;
        }
    }

    @Xml(format=XmlFormat.ATTRS)
    public static class BeanWithXmlFormatElementProperty {
        public String a;
        @Xml(format=XmlFormat.ELEMENT)
        public int b;

        BeanWithXmlFormatElementProperty init() {
            this.a = "foo";
            this.b = 123;
            return this;
        }
    }

    @Xml(format=XmlFormat.ATTRS)
    public static class BeanWithXmlFormatAttrs {
        public String a;
        public int b;

        BeanWithXmlFormatAttrs init() {
            this.a = "foo";
            this.b = 123;
            return this;
        }
    }

    public static class BeanWithXmlFormatAttrProperty {
        @Xml(format=XmlFormat.ATTR)
        public String a;
        @Xml(format=XmlFormat.ATTR)
        public int b;

        BeanWithXmlFormatAttrProperty init() {
            this.a = "foo";
            this.b = 123;
            return this;
        }
    }

    public static class BeanWithChildName {
        @Xml(childName="X")
        public String[] a;
        @Xml(childName="Y")
        public int[] b;

        BeanWithChildName init() {
            this.a = new String[]{"foo", "bar"};
            this.b = new int[]{123, 456};
            return this;
        }
    }

    public static class BeanWithChildTypeNames {
        public BeanX a;
        @Beanp(dictionary={BeanX.class})
        public Object b;
        public BeanX[] c;
        @Beanp(dictionary={BeanX.class})
        public Object[] d;

        BeanWithChildTypeNames init() {
            this.a = new BeanX().init();
            this.b = new BeanX().init();
            this.c = new BeanX[]{new BeanX().init()};
            this.d = new Object[]{new BeanX().init()};
            return this;
        }
    }

    @Bean(typeName="B")
    public static class B {
        public String b;

        B init() {
            this.b = "foo";
            return this;
        }
    }

    @Bean(dictionary={B.class})
    public static class BeanWithPropertiesWithMapTypeNames {
        public Map<String, B> b1;
        public Map<String, Object> b2;

        BeanWithPropertiesWithMapTypeNames init() {
            this.b1 = new HashMap<String, B>();
            this.b1.put("k1", new B().init());
            this.b2 = new HashMap<String, Object>();
            this.b2.put("k2", new B().init());
            return this;
        }
    }

    @Bean(dictionary={B.class})
    public static class BeanWithPropertiesWith2dArrayTypeNames {
        public B[][] b1;
        public Object[][] b2;
        public Object[][] b3;

        BeanWithPropertiesWith2dArrayTypeNames init() {
            this.b1 = new B[][]{{new B().init()}};
            this.b2 = new B[][]{{new B().init()}};
            this.b3 = new Object[][]{{new B().init()}};
            return this;
        }
    }

    @Bean(dictionary={B.class})
    public static class BeanWithPropertiesWithArrayTypeNames {
        public B[] b1;
        public Object[] b2;
        public Object[] b3;

        BeanWithPropertiesWithArrayTypeNames init() {
            this.b1 = new B[]{new B().init()};
            this.b2 = new B[]{new B().init()};
            this.b3 = new Object[]{new B().init()};
            return this;
        }
    }

    @Bean(dictionary={B.class})
    public static class BeanWithPropertiesWithTypeNames {
        public B b1;
        public Object b2;

        BeanWithPropertiesWithTypeNames init() {
            this.b1 = new B().init();
            this.b2 = new B().init();
            return this;
        }
    }

    @Bean(typeName="X")
    public static class BeanWithTypeName {
        public int a;
        public String b;

        BeanWithTypeName init() {
            this.a = 123;
            this.b = "foo";
            return this;
        }
    }

    public static class BeanWithMapProperties {
        @Beanp(type=MapWithStrings.class)
        public Map<String, String> a;
        @Beanp(type=MapWithNumbers.class)
        public Map<String, Number> b;
        @Beanp(type=MapWithObjects.class)
        public Map<String, Object> c;

        BeanWithMapProperties init() {
            this.a = new MapWithStrings().append("k1", "foo");
            this.b = new MapWithNumbers().append("k2", 123);
            this.c = new MapWithObjects().append("k3", "bar").append("k4", 456).append("k5", true).append("k6", null);
            return this;
        }
    }

    public static class Bean1a {
        public String h;

        Bean1a init() {
            this.h = "qux";
            return this;
        }
    }

    public static class BeanWithNormalProperties {
        public String a;
        public int b;
        public Object c;
        public Object d;
        public Bean1a e;
        public String[] f;
        public int[] g;

        BeanWithNormalProperties init() {
            this.a = "foo";
            this.b = 123;
            this.c = "bar";
            this.d = 456;
            this.e = new Bean1a().init();
            this.f = new String[]{"baz"};
            this.g = new int[]{789};
            return this;
        }
    }

    public static class ListWithObjects
    extends ArrayList<Object> {
        public ListWithObjects append(Object value) {
            this.add(value);
            return this;
        }
    }

    public static class ListWithNumbers
    extends ArrayList<Number> {
        public ListWithNumbers append(Number value) {
            this.add(value);
            return this;
        }
    }

    public static class ListWithStrings
    extends ArrayList<String> {
        public ListWithStrings append(String value) {
            this.add(value);
            return this;
        }
    }

    public static class MapWithObjects
    extends LinkedHashMap<String, Object> {
        public MapWithObjects append(String key, Object value) {
            this.put(key, value);
            return this;
        }
    }

    public static class MapWithNumbers
    extends LinkedHashMap<String, Number> {
        public MapWithNumbers append(String key, Number value) {
            this.put(key, value);
            return this;
        }
    }

    public static class MapWithStrings
    extends LinkedHashMap<String, String> {
        public MapWithStrings append(String key, String value) {
            this.put(key, value);
            return this;
        }
    }
}

