/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.xml;

import java.io.StringWriter;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.serializer.SerializerSessionArgs;
import org.apache.juneau.testutils.TestUtils;
import org.apache.juneau.xml.XmlParser;
import org.apache.juneau.xml.XmlSerializer;
import org.apache.juneau.xml.XmlSerializerSession;
import org.apache.juneau.xml.annotation.Xml;
import org.apache.juneau.xml.annotation.XmlFormat;
import org.junit.Assert;
import org.junit.Test;

public class XmlContentTest {
    @Test
    public void testContentFormat() throws Exception {
        A t = A.newInstance();
        XmlSerializer s1 = XmlSerializer.DEFAULT_SQ.builder().trimNullProperties(false).build();
        XmlSerializer s2 = XmlSerializer.create().sq().ws().enableNamespaces(false).trimNullProperties(false).build();
        XmlParser p = XmlParser.DEFAULT;
        t.f2 = null;
        StringWriter sw = new StringWriter();
        XmlSerializerSession session = s1.createSession(SerializerSessionArgs.create());
        session.serialize((Object)t, (Object)sw);
        String r = sw.toString();
        Assert.assertEquals((Object)"<A f1='f1' nil='true'></A>", (Object)r);
        A t2 = (A)p.parse(r, A.class);
        TestUtils.assertEqualObjects(t, t2);
        sw = new StringWriter();
        session = s2.createSession(SerializerSessionArgs.create());
        session.serialize((Object)t, (Object)sw);
        r = sw.toString();
        Assert.assertEquals((Object)"<A f1='f1' nil='true'></A>\n", (Object)r);
        t2 = (A)p.parse(r, A.class);
        TestUtils.assertEqualObjects(t, t2);
        t.f2 = "foobar";
        r = s1.serialize((Object)t);
        Assert.assertEquals((Object)"<A f1='f1'>foobar</A>", (Object)r);
        t2 = (A)p.parse(r, A.class);
        TestUtils.assertEqualObjects(t, t2);
        r = s2.serialize((Object)t);
        Assert.assertEquals((Object)"<A f1='f1'>foobar</A>\n", (Object)r);
        t2 = (A)p.parse(r, A.class);
        TestUtils.assertEqualObjects(t, t2);
        t.f2 = "~!@#$%^&*()_+`-={}|[]\\:\";'<>?,.\n\r\t\b";
        r = s1.serialize((Object)t);
        Assert.assertEquals((Object)"<A f1='f1'>~!@#$%^&amp;*()_+`-={}|[]\\:\";'&lt;&gt;?,.&#x000a;&#x000d;&#x0009;_x0008_</A>", (Object)r);
        t2 = (A)p.parse(r, A.class);
        TestUtils.assertEqualObjects(t, t2);
        r = s2.serialize((Object)t);
        Assert.assertEquals((Object)"<A f1='f1'>~!@#$%^&amp;*()_+`-={}|[]\\:\";'&lt;&gt;?,.&#x000a;&#x000d;&#x0009;_x0008_</A>\n", (Object)r);
        t2 = (A)p.parse(r, A.class);
        TestUtils.assertEqualObjects(t, t2);
        t.f2 = "  foobar";
        r = s1.serialize((Object)t);
        Assert.assertEquals((Object)"<A f1='f1'>_x0020_ foobar</A>", (Object)r);
        t2 = (A)p.parse(r, A.class);
        TestUtils.assertEqualObjects(t, t2);
        r = s2.serialize((Object)t);
        Assert.assertEquals((Object)"<A f1='f1'>_x0020_ foobar</A>\n", (Object)r);
        t2 = (A)p.parse(r, A.class);
        TestUtils.assertEqualObjects(t, t2);
        t.f2 = "foobar  ";
        r = s1.serialize((Object)t);
        Assert.assertEquals((Object)"<A f1='f1'>foobar _x0020_</A>", (Object)r);
        t2 = (A)p.parse(r, A.class);
        TestUtils.assertEqualObjects(t, t2);
        r = s2.serialize((Object)t);
        Assert.assertEquals((Object)"<A f1='f1'>foobar _x0020_</A>\n", (Object)r);
        t2 = (A)p.parse(r, A.class);
        TestUtils.assertEqualObjects(t, t2);
    }

    @Test
    public void testXmlMixed() throws Exception {
        B t = B.newInstance();
        XmlSerializer s1 = XmlSerializer.DEFAULT_SQ.builder().trimNullProperties(false).build();
        XmlSerializer s2 = XmlSerializer.create().sq().ws().enableNamespaces(false).trimNullProperties(false).build();
        XmlParser p = XmlParser.DEFAULT;
        t.f2 = null;
        StringWriter sw = new StringWriter();
        XmlSerializerSession session = s1.createSession(SerializerSessionArgs.create());
        session.serialize((Object)t, (Object)sw);
        String r = sw.toString();
        Assert.assertEquals((Object)"<A f1='f1' nil='true'></A>", (Object)r);
        B t2 = (B)p.parse(r, B.class);
        TestUtils.assertEqualObjects(t, t2);
        sw = new StringWriter();
        session = s2.createSession(SerializerSessionArgs.create());
        session.serialize((Object)t, (Object)sw);
        r = sw.toString();
        Assert.assertEquals((Object)"<A f1='f1' nil='true'></A>\n", (Object)r);
        t2 = (B)p.parse(r, B.class);
        TestUtils.assertEqualObjects(t, t2);
        t.f2 = "foobar";
        r = s1.serialize((Object)t);
        Assert.assertEquals((Object)"<A f1='f1'>foobar</A>", (Object)r);
        t2 = (B)p.parse(r, B.class);
        TestUtils.assertEqualObjects(t, t2);
        r = s2.serialize((Object)t);
        Assert.assertEquals((Object)"<A f1='f1'>foobar</A>\n", (Object)r);
        t2 = (B)p.parse(r, B.class);
        TestUtils.assertEqualObjects(t, t2);
        t.f2 = "<xxx>foobar<yyy>baz</yyy>foobar</xxx>";
        r = s1.serialize((Object)t);
        Assert.assertEquals((Object)"<A f1='f1'>&lt;xxx&gt;foobar&lt;yyy&gt;baz&lt;/yyy&gt;foobar&lt;/xxx&gt;</A>", (Object)r);
        t2 = (B)p.parse(r, B.class);
        TestUtils.assertEqualObjects(t, t2);
        r = s2.serialize((Object)t);
        Assert.assertEquals((Object)"<A f1='f1'>&lt;xxx&gt;foobar&lt;yyy&gt;baz&lt;/yyy&gt;foobar&lt;/xxx&gt;</A>\n", (Object)r);
        t2 = (B)p.parse(r, B.class);
        TestUtils.assertEqualObjects(t, t2);
        t.f2 = "  <xxx>foobar<yyy>baz</yyy>foobar</xxx>  ";
        r = s1.serialize((Object)t);
        Assert.assertEquals((Object)"<A f1='f1'>_x0020_ &lt;xxx&gt;foobar&lt;yyy&gt;baz&lt;/yyy&gt;foobar&lt;/xxx&gt; _x0020_</A>", (Object)r);
        t2 = (B)p.parse(r, B.class);
        TestUtils.assertEqualObjects(t, t2);
        r = s2.serialize((Object)t);
        Assert.assertEquals((Object)"<A f1='f1'>_x0020_ &lt;xxx&gt;foobar&lt;yyy&gt;baz&lt;/yyy&gt;foobar&lt;/xxx&gt; _x0020_</A>\n", (Object)r);
        t2 = (B)p.parse(r, B.class);
        TestUtils.assertEqualObjects(t, t2);
        t.f2 = "<xxx x=\"x\">foobar</xxx>";
        r = s1.serialize((Object)t);
        Assert.assertEquals((Object)"<A f1='f1'>&lt;xxx x=\"x\"&gt;foobar&lt;/xxx&gt;</A>", (Object)r);
        t2 = (B)p.parse(r, B.class);
        TestUtils.assertEqualObjects(t, t2);
        r = s2.serialize((Object)t);
        Assert.assertEquals((Object)"<A f1='f1'>&lt;xxx x=\"x\"&gt;foobar&lt;/xxx&gt;</A>\n", (Object)r);
        t2 = (B)p.parse(r, B.class);
        TestUtils.assertEqualObjects(t, t2);
        t.f2 = "<xxx x=\"x\">foo&lt;&gt;bar</xxx>";
        r = s1.serialize((Object)t);
        Assert.assertEquals((Object)"<A f1='f1'>&lt;xxx x=\"x\"&gt;foo&amp;lt;&amp;gt;bar&lt;/xxx&gt;</A>", (Object)r);
        t2 = (B)p.parse(r, B.class);
        TestUtils.assertEqualObjects(t, t2);
        r = s2.serialize((Object)t);
        Assert.assertEquals((Object)"<A f1='f1'>&lt;xxx x=\"x\"&gt;foo&amp;lt;&amp;gt;bar&lt;/xxx&gt;</A>\n", (Object)r);
        t2 = (B)p.parse(r, B.class);
        TestUtils.assertEqualObjects(t, t2);
    }

    @Bean(typeName="A")
    public static class B {
        @Xml(format=XmlFormat.ATTR)
        public String f1;
        @Xml(format=XmlFormat.TEXT)
        public String f2;

        public static B newInstance() {
            B t = new B();
            t.f1 = "f1";
            t.f2 = null;
            return t;
        }
    }

    @Bean(typeName="A")
    public static class A {
        @Xml(format=XmlFormat.ATTR)
        public String f1;
        @Xml(format=XmlFormat.TEXT)
        public String f2;

        public static A newInstance() {
            A t = new A();
            t.f1 = "f1";
            t.f2 = null;
            return t;
        }
    }
}

