/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.xml;

import java.util.function.Function;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.XMLEvent;
import javax.xml.stream.util.XMLEventAllocator;
import javax.xml.stream.util.XMLEventConsumer;
import org.apache.juneau.XVar;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.reflect.AnnotationList;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.svl.VarResolver;
import org.apache.juneau.svl.VarResolverSession;
import org.apache.juneau.xml.XmlEventAllocator;
import org.apache.juneau.xml.XmlParser;
import org.apache.juneau.xml.XmlParserSession;
import org.apache.juneau.xml.XmlReporter;
import org.apache.juneau.xml.XmlResolver;
import org.apache.juneau.xml.XmlSerializer;
import org.apache.juneau.xml.XmlSerializerSession;
import org.apache.juneau.xml.annotation.XmlConfig;
import org.junit.Assert;
import org.junit.Test;

public class XmlConfigAnnotationTest {
    private static final Function<Object, String> TO_STRING = new Function<Object, String>(){

        @Override
        public String apply(Object t) {
            if (t == null) {
                return null;
            }
            if (t.getClass().isArray()) {
                return this.apply(ArrayUtils.toList((Object)t, Object.class));
            }
            if (t instanceof AA) {
                return "AA";
            }
            if (t instanceof AB) {
                return "AB";
            }
            if (t instanceof AC) {
                return "AC";
            }
            return t.toString();
        }
    };
    static VarResolverSession sr = VarResolver.create().vars(new Class[]{XVar.class}).build().createSession();
    static ClassInfo a = ClassInfo.of(A.class);
    static ClassInfo b = ClassInfo.of(B.class);
    static ClassInfo c = ClassInfo.of(C.class);

    private static void check(String expected, Object o) {
        Assert.assertEquals((Object)expected, (Object)TO_STRING.apply(o));
    }

    @Test
    public void basicSerializer() throws Exception {
        AnnotationList al = a.getAnnotationList(null);
        XmlSerializerSession x = XmlSerializer.create().applyAnnotations(al, sr).build().createSession();
        XmlConfigAnnotationTest.check("true", x.isAddBeanTypes());
        XmlConfigAnnotationTest.check("true", x.isAddNamespaceUrisToRoot());
        XmlConfigAnnotationTest.check("true", x.isAutoDetectNamespaces());
        XmlConfigAnnotationTest.check("foo:null", x.getDefaultNamespace());
        XmlConfigAnnotationTest.check("true", x.isEnableNamespaces());
        XmlConfigAnnotationTest.check("[foo:null]", x.getNamespaces());
        XmlConfigAnnotationTest.check("foo:null", x.getXsNamespace());
    }

    @Test
    public void basicParser() throws Exception {
        AnnotationList al = a.getAnnotationList(null);
        XmlParserSession x = XmlParser.create().applyAnnotations(al, sr).build().createSession();
        XmlConfigAnnotationTest.check("AA", x.getEventAllocator());
        XmlConfigAnnotationTest.check("true", x.isPreserveRootElement());
        XmlConfigAnnotationTest.check("AB", x.getReporter());
        XmlConfigAnnotationTest.check("AC", x.getResolver());
        XmlConfigAnnotationTest.check("true", x.isValidating());
    }

    @Test
    public void noValuesSerializer() throws Exception {
        AnnotationList al = b.getAnnotationList(null);
        XmlSerializerSession x = XmlSerializer.create().applyAnnotations(al, sr).build().createSession();
        XmlConfigAnnotationTest.check("false", x.isAddBeanTypes());
        XmlConfigAnnotationTest.check("false", x.isAddNamespaceUrisToRoot());
        XmlConfigAnnotationTest.check("true", x.isAutoDetectNamespaces());
        XmlConfigAnnotationTest.check("juneau:http://www.apache.org/2013/Juneau", x.getDefaultNamespace());
        XmlConfigAnnotationTest.check("false", x.isEnableNamespaces());
        XmlConfigAnnotationTest.check("[]", x.getNamespaces());
        XmlConfigAnnotationTest.check("xs:http://www.w3.org/2001/XMLSchema", x.getXsNamespace());
    }

    @Test
    public void noValuesParser() throws Exception {
        AnnotationList al = b.getAnnotationList(null);
        XmlParserSession x = XmlParser.create().applyAnnotations(al, sr).build().createSession();
        XmlConfigAnnotationTest.check(null, x.getEventAllocator());
        XmlConfigAnnotationTest.check("false", x.isPreserveRootElement());
        XmlConfigAnnotationTest.check(null, x.getReporter());
        XmlConfigAnnotationTest.check(null, x.getResolver());
        XmlConfigAnnotationTest.check("false", x.isValidating());
    }

    @Test
    public void noAnnotationSerializer() throws Exception {
        AnnotationList al = c.getAnnotationList(null);
        XmlSerializerSession x = XmlSerializer.create().applyAnnotations(al, sr).build().createSession();
        XmlConfigAnnotationTest.check("false", x.isAddBeanTypes());
        XmlConfigAnnotationTest.check("false", x.isAddNamespaceUrisToRoot());
        XmlConfigAnnotationTest.check("true", x.isAutoDetectNamespaces());
        XmlConfigAnnotationTest.check("juneau:http://www.apache.org/2013/Juneau", x.getDefaultNamespace());
        XmlConfigAnnotationTest.check("false", x.isEnableNamespaces());
        XmlConfigAnnotationTest.check("[]", x.getNamespaces());
        XmlConfigAnnotationTest.check("xs:http://www.w3.org/2001/XMLSchema", x.getXsNamespace());
    }

    @Test
    public void noAnnotationParser() throws Exception {
        AnnotationList al = c.getAnnotationList(null);
        XmlParserSession x = XmlParser.create().applyAnnotations(al, sr).build().createSession();
        XmlConfigAnnotationTest.check(null, x.getEventAllocator());
        XmlConfigAnnotationTest.check("false", x.isPreserveRootElement());
        XmlConfigAnnotationTest.check(null, x.getReporter());
        XmlConfigAnnotationTest.check(null, x.getResolver());
        XmlConfigAnnotationTest.check("false", x.isValidating());
    }

    static class C {
        C() {
        }
    }

    @XmlConfig
    static class B {
        B() {
        }
    }

    @XmlConfig(addBeanTypes="$X{true}", addNamespaceUrisToRoot="$X{true}", autoDetectNamespaces="$X{true}", defaultNamespace="$X{foo}", enableNamespaces="$X{true}", eventAllocator=AA.class, namespaces={"$X{foo}"}, preserveRootElement="$X{true}", reporter=AB.class, resolver=AC.class, validating="$X{true}", xsNamespace="$X{foo}")
    static class A {
        A() {
        }
    }

    public static class AC
    extends XmlResolver {
        public Object resolveEntity(String publicID, String systemID, String baseURI, String namespace) throws XMLStreamException {
            return null;
        }
    }

    public static class AB
    extends XmlReporter {
        public void report(String message, String errorType, Object relatedInformation, Location location) throws XMLStreamException {
        }
    }

    public static class AA
    extends XmlEventAllocator {
        public XMLEventAllocator newInstance() {
            return null;
        }

        public XMLEvent allocate(XMLStreamReader reader) throws XMLStreamException {
            return null;
        }

        public void allocate(XMLStreamReader reader, XMLEventConsumer consumer) throws XMLStreamException {
        }
    }
}

