/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.xml;

import java.util.LinkedList;
import java.util.List;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.testutils.TestUtils;
import org.apache.juneau.utils.AList;
import org.apache.juneau.xml.XmlParser;
import org.apache.juneau.xml.XmlSerializer;
import org.apache.juneau.xml.annotation.Xml;
import org.apache.juneau.xml.annotation.XmlFormat;
import org.junit.Assert;
import org.junit.Test;

public class XmlCollapsedTest {
    @Test
    public void testBasic() throws Exception {
        XmlSerializer s = XmlSerializer.DEFAULT_SQ;
        XmlParser p = XmlParser.DEFAULT;
        A t = new A();
        t.f1 = new AList().append((Object)"f1a").append((Object)"f1b");
        t.f2 = new String[]{"f2a", "f2b"};
        t.f3 = new AList().append((Object)"f3a").append((Object)"f3b");
        t.f4 = new String[]{"f4a", "f4b"};
        String xml = s.serialize((Object)t);
        Assert.assertEquals((Object)"<object><f1>f1a</f1><f1>f1b</f1><f2>f2a</f2><f2>f2b</f2><xf3>f3a</xf3><xf3>f3b</xf3><xf4>f4a</xf4><xf4>f4b</xf4></object>", (Object)xml);
        t = (A)p.parse(xml, A.class);
        Assert.assertEquals((Object)"f1a", (Object)t.f1.get(0));
        Assert.assertEquals((Object)"f2a", (Object)t.f2[0]);
        Assert.assertEquals((Object)"f3a", (Object)t.f3.get(0));
        Assert.assertEquals((Object)"f4a", (Object)t.f4[0]);
        TestUtils.validateXml(t, s);
    }

    @Test
    public void testUninitializedFields() throws Exception {
        XmlSerializer s = XmlSerializer.DEFAULT_SQ;
        XmlParser p = XmlParser.DEFAULT;
        B t = new B();
        t.f1 = new AList().append((Object)"f1a").append((Object)"f1b");
        t.f2 = new String[]{"f2a", "f2b"};
        t.f3 = new AList().append((Object)"f3a").append((Object)"f3b");
        t.f4 = new String[]{"f4a", "f4b"};
        String xml = s.serialize((Object)t);
        Assert.assertEquals((Object)"<object><f1>f1a</f1><f1>f1b</f1><f2>f2a</f2><f2>f2b</f2><xf3>f3a</xf3><xf3>f3b</xf3><xf4>f4a</xf4><xf4>f4b</xf4></object>", (Object)xml);
        t = (B)p.parse(xml, B.class);
        Assert.assertEquals((Object)"f1a", (Object)t.f1.get(0));
        Assert.assertEquals((Object)"f2a", (Object)t.f2[0]);
        Assert.assertEquals((Object)"f3a", (Object)t.f3.get(0));
        Assert.assertEquals((Object)"f4a", (Object)t.f4[0]);
        TestUtils.validateXml(t, s);
    }

    @Test
    public void testInitializedFields() throws Exception {
        XmlSerializer s = XmlSerializer.DEFAULT_SQ;
        XmlParser p = XmlParser.DEFAULT;
        C t = new C();
        t.f1 = new AList().append((Object)"f1b");
        t.f2 = new String[]{"f2b"};
        t.f3 = new AList().append((Object)"f3b");
        t.f4 = new String[]{"f4b"};
        String xml = s.serialize((Object)t);
        Assert.assertEquals((Object)"<object><f1>f1b</f1><f2>f2b</f2><xf3>f3b</xf3><xf4>f4b</xf4></object>", (Object)xml);
        t = (C)p.parse(xml, C.class);
        Assert.assertEquals((Object)"f1a", (Object)t.f1.get(0));
        Assert.assertEquals((Object)"f1b", (Object)t.f1.get(1));
        Assert.assertEquals((Object)"f2a", (Object)t.f2[0]);
        Assert.assertEquals((Object)"f2b", (Object)t.f2[1]);
        Assert.assertEquals((Object)"f3a", (Object)t.f3.get(0));
        Assert.assertEquals((Object)"f3b", (Object)t.f3.get(1));
        Assert.assertEquals((Object)"f4a", (Object)t.f4[0]);
        Assert.assertEquals((Object)"f4b", (Object)t.f4[1]);
        TestUtils.validateXml(t, s);
    }

    @Test
    public void testGetters() throws Exception {
        XmlSerializer s = XmlSerializer.DEFAULT_SQ;
        XmlParser p = XmlParser.DEFAULT;
        D t = new D();
        t.f1 = (List)new AList().append((Object)"f1a");
        D.access$102(t, new String[]{"f2a"});
        t.f3 = (List)new AList().append((Object)"f3a");
        D.access$302(t, new String[]{"f4a"});
        String xml = s.serialize((Object)t);
        Assert.assertEquals((Object)"<object><f1>f1a</f1><f2>f2a</f2><xf3>f3a</xf3><xf4>f4a</xf4></object>", (Object)xml);
        t = (D)p.parse(xml, D.class);
        Assert.assertEquals((Object)"f1a", t.f1.get(0));
        Assert.assertEquals((Object)"f2a", (Object)t.f2[0]);
        Assert.assertEquals((Object)"f3a", t.f3.get(0));
        Assert.assertEquals((Object)"f4a", (Object)t.f4[0]);
        TestUtils.validateXml(t, s);
    }

    @Test
    public void testNullConstructibleCollectionFields() throws Exception {
        XmlSerializer s = XmlSerializer.DEFAULT_SQ;
        XmlParser p = XmlParser.DEFAULT;
        E t = new E();
        t.f1 = (LinkedList)new AList().append((Object)"f1a");
        t.f2 = (LinkedList)new AList().append((Object)"f2a");
        String xml = s.serialize((Object)t);
        Assert.assertEquals((Object)"<object><f1>f1a</f1><xf2>f2a</xf2></object>", (Object)xml);
        t = (E)p.parse(xml, E.class);
        Assert.assertEquals((Object)"f1a", t.f1.get(0));
        Assert.assertEquals((Object)"f2a", t.f2.get(0));
        TestUtils.validateXml(t, s);
    }

    @Test
    public void testElementNameOnElementClass() throws Exception {
        XmlSerializer s = XmlSerializer.DEFAULT_SQ;
        XmlParser p = XmlParser.DEFAULT;
        Object t1 = FA.newInstance();
        String r = s.serialize(t1);
        Assert.assertEquals((Object)"<object><xf1>x1</xf1><xf1>x2</xf1></object>", (Object)r);
        Object t2 = p.parse(r, FA.class);
        TestUtils.assertEqualObjects(t1, t2);
        TestUtils.validateXml(t1, s);
        t1 = FB.newInstance();
        r = s.serialize(t1);
        Assert.assertEquals((Object)"<object><xf1>x1</xf1><xf1>x2</xf1></object>", (Object)r);
        t2 = p.parse(r, FB.class);
        TestUtils.assertEqualObjects(t1, t2);
        TestUtils.validateXml(t1, s);
    }

    @Test
    public void testElementNameOnElementClassOverridden() throws Exception {
        XmlSerializer s = XmlSerializer.DEFAULT_SQ;
        XmlParser p = XmlParser.DEFAULT;
        G t = G.newInstance();
        String xml = s.serialize((Object)t);
        Assert.assertEquals((Object)"<object><yf1>x1</yf1><yf1>x2</yf1></object>", (Object)xml);
        G t2 = (G)p.parse(xml, G.class);
        TestUtils.assertEqualObjects(t, t2);
        TestUtils.validateXml(t, s);
    }

    @Test
    public void testElementNameOnCollectionClass() throws Exception {
        XmlSerializer s = XmlSerializer.DEFAULT_SQ;
        XmlParser p = XmlParser.DEFAULT;
        H t = H.newInstance();
        String xml = s.serialize((Object)t);
        Assert.assertEquals((Object)"<object><xf1>x1</xf1><xf1>x2</xf1></object>", (Object)xml);
        H t2 = (H)p.parse(xml, H.class);
        TestUtils.assertEqualObjects(t, t2);
        TestUtils.validateXml(t, s);
    }

    @Test
    public void testElementNameOnCollectionClassOverridden() throws Exception {
        XmlSerializer s = XmlSerializer.DEFAULT_SQ;
        XmlParser p = XmlParser.DEFAULT;
        G t = G.newInstance();
        String xml = s.serialize((Object)t);
        Assert.assertEquals((Object)"<object><yf1>x1</yf1><yf1>x2</yf1></object>", (Object)xml);
        G t2 = (G)p.parse(xml, G.class);
        TestUtils.assertEqualObjects(t, t2);
        TestUtils.validateXml(t, s);
    }

    public static class I {
        @Xml(format=XmlFormat.COLLAPSED, childName="yf1")
        public H1 f1;

        public static I newInstance() {
            I t = new I();
            t.f1 = new H1();
            t.f1.add("x1");
            t.f1.add("x2");
            return t;
        }
    }

    @Xml(childName="xf1")
    public static class H1
    extends LinkedList<String> {
    }

    public static class H {
        @Xml(format=XmlFormat.COLLAPSED)
        public H1 f1;

        public static H newInstance() {
            H t = new H();
            t.f1 = new H1();
            t.f1.add("x1");
            t.f1.add("x2");
            return t;
        }
    }

    public static class G {
        @Xml(format=XmlFormat.COLLAPSED, childName="yf1")
        public List<F1> f1;

        public static G newInstance() {
            G t = new G();
            t.f1 = new LinkedList<F1>();
            t.f1.add(F1.newInstance("x1"));
            t.f1.add(F1.newInstance("x2"));
            return t;
        }
    }

    @Bean(typeName="xf1")
    public static class F1 {
        @Xml(format=XmlFormat.TEXT)
        public String text;

        public static F1 newInstance(String text) {
            F1 t = new F1();
            t.text = text;
            return t;
        }
    }

    public static class FB {
        @Xml(format=XmlFormat.COLLAPSED)
        public F1[] f1;

        public static FB newInstance() {
            FB t = new FB();
            t.f1 = new F1[]{F1.newInstance("x1"), F1.newInstance("x2")};
            return t;
        }
    }

    public static class FA {
        @Xml(format=XmlFormat.COLLAPSED)
        public List<F1> f1;

        public static FA newInstance() {
            FA t = new FA();
            t.f1 = new LinkedList<F1>();
            t.f1.add(F1.newInstance("x1"));
            t.f1.add(F1.newInstance("x2"));
            return t;
        }
    }

    @Bean(bpi="f1,f2")
    public static class E {
        private LinkedList<String> f1;
        private LinkedList<String> f2;

        @Xml(format=XmlFormat.COLLAPSED)
        public LinkedList<String> getF1() {
            return this.f1;
        }

        public void setF1(LinkedList<String> f1) {
            this.f1 = f1;
        }

        @Xml(format=XmlFormat.COLLAPSED, childName="xf2")
        public LinkedList<String> getF2() {
            return this.f2;
        }

        public void setF2(LinkedList<String> f2) {
            this.f2 = f2;
        }
    }

    @Bean(bpi="f1,f2,f3,f4")
    public static class D {
        private List<String> f1 = new LinkedList<String>();
        private List<String> f3 = new LinkedList<String>();
        private String[] f2;
        private String[] f4;

        @Xml(format=XmlFormat.COLLAPSED)
        public List<String> getF1() {
            return this.f1;
        }

        @Xml(format=XmlFormat.COLLAPSED)
        public String[] getF2() {
            return this.f2;
        }

        public void setF2(String[] f2) {
            this.f2 = f2;
        }

        @Xml(format=XmlFormat.COLLAPSED, childName="xf3")
        public List<String> getF3() {
            return this.f3;
        }

        @Xml(format=XmlFormat.COLLAPSED, childName="xf4")
        public String[] getF4() {
            return this.f4;
        }

        public void setF4(String[] f4) {
            this.f4 = f4;
        }

        static /* synthetic */ String[] access$102(D x0, String[] x1) {
            x0.f2 = x1;
            return x1;
        }

        static /* synthetic */ String[] access$302(D x0, String[] x1) {
            x0.f4 = x1;
            return x1;
        }
    }

    public static class C {
        @Xml(format=XmlFormat.COLLAPSED)
        public List<String> f1 = new AList().append((Object)"f1a");
        @Xml(format=XmlFormat.COLLAPSED)
        public String[] f2 = new String[]{"f2a"};
        @Xml(format=XmlFormat.COLLAPSED, childName="xf3")
        public List<String> f3 = new AList().append((Object)"f3a");
        @Xml(format=XmlFormat.COLLAPSED, childName="xf4")
        public String[] f4 = new String[]{"f4a"};
    }

    public static class B {
        @Xml(format=XmlFormat.COLLAPSED)
        public List<String> f1;
        @Xml(format=XmlFormat.COLLAPSED)
        public String[] f2;
        @Xml(format=XmlFormat.COLLAPSED, childName="xf3")
        public List<String> f3;
        @Xml(format=XmlFormat.COLLAPSED, childName="xf4")
        public String[] f4;
    }

    public static class A {
        @Xml(format=XmlFormat.COLLAPSED)
        public List<String> f1 = new LinkedList<String>();
        @Xml(format=XmlFormat.COLLAPSED)
        public String[] f2 = new String[0];
        @Xml(format=XmlFormat.COLLAPSED, childName="xf3")
        public List<String> f3 = new LinkedList<String>();
        @Xml(format=XmlFormat.COLLAPSED, childName="xf4")
        public String[] f4 = new String[0];
    }
}

