/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.xml;

import java.util.Arrays;
import java.util.Collection;
import org.apache.juneau.ObjectList;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.xml.XmlSerializer;
import org.apache.juneau.xml.annotation.Xml;
import org.apache.juneau.xml.annotation.XmlFormat;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class InvalidXmlBeansTest {
    private static final XmlSerializer s1 = XmlSerializer.DEFAULT_SQ;
    private String label;
    private String expected;
    private Object in;

    @Parameterized.Parameters
    public static Collection<Object[]> getParameters() {
        return Arrays.asList({"BeanWithAttrFormat", new BeanWithAttrFormat(), "org.apache.juneau.xml.InvalidXmlBeansTest$BeanWithAttrFormat: Invalid format specified in @Xml annotation on bean: ATTR.  Must be one of the following: DEFAULT,ATTRS,ELEMENTS,VOID"}, {"BeanWithElementFormat", new BeanWithElementFormat(), "org.apache.juneau.xml.InvalidXmlBeansTest$BeanWithElementFormat: Invalid format specified in @Xml annotation on bean: ELEMENT.  Must be one of the following: DEFAULT,ATTRS,ELEMENTS,VOID"}, {"BeanWithCollapsedFormat", new BeanWithCollapsedFormat(), "org.apache.juneau.xml.InvalidXmlBeansTest$BeanWithCollapsedFormat: Invalid format specified in @Xml annotation on bean: COLLAPSED.  Must be one of the following: DEFAULT,ATTRS,ELEMENTS,VOID"}, {"BeanWithMixedFormat", new BeanWithMixedFormat(), "org.apache.juneau.xml.InvalidXmlBeansTest$BeanWithMixedFormat: Invalid format specified in @Xml annotation on bean: MIXED.  Must be one of the following: DEFAULT,ATTRS,ELEMENTS,VOID"}, {"BeanWithMultipleAttrs", new BeanWithMultipleAttrs(), "org.apache.juneau.xml.InvalidXmlBeansTest$BeanWithMultipleAttrs: Multiple instances of ATTRS properties defined on class.  Only one property can be designated as such."}, {"BeanWithWrongAttrsType", new BeanWithWrongAttrsType(), "org.apache.juneau.xml.InvalidXmlBeansTest$BeanWithWrongAttrsType: Invalid type for ATTRS property.  Only properties of type Map and bean can be used."}, {"BeanWithMulipleElements", new BeanWithMulipleElements(), "org.apache.juneau.xml.InvalidXmlBeansTest$BeanWithMulipleElements: Multiple instances of ELEMENTS properties defined on class.  Only one property can be designated as such."}, {"BeanWithWrongElementsType", new BeanWithWrongElementsType(), "org.apache.juneau.xml.InvalidXmlBeansTest$BeanWithWrongElementsType: Invalid type for ELEMENTS property.  Only properties of type Collection and array can be used."}, {"BeanWithMulipleMixed", new BeanWithMulipleMixed(), "org.apache.juneau.xml.InvalidXmlBeansTest$BeanWithMulipleMixed: Multiple instances of MIXED properties defined on class.  Only one property can be designated as such."}, {"BeanWithConflictingChildNames", new BeanWithConflictingChildNames(), "org.apache.juneau.xml.InvalidXmlBeansTest$BeanWithConflictingChildNames: Multiple properties found with the child name 'X'."}, {"BeanWithElementsAndMixed", new BeanWithElementsAndMixed(), "org.apache.juneau.xml.InvalidXmlBeansTest$BeanWithElementsAndMixed: ELEMENTS and MIXED properties found on the same bean.  Only one property can be designated as such."}, {"BeanWithElementsAndElement", new BeanWithElementsAndElement(), "org.apache.juneau.xml.InvalidXmlBeansTest$BeanWithElementsAndElement: ELEMENTS and ELEMENT properties found on the same bean.  These cannot be mixed."}, {"BeanWithElementsAndDefault", new BeanWithElementsAndDefault(), "org.apache.juneau.xml.InvalidXmlBeansTest$BeanWithElementsAndDefault: ELEMENTS and ELEMENT properties found on the same bean.  These cannot be mixed."}, {"BeanWithElementsAndCollapsed", new BeanWithElementsAndCollapsed(), "org.apache.juneau.xml.InvalidXmlBeansTest$BeanWithElementsAndCollapsed: ELEMENTS and COLLAPSED properties found on the same bean.  These cannot be mixed."}, {"BeanWithChildAndPropNameConflict", new BeanWithChildAndPropNameConflict(), "org.apache.juneau.xml.InvalidXmlBeansTest$BeanWithChildAndPropNameConflict: Child element name conflicts found with another property."});
    }

    public InvalidXmlBeansTest(String label, Object in, String expected) throws Exception {
        this.label = label;
        this.in = in;
        this.expected = expected;
    }

    @Test
    public void test() {
        try {
            s1.serialize(this.in);
            Assert.fail((String)(this.label + ":  Expected exception didn't occur."));
        }
        catch (Exception e) {
            Assert.assertEquals((String)(this.label + ":  Wrong error message."), (Object)this.expected, (Object)e.getLocalizedMessage());
        }
    }

    public static class BeanWithChildAndPropNameConflict {
        @Xml(format=XmlFormat.COLLAPSED, childName="f2")
        public ObjectList f1;
        public ObjectList f2;
    }

    public static class BeanWithElementsAndCollapsed {
        @Xml(format=XmlFormat.ELEMENTS)
        public ObjectList f1;
        @Xml(format=XmlFormat.COLLAPSED)
        public ObjectList f2;
    }

    public static class BeanWithElementsAndDefault {
        @Xml(format=XmlFormat.ELEMENTS)
        public ObjectList f1;
        public ObjectList f2;
    }

    public static class BeanWithElementsAndElement {
        @Xml(format=XmlFormat.ELEMENTS)
        public ObjectList f1;
        @Xml(format=XmlFormat.ELEMENT)
        public ObjectList f2;
    }

    public static class BeanWithElementsAndMixed {
        @Xml(format=XmlFormat.ELEMENTS)
        public ObjectList f1;
        @Xml(format=XmlFormat.MIXED)
        public ObjectList f2;
    }

    public static class BeanWithConflictingChildNames {
        @Xml(format=XmlFormat.COLLAPSED, childName="X")
        public ObjectList f1;
        @Xml(format=XmlFormat.COLLAPSED, childName="X")
        public ObjectList f2;
    }

    public static class BeanWithMulipleMixed {
        @Xml(format=XmlFormat.MIXED)
        public ObjectList f1;
        @Xml(format=XmlFormat.MIXED)
        public ObjectList f2;
    }

    public static class BeanWithWrongElementsType {
        @Xml(format=XmlFormat.ELEMENTS)
        public ObjectMap f1;
    }

    public static class BeanWithMulipleElements {
        @Xml(format=XmlFormat.ELEMENTS)
        public ObjectList f1;
        @Xml(format=XmlFormat.ELEMENTS)
        public ObjectList f2;
    }

    public static class BeanWithWrongAttrsType {
        @Xml(format=XmlFormat.ATTRS)
        public ObjectList f1;
    }

    public static class BeanWithMultipleAttrs {
        @Xml(format=XmlFormat.ATTRS)
        public ObjectMap f1;
        @Xml(format=XmlFormat.ATTRS)
        public ObjectMap f2;
    }

    @Xml(format=XmlFormat.MIXED)
    public static class BeanWithMixedFormat {
        public int f1;
    }

    @Xml(format=XmlFormat.COLLAPSED)
    public static class BeanWithCollapsedFormat {
        public int f1;
    }

    @Xml(format=XmlFormat.ELEMENT)
    public static class BeanWithElementFormat {
        public int f1;
    }

    @Xml(format=XmlFormat.ATTR)
    public static class BeanWithAttrFormat {
        public int f1;
    }
}

