/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.xml;

import java.net.URL;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.testutils.TestUtils;
import org.apache.juneau.xml.XmlParser;
import org.apache.juneau.xml.XmlSerializer;
import org.apache.juneau.xml.annotation.Xml;
import org.apache.juneau.xml.annotation.XmlFormat;
import org.junit.Assert;
import org.junit.Test;

public class CommonXmlTest {
    @Test
    public void testBeanUriAnnotation() throws Exception {
        XmlParser p = XmlParser.DEFAULT;
        XmlSerializer s = XmlSerializer.DEFAULT_SQ;
        A t = new A("http://foo", 123, "bar");
        String xml = s.serialize((Object)t);
        Assert.assertEquals((Object)"<object url='http://foo' id='123'><name>bar</name></object>", (Object)xml);
        t = (A)p.parse(xml, A.class);
        Assert.assertEquals((Object)"http://foo", (Object)t.url.toString());
        Assert.assertEquals((long)123L, (long)t.id);
        Assert.assertEquals((Object)"bar", (Object)t.name);
        TestUtils.validateXml(t, s);
    }

    @Test
    public void testBeanUriAnnotationOnlyUriProperty() throws Exception {
        XmlSerializer s = XmlSerializer.create().sq().addNamespaceUrisToRoot(false).build();
        B t = new B("http://foo");
        String xml = s.serialize((Object)t);
        Assert.assertEquals((Object)"<object url='http://foo'><url2>http://foo/2</url2></object>", (Object)xml);
    }

    public static class B {
        @Xml(format=XmlFormat.ATTR)
        public URL url;
        public URL url2;

        public B() {
        }

        public B(String url) throws Exception {
            this.url = new URL(url);
            this.url2 = new URL(url + "/2");
        }
    }

    @Bean(bpi="url,id,name")
    public static class A {
        @Xml(format=XmlFormat.ATTR)
        public URL url;
        @Xml(format=XmlFormat.ATTR)
        public int id;
        public String name;

        public A() {
        }

        public A(String url, int id, String name) throws Exception {
            this.url = new URL(url);
            this.id = id;
            this.name = name;
        }
    }
}

