/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.xml;

import java.net.URI;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.annotation.Beanp;
import org.apache.juneau.jena.annotation.Rdf;
import org.apache.juneau.testutils.TestUtils;
import org.apache.juneau.utils.AList;
import org.apache.juneau.utils.AMap;
import org.apache.juneau.xml.XmlParser;
import org.apache.juneau.xml.XmlSerializer;
import org.apache.juneau.xml.XmlSerializerBuilder;
import org.apache.juneau.xml.annotation.Xml;
import org.apache.juneau.xml.annotation.XmlFormat;
import org.junit.Assert;
import org.junit.Test;

public class CommonTest {
    @Test
    public void testTrimNullsFromBeans() throws Exception {
        XmlSerializerBuilder s = XmlSerializer.create().sq();
        XmlParser p = XmlParser.DEFAULT;
        A t1 = A.create();
        s.trimNullProperties(false);
        String r = s.build().serialize((Object)t1);
        Assert.assertEquals((Object)"<object><s1 _type='null'/><s2>s2</s2></object>", (Object)r);
        A t2 = (A)p.parse(r, A.class);
        TestUtils.assertEqualObjects(t1, t2);
        s.trimNullProperties(true);
        r = s.build().serialize((Object)t1);
        Assert.assertEquals((Object)"<object><s2>s2</s2></object>", (Object)r);
        t2 = (A)p.parse(r, A.class);
        TestUtils.assertEqualObjects(t1, t2);
    }

    @Test
    public void testTrimEmptyMaps() throws Exception {
        XmlSerializerBuilder s = XmlSerializer.create().sq();
        XmlParser p = XmlParser.DEFAULT;
        B t1 = B.create();
        s.trimEmptyMaps(false);
        String r = s.build().serialize((Object)t1);
        Assert.assertEquals((Object)"<object><f1/><f2><f2a _type='null'/><f2b><s2>s2</s2></f2b></f2></object>", (Object)r);
        B t2 = (B)p.parse(r, B.class);
        TestUtils.assertEqualObjects(t1, t2);
        s.trimEmptyMaps(true);
        r = s.build().serialize((Object)t1);
        Assert.assertEquals((Object)"<object><f2><f2a _type='null'/><f2b><s2>s2</s2></f2b></f2></object>", (Object)r);
        t2 = (B)p.parse(r, B.class);
        Assert.assertNull(t2.f1);
        s.trimEmptyMaps();
        r = s.build().serialize((Object)t1);
        Assert.assertEquals((Object)"<object><f2><f2a _type='null'/><f2b><s2>s2</s2></f2b></f2></object>", (Object)r);
        t2 = (B)p.parse(r, B.class);
        Assert.assertNull(t2.f1);
    }

    @Test
    public void testTrimEmptyLists() throws Exception {
        XmlSerializerBuilder s = XmlSerializer.create().sq();
        XmlParser p = XmlParser.DEFAULT;
        C t1 = C.create();
        s.trimEmptyCollections(false);
        String r = s.build().serialize((Object)t1);
        Assert.assertEquals((Object)"<object><f1></f1><f2><null/><object><s2>s2</s2></object></f2></object>", (Object)r);
        C t2 = (C)p.parse(r, C.class);
        TestUtils.assertEqualObjects(t1, t2);
        s.trimEmptyCollections(true);
        r = s.build().serialize((Object)t1);
        Assert.assertEquals((Object)"<object><f2><null/><object><s2>s2</s2></object></f2></object>", (Object)r);
        t2 = (C)p.parse(r, C.class);
        Assert.assertNull(t2.f1);
        s.trimEmptyCollections();
        r = s.build().serialize((Object)t1);
        Assert.assertEquals((Object)"<object><f2><null/><object><s2>s2</s2></object></f2></object>", (Object)r);
        t2 = (C)p.parse(r, C.class);
        Assert.assertNull(t2.f1);
    }

    @Test
    public void testTrimEmptyArrays() throws Exception {
        XmlSerializerBuilder s = XmlSerializer.create().sq();
        XmlParser p = XmlParser.DEFAULT;
        D t1 = D.create();
        s.trimEmptyCollections(false);
        String r = s.build().serialize((Object)t1);
        Assert.assertEquals((Object)"<object><f1></f1><f2><null/><object><s2>s2</s2></object></f2></object>", (Object)r);
        D t2 = (D)p.parse(r, D.class);
        TestUtils.assertEqualObjects(t1, t2);
        s.trimEmptyCollections(true);
        r = s.build().serialize((Object)t1);
        Assert.assertEquals((Object)"<object><f2><null/><object><s2>s2</s2></object></f2></object>", (Object)r);
        t2 = (D)p.parse(r, D.class);
        Assert.assertNull((Object)t2.f1);
        s.trimEmptyCollections();
        r = s.build().serialize((Object)t1);
        Assert.assertEquals((Object)"<object><f2><null/><object><s2>s2</s2></object></f2></object>", (Object)r);
        t2 = (D)p.parse(r, D.class);
        Assert.assertNull((Object)t2.f1);
    }

    @Test
    public void testBeanPropertyProperties() throws Exception {
        XmlSerializer s = XmlSerializer.DEFAULT_SQ;
        E1 t = new E1();
        String r = s.serialize((Object)t);
        Assert.assertEquals((Object)"<object><x1 f2='2'><f1>1</f1></x1><x2><f1>1</f1></x2><x3><object f2='2'><f1>1</f1></object></x3><x4><object f2='2'><f1>1</f1></object></x4><x5><object><f1 _type='number'>1</f1></object></x5><x6><object><f1 _type='number'>1</f1></object></x6></object>", (Object)r);
        TestUtils.validateXml(t);
    }

    @Test
    public void testBeanPropertyPropertiesOnListOfBeans() throws Exception {
        XmlSerializer s = XmlSerializer.DEFAULT_SQ;
        LinkedList<Test7b> l = new LinkedList<Test7b>();
        Test7b t = new Test7b();
        t.x1.add(new Test7b());
        l.add(t);
        String xml = s.serialize(l);
        Assert.assertEquals((Object)"<array><object><x1><object><x2>2</x2></object></x1><x2>2</x2></object></array>", (Object)xml);
    }

    @Test
    public void testURIAttr() throws Exception {
        XmlSerializer s = XmlSerializer.DEFAULT_SQ;
        XmlParser p = XmlParser.DEFAULT;
        G t = new G();
        t.uri = new URI("http://uri");
        t.f1 = new URI("http://f1");
        t.f2 = new URL("http://f2");
        String xml = s.serialize((Object)t);
        t = (G)p.parse(xml, G.class);
        Assert.assertEquals((Object)"http://uri", (Object)t.uri.toString());
        Assert.assertEquals((Object)"http://f1", (Object)t.f1.toString());
        Assert.assertEquals((Object)"http://f2", (Object)t.f2.toString());
    }

    @Test
    public void testRecursion() throws Exception {
        String msg;
        XmlSerializerBuilder s = XmlSerializer.create().enableNamespaces(false);
        R1 r1 = new R1();
        R2 r2 = new R2();
        R3 r3 = new R3();
        r1.r2 = r2;
        r2.r3 = r3;
        r3.r1 = r1;
        try {
            s.build().serialize((Object)r1);
            Assert.fail((String)"Exception expected!");
        }
        catch (Exception e) {
            msg = e.getLocalizedMessage();
            TestUtils.assertContains(msg, "It's recommended you use the BeanTraverseContext.BEANTRAVERSE_detectRecursions setting to help locate the loop.");
        }
        s.detectRecursions();
        try {
            s.build().serialize((Object)r1);
            Assert.fail((String)"Exception expected!");
        }
        catch (Exception e) {
            msg = e.getLocalizedMessage();
            Assert.assertTrue((boolean)msg.contains("[0] <noname>:org.apache.juneau.xml.CommonTest$R1"));
            Assert.assertTrue((boolean)msg.contains("->[1] r2:org.apache.juneau.xml.CommonTest$R2"));
            Assert.assertTrue((boolean)msg.contains("->[2] r3:org.apache.juneau.xml.CommonTest$R3"));
            Assert.assertTrue((boolean)msg.contains("->[3] r1:org.apache.juneau.xml.CommonTest$R1"));
        }
        s.ignoreRecursions();
        Assert.assertEquals((Object)"<object><name>foo</name><r2><name>bar</name><r3><name>baz</name></r3></r2></object>", (Object)s.build().serialize((Object)r1));
        s.build().getSchemaSerializer().serialize((Object)r1);
    }

    public static class R3 {
        public String name = "baz";
        public R1 r1;
    }

    public static class R2 {
        public String name = "bar";
        public R3 r3;
    }

    public static class R1 {
        public String name = "foo";
        public R2 r2;
    }

    public static class G {
        @Rdf(beanUri=true)
        public URI uri;
        public URI f1;
        public URL f2;
    }

    public static class Test7b {
        @Beanp(properties="x2")
        public List<Test7b> x1 = new LinkedList<Test7b>();
        public int x2 = 2;
    }

    public static class E2 {
        public int f1 = 1;
        @Xml(format=XmlFormat.ATTR)
        public int f2 = 2;
        public int f3 = 3;
        @Xml(format=XmlFormat.ATTR)
        public int f4 = 4;
    }

    public static class E1 {
        @Beanp(properties="f1,f2")
        public E2 x1 = new E2();
        @Beanp(properties="f1,f2")
        public Map<String, Integer> x2 = new AMap().append((Object)"f1", (Object)1).append((Object)"f3", (Object)3);
        @Beanp(properties="f1,f2")
        public E2[] x3 = new E2[]{new E2()};
        @Beanp(properties="f1,f2")
        public List<E2> x4 = new AList().append((Object)new E2());
        @Beanp(properties="f1")
        public ObjectMap[] x5 = new ObjectMap[]{new ObjectMap().append("f1", (Object)1).append("f3", (Object)3)};
        @Beanp(properties="f1")
        public List<ObjectMap> x6 = new AList().append((Object)new ObjectMap().append("f1", (Object)1).append("f3", (Object)3));
    }

    public static class D {
        public A[] f1;
        public A[] f2;

        public static D create() {
            D t = new D();
            t.f1 = new A[0];
            t.f2 = new A[]{null, A.create()};
            return t;
        }
    }

    public static class C {
        public List<A> f1;
        public List<A> f2;

        public static C create() {
            C t = new C();
            t.f1 = new AList();
            t.f2 = new AList().append(null).append((Object)A.create());
            return t;
        }
    }

    public static class B {
        public TreeMap<String, A> f1;
        public TreeMap<String, A> f2;

        public static B create() {
            B t = new B();
            t.f1 = new TreeMap();
            t.f2 = new TreeMap<String, A>(){
                {
                    this.put("f2a", null);
                    this.put("f2b", A.create());
                }
            };
            return t;
        }
    }

    public static class A {
        public String s1;
        public String s2;

        public static A create() {
            A t = new A();
            t.s2 = "s2";
            return t;
        }
    }
}

