/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.xml;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.juneau.ObjectList;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.ParserListener;
import org.apache.juneau.parser.ParserSession;
import org.apache.juneau.xml.XmlParser;
import org.apache.juneau.xml.XmlSerializer;
import org.junit.Assert;
import org.junit.Test;

public class CommonParserTest {
    @Test
    public void testFromSerializer() throws Exception {
        XmlParser p = XmlParser.DEFAULT;
        Map m = null;
        m = (Map)p.parse("<object><a _type='number'>1</a></object>", Object.class);
        Assert.assertEquals((Object)1, m.get("a"));
        m = (Map)p.parse("<object><a _type='number'>1</a><b _type='string'>foo bar</b></object>", Object.class);
        Assert.assertEquals((Object)1, m.get("a"));
        Assert.assertEquals((Object)"foo bar", m.get("b"));
        m = (Map)p.parse("<object><a _type='number'>1</a><b _type='string'>foo bar</b><c _type='boolean'>false</c></object>", Object.class);
        Assert.assertEquals((Object)1, m.get("a"));
        Assert.assertEquals((Object)false, m.get("c"));
        m = (Map)p.parse("   <object>\t<a _type='number'>\t1\t</a>\t<b _type='string'>\tfoo\t</b>\t<c _type='boolean'>\tfalse \t</c>\t</object>\t", Object.class);
        Assert.assertEquals((Object)1, m.get("a"));
        Assert.assertEquals((Object)"foo", m.get("b"));
        Assert.assertEquals((Object)false, m.get("c"));
        m = (Map)p.parse("<object><x _type='string'>org.apache.juneau.test.Person</x><addresses _type='array'><object><x _type='string'>org.apache.juneau.test.Address</x><city _type='string'>city A</city><state _type='string'>state A</state><street _type='string'>street A</street><zip _type='number'>12345</zip></object></addresses></object>", Object.class);
        Assert.assertEquals((Object)"org.apache.juneau.test.Person", m.get("x"));
        List l = (List)m.get("addresses");
        Assert.assertNotNull((Object)l);
        m = (Map)l.get(0);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)"org.apache.juneau.test.Address", m.get("x"));
        Assert.assertEquals((Object)"city A", m.get("city"));
        Assert.assertEquals((Object)"state A", m.get("state"));
        Assert.assertEquals((Object)"street A", m.get("street"));
        Assert.assertEquals((Object)12345, m.get("zip"));
        ObjectList jl = (ObjectList)p.parse("<array><object><attribute _type='string'>value</attribute></object><object><attribute _type='string'>value</attribute></object></array>", Object.class);
        Assert.assertEquals((Object)"value", (Object)jl.getObjectMap(0).getString("attribute"));
        Assert.assertEquals((Object)"value", (Object)jl.getObjectMap(1).getString("attribute"));
        try {
            jl = (ObjectList)p.parse("<array><object><attribute _type='string'>value</attribute></object><object><attribute _type='string'>value</attribute></object></array>", Object.class);
            Assert.assertEquals((Object)"value", (Object)jl.getObjectMap(0).getString("attribute"));
            Assert.assertEquals((Object)"value", (Object)jl.getObjectMap(1).getString("attribute"));
        }
        catch (Exception e) {
            Assert.fail((String)e.getLocalizedMessage());
        }
        A1 t1 = new A1();
        A2 t2 = new A2();
        t2.add(new A3("name0", "value0"));
        t2.add(new A3("name1", "value1"));
        t1.list = t2;
        String r = XmlSerializer.DEFAULT_NS.serialize((Object)t1);
        t1 = (A1)p.parse(r, A1.class);
        Assert.assertEquals((Object)"value1", (Object)((A3)t1.list.get((int)1)).value);
        r = XmlSerializer.DEFAULT_NS.serialize((Object)t1);
        t1 = (A1)p.parse(r, A1.class);
        Assert.assertEquals((Object)"value1", (Object)((A3)t1.list.get((int)1)).value);
    }

    @Test
    public void testCorrectHandlingOfUnknownProperties() throws Exception {
        XmlParser p = XmlParser.create().ignoreUnknownBeanProperties().build();
        String in = "<object><a>1</a><unknown>foo</unknown><b>2</b></object>";
        B t = (B)p.parse(in, B.class);
        Assert.assertEquals((long)t.a, (long)1L);
        Assert.assertEquals((long)t.b, (long)2L);
        in = "<object><a>1</a><unknown><object><a _type='string'>foo</a></object></unknown><b>2</b></object>";
        t = (B)p.parse(in, B.class);
        Assert.assertEquals((long)t.a, (long)1L);
        Assert.assertEquals((long)t.b, (long)2L);
        try {
            p = XmlParser.DEFAULT;
            p.parse(in, B.class);
            Assert.fail((String)"Exception expected");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    @Test
    public void testCollectionPropertiesWithNoSetters() throws Exception {
        XmlParser p = XmlParser.DEFAULT;
        String in = "<object><ints _type='array'><number>1</number><number>2</number><number>3</number></ints><beans _type='array'><object><a _type='number'>1</a><b _type='number'>2</b></object></beans></object>";
        C t = (C)p.parse(in, C.class);
        Assert.assertEquals((long)t.getInts().size(), (long)3L);
        Assert.assertEquals((long)t.getBeans().get((int)0).b, (long)2L);
    }

    @Test
    public void testParserListeners() throws Exception {
        XmlParser p = XmlParser.create().ignoreUnknownBeanProperties().listener(MyParserListener.class).build();
        String in = "<object><a _type='number'>1</a><unknownProperty _type='string'>foo</unknownProperty><b _type='number'>2</b></object>";
        p.parse(in, B.class);
        Assert.assertEquals((long)1L, (long)MyParserListener.events.size());
        Assert.assertTrue((boolean)MyParserListener.events.get(0).startsWith("unknownProperty,"));
    }

    public static class MyParserListener
    extends ParserListener {
        static final List<String> events = new LinkedList<String>();

        public <T> void onUnknownBeanProperty(ParserSession session, String propertyName, Class<T> beanClass, T bean) {
            events.add(propertyName + ", " + session.getPosition());
        }
    }

    public static class C {
        private Collection<Integer> ints = new LinkedList<Integer>();
        private List<B> beans = new LinkedList<B>();

        public Collection<Integer> getInts() {
            return this.ints;
        }

        public List<B> getBeans() {
            return this.beans;
        }
    }

    public static class B {
        public int a;
        public int b;
    }

    public static class A3 {
        public String name;
        public String value;

        public A3() {
        }

        public A3(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }

    public static class A2
    extends LinkedList<A3> {
    }

    public static class A1 {
        public A2 list;
    }
}

