/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.xml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.annotation.Beanp;
import org.apache.juneau.xml.XmlParser;
import org.apache.juneau.xml.XmlSerializer;
import org.apache.juneau.xml.annotation.Xml;
import org.apache.juneau.xml.annotation.XmlFormat;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class BasicXmlTest {
    private static final XmlSerializer s1 = XmlSerializer.DEFAULT_SQ;
    private static final XmlSerializer s2 = XmlSerializer.DEFAULT_SQ_READABLE;
    private static final XmlSerializer s3 = XmlSerializer.DEFAULT_NS_SQ;
    private static final XmlParser parser = XmlParser.DEFAULT;
    private String label;
    private String e1;
    private String e2;
    private String e3;
    private Object in;

    @Parameterized.Parameters
    public static Collection<Object[]> getParameters() {
        return Arrays.asList({"SimpleTypes-1", "foo", "<string>foo</string>", "<string>foo</string>\n", "<string>foo</string>"}, {"SimpleTypes-2", true, "<boolean>true</boolean>", "<boolean>true</boolean>\n", "<boolean>true</boolean>"}, {"SimpleTypes-3", 123, "<number>123</number>", "<number>123</number>\n", "<number>123</number>"}, {"SimpleTypes-4", Float.valueOf(1.23f), "<number>1.23</number>", "<number>1.23</number>\n", "<number>1.23</number>"}, {"SimpleTypes-5", null, "<null/>", "<null/>\n", "<null/>"}, {"Arrays-1", new String[]{"foo"}, "<array><string>foo</string></array>", "<array>\n\t<string>foo</string>\n</array>\n", "<array><string>foo</string></array>"}, {"Arrays-2", new String[]{null}, "<array><null/></array>", "<array>\n\t<null/>\n</array>\n", "<array><null/></array>"}, {"Arrays-3", new Object[]{"foo"}, "<array><string>foo</string></array>", "<array>\n\t<string>foo</string>\n</array>\n", "<array><string>foo</string></array>"}, {"Arrays-4", new int[]{123}, "<array><number>123</number></array>", "<array>\n\t<number>123</number>\n</array>\n", "<array><number>123</number></array>"}, {"Arrays-5", new boolean[]{true}, "<array><boolean>true</boolean></array>", "<array>\n\t<boolean>true</boolean>\n</array>\n", "<array><boolean>true</boolean></array>"}, {"Arrays-6", new String[][]{{"foo"}}, "<array><array><string>foo</string></array></array>", "<array>\n\t<array>\n\t\t<string>foo</string>\n\t</array>\n</array>\n", "<array><array><string>foo</string></array></array>"}, {"MapWithStrings", new MapWithStrings().append("k1", "v1").append("k2", null), "<object><k1>v1</k1><k2 _type='null'/></object>", "<object>\n\t<k1>v1</k1>\n\t<k2 _type='null'/>\n</object>\n", "<object><k1>v1</k1><k2 _type='null'/></object>"}, {"MapsWithNumbers", new MapWithNumbers().append("k1", 123).append("k2", 1.23).append("k3", null), "<object><k1>123</k1><k2>1.23</k2><k3 _type='null'/></object>", "<object>\n\t<k1>123</k1>\n\t<k2>1.23</k2>\n\t<k3 _type='null'/>\n</object>\n", "<object><k1>123</k1><k2>1.23</k2><k3 _type='null'/></object>"}, {"MapWithObjects", new MapWithObjects().append("k1", "v1").append("k2", 123).append("k3", 1.23).append("k4", true).append("k5", null), "<object><k1>v1</k1><k2 _type='number'>123</k2><k3 _type='number'>1.23</k3><k4 _type='boolean'>true</k4><k5 _type='null'/></object>", "<object>\n\t<k1>v1</k1>\n\t<k2 _type='number'>123</k2>\n\t<k3 _type='number'>1.23</k3>\n\t<k4 _type='boolean'>true</k4>\n\t<k5 _type='null'/>\n</object>\n", "<object><k1>v1</k1><k2 _type='number'>123</k2><k3 _type='number'>1.23</k3><k4 _type='boolean'>true</k4><k5 _type='null'/></object>"}, {"ListWithStrings", new ListWithStrings().append("foo").append(null), "<array><string>foo</string><null/></array>", "<array>\n\t<string>foo</string>\n\t<null/>\n</array>\n", "<array><string>foo</string><null/></array>"}, {"ListWithNumbers", new ListWithNumbers().append(123).append(1.23).append(null), "<array><number>123</number><number>1.23</number><null/></array>", "<array>\n\t<number>123</number>\n\t<number>1.23</number>\n\t<null/>\n</array>\n", "<array><number>123</number><number>1.23</number><null/></array>"}, {"ListWithObjects", new ListWithObjects().append("foo").append(123).append(1.23).append(true).append(null), "<array><string>foo</string><number>123</number><number>1.23</number><boolean>true</boolean><null/></array>", "<array>\n\t<string>foo</string>\n\t<number>123</number>\n\t<number>1.23</number>\n\t<boolean>true</boolean>\n\t<null/>\n</array>\n", "<array><string>foo</string><number>123</number><number>1.23</number><boolean>true</boolean><null/></array>"}, {"BeanWithNormalProperties", new BeanWithNormalProperties().init(), "<object><a>foo</a><b>123</b><c>bar</c><d _type='number'>456</d><e><h>qux</h></e><f><string>baz</string></f><g><number>789</number></g></object>", "<object>\n\t<a>foo</a>\n\t<b>123</b>\n\t<c>bar</c>\n\t<d _type='number'>456</d>\n\t<e>\n\t\t<h>qux</h>\n\t</e>\n\t<f>\n\t\t<string>baz</string>\n\t</f>\n\t<g>\n\t\t<number>789</number>\n\t</g>\n</object>\n", "<object><a>foo</a><b>123</b><c>bar</c><d _type='number'>456</d><e><h>qux</h></e><f><string>baz</string></f><g><number>789</number></g></object>"}, {"BeanWithMapProperties", new BeanWithMapProperties().init(), "<object><a><k1>foo</k1></a><b><k2>123</k2></b><c><k3>bar</k3><k4 _type='number'>456</k4><k5 _type='boolean'>true</k5><k6 _type='null'/></c></object>", "<object>\n\t<a>\n\t\t<k1>foo</k1>\n\t</a>\n\t<b>\n\t\t<k2>123</k2>\n\t</b>\n\t<c>\n\t\t<k3>bar</k3>\n\t\t<k4 _type='number'>456</k4>\n\t\t<k5 _type='boolean'>true</k5>\n\t\t<k6 _type='null'/>\n\t</c>\n</object>\n", "<object><a><k1>foo</k1></a><b><k2>123</k2></b><c><k3>bar</k3><k4 _type='number'>456</k4><k5 _type='boolean'>true</k5><k6 _type='null'/></c></object>"}, {"BeanWithTypeName", new BeanWithTypeName().init(), "<X><a>123</a><b>foo</b></X>", "<X>\n\t<a>123</a>\n\t<b>foo</b>\n</X>\n", "<X><a>123</a><b>foo</b></X>"}, {"BeanWithPropertiesWithTypeNames", new BeanWithPropertiesWithTypeNames().init(), "<object><b1><b>foo</b></b1><b2 _type='B'><b>foo</b></b2></object>", "<object>\n\t<b1>\n\t\t<b>foo</b>\n\t</b1>\n\t<b2 _type='B'>\n\t\t<b>foo</b>\n\t</b2>\n</object>\n", "<object><b1><b>foo</b></b1><b2 _type='B'><b>foo</b></b2></object>"}, {"BeanWithPropertiesWithArrayTypeNames", new BeanWithPropertiesWithArrayTypeNames().init(), "<object><b1><B><b>foo</b></B></b1><b2><B><b>foo</b></B></b2><b3><B><b>foo</b></B></b3></object>", "<object>\n\t<b1>\n\t\t<B>\n\t\t\t<b>foo</b>\n\t\t</B>\n\t</b1>\n\t<b2>\n\t\t<B>\n\t\t\t<b>foo</b>\n\t\t</B>\n\t</b2>\n\t<b3>\n\t\t<B>\n\t\t\t<b>foo</b>\n\t\t</B>\n\t</b3>\n</object>\n", "<object><b1><B><b>foo</b></B></b1><b2><B><b>foo</b></B></b2><b3><B><b>foo</b></B></b3></object>"}, {"BeanWithPropertiesWithArray2dTypeNames", new BeanWithPropertiesWith2dArrayTypeNames().init(), "<object><b1><array><B><b>foo</b></B></array></b1><b2><array><B><b>foo</b></B></array></b2><b3><array><B><b>foo</b></B></array></b3></object>", "<object>\n\t<b1>\n\t\t<array>\n\t\t\t<B>\n\t\t\t\t<b>foo</b>\n\t\t\t</B>\n\t\t</array>\n\t</b1>\n\t<b2>\n\t\t<array>\n\t\t\t<B>\n\t\t\t\t<b>foo</b>\n\t\t\t</B>\n\t\t</array>\n\t</b2>\n\t<b3>\n\t\t<array>\n\t\t\t<B>\n\t\t\t\t<b>foo</b>\n\t\t\t</B>\n\t\t</array>\n\t</b3>\n</object>\n", "<object><b1><array><B><b>foo</b></B></array></b1><b2><array><B><b>foo</b></B></array></b2><b3><array><B><b>foo</b></B></array></b3></object>"}, {"BeanWithPropertiesWithMapTypeNames", new BeanWithPropertiesWithMapTypeNames().init(), "<object><b1><k1><b>foo</b></k1></b1><b2><k2 _type='B'><b>foo</b></k2></b2></object>", "<object>\n\t<b1>\n\t\t<k1>\n\t\t\t<b>foo</b>\n\t\t</k1>\n\t</b1>\n\t<b2>\n\t\t<k2 _type='B'>\n\t\t\t<b>foo</b>\n\t\t</k2>\n\t</b2>\n</object>\n", "<object><b1><k1><b>foo</b></k1></b1><b2><k2 _type='B'><b>foo</b></k2></b2></object>"}, {"BeanWithChildTypeNames", new BeanWithChildTypeNames().init(), "<object><a><fx>fx1</fx></a><b _type='X'><fx>fx1</fx></b><c><X><fx>fx1</fx></X></c><d><X><fx>fx1</fx></X></d></object>", "<object>\n\t<a>\n\t\t<fx>fx1</fx>\n\t</a>\n\t<b _type='X'>\n\t\t<fx>fx1</fx>\n\t</b>\n\t<c>\n\t\t<X>\n\t\t\t<fx>fx1</fx>\n\t\t</X>\n\t</c>\n\t<d>\n\t\t<X>\n\t\t\t<fx>fx1</fx>\n\t\t</X>\n\t</d>\n</object>\n", "<object><a><fx>fx1</fx></a><b _type='X'><fx>fx1</fx></b><c><X><fx>fx1</fx></X></c><d><X><fx>fx1</fx></X></d></object>"}, {"BeanWithChildName", new BeanWithChildName().init(), "<object><a><X>foo</X><X>bar</X></a><b><Y>123</Y><Y>456</Y></b></object>", "<object>\n\t<a>\n\t\t<X>foo</X>\n\t\t<X>bar</X>\n\t</a>\n\t<b>\n\t\t<Y>123</Y>\n\t\t<Y>456</Y>\n\t</b>\n</object>\n", "<object><a><X>foo</X><X>bar</X></a><b><Y>123</Y><Y>456</Y></b></object>"}, {"BeanWithXmlFormatAttrProperty", new BeanWithXmlFormatAttrProperty().init(), "<object a='foo' b='123'/>", "<object a='foo' b='123'/>\n", "<object a='foo' b='123'/>"}, {"BeanWithXmlFormatAttrs", new BeanWithXmlFormatAttrs().init(), "<object a='foo' b='123'/>", "<object a='foo' b='123'/>\n", "<object a='foo' b='123'/>"}, {"BeanWithXmlFormatElementProperty", new BeanWithXmlFormatElementProperty().init(), "<object a='foo'><b>123</b></object>", "<object a='foo'>\n\t<b>123</b>\n</object>\n", "<object a='foo'><b>123</b></object>"}, {"BeanWithXmlFormatAttrsProperty", new BeanWithXmlFormatAttrsProperty().init(), "<object k1='foo' k2='123' b='456'/>", "<object k1='foo' k2='123' b='456'/>\n", "<object k1='foo' k2='123' b='456'/>"}, {"BeanWithXmlFormatCollapsedProperty", new BeanWithXmlFormatCollapsedProperty().init(), "<object><A>foo</A><A>bar</A><B>123</B><B>456</B></object>", "<object>\n\t<A>foo</A>\n\t<A>bar</A>\n\t<B>123</B>\n\t<B>456</B>\n</object>\n", "<object><A>foo</A><A>bar</A><B>123</B><B>456</B></object>"}, {"BeanWithXmlFormatTextProperty", new BeanWithXmlFormatTextProperty().init(), "<object a='foo'>bar</object>", "<object a='foo'>bar</object>\n", "<object a='foo'>bar</object>"}, {"BeanWithXmlFormatXmlTextProperty", new BeanWithXmlFormatXmlTextProperty().init(), "<object a='foo'>bar<b>baz</b>qux</object>", "<object a='foo'>bar<b>baz</b>qux</object>\n", "<object a='foo'>bar<b>baz</b>qux</object>"}, {"BeanWithXmlFormatElementsPropertyCollection", new BeanWithXmlFormatElementsPropertyCollection().init(), "<object a='foo'><string>bar</string><string>baz</string><number>123</number><boolean>true</boolean><null/></object>", "<object a='foo'>\n\t<string>bar</string>\n\t<string>baz</string>\n\t<number>123</number>\n\t<boolean>true</boolean>\n\t<null/>\n</object>\n", "<object a='foo'><string>bar</string><string>baz</string><number>123</number><boolean>true</boolean><null/></object>"}, {"BeanWithMixedContent", new BeanWithMixedContent().init(), "<object>foo<X fx='fx1'/>bar<Y fy='fy1'/>baz</object>", "<object>foo<X fx='fx1'/>bar<Y fy='fy1'/>baz</object>\n", "<object>foo<X fx='fx1'/>bar<Y fy='fy1'/>baz</object>"}, {"BeanWithSpecialCharacters", new BeanWithSpecialCharacters().init(), "<object><a>_x0020_ _x0008__x000C_&#x000a;&#x0009;&#x000d; _x0020_</a></object>", "<object>\n\t<a>_x0020_ _x0008__x000C_&#x000a;&#x0009;&#x000d; _x0020_</a>\n</object>\n", "<object><a>_x0020_ _x0008__x000C_&#x000a;&#x0009;&#x000d; _x0020_</a></object>"}, {"BeanWithSpecialCharacters2", new BeanWithSpecialCharacters2().init(), "<_x0020__x0020__x0008__x000C__x000A__x0009__x000D__x0020__x0020_><_x0020__x0020__x0008__x000C__x000A__x0009__x000D__x0020__x0020_>_x0020_ _x0008__x000C_&#x000a;&#x0009;&#x000d; _x0020_</_x0020__x0020__x0008__x000C__x000A__x0009__x000D__x0020__x0020_></_x0020__x0020__x0008__x000C__x000A__x0009__x000D__x0020__x0020_>", "<_x0020__x0020__x0008__x000C__x000A__x0009__x000D__x0020__x0020_>\n\t<_x0020__x0020__x0008__x000C__x000A__x0009__x000D__x0020__x0020_>_x0020_ _x0008__x000C_&#x000a;&#x0009;&#x000d; _x0020_</_x0020__x0020__x0008__x000C__x000A__x0009__x000D__x0020__x0020_>\n</_x0020__x0020__x0008__x000C__x000A__x0009__x000D__x0020__x0020_>\n", "<_x0020__x0020__x0008__x000C__x000A__x0009__x000D__x0020__x0020_><_x0020__x0020__x0008__x000C__x000A__x0009__x000D__x0020__x0020_>_x0020_ _x0008__x000C_&#x000a;&#x0009;&#x000d; _x0020_</_x0020__x0020__x0008__x000C__x000A__x0009__x000D__x0020__x0020_></_x0020__x0020__x0008__x000C__x000A__x0009__x000D__x0020__x0020_>"}, {"BeanWithNullProperties", new BeanWithNullProperties(), "<object/>", "<object/>\n", "<object/>"}, {"BeanWithAbstractFields", new BeanWithAbstractFields().init(), "<object><a><a>foo</a></a><ia _type='A'><a>foo</a></ia><aa _type='A'><a>foo</a></aa><o _type='A'><a>foo</a></o></object>", "<object>\n\t<a>\n\t\t<a>foo</a>\n\t</a>\n\t<ia _type='A'>\n\t\t<a>foo</a>\n\t</ia>\n\t<aa _type='A'>\n\t\t<a>foo</a>\n\t</aa>\n\t<o _type='A'>\n\t\t<a>foo</a>\n\t</o>\n</object>\n", "<object><a><a>foo</a></a><ia _type='A'><a>foo</a></ia><aa _type='A'><a>foo</a></aa><o _type='A'><a>foo</a></o></object>"}, {"BeanWithAbstractArrayFields", new BeanWithAbstractArrayFields().init(), "<object><a><A><a>foo</a></A></a><ia1><A><a>foo</a></A></ia1><ia2><A><a>foo</a></A></ia2><aa1><A><a>foo</a></A></aa1><aa2><A><a>foo</a></A></aa2><o1><A><a>foo</a></A></o1><o2><A><a>foo</a></A></o2></object>", "<object>\n\t<a>\n\t\t<A>\n\t\t\t<a>foo</a>\n\t\t</A>\n\t</a>\n\t<ia1>\n\t\t<A>\n\t\t\t<a>foo</a>\n\t\t</A>\n\t</ia1>\n\t<ia2>\n\t\t<A>\n\t\t\t<a>foo</a>\n\t\t</A>\n\t</ia2>\n\t<aa1>\n\t\t<A>\n\t\t\t<a>foo</a>\n\t\t</A>\n\t</aa1>\n\t<aa2>\n\t\t<A>\n\t\t\t<a>foo</a>\n\t\t</A>\n\t</aa2>\n\t<o1>\n\t\t<A>\n\t\t\t<a>foo</a>\n\t\t</A>\n\t</o1>\n\t<o2>\n\t\t<A>\n\t\t\t<a>foo</a>\n\t\t</A>\n\t</o2>\n</object>\n", "<object><a><A><a>foo</a></A></a><ia1><A><a>foo</a></A></ia1><ia2><A><a>foo</a></A></ia2><aa1><A><a>foo</a></A></aa1><aa2><A><a>foo</a></A></aa2><o1><A><a>foo</a></A></o1><o2><A><a>foo</a></A></o2></object>"}, {"BeanWithAbstractMapFields", new BeanWithAbstractMapFields().init(), "<object><a><k1><a>foo</a></k1></a><b><k2 _type='A'><a>foo</a></k2></b><c><k3 _type='A'><a>foo</a></k3></c></object>", "<object>\n\t<a>\n\t\t<k1>\n\t\t\t<a>foo</a>\n\t\t</k1>\n\t</a>\n\t<b>\n\t\t<k2 _type='A'>\n\t\t\t<a>foo</a>\n\t\t</k2>\n\t</b>\n\t<c>\n\t\t<k3 _type='A'>\n\t\t\t<a>foo</a>\n\t\t</k3>\n\t</c>\n</object>\n", "<object><a><k1><a>foo</a></k1></a><b><k2 _type='A'><a>foo</a></k2></b><c><k3 _type='A'><a>foo</a></k3></c></object>"}, {"BeanWithAbstractMapArrayFields", new BeanWithAbstractMapArrayFields().init(), "<object><a><a1><A><a>foo</a></A></a1></a><ia><ia1><A><a>foo</a></A></ia1><ia2><A><a>foo</a></A></ia2></ia><aa><aa1><A><a>foo</a></A></aa1><aa2><A><a>foo</a></A></aa2></aa><o><o1><A><a>foo</a></A></o1><o2><A><a>foo</a></A></o2></o></object>", "<object>\n\t<a>\n\t\t<a1>\n\t\t\t<A>\n\t\t\t\t<a>foo</a>\n\t\t\t</A>\n\t\t</a1>\n\t</a>\n\t<ia>\n\t\t<ia1>\n\t\t\t<A>\n\t\t\t\t<a>foo</a>\n\t\t\t</A>\n\t\t</ia1>\n\t\t<ia2>\n\t\t\t<A>\n\t\t\t\t<a>foo</a>\n\t\t\t</A>\n\t\t</ia2>\n\t</ia>\n\t<aa>\n\t\t<aa1>\n\t\t\t<A>\n\t\t\t\t<a>foo</a>\n\t\t\t</A>\n\t\t</aa1>\n\t\t<aa2>\n\t\t\t<A>\n\t\t\t\t<a>foo</a>\n\t\t\t</A>\n\t\t</aa2>\n\t</aa>\n\t<o>\n\t\t<o1>\n\t\t\t<A>\n\t\t\t\t<a>foo</a>\n\t\t\t</A>\n\t\t</o1>\n\t\t<o2>\n\t\t\t<A>\n\t\t\t\t<a>foo</a>\n\t\t\t</A>\n\t\t</o2>\n\t</o>\n</object>\n", "<object><a><a1><A><a>foo</a></A></a1></a><ia><ia1><A><a>foo</a></A></ia1><ia2><A><a>foo</a></A></ia2></ia><aa><aa1><A><a>foo</a></A></aa1><aa2><A><a>foo</a></A></aa2></aa><o><o1><A><a>foo</a></A></o1><o2><A><a>foo</a></A></o2></o></object>"}, {"BeanWithWhitespaceTextFields-1", new BeanWithWhitespaceTextFields().init(null), "<object nil='true'></object>", "<object nil='true'>\n</object>\n", "<object nil='true'></object>"}, {"BeanWithWhitespaceTextFields-2", new BeanWithWhitespaceTextFields().init(""), "<object>_xE000_</object>", "<object>_xE000_</object>\n", "<object>_xE000_</object>"}, {"BeanWithWhitespaceTextFields-3", new BeanWithWhitespaceTextFields().init(" "), "<object>_x0020_</object>", "<object>_x0020_</object>\n", "<object>_x0020_</object>"}, {"BeanWithWhitespaceTextFields-4", new BeanWithWhitespaceTextFields().init("  "), "<object>_x0020__x0020_</object>", "<object>_x0020__x0020_</object>\n", "<object>_x0020__x0020_</object>"}, {"BeanWithWhitespaceTextFields-5", new BeanWithWhitespaceTextFields().init(" foo\n\tbar "), "<object>_x0020_foo&#x000a;&#x0009;bar_x0020_</object>", "<object>_x0020_foo&#x000a;&#x0009;bar_x0020_</object>\n", "<object>_x0020_foo&#x000a;&#x0009;bar_x0020_</object>"}, {"BeanWithWhitespaceTextPwsFields-1", new BeanWithWhitespaceTextPwsFields().init(null), "<object nil='true'></object>", "<object nil='true'>\n</object>\n", "<object nil='true'></object>"}, {"BeanWithWhitespaceTextPwsFields-2", new BeanWithWhitespaceTextPwsFields().init(""), "<object>_xE000_</object>", "<object>_xE000_</object>\n", "<object>_xE000_</object>"}, {"BeanWithWhitespaceTextPwsFields-3", new BeanWithWhitespaceTextPwsFields().init(" "), "<object> </object>", "<object> </object>\n", "<object> </object>"}, {"BeanWithWhitespaceTextPwsFields-4", new BeanWithWhitespaceTextPwsFields().init("  "), "<object>  </object>", "<object>  </object>\n", "<object>  </object>"}, {"BeanWithWhitespaceTextPwsFields-5", new BeanWithWhitespaceTextPwsFields().init("  foobar  "), "<object>  foobar  </object>", "<object>  foobar  </object>\n", "<object>  foobar  </object>"}, {"BeanWithWhitespaceMixedFields-1", new BeanWithWhitespaceMixedFields().init(null), "<object nil='true'></object>", "<object nil='true'>\n</object>\n", "<object nil='true'></object>"}, {"BeanWithWhitespaceMixedFields-2", new BeanWithWhitespaceMixedFields().init(new String[0]), "<object></object>", "<object></object>\n", "<object></object>"}, {"BeanWithWhitespaceMixedFields-3", new BeanWithWhitespaceMixedFields().init(new String[]{""}), "<object>_xE000_</object>", "<object>_xE000_</object>\n", "<object>_xE000_</object>"}, {"BeanWithWhitespaceMixedFields-4", new BeanWithWhitespaceMixedFields().init(new String[]{" "}), "<object>_x0020_</object>", "<object>_x0020_</object>\n", "<object>_x0020_</object>"}, {"BeanWithWhitespaceMixedFields-5", new BeanWithWhitespaceMixedFields().init(new String[]{"  "}), "<object>_x0020__x0020_</object>", "<object>_x0020__x0020_</object>\n", "<object>_x0020__x0020_</object>"}, {"BeanWithWhitespaceMixedFields-6", new BeanWithWhitespaceMixedFields().init(new String[]{"  foobar  "}), "<object>_x0020_ foobar _x0020_</object>", "<object>_x0020_ foobar _x0020_</object>\n", "<object>_x0020_ foobar _x0020_</object>"}, {"BeanWithWhitespaceMixedPwsFields-1", new BeanWithWhitespaceMixedPwsFields().init(null), "<object nil='true'></object>", "<object nil='true'>\n</object>\n", "<object nil='true'></object>"}, {"BeanWithWhitespaceMixedPwsFields-2", new BeanWithWhitespaceMixedPwsFields().init(new String[0]), "<object></object>", "<object></object>\n", "<object></object>"}, {"BeanWithWhitespaceMixedPwsFields-3", new BeanWithWhitespaceMixedPwsFields().init(new String[]{""}), "<object>_xE000_</object>", "<object>_xE000_</object>\n", "<object>_xE000_</object>"}, {"BeanWithWhitespaceMixedPwsFields-4", new BeanWithWhitespaceMixedPwsFields().init(new String[]{" "}), "<object> </object>", "<object> </object>\n", "<object> </object>"}, {"BeanWithWhitespaceMixedPwsFields-5", new BeanWithWhitespaceMixedPwsFields().init(new String[]{"  "}), "<object>  </object>", "<object>  </object>\n", "<object>  </object>"}, {"BeanWithWhitespaceMixedPwsFields-6", new BeanWithWhitespaceMixedPwsFields().init(new String[]{"  foobar  "}), "<object>  foobar  </object>", "<object>  foobar  </object>\n", "<object>  foobar  </object>"});
    }

    public BasicXmlTest(String label, Object in, String e1, String e2, String e3) throws Exception {
        this.label = label;
        this.in = in;
        this.e1 = e1;
        this.e2 = e2;
        this.e3 = e3;
    }

    @Test
    public void serializeNormal() {
        try {
            String r = s1.serialize(this.in);
            Assert.assertEquals((String)(this.label + " serialize-normal failed"), (Object)this.e1, (Object)r);
        }
        catch (AssertionError e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(this.label + " test failed", e);
        }
    }

    @Test
    public void parseNormal() {
        try {
            String r = s1.serialize(this.in);
            Class<Object> c = this.in == null ? Object.class : this.in.getClass();
            Object o = parser.parse(r, c);
            r = s1.serialize(o);
            Assert.assertEquals((String)(this.label + " parse-normal failed"), (Object)this.e1, (Object)r);
        }
        catch (AssertionError e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(this.label + " test failed", e);
        }
    }

    @Test
    public void serializeReadable() {
        try {
            String r = s2.serialize(this.in);
            Assert.assertEquals((String)(this.label + " serialize-readable failed"), (Object)this.e2, (Object)r);
        }
        catch (AssertionError e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(this.label + " test failed", e);
        }
    }

    @Test
    public void parseReadable() {
        try {
            String r = s2.serialize(this.in);
            Class<Object> c = this.in == null ? Object.class : this.in.getClass();
            Object o = parser.parse(r, c);
            r = s2.serialize(o);
            Assert.assertEquals((String)(this.label + " parse-readable failed"), (Object)this.e2, (Object)r);
        }
        catch (AssertionError e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(this.label + " test failed", e);
        }
    }

    @Test
    public void serializeNsEnabled() {
        try {
            String r = s3.serialize(this.in);
            Assert.assertEquals((String)(this.label + " serialize-ns-enabled failed"), (Object)this.e3, (Object)r);
        }
        catch (AssertionError e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(this.label + " test failed", e);
        }
    }

    @Test
    public void parseNsEnabled() {
        try {
            String r = s3.serialize(this.in);
            Class<Object> c = this.in == null ? Object.class : this.in.getClass();
            Object o = parser.parse(r, c);
            r = s3.serialize(o);
            Assert.assertEquals((String)(this.label + " parse-ns-enabled failed"), (Object)this.e3, (Object)r);
        }
        catch (AssertionError e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(this.label + " test failed", e);
        }
    }

    public static class BeanWithWhitespaceMixedPwsFields {
        @Xml(format=XmlFormat.MIXED_PWS)
        public String[] a;

        public BeanWithWhitespaceMixedPwsFields init(String[] s) {
            this.a = s;
            return this;
        }
    }

    public static class BeanWithWhitespaceMixedFields {
        @Xml(format=XmlFormat.MIXED)
        public String[] a;

        public BeanWithWhitespaceMixedFields init(String[] s) {
            this.a = s;
            return this;
        }
    }

    public static class BeanWithWhitespaceTextPwsFields {
        @Xml(format=XmlFormat.TEXT_PWS)
        public String a;

        public BeanWithWhitespaceTextPwsFields init(String s) {
            this.a = s;
            return this;
        }
    }

    public static class BeanWithWhitespaceTextFields {
        @Xml(format=XmlFormat.TEXT)
        public String a;

        public BeanWithWhitespaceTextFields init(String s) {
            this.a = s;
            return this;
        }
    }

    @Bean(typeName="A")
    public static class A
    extends AA {
        private String a;

        @Override
        public String getA() {
            return this.a;
        }

        @Override
        public void setA(String a) {
            this.a = a;
        }

        A init() {
            this.a = "foo";
            return this;
        }
    }

    public static abstract class AA
    implements IA {
    }

    public static interface IA {
        public String getA();

        public void setA(String var1);
    }

    @Bean(dictionary={A.class}, bpi="a,ia,aa,o")
    public static class BeanWithAbstractMapArrayFields {
        public Map<String, A[]> a;
        public Map<String, IA[]> ia;
        public Map<String, AA[]> aa;
        public Map<String, Object[]> o;

        BeanWithAbstractMapArrayFields init() {
            this.a = new LinkedHashMap<String, A[]>();
            this.ia = new LinkedHashMap<String, IA[]>();
            this.aa = new LinkedHashMap<String, AA[]>();
            this.o = new LinkedHashMap<String, Object[]>();
            this.a.put("a1", new A[]{new A().init()});
            this.ia.put("ia1", new A[]{new A().init()});
            this.ia.put("ia2", new IA[]{new A().init()});
            this.aa.put("aa1", new A[]{new A().init()});
            this.aa.put("aa2", new AA[]{new A().init()});
            this.o.put("o1", new A[]{new A().init()});
            this.o.put("o2", new Object[]{new A().init()});
            return this;
        }
    }

    @Bean(dictionary={A.class})
    public static class BeanWithAbstractMapFields {
        public Map<String, A> a;
        public Map<String, AA> b;
        public Map<String, Object> c;

        BeanWithAbstractMapFields init() {
            this.a = new HashMap<String, A>();
            this.b = new HashMap<String, AA>();
            this.c = new HashMap<String, Object>();
            this.a.put("k1", new A().init());
            this.b.put("k2", new A().init());
            this.c.put("k3", new A().init());
            return this;
        }
    }

    @Bean(dictionary={A.class}, bpi="a,ia1,ia2,aa1,aa2,o1,o2")
    public static class BeanWithAbstractArrayFields {
        public A[] a;
        public IA[] ia1;
        public IA[] ia2;
        public AA[] aa1;
        public AA[] aa2;
        public Object[] o1;
        public Object[] o2;

        BeanWithAbstractArrayFields init() {
            this.a = new A[]{new A().init()};
            this.ia1 = new A[]{new A().init()};
            this.aa1 = new A[]{new A().init()};
            this.o1 = new A[]{new A().init()};
            this.ia2 = new IA[]{new A().init()};
            this.aa2 = new AA[]{new A().init()};
            this.o2 = new Object[]{new A().init()};
            return this;
        }
    }

    @Bean(dictionary={A.class}, bpi="a,ia,aa,o")
    public static class BeanWithAbstractFields {
        public A a;
        public IA ia;
        public AA aa;
        public Object o;

        BeanWithAbstractFields init() {
            this.ia = new A().init();
            this.aa = new A().init();
            this.a = new A().init();
            this.o = new A().init();
            return this;
        }
    }

    public static class BeanWithNullProperties {
        public String a;
        public String[] b;
    }

    @Bean(typeName="  \b\f\n\t\r  ")
    public static class BeanWithSpecialCharacters2 {
        @Beanp(name="  \b\f\n\t\r  ")
        public String a;

        BeanWithSpecialCharacters2 init() {
            this.a = "  \b\f\n\t\r  ";
            return this;
        }
    }

    public static class BeanWithSpecialCharacters {
        public String a;

        BeanWithSpecialCharacters init() {
            this.a = "  \b\f\n\t\r  ";
            return this;
        }
    }

    @Bean(typeName="Y")
    public static class BeanYSimple {
        @Xml(format=XmlFormat.ATTR)
        public String fy;

        BeanYSimple init() {
            this.fy = "fy1";
            return this;
        }
    }

    @Bean(typeName="Y")
    public static class BeanY {
        public String fy;

        BeanY init() {
            this.fy = "fy1";
            return this;
        }
    }

    @Bean(typeName="X")
    public static class BeanXSimple {
        @Xml(format=XmlFormat.ATTR)
        public String fx;

        BeanXSimple init() {
            this.fx = "fx1";
            return this;
        }
    }

    @Bean(typeName="X")
    public static class BeanX {
        public String fx;

        BeanX init() {
            this.fx = "fx1";
            return this;
        }
    }

    public static class BeanWithMixedContent {
        @Xml(format=XmlFormat.MIXED)
        @Beanp(dictionary={BeanXSimple.class, BeanYSimple.class})
        public Object[] a;

        BeanWithMixedContent init() {
            this.a = new Object[]{"foo", new BeanXSimple().init(), "bar", new BeanYSimple().init(), "baz"};
            return this;
        }
    }

    public static class BeanWithXmlFormatElementsPropertyCollection {
        @Xml(format=XmlFormat.ATTR)
        public String a;
        @Xml(format=XmlFormat.ELEMENTS)
        public Object[] b;

        BeanWithXmlFormatElementsPropertyCollection init() {
            this.a = "foo";
            this.b = new Object[]{"bar", "baz", 123, true, null};
            return this;
        }
    }

    public static class BeanWithXmlFormatXmlTextProperty {
        @Xml(format=XmlFormat.ATTR)
        public String a;
        @Xml(format=XmlFormat.XMLTEXT)
        public String b;

        BeanWithXmlFormatXmlTextProperty init() {
            this.a = "foo";
            this.b = "bar<b>baz</b>qux";
            return this;
        }
    }

    public static class BeanWithXmlFormatTextProperty {
        @Xml(format=XmlFormat.ATTR)
        public String a;
        @Xml(format=XmlFormat.TEXT)
        public String b;

        BeanWithXmlFormatTextProperty init() {
            this.a = "foo";
            this.b = "bar";
            return this;
        }
    }

    public static class BeanWithXmlFormatCollapsedProperty {
        @Xml(childName="A", format=XmlFormat.COLLAPSED)
        public String[] a;
        @Xml(childName="B", format=XmlFormat.COLLAPSED)
        public int[] b;

        BeanWithXmlFormatCollapsedProperty init() {
            this.a = new String[]{"foo", "bar"};
            this.b = new int[]{123, 456};
            return this;
        }
    }

    public static class BeanWithXmlFormatAttrsProperty {
        @Xml(format=XmlFormat.ATTRS)
        public Map<String, Object> a;
        @Xml(format=XmlFormat.ATTR)
        public int b;

        BeanWithXmlFormatAttrsProperty init() {
            this.a = new ObjectMap().append("k1", (Object)"foo").append("k2", (Object)123);
            this.b = 456;
            return this;
        }
    }

    @Xml(format=XmlFormat.ATTRS)
    public static class BeanWithXmlFormatElementProperty {
        public String a;
        @Xml(format=XmlFormat.ELEMENT)
        public int b;

        BeanWithXmlFormatElementProperty init() {
            this.a = "foo";
            this.b = 123;
            return this;
        }
    }

    @Xml(format=XmlFormat.ATTRS)
    public static class BeanWithXmlFormatAttrs {
        public String a;
        public int b;

        BeanWithXmlFormatAttrs init() {
            this.a = "foo";
            this.b = 123;
            return this;
        }
    }

    public static class BeanWithXmlFormatAttrProperty {
        @Xml(format=XmlFormat.ATTR)
        public String a;
        @Xml(format=XmlFormat.ATTR)
        public int b;

        BeanWithXmlFormatAttrProperty init() {
            this.a = "foo";
            this.b = 123;
            return this;
        }
    }

    public static class BeanWithChildName {
        @Xml(childName="X")
        public String[] a;
        @Xml(childName="Y")
        public int[] b;

        BeanWithChildName init() {
            this.a = new String[]{"foo", "bar"};
            this.b = new int[]{123, 456};
            return this;
        }
    }

    public static class BeanWithChildTypeNames {
        public BeanX a;
        @Beanp(dictionary={BeanX.class})
        public Object b;
        public BeanX[] c;
        @Beanp(dictionary={BeanX.class})
        public Object[] d;

        BeanWithChildTypeNames init() {
            this.a = new BeanX().init();
            this.b = new BeanX().init();
            this.c = new BeanX[]{new BeanX().init()};
            this.d = new Object[]{new BeanX().init()};
            return this;
        }
    }

    @Bean(typeName="B")
    public static class B {
        public String b;

        B init() {
            this.b = "foo";
            return this;
        }
    }

    @Bean(dictionary={B.class})
    public static class BeanWithPropertiesWithMapTypeNames {
        public Map<String, B> b1;
        public Map<String, Object> b2;

        BeanWithPropertiesWithMapTypeNames init() {
            this.b1 = new HashMap<String, B>();
            this.b1.put("k1", new B().init());
            this.b2 = new HashMap<String, Object>();
            this.b2.put("k2", new B().init());
            return this;
        }
    }

    @Bean(dictionary={B.class})
    public static class BeanWithPropertiesWith2dArrayTypeNames {
        public B[][] b1;
        public Object[][] b2;
        public Object[][] b3;

        BeanWithPropertiesWith2dArrayTypeNames init() {
            this.b1 = new B[][]{{new B().init()}};
            this.b2 = new B[][]{{new B().init()}};
            this.b3 = new Object[][]{{new B().init()}};
            return this;
        }
    }

    @Bean(dictionary={B.class})
    public static class BeanWithPropertiesWithArrayTypeNames {
        public B[] b1;
        public Object[] b2;
        public Object[] b3;

        BeanWithPropertiesWithArrayTypeNames init() {
            this.b1 = new B[]{new B().init()};
            this.b2 = new B[]{new B().init()};
            this.b3 = new Object[]{new B().init()};
            return this;
        }
    }

    @Bean(dictionary={B.class})
    public static class BeanWithPropertiesWithTypeNames {
        public B b1;
        public Object b2;

        BeanWithPropertiesWithTypeNames init() {
            this.b1 = new B().init();
            this.b2 = new B().init();
            return this;
        }
    }

    @Bean(typeName="X")
    public static class BeanWithTypeName {
        public int a;
        public String b;

        BeanWithTypeName init() {
            this.a = 123;
            this.b = "foo";
            return this;
        }
    }

    public static class BeanWithMapProperties {
        @Beanp(type=MapWithStrings.class)
        public Map<String, String> a;
        @Beanp(type=MapWithNumbers.class)
        public Map<String, Number> b;
        @Beanp(type=MapWithObjects.class)
        public Map<String, Object> c;

        BeanWithMapProperties init() {
            this.a = new MapWithStrings().append("k1", "foo");
            this.b = new MapWithNumbers().append("k2", 123);
            this.c = new MapWithObjects().append("k3", "bar").append("k4", 456).append("k5", true).append("k6", null);
            return this;
        }
    }

    public static class Bean1a {
        public String h;

        Bean1a init() {
            this.h = "qux";
            return this;
        }
    }

    public static class BeanWithNormalProperties {
        public String a;
        public int b;
        public Object c;
        public Object d;
        public Bean1a e;
        public String[] f;
        public int[] g;

        BeanWithNormalProperties init() {
            this.a = "foo";
            this.b = 123;
            this.c = "bar";
            this.d = 456;
            this.e = new Bean1a().init();
            this.f = new String[]{"baz"};
            this.g = new int[]{789};
            return this;
        }
    }

    public static class ListWithObjects
    extends ArrayList<Object> {
        public ListWithObjects append(Object value) {
            this.add(value);
            return this;
        }
    }

    public static class ListWithNumbers
    extends ArrayList<Number> {
        public ListWithNumbers append(Number value) {
            this.add(value);
            return this;
        }
    }

    public static class ListWithStrings
    extends ArrayList<String> {
        public ListWithStrings append(String value) {
            this.add(value);
            return this;
        }
    }

    public static class MapWithObjects
    extends LinkedHashMap<String, Object> {
        public MapWithObjects append(String key, Object value) {
            this.put(key, value);
            return this;
        }
    }

    public static class MapWithNumbers
    extends LinkedHashMap<String, Number> {
        public MapWithNumbers append(String key, Number value) {
            this.put(key, value);
            return this;
        }
    }

    public static class MapWithStrings
    extends LinkedHashMap<String, String> {
        public MapWithStrings append(String key, String value) {
            this.put(key, value);
            return this;
        }
    }
}

