/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.utils;

import org.apache.juneau.utils.WeightedAverage;
import org.junit.Assert;
import org.junit.Test;

public class WeightedAverageTest {
    @Test
    public void testEmpty() {
        WeightedAverage w = new WeightedAverage();
        Assert.assertEquals((double)0.0, (double)w.getValue(), (double)0.01);
    }

    @Test
    public void testBasic() {
        WeightedAverage w = new WeightedAverage();
        w.add(0, (Number)100).add(1, (Number)1).add(1, (Number)2).add(1, (Number)3).add(0, (Number)100);
        Assert.assertEquals((double)2.0, (double)w.getValue(), (double)0.01);
    }

    @Test
    public void testBasicWithNullValue() {
        WeightedAverage w = new WeightedAverage();
        w.add(1, (Number)1).add(1, null).add(1, (Number)3);
        Assert.assertEquals((double)2.0, (double)w.getValue(), (double)0.01);
    }

    @Test
    public void testDifferingWeights() {
        WeightedAverage w = new WeightedAverage();
        w.add(10, (Number)1).add(20, (Number)3);
        Assert.assertEquals((double)2.33f, (double)w.getValue(), (double)0.01);
    }
}

