/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.utils;

import java.util.Arrays;
import java.util.Collection;
import org.apache.juneau.UriContext;
import org.apache.juneau.testutils.TestUtils;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.MethodSorters;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class UriContextUriComboTest {
    private String label;
    private Input in;
    private Results r;

    @Parameterized.Parameters
    public static Collection<Object[]> getInput() {
        return Arrays.asList({"Happy-1", UriContextUriComboTest.input("http://foo.com:123", "/context", "/resource", "/path"), UriContextUriComboTest.results("http://foo.com:123", "http://foo.com:123/context", "http://foo.com:123/context/resource", "http://foo.com:123/context/resource/path", "/context", "/context/resource", "/context/resource/path")}, {"Happy-2", UriContextUriComboTest.input("http://foo.com:123", "/c1/c2", "/r1/r2", "/p1/p2"), UriContextUriComboTest.results("http://foo.com:123", "http://foo.com:123/c1/c2", "http://foo.com:123/c1/c2/r1/r2", "http://foo.com:123/c1/c2/r1/r2/p1/p2", "/c1/c2", "/c1/c2/r1/r2", "/c1/c2/r1/r2/p1/p2")}, {"NoAuthority-1", UriContextUriComboTest.input("", "/context", "/resource", "/path"), UriContextUriComboTest.results("/", "/context", "/context/resource", "/context/resource/path", "/context", "/context/resource", "/context/resource/path")}, {"NoContext-1", UriContextUriComboTest.input("http://foo.com:123", "", "/resource", "/path"), UriContextUriComboTest.results("http://foo.com:123", "http://foo.com:123", "http://foo.com:123/resource", "http://foo.com:123/resource/path", "/", "/resource", "/resource/path")}, {"NoResource-1", UriContextUriComboTest.input("http://foo.com:123", "/context", "", "/path"), UriContextUriComboTest.results("http://foo.com:123", "http://foo.com:123/context", "http://foo.com:123/context", "http://foo.com:123/context/path", "/context", "/context", "/context/path")}, {"NoPath-1", UriContextUriComboTest.input("http://foo.com:123", "/context", "/resource", ""), UriContextUriComboTest.results("http://foo.com:123", "http://foo.com:123/context", "http://foo.com:123/context/resource", "http://foo.com:123/context/resource", "/context", "/context/resource", "/context/resource")}, {"NoAuthorityNoContext-1", UriContextUriComboTest.input("", "", "/resource", "/path"), UriContextUriComboTest.results("/", "/", "/resource", "/resource/path", "/", "/resource", "/resource/path")}, {"NoContextNoResource-1", UriContextUriComboTest.input("http://foo.com:123", "", "", "/path"), UriContextUriComboTest.results("http://foo.com:123", "http://foo.com:123", "http://foo.com:123", "http://foo.com:123/path", "/", "/", "/path")}, {"NoAuthorityNoContextNoResource-1", UriContextUriComboTest.input("", "", "", "/path"), UriContextUriComboTest.results("/", "/", "/", "/path", "/", "/", "/path")}, {"Nothing-1", UriContextUriComboTest.input("", "", "", ""), UriContextUriComboTest.results("/", "/", "/", "/", "/", "/", "/")});
    }

    public static Input input(String authority, String context, String resource, String path) {
        return new Input(authority, context, resource, path);
    }

    public static Results results(String eAbsoluteAuthority, String eAbsoluteContext, String eAbsoluteResource, String eAbsolutePath, String eRootRelativeContext, String eRootRelativeResource, String eRootRelativePath) {
        return new Results(eAbsoluteAuthority, eAbsoluteContext, eAbsoluteResource, eAbsolutePath, eRootRelativeContext, eRootRelativeResource, eRootRelativePath);
    }

    public UriContextUriComboTest(String label, Input in, Results r) throws Exception {
        this.label = label;
        this.in = in;
        this.r = r;
    }

    @Test
    public void a1_testAbsoluteAuthority() {
        TestUtils.assertEquals(this.r.eAbsoluteAuthority, this.in.uriContext.getAbsoluteAuthority(), "{0}: testAbsoluteAuthority() failed", this.label);
    }

    @Test
    public void a2_testAbsoluteContext() {
        TestUtils.assertEquals(this.r.eAbsoluteContext, this.in.uriContext.getAbsoluteContextRoot(), "{0}: testAbsoluteContext() failed", this.label);
    }

    @Test
    public void a3_testAbsoluteResource() {
        TestUtils.assertEquals(this.r.eAbsoluteResource, this.in.uriContext.getAbsoluteServletPath(), "{0}: testAbsoluteResource() failed", this.label);
    }

    @Test
    public void a4_testAbsolutePath() {
        TestUtils.assertEquals(this.r.eAbsolutePath, this.in.uriContext.getAbsolutePathInfo(), "{0}: testAbsolutePath() failed", this.label);
    }

    @Test
    public void a5_testRootRelativeContext() {
        TestUtils.assertEquals(this.r.eRootRelativeContext, this.in.uriContext.getRootRelativeContextRoot(), "{0}: testRootRelativeContext() failed", this.label);
    }

    @Test
    public void a6_testRootRelativeResource() {
        TestUtils.assertEquals(this.r.eRootRelativeResource, this.in.uriContext.getRootRelativeServletPath(), "{0}: testRootRelativeResource() failed", this.label);
    }

    @Test
    public void a7_testRootRelativePath() {
        TestUtils.assertEquals(this.r.eRootRelativePath, this.in.uriContext.getRootRelativePathInfo(), "{0}: testRootRelativePath() failed", this.label);
    }

    public static class Results {
        private final String eAbsoluteAuthority;
        private final String eAbsoluteContext;
        private final String eAbsoluteResource;
        private final String eAbsolutePath;
        private final String eRootRelativeContext;
        private final String eRootRelativeResource;
        private final String eRootRelativePath;

        public Results(String eAbsoluteAuthority, String eAbsoluteContext, String eAbsoluteResource, String eAbsolutePath, String eRootRelativeContext, String eRootRelativeResource, String eRootRelativePath) {
            this.eAbsoluteAuthority = eAbsoluteAuthority;
            this.eAbsoluteContext = eAbsoluteContext;
            this.eAbsoluteResource = eAbsoluteResource;
            this.eAbsolutePath = eAbsolutePath;
            this.eRootRelativeContext = eRootRelativeContext;
            this.eRootRelativeResource = eRootRelativeResource;
            this.eRootRelativePath = eRootRelativePath;
        }
    }

    public static class Input {
        private final UriContext uriContext;

        public Input(String authority, String context, String resource, String path) {
            this.uriContext = new UriContext(authority, context, resource, path);
        }
    }
}

