/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.utils;

import java.util.Arrays;
import java.util.Collection;
import org.apache.juneau.UriContext;
import org.apache.juneau.UriRelativity;
import org.apache.juneau.UriResolution;
import org.apache.juneau.UriResolver;
import org.apache.juneau.testutils.TestUtils;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.MethodSorters;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class UriContextResolutionComboTest {
    private String label;
    private Input in;
    private Results r;

    @Parameterized.Parameters
    public static Collection<Object[]> getInput() {
        return Arrays.asList({"Happy-1a", UriContextResolutionComboTest.input("http://host:port", "/context", "/resource", "/path", "http://foo.com:123/foobar"), UriContextResolutionComboTest.results("http://foo.com:123/foobar", "http://foo.com:123/foobar", "http://foo.com:123/foobar", "http://foo.com:123/foobar", "http://foo.com:123/foobar", "http://foo.com:123/foobar")}, {"Happy-2", UriContextResolutionComboTest.input("http://host:port", "/context", "/resource", "/path", "http://foo.com:123"), UriContextResolutionComboTest.results("http://foo.com:123", "http://foo.com:123", "http://foo.com:123", "http://foo.com:123", "http://foo.com:123", "http://foo.com:123")}, {"Happy-3", UriContextResolutionComboTest.input("http://host:port", "/context", "/resource", "/path", "/foobar"), UriContextResolutionComboTest.results("http://host:port/foobar", "http://host:port/foobar", "/foobar", "/foobar", "/foobar", "/foobar")}, {"Happy-4", UriContextResolutionComboTest.input("http://host:port", "/context", "/resource", "/path", "/"), UriContextResolutionComboTest.results("http://host:port", "http://host:port", "/", "/", "/", "/")}, {"Happy-5", UriContextResolutionComboTest.input("http://host:port", "/context", "/resource", "/path", "foobar"), UriContextResolutionComboTest.results("http://host:port/context/resource/foobar", "http://host:port/context/resource/foobar", "/context/resource/foobar", "/context/resource/foobar", "foobar", "foobar")}, {"Happy-6", UriContextResolutionComboTest.input("http://host:port", "/context", "/resource", "/path", ""), UriContextResolutionComboTest.results("http://host:port/context/resource", "http://host:port/context/resource/path", "/context/resource", "/context/resource/path", "", "")}, {"Happy-7", UriContextResolutionComboTest.input("http://host:port", "/context", "/resource", "/path", "context:/foo"), UriContextResolutionComboTest.results("http://host:port/context/foo", "http://host:port/context/foo", "/context/foo", "/context/foo", "/context/foo", "/context/foo")}, {"Happy-8", UriContextResolutionComboTest.input("http://host:port", "/context", "/resource", "/path", "context:/"), UriContextResolutionComboTest.results("http://host:port/context", "http://host:port/context", "/context", "/context", "/context", "/context")}, {"Happy-9", UriContextResolutionComboTest.input("http://host:port", "/context", "/resource", "/path", "servlet:/foo"), UriContextResolutionComboTest.results("http://host:port/context/resource/foo", "http://host:port/context/resource/foo", "/context/resource/foo", "/context/resource/foo", "/context/resource/foo", "/context/resource/foo")}, {"Happy-10", UriContextResolutionComboTest.input("http://host:port", "/context", "/resource", "/path", "servlet:/"), UriContextResolutionComboTest.results("http://host:port/context/resource", "http://host:port/context/resource", "/context/resource", "/context/resource", "/context/resource", "/context/resource")}, {"MultiContextResource-1", UriContextResolutionComboTest.input("http://host:port", "/c1/c2", "/r1/r2", "/p1/p2", "http://foo.com:123/foobar"), UriContextResolutionComboTest.results("http://foo.com:123/foobar", "http://foo.com:123/foobar", "http://foo.com:123/foobar", "http://foo.com:123/foobar", "http://foo.com:123/foobar", "http://foo.com:123/foobar")}, {"MultiContextResource-2", UriContextResolutionComboTest.input("http://host:port", "/c1/c2", "/r1/r2", "/p1/p2", "http://foo.com:123"), UriContextResolutionComboTest.results("http://foo.com:123", "http://foo.com:123", "http://foo.com:123", "http://foo.com:123", "http://foo.com:123", "http://foo.com:123")}, {"MultiContextResource-3", UriContextResolutionComboTest.input("http://host:port", "/c1/c2", "/r1/r2", "/p1/p2", "/foobar"), UriContextResolutionComboTest.results("http://host:port/foobar", "http://host:port/foobar", "/foobar", "/foobar", "/foobar", "/foobar")}, {"MultiContextResource-4", UriContextResolutionComboTest.input("http://host:port", "/c1/c2", "/r1/r2", "/p1/p2", "/"), UriContextResolutionComboTest.results("http://host:port", "http://host:port", "/", "/", "/", "/")}, {"MultiContextResource-5", UriContextResolutionComboTest.input("http://host:port", "/c1/c2", "/r1/r2", "/p1/p2", "foobar"), UriContextResolutionComboTest.results("http://host:port/c1/c2/r1/r2/foobar", "http://host:port/c1/c2/r1/r2/p1/foobar", "/c1/c2/r1/r2/foobar", "/c1/c2/r1/r2/p1/foobar", "foobar", "foobar")}, {"MultiContextResource-6", UriContextResolutionComboTest.input("http://host:port", "/c1/c2", "/r1/r2", "/p1/p2", ""), UriContextResolutionComboTest.results("http://host:port/c1/c2/r1/r2", "http://host:port/c1/c2/r1/r2/p1/p2", "/c1/c2/r1/r2", "/c1/c2/r1/r2/p1/p2", "", "")}, {"MultiContextResource-7", UriContextResolutionComboTest.input("http://host:port", "/c1/c2", "/r1/r2", "/p1/p2", "context:/foo"), UriContextResolutionComboTest.results("http://host:port/c1/c2/foo", "http://host:port/c1/c2/foo", "/c1/c2/foo", "/c1/c2/foo", "/c1/c2/foo", "/c1/c2/foo")}, {"MultiContextResource-8", UriContextResolutionComboTest.input("http://host:port", "/c1/c2", "/r1/r2", "/p1/p2", "context:/"), UriContextResolutionComboTest.results("http://host:port/c1/c2", "http://host:port/c1/c2", "/c1/c2", "/c1/c2", "/c1/c2", "/c1/c2")}, {"MultiContextResource-9", UriContextResolutionComboTest.input("http://host:port", "/c1/c2", "/r1/r2", "/p1/p2", "servlet:/foo"), UriContextResolutionComboTest.results("http://host:port/c1/c2/r1/r2/foo", "http://host:port/c1/c2/r1/r2/foo", "/c1/c2/r1/r2/foo", "/c1/c2/r1/r2/foo", "/c1/c2/r1/r2/foo", "/c1/c2/r1/r2/foo")}, {"MultiContextResource-10", UriContextResolutionComboTest.input("http://host:port", "/c1/c2", "/r1/r2", "/p1/p2", "servlet:/"), UriContextResolutionComboTest.results("http://host:port/c1/c2/r1/r2", "http://host:port/c1/c2/r1/r2", "/c1/c2/r1/r2", "/c1/c2/r1/r2", "/c1/c2/r1/r2", "/c1/c2/r1/r2")}, {"NoAuthority-1", UriContextResolutionComboTest.input("", "/context", "/resource", "/path", "http://foo.com:123/foobar"), UriContextResolutionComboTest.results("http://foo.com:123/foobar", "http://foo.com:123/foobar", "http://foo.com:123/foobar", "http://foo.com:123/foobar", "http://foo.com:123/foobar", "http://foo.com:123/foobar")}, {"NoAuthority-2", UriContextResolutionComboTest.input("", "/context", "/resource", "/path", "http://foo.com:123"), UriContextResolutionComboTest.results("http://foo.com:123", "http://foo.com:123", "http://foo.com:123", "http://foo.com:123", "http://foo.com:123", "http://foo.com:123")}, {"NoAuthority-3", UriContextResolutionComboTest.input("", "/context", "/resource", "/path", "/foobar"), UriContextResolutionComboTest.results("/foobar", "/foobar", "/foobar", "/foobar", "/foobar", "/foobar")}, {"NoAuthority-4", UriContextResolutionComboTest.input("", "/context", "/resource", "/path", "/"), UriContextResolutionComboTest.results("/", "/", "/", "/", "/", "/")}, {"NoAuthority-5", UriContextResolutionComboTest.input("", "/context", "/resource", "/path", "foobar"), UriContextResolutionComboTest.results("/context/resource/foobar", "/context/resource/foobar", "/context/resource/foobar", "/context/resource/foobar", "foobar", "foobar")}, {"NoAuthority-6", UriContextResolutionComboTest.input("", "/context", "/resource", "/path", ""), UriContextResolutionComboTest.results("/context/resource", "/context/resource/path", "/context/resource", "/context/resource/path", "", "")}, {"NoAuthority-7", UriContextResolutionComboTest.input("", "/context", "/resource", "/path", "context:/foo"), UriContextResolutionComboTest.results("/context/foo", "/context/foo", "/context/foo", "/context/foo", "/context/foo", "/context/foo")}, {"NoAuthority-8", UriContextResolutionComboTest.input("", "/context", "/resource", "/path", "context:/"), UriContextResolutionComboTest.results("/context", "/context", "/context", "/context", "/context", "/context")}, {"NoAuthority-9", UriContextResolutionComboTest.input("", "/context", "/resource", "/path", "servlet:/foo"), UriContextResolutionComboTest.results("/context/resource/foo", "/context/resource/foo", "/context/resource/foo", "/context/resource/foo", "/context/resource/foo", "/context/resource/foo")}, {"NoAuthority-10", UriContextResolutionComboTest.input("", "/context", "/resource", "/path", "servlet:/"), UriContextResolutionComboTest.results("/context/resource", "/context/resource", "/context/resource", "/context/resource", "/context/resource", "/context/resource")}, {"NoAuthorityOrContext-1", UriContextResolutionComboTest.input("", "", "/resource", "/path", "http://foo.com:123/foobar"), UriContextResolutionComboTest.results("http://foo.com:123/foobar", "http://foo.com:123/foobar", "http://foo.com:123/foobar", "http://foo.com:123/foobar", "http://foo.com:123/foobar", "http://foo.com:123/foobar")}, {"NoAuthorityOrContext-2", UriContextResolutionComboTest.input("", "", "/resource", "/path", "http://foo.com:123"), UriContextResolutionComboTest.results("http://foo.com:123", "http://foo.com:123", "http://foo.com:123", "http://foo.com:123", "http://foo.com:123", "http://foo.com:123")}, {"NoAuthorityOrContext-3", UriContextResolutionComboTest.input("", "", "/resource", "/path", "/foobar"), UriContextResolutionComboTest.results("/foobar", "/foobar", "/foobar", "/foobar", "/foobar", "/foobar")}, {"NoAuthorityOrContext-4", UriContextResolutionComboTest.input("", "", "/resource", "/path", "/"), UriContextResolutionComboTest.results("/", "/", "/", "/", "/", "/")}, {"NoAuthorityOrContext-5", UriContextResolutionComboTest.input("", "", "/resource", "/path", "foobar"), UriContextResolutionComboTest.results("/resource/foobar", "/resource/foobar", "/resource/foobar", "/resource/foobar", "foobar", "foobar")}, {"NoAuthorityOrContext-6", UriContextResolutionComboTest.input("", "", "/resource", "/path", ""), UriContextResolutionComboTest.results("/resource", "/resource/path", "/resource", "/resource/path", "", "")}, {"NoAuthorityOrContext-7", UriContextResolutionComboTest.input("", "", "/resource", "/path", "context:/foo"), UriContextResolutionComboTest.results("/foo", "/foo", "/foo", "/foo", "/foo", "/foo")}, {"NoAuthorityOrContext-8", UriContextResolutionComboTest.input("", "", "/resource", "/path", "context:/"), UriContextResolutionComboTest.results("/", "/", "/", "/", "/", "/")}, {"NoAuthorityOrContext-9", UriContextResolutionComboTest.input("", "", "/resource", "/path", "servlet:/foo"), UriContextResolutionComboTest.results("/resource/foo", "/resource/foo", "/resource/foo", "/resource/foo", "/resource/foo", "/resource/foo")}, {"NoAuthorityOrContext-10", UriContextResolutionComboTest.input("", "", "/resource", "/path", "servlet:/"), UriContextResolutionComboTest.results("/resource", "/resource", "/resource", "/resource", "/resource", "/resource")}, {"NoAuthorityOrContextOrResource-1", UriContextResolutionComboTest.input("", "", "", "/path", "http://foo.com:123/foobar"), UriContextResolutionComboTest.results("http://foo.com:123/foobar", "http://foo.com:123/foobar", "http://foo.com:123/foobar", "http://foo.com:123/foobar", "http://foo.com:123/foobar", "http://foo.com:123/foobar")}, {"NoAuthorityOrContextOrResource-2", UriContextResolutionComboTest.input("", "", "", "/path", "http://foo.com:123"), UriContextResolutionComboTest.results("http://foo.com:123", "http://foo.com:123", "http://foo.com:123", "http://foo.com:123", "http://foo.com:123", "http://foo.com:123")}, {"NoAuthorityOrContextOrResource-3", UriContextResolutionComboTest.input("", "", "", "/path", "/foobar"), UriContextResolutionComboTest.results("/foobar", "/foobar", "/foobar", "/foobar", "/foobar", "/foobar")}, {"NoAuthorityOrContextOrResource-4", UriContextResolutionComboTest.input("", "", "", "/path", "/"), UriContextResolutionComboTest.results("/", "/", "/", "/", "/", "/")}, {"NoAuthorityOrContextOrResource-5", UriContextResolutionComboTest.input("", "", "", "/path", "foobar"), UriContextResolutionComboTest.results("/foobar", "/foobar", "/foobar", "/foobar", "foobar", "foobar")}, {"NoAuthorityOrContextOrResource-6", UriContextResolutionComboTest.input("", "", "", "/path", ""), UriContextResolutionComboTest.results("/", "/path", "/", "/path", "", "")}, {"NoAuthorityOrContextOrResource-7", UriContextResolutionComboTest.input("", "", "", "/path", "context:/foo"), UriContextResolutionComboTest.results("/foo", "/foo", "/foo", "/foo", "/foo", "/foo")}, {"NoAuthorityOrContextOrResource-8", UriContextResolutionComboTest.input("", "", "", "/path", "context:/"), UriContextResolutionComboTest.results("/", "/", "/", "/", "/", "/")}, {"NoAuthorityOrContextOrResource-9", UriContextResolutionComboTest.input("", "", "", "/path", "servlet:/foo"), UriContextResolutionComboTest.results("/foo", "/foo", "/foo", "/foo", "/foo", "/foo")}, {"NoAuthorityOrContextOrResource-10", UriContextResolutionComboTest.input("", "", "", "/path", "servlet:/"), UriContextResolutionComboTest.results("/", "/", "/", "/", "/", "/")}, {"NoContextOrResource-1", UriContextResolutionComboTest.input("http://host:port", "", "", "/path", "http://foo.com:123/foobar"), UriContextResolutionComboTest.results("http://foo.com:123/foobar", "http://foo.com:123/foobar", "http://foo.com:123/foobar", "http://foo.com:123/foobar", "http://foo.com:123/foobar", "http://foo.com:123/foobar")}, {"NoContextOrResource-2", UriContextResolutionComboTest.input("http://host:port", "", "", "/path", "http://foo.com:123"), UriContextResolutionComboTest.results("http://foo.com:123", "http://foo.com:123", "http://foo.com:123", "http://foo.com:123", "http://foo.com:123", "http://foo.com:123")}, {"NoContextOrResource-3", UriContextResolutionComboTest.input("http://host:port", "", "", "/path", "/foobar"), UriContextResolutionComboTest.results("http://host:port/foobar", "http://host:port/foobar", "/foobar", "/foobar", "/foobar", "/foobar")}, {"NoContextOrResource-4", UriContextResolutionComboTest.input("http://host:port", "", "", "/path", "/"), UriContextResolutionComboTest.results("http://host:port", "http://host:port", "/", "/", "/", "/")}, {"NoContextOrResource-5", UriContextResolutionComboTest.input("http://host:port", "", "", "/path", "foobar"), UriContextResolutionComboTest.results("http://host:port/foobar", "http://host:port/foobar", "/foobar", "/foobar", "foobar", "foobar")}, {"NoContextOrResource-6", UriContextResolutionComboTest.input("http://host:port", "", "", "/path", ""), UriContextResolutionComboTest.results("http://host:port", "http://host:port/path", "/", "/path", "", "")}, {"NoContextOrResource-7", UriContextResolutionComboTest.input("http://host:port", "", "", "/path", "context:/foo"), UriContextResolutionComboTest.results("http://host:port/foo", "http://host:port/foo", "/foo", "/foo", "/foo", "/foo")}, {"NoContextOrResource-8", UriContextResolutionComboTest.input("http://host:port", "", "", "/path", "context:/"), UriContextResolutionComboTest.results("http://host:port", "http://host:port", "/", "/", "/", "/")}, {"NoContextOrResource-9", UriContextResolutionComboTest.input("http://host:port", "", "", "/path", "servlet:/foo"), UriContextResolutionComboTest.results("http://host:port/foo", "http://host:port/foo", "/foo", "/foo", "/foo", "/foo")}, {"NoContextOrResource-10", UriContextResolutionComboTest.input("http://host:port", "", "", "/path", "servlet:/"), UriContextResolutionComboTest.results("http://host:port", "http://host:port", "/", "/", "/", "/")});
    }

    public static Input input(String authority, String context, String resource, String path, String uri) {
        return new Input(authority, context, resource, path, uri);
    }

    public static Results results(String eAbsResource, String eAbsPathInfo, String eRrResource, String eRrPathInfo, String eNoneResource, String eNonePathInfo) {
        return new Results(eAbsResource, eAbsPathInfo, eRrResource, eRrPathInfo, eNoneResource, eNonePathInfo);
    }

    public UriContextResolutionComboTest(String label, Input in, Results r) throws Exception {
        this.label = label;
        this.in = in;
        this.r = r;
    }

    @Test
    public void a01_testAbsoluteResource() {
        TestUtils.assertEquals(this.r.aResource, new UriResolver(UriResolution.ABSOLUTE, UriRelativity.RESOURCE, new UriContext(this.in.authority, this.in.context, this.in.resource, this.in.path)).resolve((Object)this.in.uri), "{0}: testAbsolute() failed", this.label);
    }

    @Test
    public void a02_testAppendAbsoluteResource() {
        TestUtils.assertEquals(this.r.aResource, new UriResolver(UriResolution.ABSOLUTE, UriRelativity.RESOURCE, new UriContext(this.in.authority, this.in.context, this.in.resource, this.in.path)).append((Appendable)new StringBuilder(), (Object)this.in.uri).toString(), "{0}: testAbsolute() failed", this.label);
    }

    @Test
    public void a03_testAbsolutePathInfo() {
        TestUtils.assertEquals(this.r.aPathInfo, new UriResolver(UriResolution.ABSOLUTE, UriRelativity.PATH_INFO, new UriContext(this.in.authority, this.in.context, this.in.resource, this.in.path)).resolve((Object)this.in.uri), "{0}: testAbsolute() failed", this.label);
    }

    @Test
    public void a04_testAppendAbsolutePathInfo() {
        TestUtils.assertEquals(this.r.aPathInfo, new UriResolver(UriResolution.ABSOLUTE, UriRelativity.PATH_INFO, new UriContext(this.in.authority, this.in.context, this.in.resource, this.in.path)).append((Appendable)new StringBuilder(), (Object)this.in.uri).toString(), "{0}: testAbsolute() failed", this.label);
    }

    @Test
    public void a05_testRootRelativeResource() {
        TestUtils.assertEquals(this.r.rrResource, new UriResolver(UriResolution.ROOT_RELATIVE, UriRelativity.RESOURCE, new UriContext(this.in.authority, this.in.context, this.in.resource, this.in.path)).resolve((Object)this.in.uri), "{0}: testAbsolute() failed", this.label);
    }

    @Test
    public void a06_testAppendRootRelativeResource() {
        TestUtils.assertEquals(this.r.rrResource, new UriResolver(UriResolution.ROOT_RELATIVE, UriRelativity.RESOURCE, new UriContext(this.in.authority, this.in.context, this.in.resource, this.in.path)).append((Appendable)new StringBuilder(), (Object)this.in.uri).toString(), "{0}: testAbsolute() failed", this.label);
    }

    @Test
    public void a07_testRootRelativePathInfo() {
        TestUtils.assertEquals(this.r.rrPathInfo, new UriResolver(UriResolution.ROOT_RELATIVE, UriRelativity.PATH_INFO, new UriContext(this.in.authority, this.in.context, this.in.resource, this.in.path)).resolve((Object)this.in.uri), "{0}: testAbsolute() failed", this.label);
    }

    @Test
    public void a08_testAppendRootRelativePathInfo() {
        TestUtils.assertEquals(this.r.rrPathInfo, new UriResolver(UriResolution.ROOT_RELATIVE, UriRelativity.PATH_INFO, new UriContext(this.in.authority, this.in.context, this.in.resource, this.in.path)).append((Appendable)new StringBuilder(), (Object)this.in.uri).toString(), "{0}: testAbsolute() failed", this.label);
    }

    @Test
    public void a09_testNoneResource() {
        TestUtils.assertEquals(this.r.nResource, new UriResolver(UriResolution.NONE, UriRelativity.RESOURCE, new UriContext(this.in.authority, this.in.context, this.in.resource, this.in.path)).resolve((Object)this.in.uri), "{0}: testAbsolute() failed", this.label);
    }

    @Test
    public void a10_testAppendNoneResource() {
        TestUtils.assertEquals(this.r.nResource, new UriResolver(UriResolution.NONE, UriRelativity.RESOURCE, new UriContext(this.in.authority, this.in.context, this.in.resource, this.in.path)).append((Appendable)new StringBuilder(), (Object)this.in.uri).toString(), "{0}: testAbsolute() failed", this.label);
    }

    @Test
    public void a11_testNonePathInfo() {
        TestUtils.assertEquals(this.r.nPathInfo, new UriResolver(UriResolution.NONE, UriRelativity.PATH_INFO, new UriContext(this.in.authority, this.in.context, this.in.resource, this.in.path)).resolve((Object)this.in.uri), "{0}: testAbsolute() failed", this.label);
    }

    @Test
    public void a12_testAppendNonePathInfo() {
        TestUtils.assertEquals(this.r.nPathInfo, new UriResolver(UriResolution.NONE, UriRelativity.PATH_INFO, new UriContext(this.in.authority, this.in.context, this.in.resource, this.in.path)).append((Appendable)new StringBuilder(), (Object)this.in.uri).toString(), "{0}: testAbsolute() failed", this.label);
    }

    public static class Results {
        private final String aResource;
        private final String aPathInfo;
        private final String rrResource;
        private final String rrPathInfo;
        private final String nResource;
        private final String nPathInfo;

        public Results(String aResource, String aPathInfo, String rrResource, String rrPathInfo, String nResource, String nPathInfo) {
            this.aResource = aResource;
            this.aPathInfo = aPathInfo;
            this.rrResource = rrResource;
            this.rrPathInfo = rrPathInfo;
            this.nResource = nResource;
            this.nPathInfo = nPathInfo;
        }
    }

    public static class Input {
        private final String uri;
        private final String authority;
        private final String context;
        private final String resource;
        private final String path;

        public Input(String authority, String context, String resource, String path, String uri) {
            this.authority = authority;
            this.context = context;
            this.resource = resource;
            this.path = path;
            this.uri = uri;
        }
    }
}

