/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.utils;

import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.svl.MultipartVar;
import org.apache.juneau.svl.SimpleVar;
import org.apache.juneau.svl.VarResolver;
import org.apache.juneau.svl.VarResolverBuilder;
import org.apache.juneau.svl.VarResolverSession;
import org.junit.Assert;
import org.junit.Test;

public class StringVarResolverTest {
    @Test
    public void test() throws Exception {
        VarResolver vr = new VarResolverBuilder().vars(new Class[]{XVar.class}).build();
        String t = null;
        Assert.assertEquals(null, (Object)vr.resolve(t));
        t = "";
        Assert.assertEquals((Object)"", (Object)vr.resolve(t));
        t = "foo";
        Assert.assertEquals((Object)"foo", (Object)vr.resolve(t));
        t = "$X{y}";
        Assert.assertEquals((Object)"xyx", (Object)vr.resolve(t));
        t = "$X{y}x";
        Assert.assertEquals((Object)"xyxx", (Object)vr.resolve(t));
        t = "x$X{y}";
        Assert.assertEquals((Object)"xxyx", (Object)vr.resolve(t));
        t = "$X{y}$X{y}";
        Assert.assertEquals((Object)"xyxxyx", (Object)vr.resolve(t));
        t = "z$X{y}z$X{y}z";
        Assert.assertEquals((Object)"zxyxzxyxz", (Object)vr.resolve(t));
        t = "$X{$X{y}}";
        Assert.assertEquals((Object)"xxyxx", (Object)vr.resolve(t));
        t = "$X{z$X{y}z}";
        Assert.assertEquals((Object)"xzxyxzx", (Object)vr.resolve(t));
        t = "$X.{y}";
        Assert.assertEquals((Object)"$X.{y}", (Object)vr.resolve(t));
        t = "z$X.{y}z";
        Assert.assertEquals((Object)"z$X.{y}z", (Object)vr.resolve(t));
        t = "z$X.{$X.{z}}z";
        Assert.assertEquals((Object)"z$X.{$X.{z}}z", (Object)vr.resolve(t));
        t = "$Y{y}";
        Assert.assertEquals((Object)"$Y{y}", (Object)vr.resolve(t));
        t = "$Y{y}x";
        Assert.assertEquals((Object)"$Y{y}x", (Object)vr.resolve(t));
        t = "x$Y{y}";
        Assert.assertEquals((Object)"x$Y{y}", (Object)vr.resolve(t));
    }

    @Test
    public void test2() throws Exception {
        VarResolver vr = new VarResolverBuilder().vars(new Class[]{BlankVar.class}).build();
        String t = "${y}";
        Assert.assertEquals((Object)"xyx", (Object)vr.resolve(t));
        t = "${${y}}";
        Assert.assertEquals((Object)"xxyxx", (Object)vr.resolve(t));
        t = "${${y}${y}}";
        Assert.assertEquals((Object)"xxyxxyxx", (Object)vr.resolve(t));
        t = "z${z${y}z}z";
        Assert.assertEquals((Object)"zxzxyxzxz", (Object)vr.resolve(t));
    }

    @Test
    public void testEscaped$() throws Exception {
        VarResolver vr = new VarResolverBuilder().vars(new Class[]{BlankVar.class}).build();
        String t = "${y}";
        Assert.assertEquals((Object)"xyx", (Object)vr.resolve(t));
        t = "\\${y}";
        Assert.assertEquals((Object)"${y}", (Object)vr.resolve(t));
        t = "foo\\${y}foo";
        Assert.assertEquals((Object)"foo${y}foo", (Object)vr.resolve(t));
    }

    @Test
    public void testEscapedSequences() throws Exception {
        VarResolver vr = new VarResolverBuilder().vars(new Class[]{XVar.class}).build();
        char b = '\\';
        String t = "A|A".replace('|', b);
        Assert.assertEquals((Object)"A|A".replace('|', b), (Object)vr.resolve(t));
        t = "A||A".replace('|', b);
        Assert.assertEquals((Object)"A|A".replace('|', b), (Object)vr.resolve(t));
        t = "A|A$X{B}".replace('|', b);
        Assert.assertEquals((Object)"A|AxBx".replace('|', b), (Object)vr.resolve(t));
        t = "A||A$X{B}".replace('|', b);
        Assert.assertEquals((Object)"A|AxBx".replace('|', b), (Object)vr.resolve(t));
        t = "A|$X{B}".replace('|', b);
        Assert.assertEquals((Object)"A$X{B}".replace('|', b), (Object)vr.resolve(t));
        t = "A||$X{B}".replace('|', b);
        Assert.assertEquals((Object)"A|xBx".replace('|', b), (Object)vr.resolve(t));
        t = "A$X|{B}".replace('|', b);
        Assert.assertEquals((Object)"A$X{B}".replace('|', b), (Object)vr.resolve(t));
        t = "A$X{B|}".replace('|', b);
        Assert.assertEquals((Object)"A$X{B}".replace('|', b), (Object)vr.resolve(t));
        t = "A$X{B}|".replace('|', b);
        Assert.assertEquals((Object)"AxBx|".replace('|', b), (Object)vr.resolve(t));
    }

    @Test
    public void test$E() throws Exception {
        String t = "$E{PATH}";
        Assert.assertFalse((boolean)StringUtils.isEmpty((String)VarResolver.DEFAULT.resolve(t)));
    }

    @Test
    public void testParent() throws Exception {
        VarResolver vr = new VarResolverBuilder().defaultVars().vars(new Class[]{XMultipartVar.class}).build();
        System.setProperty("a", "a1");
        System.setProperty("b", "b1");
        String t = "$X{$S{a},$S{b}}";
        Assert.assertEquals((Object)"a1+b1", (Object)vr.resolve(t));
        t = "$X{$S{a}}";
        Assert.assertEquals((Object)"a1", (Object)vr.resolve(t));
    }

    @Test
    public void testFalseTriggers() throws Exception {
        VarResolverBuilder vrb = new VarResolverBuilder().defaultVars();
        String in = null;
        for (Class c : new Class[]{InvalidVar1.class, InvalidVar2.class, InvalidVar3.class, InvalidVar4.class, InvalidVar5.class}) {
            try {
                vrb.vars(new Class[]{c});
                Assert.fail();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        VarResolver vr = vrb.build();
        in = "$@{foobar}";
        Assert.assertEquals((Object)in, (Object)vr.resolve(in));
        in = "$[{foobar}";
        Assert.assertEquals((Object)in, (Object)vr.resolve(in));
        in = "$`{foobar}";
        Assert.assertEquals((Object)in, (Object)vr.resolve(in));
        in = "$|{foobar}";
        Assert.assertEquals((Object)in, (Object)vr.resolve(in));
        in = "${{foobar}";
        Assert.assertEquals((Object)in, (Object)vr.resolve(in));
        in = "${$foobar}";
        Assert.assertEquals((Object)in, (Object)vr.resolve(in));
        System.setProperty("foobar", "baz");
        in = "$";
        Assert.assertEquals((Object)in, (Object)vr.resolve(in));
        in = "$S";
        Assert.assertEquals((Object)in, (Object)vr.resolve(in));
        in = "$S{";
        Assert.assertEquals((Object)in, (Object)vr.resolve(in));
        in = "$S{foobar";
        Assert.assertEquals((Object)in, (Object)vr.resolve(in));
        in = "$S{foobar}$";
        Assert.assertEquals((Object)"baz$", (Object)vr.resolve(in));
        in = "$S{foobar}$S";
        Assert.assertEquals((Object)"baz$S", (Object)vr.resolve(in));
        in = "$S{foobar}$S{";
        Assert.assertEquals((Object)"baz$S{", (Object)vr.resolve(in));
        in = "$S{foobar}$S{foobar";
        Assert.assertEquals((Object)"baz$S{foobar", (Object)vr.resolve(in));
        System.clearProperty("foobar");
        in = "$S{foobar}";
        vrb.vars(new Class[]{AlwaysNullVar.class});
        vr = vrb.build();
        in = "$A{xxx}";
        Assert.assertEquals((Object)"", (Object)vr.resolve(in));
        in = "x$A{xxx}";
        Assert.assertEquals((Object)"x", (Object)vr.resolve(in));
        in = "$A{xxx}x";
        Assert.assertEquals((Object)"x", (Object)vr.resolve(in));
    }

    public static class InvalidVar5
    extends InvalidVar {
        public InvalidVar5() {
            super("|");
        }
    }

    public static class InvalidVar4
    extends InvalidVar {
        public InvalidVar4() {
            super("`");
        }
    }

    public static class InvalidVar3
    extends InvalidVar {
        public InvalidVar3() {
            super("[");
        }
    }

    public static class InvalidVar2
    extends InvalidVar {
        public InvalidVar2() {
            super("@");
        }
    }

    public static class InvalidVar1
    extends InvalidVar {
        public InvalidVar1() {
            super(null);
        }
    }

    public static class InvalidVar
    extends SimpleVar {
        public InvalidVar(String c) {
            super(c);
        }

        public String resolve(VarResolverSession session, String key) {
            return null;
        }
    }

    public static class AlwaysNullVar
    extends SimpleVar {
        public AlwaysNullVar() {
            super("A");
        }

        public String resolve(VarResolverSession session, String key) {
            return null;
        }
    }

    public static class XMultipartVar
    extends MultipartVar {
        public XMultipartVar() {
            super("X");
        }

        public String resolve(VarResolverSession session, String[] args) {
            return StringUtils.join((Object[])args, (char)'+');
        }
    }

    public static class BlankVar
    extends SimpleVar {
        public BlankVar() {
            super("");
        }

        public String resolve(VarResolverSession session, String arg) {
            return "x" + arg + "x";
        }
    }

    public static class XVar
    extends SimpleVar {
        public XVar() {
            super("X");
        }

        public String resolve(VarResolverSession session, String arg) {
            return "x" + arg + "x";
        }
    }
}

