/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.utils;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.internal.AsciiSet;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.ParserPipe;
import org.apache.juneau.parser.ParserReader;
import org.apache.juneau.testutils.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class StringUtilsTest {
    @Test
    public void testParseNumber() throws Exception {
        Assert.assertTrue((boolean)StringUtils.isNumeric((String)"123"));
        Assert.assertEquals((Object)123, (Object)StringUtils.parseNumber((String)"123", null));
        Assert.assertEquals((Object)123, (Object)StringUtils.parseNumber((String)"123", Integer.class));
        Assert.assertEquals((Object)123, (Object)StringUtils.parseNumber((String)"123", Short.class));
        Assert.assertEquals((Object)123L, (Object)StringUtils.parseNumber((String)"123", Long.class));
        Assert.assertTrue((boolean)StringUtils.isNumeric((String)"0123"));
        Assert.assertEquals((Object)83, (Object)StringUtils.parseNumber((String)"0123", null));
        Assert.assertTrue((boolean)StringUtils.isNumeric((String)"-0123"));
        Assert.assertEquals((Object)-83, (Object)StringUtils.parseNumber((String)"-0123", null));
        Assert.assertTrue((boolean)StringUtils.isNumeric((String)"0x123"));
        Assert.assertEquals((Object)291, (Object)StringUtils.parseNumber((String)"0x123", null));
        Assert.assertTrue((boolean)StringUtils.isNumeric((String)"-0x123"));
        Assert.assertEquals((Object)-291, (Object)StringUtils.parseNumber((String)"-0x123", null));
        Assert.assertTrue((boolean)StringUtils.isNumeric((String)"0X123"));
        Assert.assertEquals((Object)291, (Object)StringUtils.parseNumber((String)"0X123", null));
        Assert.assertTrue((boolean)StringUtils.isNumeric((String)"-0X123"));
        Assert.assertEquals((Object)-291, (Object)StringUtils.parseNumber((String)"-0X123", null));
        Assert.assertTrue((boolean)StringUtils.isNumeric((String)"#123"));
        Assert.assertEquals((Object)291, (Object)StringUtils.parseNumber((String)"#123", null));
        Assert.assertTrue((boolean)StringUtils.isNumeric((String)"-#123"));
        Assert.assertEquals((Object)-291, (Object)StringUtils.parseNumber((String)"-#123", null));
        Assert.assertFalse((boolean)StringUtils.isNumeric((String)"x123"));
        Assert.assertFalse((boolean)StringUtils.isNumeric((String)"0x123x"));
        Assert.assertTrue((boolean)StringUtils.isNumeric((String)"0.123"));
        Assert.assertEquals((Object)Float.valueOf(0.123f), (Object)StringUtils.parseNumber((String)"0.123", null));
        Assert.assertTrue((boolean)StringUtils.isNumeric((String)"-0.123"));
        Assert.assertEquals((Object)Float.valueOf(-0.123f), (Object)StringUtils.parseNumber((String)"-0.123", null));
        Assert.assertTrue((boolean)StringUtils.isNumeric((String)".123"));
        Assert.assertEquals((Object)Float.valueOf(0.123f), (Object)StringUtils.parseNumber((String)".123", null));
        Assert.assertTrue((boolean)StringUtils.isNumeric((String)"-.123"));
        Assert.assertEquals((Object)Float.valueOf(-0.123f), (Object)StringUtils.parseNumber((String)"-.123", null));
        Assert.assertFalse((boolean)StringUtils.isNumeric((String)"0.123.4"));
        Assert.assertTrue((boolean)StringUtils.isNumeric((String)"0.84370821629078d"));
        Assert.assertEquals((Object)0.84370821629078, (Object)StringUtils.parseNumber((String)"0.84370821629078d", null));
        Assert.assertTrue((boolean)StringUtils.isNumeric((String)"84370821629078.8437d"));
        Assert.assertEquals((Object)8.437082162907884E13, (Object)StringUtils.parseNumber((String)"84370821629078.8437d", null));
        Assert.assertTrue((boolean)StringUtils.isNumeric((String)"0.16666666666666666d"));
        Assert.assertEquals((Object)0.16666666666666666, (Object)StringUtils.parseNumber((String)"0.16666666666666666d", null));
        Assert.assertTrue((boolean)StringUtils.isNumeric((String)"0.16666666f"));
        Assert.assertEquals((Object)Float.valueOf(0.16666666f), (Object)StringUtils.parseNumber((String)"0.16666666f", null));
        Assert.assertTrue((boolean)StringUtils.isNumeric((String)"0.16666666d"));
        Assert.assertEquals((Object)Float.valueOf(0.16666666f), (Object)StringUtils.parseNumber((String)"0.16666666d", null));
        Assert.assertTrue((boolean)StringUtils.isNumeric((String)"3.140000000000000124344978758017532527446746826171875d"));
        Assert.assertEquals((Object)Float.valueOf(3.14f), (Object)StringUtils.parseNumber((String)"3.140000000000000124344978758017532527446746826171875d", null));
        Assert.assertTrue((boolean)StringUtils.isNumeric((String)"12345.678f"));
        Assert.assertEquals((Object)Float.valueOf(12345.678f), (Object)StringUtils.parseNumber((String)"12345.678f", null));
        Assert.assertTrue((boolean)StringUtils.isNumeric((String)"1e1"));
        Assert.assertEquals((Object)Float.valueOf(10.0f), (Object)StringUtils.parseNumber((String)"1e1", null));
        Assert.assertTrue((boolean)StringUtils.isNumeric((String)"1e+1"));
        Assert.assertEquals((Object)Float.valueOf(10.0f), (Object)StringUtils.parseNumber((String)"1e+1", null));
        Assert.assertTrue((boolean)StringUtils.isNumeric((String)"1e-1"));
        Assert.assertEquals((Object)Float.valueOf(0.1f), (Object)StringUtils.parseNumber((String)"1e-1", null));
        Assert.assertTrue((boolean)StringUtils.isNumeric((String)"1.1e1"));
        Assert.assertEquals((Object)Float.valueOf(11.0f), (Object)StringUtils.parseNumber((String)"1.1e1", null));
        Assert.assertTrue((boolean)StringUtils.isNumeric((String)"1.1e+1"));
        Assert.assertEquals((Object)Float.valueOf(11.0f), (Object)StringUtils.parseNumber((String)"1.1e+1", null));
        Assert.assertTrue((boolean)StringUtils.isNumeric((String)"1.1e-1"));
        Assert.assertEquals((Object)Float.valueOf(0.11f), (Object)StringUtils.parseNumber((String)"1.1e-1", null));
        Assert.assertTrue((boolean)StringUtils.isNumeric((String)".1e1"));
        Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)StringUtils.parseNumber((String)".1e1", null));
        Assert.assertTrue((boolean)StringUtils.isNumeric((String)".1e+1"));
        Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)StringUtils.parseNumber((String)".1e+1", null));
        Assert.assertTrue((boolean)StringUtils.isNumeric((String)".1e-1"));
        Assert.assertEquals((Object)Float.valueOf(0.01f), (Object)StringUtils.parseNumber((String)".1e-1", null));
        Assert.assertTrue((boolean)StringUtils.isNumeric((String)"0x123e1"));
        Assert.assertEquals((Object)74721, (Object)StringUtils.parseNumber((String)"0x123e1", null));
        try {
            StringUtils.parseNumber((String)"x", Number.class);
            Assert.fail();
        }
        catch (ParseException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof NumberFormatException));
        }
        try {
            StringUtils.parseNumber((String)"x", null);
            Assert.fail();
        }
        catch (ParseException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof NumberFormatException));
        }
        try {
            StringUtils.parseNumber((String)"x", BadNumber.class);
            Assert.fail();
        }
        catch (ParseException e) {
            Assert.assertTrue((boolean)e.getLocalizedMessage().startsWith("Unsupported Number type"));
        }
    }

    @Test
    public void testParseNumberFromReader() throws Exception {
        for (Class c : new Class[]{Integer.class, Double.class, Float.class, Long.class, Short.class, Byte.class, BigInteger.class, BigDecimal.class, Number.class, AtomicInteger.class, AtomicLong.class}) {
            ParserReader in = new ParserReader(new ParserPipe((Object)"123'"));
            Number n = StringUtils.parseNumber((ParserReader)in, (Class)c);
            Assert.assertTrue((boolean)c.isInstance(n));
            Assert.assertEquals((long)123L, (long)n.intValue());
        }
    }

    @Test
    public void testNumberRanges() throws Exception {
        Assert.assertFalse((boolean)StringUtils.isNumeric(null));
        Assert.assertFalse((boolean)StringUtils.isNumeric((String)""));
        Assert.assertFalse((boolean)StringUtils.isNumeric((String)"x"));
        String s = "-2147483648";
        Assert.assertTrue((boolean)StringUtils.isNumeric((String)s));
        Assert.assertTrue((boolean)(StringUtils.parseNumber((String)s, null) instanceof Integer));
        Assert.assertEquals((Object)Integer.MIN_VALUE, (Object)StringUtils.parseNumber((String)s, null));
        s = "2147483647";
        Assert.assertTrue((boolean)StringUtils.isNumeric((String)s));
        Assert.assertTrue((boolean)(StringUtils.parseNumber((String)s, null) instanceof Integer));
        Assert.assertEquals((Object)Integer.MAX_VALUE, (Object)StringUtils.parseNumber((String)s, null));
        s = "-2147483649";
        Assert.assertTrue((boolean)StringUtils.isNumeric((String)s));
        Assert.assertTrue((boolean)(StringUtils.parseNumber((String)s, null) instanceof Long));
        Assert.assertEquals((Object)-2147483649L, (Object)StringUtils.parseNumber((String)s, null));
        s = "2147483648";
        Assert.assertTrue((boolean)StringUtils.isNumeric((String)s));
        Assert.assertTrue((boolean)(StringUtils.parseNumber((String)s, null) instanceof Long));
        Assert.assertEquals((Object)0x80000000L, (Object)StringUtils.parseNumber((String)s, null));
        s = "-9223372036854775808";
        Assert.assertTrue((boolean)StringUtils.isNumeric((String)s));
        Assert.assertTrue((boolean)(StringUtils.parseNumber((String)s, null) instanceof Long));
        Assert.assertEquals((Object)Long.MIN_VALUE, (Object)StringUtils.parseNumber((String)s, null));
        s = "9223372036854775807";
        Assert.assertTrue((boolean)StringUtils.isNumeric((String)s));
        Assert.assertTrue((boolean)(StringUtils.parseNumber((String)s, null) instanceof Long));
        Assert.assertEquals((Object)Long.MAX_VALUE, (Object)StringUtils.parseNumber((String)s, null));
        s = "-9223372036854775809";
        Assert.assertTrue((boolean)StringUtils.isNumeric((String)s));
        Assert.assertTrue((boolean)(StringUtils.parseNumber((String)s, null) instanceof Double));
        Assert.assertEquals((long)Long.MIN_VALUE, (long)StringUtils.parseNumber((String)s, null).longValue());
        Assert.assertEquals((Object)-9.223372036854776E18, (Object)StringUtils.parseNumber((String)s, null));
        s = "9223372036854775808";
        Assert.assertTrue((boolean)StringUtils.isNumeric((String)s));
        Assert.assertTrue((boolean)(StringUtils.parseNumber((String)s, null) instanceof Double));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)StringUtils.parseNumber((String)s, null).longValue());
        Assert.assertEquals((Object)9.223372036854776E18, (Object)StringUtils.parseNumber((String)s, null));
        s = "-123456789012345678901";
        Assert.assertTrue((boolean)StringUtils.isNumeric((String)s));
        Assert.assertTrue((boolean)(StringUtils.parseNumber((String)s, null) instanceof Double));
        Assert.assertEquals((long)Long.MIN_VALUE, (long)StringUtils.parseNumber((String)s, null).longValue());
        Assert.assertEquals((Object)-1.2345678901234568E20, (Object)StringUtils.parseNumber((String)s, null));
        s = "123456789012345678901";
        Assert.assertTrue((boolean)StringUtils.isNumeric((String)s));
        Assert.assertTrue((boolean)(StringUtils.parseNumber((String)s, null) instanceof Double));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)StringUtils.parseNumber((String)s, null).longValue());
        Assert.assertEquals((Object)1.2345678901234568E20, (Object)StringUtils.parseNumber((String)s, null));
        s = String.valueOf(1.7014117E38f);
        Assert.assertTrue((boolean)StringUtils.isNumeric((String)s));
        Assert.assertTrue((boolean)(StringUtils.parseNumber((String)s, null) instanceof Float));
        Assert.assertEquals((Object)Float.valueOf(1.7014117E38f), (Object)StringUtils.parseNumber((String)s, null));
        s = String.valueOf(-1.7014117E38f);
        Assert.assertTrue((boolean)StringUtils.isNumeric((String)s));
        Assert.assertTrue((boolean)(StringUtils.parseNumber((String)s, null) instanceof Float));
        Assert.assertEquals((Object)Float.valueOf(-1.7014117E38f), (Object)StringUtils.parseNumber((String)s, null));
        s = String.valueOf(6.805646932770577E38);
        Assert.assertTrue((boolean)StringUtils.isNumeric((String)s));
        Assert.assertTrue((boolean)(StringUtils.parseNumber((String)s, null) instanceof Double));
        Assert.assertEquals((Object)"6.805646932770577E38", (Object)StringUtils.parseNumber((String)s, null).toString());
        s = String.valueOf(-6.805646932770577E38);
        Assert.assertTrue((boolean)StringUtils.isNumeric((String)s));
        Assert.assertTrue((boolean)(StringUtils.parseNumber((String)s, null) instanceof Double));
        Assert.assertEquals((Object)"-6.805646932770577E38", (Object)StringUtils.parseNumber((String)s, null).toString());
        s = String.valueOf("214748364x");
        Assert.assertFalse((boolean)StringUtils.isNumeric((String)s));
        try {
            StringUtils.parseNumber((String)s, Number.class);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        s = String.valueOf("2147483640x");
        Assert.assertFalse((boolean)StringUtils.isNumeric((String)s));
        try {
            StringUtils.parseNumber((String)s, Long.class);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    @Test
    public void testReplaceVars() throws Exception {
        ObjectMap m = new ObjectMap((CharSequence)"{a:'A',b:1,c:true,d:'{e}',e:'E{f}E',f:'F',g:'{a}',h:'a',i:null}");
        String s = "xxx";
        Assert.assertEquals((Object)"xxx", (Object)StringUtils.replaceVars((String)s, (Map)m));
        s = "{a}";
        Assert.assertEquals((Object)"A", (Object)StringUtils.replaceVars((String)s, (Map)m));
        s = "{a}{a}";
        Assert.assertEquals((Object)"AA", (Object)StringUtils.replaceVars((String)s, (Map)m));
        s = "x{a}x";
        Assert.assertEquals((Object)"xAx", (Object)StringUtils.replaceVars((String)s, (Map)m));
        s = "x{a}x{a}x";
        Assert.assertEquals((Object)"xAxAx", (Object)StringUtils.replaceVars((String)s, (Map)m));
        s = "{b}";
        Assert.assertEquals((Object)"1", (Object)StringUtils.replaceVars((String)s, (Map)m));
        s = "{b}{b}";
        Assert.assertEquals((Object)"11", (Object)StringUtils.replaceVars((String)s, (Map)m));
        s = "x{b}x";
        Assert.assertEquals((Object)"x1x", (Object)StringUtils.replaceVars((String)s, (Map)m));
        s = "x{b}x{b}x";
        Assert.assertEquals((Object)"x1x1x", (Object)StringUtils.replaceVars((String)s, (Map)m));
        s = "{c}";
        Assert.assertEquals((Object)"true", (Object)StringUtils.replaceVars((String)s, (Map)m));
        s = "{c}{c}";
        Assert.assertEquals((Object)"truetrue", (Object)StringUtils.replaceVars((String)s, (Map)m));
        s = "x{c}x{c}x";
        Assert.assertEquals((Object)"xtruextruex", (Object)StringUtils.replaceVars((String)s, (Map)m));
        s = "{d}";
        Assert.assertEquals((Object)"EFE", (Object)StringUtils.replaceVars((String)s, (Map)m));
        s = "{d}{d}";
        Assert.assertEquals((Object)"EFEEFE", (Object)StringUtils.replaceVars((String)s, (Map)m));
        s = "x{d}x";
        Assert.assertEquals((Object)"xEFEx", (Object)StringUtils.replaceVars((String)s, (Map)m));
        s = "x{d}x{d}x";
        Assert.assertEquals((Object)"xEFExEFEx", (Object)StringUtils.replaceVars((String)s, (Map)m));
        s = "{g}";
        Assert.assertEquals((Object)"A", (Object)StringUtils.replaceVars((String)s, (Map)m));
        s = "{g}{g}";
        Assert.assertEquals((Object)"AA", (Object)StringUtils.replaceVars((String)s, (Map)m));
        s = "x{g}x";
        Assert.assertEquals((Object)"xAx", (Object)StringUtils.replaceVars((String)s, (Map)m));
        s = "x{g}x{g}x";
        Assert.assertEquals((Object)"xAxAx", (Object)StringUtils.replaceVars((String)s, (Map)m));
        s = "{x}";
        Assert.assertEquals((Object)"{x}", (Object)StringUtils.replaceVars((String)s, (Map)m));
        s = "{x}{x}";
        Assert.assertEquals((Object)"{x}{x}", (Object)StringUtils.replaceVars((String)s, (Map)m));
        s = "x{x}x{x}x";
        Assert.assertEquals((Object)"x{x}x{x}x", (Object)StringUtils.replaceVars((String)s, (Map)m));
        s = "{{g}}";
        Assert.assertEquals((Object)"{A}", (Object)StringUtils.replaceVars((String)s, (Map)m));
        s = "{{h}}";
        Assert.assertEquals((Object)"A", (Object)StringUtils.replaceVars((String)s, (Map)m));
        s = "{{i}}";
        Assert.assertEquals((Object)"{}", (Object)StringUtils.replaceVars((String)s, (Map)m));
        s = "{}";
        Assert.assertEquals((Object)"{}", (Object)StringUtils.replaceVars((String)s, (Map)m));
    }

    @Test
    public void testisFloat() throws Exception {
        String[] invalid;
        String[] valid;
        for (String s : valid = new String[]{"+1.0", "-1.0", ".0", "NaN", "Infinity", "1e1", "-1e-1", "+1e+1", "-1.1e-1", "+1.1e+1", "1.1f", "1.1F", "1.1d", "1.1D", "0x1.fffffffffffffp1023", "0x1.FFFFFFFFFFFFFP1023"}) {
            Assert.assertTrue((boolean)StringUtils.isFloat((String)s));
        }
        for (String s : invalid = new String[]{null, "", "a", "+", "-", ".", "a", "+a", "11a"}) {
            Assert.assertFalse((boolean)StringUtils.isFloat((String)s));
        }
    }

    @Test
    public void testisDecimal() throws Exception {
        String[] invalid;
        String[] valid;
        for (String s : valid = new String[]{"+1", "-1", "0x123", "0X123", "0xdef", "0XDEF", "#def", "#DEF", "0123"}) {
            Assert.assertTrue((boolean)StringUtils.isDecimal((String)s));
        }
        for (String s : invalid = new String[]{null, "", "a", "+", "-", ".", "0xdeg", "0XDEG", "#deg", "#DEG", "0128", "012A"}) {
            Assert.assertFalse((boolean)StringUtils.isDecimal((String)s));
        }
    }

    @Test
    public void testJoin() throws Exception {
        Assert.assertNull((Object)StringUtils.join((Object[])null, (String)","));
        Assert.assertEquals((Object)"1", (Object)StringUtils.join((Object[])new Object[]{1}, (String)","));
        Assert.assertEquals((Object)"1,2", (Object)StringUtils.join((Object[])new Object[]{1, 2}, (String)","));
        Assert.assertNull((Object)StringUtils.join((int[])null, (String)","));
        Assert.assertEquals((Object)"1", (Object)StringUtils.join((int[])new int[]{1}, (String)","));
        Assert.assertEquals((Object)"1,2", (Object)StringUtils.join((int[])new int[]{1, 2}, (String)","));
        Assert.assertNull((Object)StringUtils.join((Collection)null, (String)","));
        Assert.assertEquals((Object)"1", (Object)StringUtils.join(Arrays.asList(1), (String)","));
        Assert.assertEquals((Object)"1,2", (Object)StringUtils.join(Arrays.asList(1, 2), (String)","));
        Assert.assertNull((Object)StringUtils.join((Object[])null, (char)','));
        Assert.assertEquals((Object)"x,y,z", (Object)StringUtils.join((Object[])new Object[]{"x,y", "z"}, (char)','));
        Assert.assertNull((Object)StringUtils.joine((Object[])null, (char)','));
        Assert.assertEquals((Object)"x\\,y,z", (Object)StringUtils.joine((Object[])new Object[]{"x,y", "z"}, (char)','));
        Assert.assertNull((Object)StringUtils.join((int[])null, (char)','));
        Assert.assertEquals((Object)"1", (Object)StringUtils.join((int[])new int[]{1}, (char)','));
        Assert.assertEquals((Object)"1,2", (Object)StringUtils.join((int[])new int[]{1, 2}, (char)','));
        Assert.assertNull((Object)StringUtils.join((Collection)null, (char)','));
        Assert.assertEquals((Object)"1", (Object)StringUtils.join(Arrays.asList(1), (char)','));
        Assert.assertEquals((Object)"1,2", (Object)StringUtils.join(Arrays.asList(1, 2), (char)','));
        Assert.assertNull((Object)StringUtils.joine((Collection)null, (char)','));
        Assert.assertEquals((Object)"x\\,y,z", (Object)StringUtils.joine(Arrays.asList("x,y", "z"), (char)','));
    }

    @Test
    public void testSplit() throws Exception {
        Assert.assertNull((Object)StringUtils.split((String)null));
        TestUtils.assertObjectEquals("[]", StringUtils.split((String)""));
        TestUtils.assertObjectEquals("['1']", StringUtils.split((String)"1"));
        TestUtils.assertObjectEquals("['1','2']", StringUtils.split((String)"1,2"));
        TestUtils.assertObjectEquals("['1,2']", StringUtils.split((String)"1\\,2"));
        String[] r = StringUtils.split((String)"1\\\\,2");
        Assert.assertEquals((Object)"1\\", (Object)r[0]);
        Assert.assertEquals((Object)"2", (Object)r[1]);
        r = StringUtils.split((String)"1\\\\\\,2");
        Assert.assertEquals((long)1L, (long)r.length);
        Assert.assertEquals((Object)"1\\,2", (Object)r[0]);
        r = StringUtils.split((String)"1,2\\");
        Assert.assertEquals((Object)"2\\", (Object)r[1]);
        r = StringUtils.split((String)"1,2\\\\");
        Assert.assertEquals((Object)"2\\", (Object)r[1]);
        r = StringUtils.split((String)"1,2\\,");
        Assert.assertEquals((Object)"2,", (Object)r[1]);
        r = StringUtils.split((String)"1,2\\\\,");
        Assert.assertEquals((Object)"2\\", (Object)r[1]);
        Assert.assertEquals((Object)"", (Object)r[2]);
    }

    @Test
    public void testSplitWithLimit() {
        String[] r = StringUtils.split((String)"boo:and:foo", (char)':', (int)10);
        TestUtils.assertObjectEquals("['boo','and','foo']", r);
        r = StringUtils.split((String)"boo:and:foo", (char)':', (int)2);
        TestUtils.assertObjectEquals("['boo','and:foo']", r);
        r = StringUtils.split((String)"boo:and:foo", (char)':', (int)1);
        TestUtils.assertObjectEquals("['boo:and:foo']", r);
        r = StringUtils.split((String)"boo:and:foo", (char)':', (int)0);
        TestUtils.assertObjectEquals("['boo:and:foo']", r);
        r = StringUtils.split((String)"boo:and:foo", (char)':', (int)-1);
        TestUtils.assertObjectEquals("['boo:and:foo']", r);
        r = StringUtils.split((String)"boo : and : foo", (char)':', (int)10);
        TestUtils.assertObjectEquals("['boo','and','foo']", r);
        r = StringUtils.split((String)"boo : and : foo", (char)':', (int)2);
        TestUtils.assertObjectEquals("['boo','and : foo']", r);
    }

    @Test
    public void testNullIfEmpty() throws Exception {
        Assert.assertNull((Object)StringUtils.nullIfEmpty(null));
        Assert.assertNull((Object)StringUtils.nullIfEmpty((String)""));
        Assert.assertNotNull((Object)StringUtils.nullIfEmpty((String)"x"));
    }

    @Test
    public void testUnescapeChars() throws Exception {
        AsciiSet escape = AsciiSet.create((String)"\\,|");
        Assert.assertNull((Object)StringUtils.unEscapeChars(null, (AsciiSet)escape));
        Assert.assertEquals((Object)"xxx", (Object)StringUtils.unEscapeChars((String)"xxx", (AsciiSet)escape));
        Assert.assertEquals((Object)"xxx", (Object)StringUtils.unEscapeChars((String)"xxx", (AsciiSet)escape));
        Assert.assertEquals((Object)"x,xx", (Object)StringUtils.unEscapeChars((String)"x\\,xx", (AsciiSet)escape));
        Assert.assertEquals((Object)"x\\xx", (Object)StringUtils.unEscapeChars((String)"x\\xx", (AsciiSet)escape));
        Assert.assertEquals((Object)"x\\,xx", (Object)StringUtils.unEscapeChars((String)"x\\\\,xx", (AsciiSet)escape));
        Assert.assertEquals((Object)"x\\,xx", (Object)StringUtils.unEscapeChars((String)"x\\\\\\,xx", (AsciiSet)escape));
        Assert.assertEquals((Object)"\\", (Object)StringUtils.unEscapeChars((String)"\\", (AsciiSet)escape));
        Assert.assertEquals((Object)",", (Object)StringUtils.unEscapeChars((String)"\\,", (AsciiSet)escape));
        Assert.assertEquals((Object)"|", (Object)StringUtils.unEscapeChars((String)"\\|", (AsciiSet)escape));
        escape = AsciiSet.create((String)",|");
        Assert.assertEquals((Object)"x\\\\xx", (Object)StringUtils.unEscapeChars((String)"x\\\\xx", (AsciiSet)escape));
    }

    @Test
    public void testDecodeHex() throws Exception {
        Assert.assertNull((Object)StringUtils.decodeHex(null));
        Assert.assertEquals((Object)"19azAZ", (Object)StringUtils.decodeHex((String)"19azAZ"));
        Assert.assertEquals((Object)"[0][1][ffff]", (Object)StringUtils.decodeHex((String)"\u0000\u0001\uffff"));
    }

    @Test
    public void testStartsWith() throws Exception {
        Assert.assertFalse((boolean)StringUtils.startsWith(null, (char)'a'));
        Assert.assertFalse((boolean)StringUtils.startsWith((String)"", (char)'a'));
        Assert.assertTrue((boolean)StringUtils.startsWith((String)"a", (char)'a'));
        Assert.assertTrue((boolean)StringUtils.startsWith((String)"ab", (char)'a'));
    }

    @Test
    public void testEndsWith() throws Exception {
        Assert.assertFalse((boolean)StringUtils.endsWith(null, (char)'a'));
        Assert.assertFalse((boolean)StringUtils.endsWith((String)"", (char)'a'));
        Assert.assertTrue((boolean)StringUtils.endsWith((String)"a", (char)'a'));
        Assert.assertTrue((boolean)StringUtils.endsWith((String)"ba", (char)'a'));
    }

    @Test
    public void testBase64EncodeToString() throws Exception {
        String s = null;
        Assert.assertEquals(s, (Object)StringUtils.base64DecodeToString((String)StringUtils.base64EncodeToString(s)));
        s = "";
        Assert.assertEquals((Object)s, (Object)StringUtils.base64DecodeToString((String)StringUtils.base64EncodeToString((String)s)));
        s = "foobar";
        Assert.assertEquals((Object)s, (Object)StringUtils.base64DecodeToString((String)StringUtils.base64EncodeToString((String)s)));
        s = "\u0000\uffff";
        Assert.assertEquals((Object)s, (Object)StringUtils.base64DecodeToString((String)StringUtils.base64EncodeToString((String)s)));
        try {
            StringUtils.base64Decode((String)"a");
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Invalid BASE64 string length.  Must be multiple of 4.", (Object)e.getLocalizedMessage());
        }
        try {
            StringUtils.base64Decode((String)"aaa");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGenerateUUID() throws Exception {
        for (int i = 0; i < 10; ++i) {
            String s = StringUtils.generateUUID((int)i);
            Assert.assertEquals((long)i, (long)s.length());
            for (char c : s.toCharArray()) {
                Assert.assertTrue((Character.isLowerCase(c) || Character.isDigit(c) ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testTrim() throws Exception {
        Assert.assertNull((Object)StringUtils.trim(null));
        Assert.assertEquals((Object)"", (Object)StringUtils.trim((String)""));
        Assert.assertEquals((Object)"", (Object)StringUtils.trim((String)"  "));
    }

    @Test
    public void testParseISO8601Date() throws Exception {
        JsonSerializer s = JsonSerializer.create().ssq().build();
        Assert.assertNull((Object)StringUtils.parseIsoDate(null));
        Assert.assertNull((Object)StringUtils.parseIsoDate((String)""));
        TestUtils.setTimeZone("GMT");
        try {
            Assert.assertEquals((Object)"'2000-01-01T00:00:00'", (Object)s.serialize((Object)StringUtils.parseIsoDate((String)"2000")));
            Assert.assertEquals((Object)"'2000-02-01T00:00:00'", (Object)s.serialize((Object)StringUtils.parseIsoDate((String)"2000-02")));
            Assert.assertEquals((Object)"'2000-02-03T00:00:00'", (Object)s.serialize((Object)StringUtils.parseIsoDate((String)"2000-02-03")));
            Assert.assertEquals((Object)"'2000-02-03T04:00:00'", (Object)s.serialize((Object)StringUtils.parseIsoDate((String)"2000-02-03T04")));
            Assert.assertEquals((Object)"'2000-02-03T04:05:00'", (Object)s.serialize((Object)StringUtils.parseIsoDate((String)"2000-02-03T04:05")));
            Assert.assertEquals((Object)"'2000-02-03T04:05:06'", (Object)s.serialize((Object)StringUtils.parseIsoDate((String)"2000-02-03T04:05:06")));
            Assert.assertEquals((Object)"'2000-02-03T04:00:00'", (Object)s.serialize((Object)StringUtils.parseIsoDate((String)"2000-02-03 04")));
            Assert.assertEquals((Object)"'2000-02-03T04:05:00'", (Object)s.serialize((Object)StringUtils.parseIsoDate((String)"2000-02-03 04:05")));
            Assert.assertEquals((Object)"'2000-02-03T04:05:06'", (Object)s.serialize((Object)StringUtils.parseIsoDate((String)"2000-02-03 04:05:06")));
            Assert.assertEquals((Object)"'2000-02-03T04:05:06'", (Object)s.serialize((Object)StringUtils.parseIsoDate((String)"2000-02-03 04:05:06,789")));
        }
        finally {
            TestUtils.unsetTimeZone();
        }
    }

    @Test
    public void testPathStartsWith() throws Exception {
        Assert.assertTrue((boolean)StringUtils.pathStartsWith((String)"foo", (String)"foo"));
        Assert.assertTrue((boolean)StringUtils.pathStartsWith((String)"foo/bar", (String)"foo"));
        Assert.assertFalse((boolean)StringUtils.pathStartsWith((String)"foo2/bar", (String)"foo"));
        Assert.assertFalse((boolean)StringUtils.pathStartsWith((String)"foo2", (String)"foo"));
        Assert.assertFalse((boolean)StringUtils.pathStartsWith((String)"foo2", (String)""));
    }

    @Test
    public void testGetField() {
        String in = "0,1,2";
        Assert.assertEquals((Object)"0", (Object)StringUtils.getField((int)0, (String)in, (char)','));
        Assert.assertEquals((Object)"1", (Object)StringUtils.getField((int)1, (String)in, (char)','));
        Assert.assertEquals((Object)"2", (Object)StringUtils.getField((int)2, (String)in, (char)','));
        Assert.assertEquals((Object)"", (Object)StringUtils.getField((int)3, (String)in, (char)','));
        in = ",1,,3,";
        Assert.assertEquals((Object)"", (Object)StringUtils.getField((int)0, (String)in, (char)','));
        Assert.assertEquals((Object)"1", (Object)StringUtils.getField((int)1, (String)in, (char)','));
        Assert.assertEquals((Object)"", (Object)StringUtils.getField((int)2, (String)in, (char)','));
        Assert.assertEquals((Object)"3", (Object)StringUtils.getField((int)3, (String)in, (char)','));
        Assert.assertEquals((Object)"", (Object)StringUtils.getField((int)4, (String)in, (char)','));
        Assert.assertEquals((Object)"", (Object)StringUtils.getField((int)5, (String)in, (char)','));
        in = "";
        Assert.assertEquals((Object)"", (Object)StringUtils.getField((int)0, (String)in, (char)','));
        in = null;
        Assert.assertEquals((Object)"", (Object)StringUtils.getField((int)0, (String)in, (char)','));
    }

    @Test
    public void testSplitMap() {
        TestUtils.assertObjectEquals("{a:'1'}", StringUtils.splitMap((String)"a=1", (boolean)true));
        TestUtils.assertObjectEquals("{a:'1',b:'2'}", StringUtils.splitMap((String)"a=1,b=2", (boolean)true));
        TestUtils.assertObjectEquals("{a:'1',b:'2'}", StringUtils.splitMap((String)" a = 1 , b = 2 ", (boolean)true));
        TestUtils.assertObjectEquals("{' a ':' 1 ',' b ':' 2 '}", StringUtils.splitMap((String)" a = 1 , b = 2 ", (boolean)false));
        TestUtils.assertObjectEquals("{a:''}", StringUtils.splitMap((String)"a", (boolean)true));
        TestUtils.assertObjectEquals("{a:'',b:''}", StringUtils.splitMap((String)"a,b", (boolean)true));
        TestUtils.assertObjectEquals("{a:'1',b:''}", StringUtils.splitMap((String)"a=1,b", (boolean)true));
        TestUtils.assertObjectEquals("{a:'',b:'1'}", StringUtils.splitMap((String)"a,b=1", (boolean)true));
        TestUtils.assertObjectEquals("{'a=':'1'}", StringUtils.splitMap((String)"a\\==1", (boolean)true));
        TestUtils.assertObjectEquals("{'a\\\\':'1'}", StringUtils.splitMap((String)"a\\\\=1", (boolean)true));
    }

    @Test
    public void testIsAbsoluteUri() {
        Assert.assertFalse((boolean)StringUtils.isAbsoluteUri(null));
        Assert.assertFalse((boolean)StringUtils.isAbsoluteUri((String)""));
        Assert.assertTrue((boolean)StringUtils.isAbsoluteUri((String)"http://foo"));
        Assert.assertTrue((boolean)StringUtils.isAbsoluteUri((String)"x://x"));
        Assert.assertFalse((boolean)StringUtils.isAbsoluteUri((String)"xX://x"));
        Assert.assertFalse((boolean)StringUtils.isAbsoluteUri((String)"x ://x"));
        Assert.assertFalse((boolean)StringUtils.isAbsoluteUri((String)"x: //x"));
        Assert.assertFalse((boolean)StringUtils.isAbsoluteUri((String)"x:/ /x"));
        Assert.assertFalse((boolean)StringUtils.isAbsoluteUri((String)"x:x//x"));
        Assert.assertFalse((boolean)StringUtils.isAbsoluteUri((String)"x:/x/x"));
    }

    @Test
    public void testGetAuthorityUri() {
        Assert.assertEquals((Object)"http://foo", (Object)StringUtils.getAuthorityUri((String)"http://foo"));
        Assert.assertEquals((Object)"http://foo:123", (Object)StringUtils.getAuthorityUri((String)"http://foo:123"));
        Assert.assertEquals((Object)"http://foo:123", (Object)StringUtils.getAuthorityUri((String)"http://foo:123/"));
        Assert.assertEquals((Object)"http://foo:123", (Object)StringUtils.getAuthorityUri((String)"http://foo:123/bar"));
    }

    @Test
    public void getSplitQuoted() {
        TestUtils.assertObjectEquals("null", StringUtils.splitQuoted(null));
        TestUtils.assertObjectEquals("[]", StringUtils.splitQuoted((String)""));
        TestUtils.assertObjectEquals("[]", StringUtils.splitQuoted((String)" \t "));
        TestUtils.assertObjectEquals("['foo']", StringUtils.splitQuoted((String)"foo"));
        TestUtils.assertObjectEquals("['foo','bar','baz']", StringUtils.splitQuoted((String)"foo  bar baz"));
        TestUtils.assertObjectEquals("['foo']", StringUtils.splitQuoted((String)"'foo'"));
        TestUtils.assertObjectEquals("[' foo ']", StringUtils.splitQuoted((String)" ' foo ' "));
        TestUtils.assertObjectEquals("['foo','bar']", StringUtils.splitQuoted((String)"'foo' 'bar'"));
        TestUtils.assertObjectEquals("['foo']", StringUtils.splitQuoted((String)"\"foo\""));
        TestUtils.assertObjectEquals("[' foo ']", StringUtils.splitQuoted((String)" \" foo \" "));
        TestUtils.assertObjectEquals("['foo','bar']", StringUtils.splitQuoted((String)"\"foo\" \"bar\""));
        TestUtils.assertObjectEquals("['foo\\'bar']", StringUtils.splitQuoted((String)"'foo\\'bar'"));
        TestUtils.assertObjectEquals("['foo\"bar']", StringUtils.splitQuoted((String)"'foo\\\"bar'"));
        TestUtils.assertObjectEquals("['\\'foo\\'bar\\'']", StringUtils.splitQuoted((String)"'\\'foo\\'bar\\''"));
        TestUtils.assertObjectEquals("['\"foo\"bar\"']", StringUtils.splitQuoted((String)"'\\\"foo\\\"bar\\\"'"));
        TestUtils.assertObjectEquals("['\\'foo\\'']", StringUtils.splitQuoted((String)"'\\'foo\\''"));
        TestUtils.assertObjectEquals("['\"foo\"']", StringUtils.splitQuoted((String)"\"\\\"foo\\\"\""));
        TestUtils.assertObjectEquals("['\"foo\"']", StringUtils.splitQuoted((String)"'\"foo\"'"));
        TestUtils.assertObjectEquals("['\\'foo\\'']", StringUtils.splitQuoted((String)"\"'foo'\""));
    }

    @Test
    public void testFirstNonWhitespaceChar() {
        Assert.assertEquals((long)102L, (long)StringUtils.firstNonWhitespaceChar((String)"foo"));
        Assert.assertEquals((long)102L, (long)StringUtils.firstNonWhitespaceChar((String)" foo"));
        Assert.assertEquals((long)102L, (long)StringUtils.firstNonWhitespaceChar((String)"\tfoo"));
        Assert.assertEquals((long)0L, (long)StringUtils.firstNonWhitespaceChar((String)""));
        Assert.assertEquals((long)0L, (long)StringUtils.firstNonWhitespaceChar((String)" "));
        Assert.assertEquals((long)0L, (long)StringUtils.firstNonWhitespaceChar((String)"\t"));
        Assert.assertEquals((long)0L, (long)StringUtils.firstNonWhitespaceChar(null));
    }

    @Test
    public void testLastNonWhitespaceChar() {
        Assert.assertEquals((long)114L, (long)StringUtils.lastNonWhitespaceChar((String)"bar"));
        Assert.assertEquals((long)114L, (long)StringUtils.lastNonWhitespaceChar((String)" bar "));
        Assert.assertEquals((long)114L, (long)StringUtils.lastNonWhitespaceChar((String)"\tbar\t"));
        Assert.assertEquals((long)0L, (long)StringUtils.lastNonWhitespaceChar((String)""));
        Assert.assertEquals((long)0L, (long)StringUtils.lastNonWhitespaceChar((String)" "));
        Assert.assertEquals((long)0L, (long)StringUtils.lastNonWhitespaceChar((String)"\t"));
        Assert.assertEquals((long)0L, (long)StringUtils.lastNonWhitespaceChar(null));
    }

    @Test
    public void testSplitEqually() {
        Assert.assertNull(null, (Object)StringUtils.splitEqually(null, (int)3));
        Assert.assertEquals((Object)"", (Object)StringUtils.join((Collection)StringUtils.splitEqually((String)"", (int)3), (char)'|'));
        Assert.assertEquals((Object)"a", (Object)StringUtils.join((Collection)StringUtils.splitEqually((String)"a", (int)3), (char)'|'));
        Assert.assertEquals((Object)"ab", (Object)StringUtils.join((Collection)StringUtils.splitEqually((String)"ab", (int)3), (char)'|'));
        Assert.assertEquals((Object)"abc", (Object)StringUtils.join((Collection)StringUtils.splitEqually((String)"abc", (int)3), (char)'|'));
        Assert.assertEquals((Object)"abc|d", (Object)StringUtils.join((Collection)StringUtils.splitEqually((String)"abcd", (int)3), (char)'|'));
    }

    @Test
    public void testIsObjectMap() {
        Assert.assertTrue((boolean)StringUtils.isObjectMap((Object)"{foo:'bar'}", (boolean)true));
        Assert.assertTrue((boolean)StringUtils.isObjectMap((Object)" { foo:'bar' } ", (boolean)true));
        Assert.assertFalse((boolean)StringUtils.isObjectMap((Object)" { foo:'bar'  ", (boolean)true));
        Assert.assertFalse((boolean)StringUtils.isObjectMap((Object)"  foo:'bar' } ", (boolean)true));
        Assert.assertTrue((boolean)StringUtils.isObjectMap((Object)"/*foo*/ { foo:'bar' } /*foo*/", (boolean)true));
    }

    @Test
    public void testIsObjectList() {
        Assert.assertTrue((boolean)StringUtils.isObjectList((Object)"[123,'bar']", (boolean)true));
        Assert.assertTrue((boolean)StringUtils.isObjectList((Object)" [ 123,'bar' ] ", (boolean)true));
        Assert.assertFalse((boolean)StringUtils.isObjectList((Object)" [ 123,'bar'  ", (boolean)true));
        Assert.assertFalse((boolean)StringUtils.isObjectList((Object)"  123,'bar' ] ", (boolean)true));
        Assert.assertTrue((boolean)StringUtils.isObjectList((Object)"/*foo*/ [ 123,'bar' ] /*foo*/", (boolean)true));
    }

    @Test
    public void testAddLineNumbers() {
        Assert.assertNull((Object)StringUtils.getNumberedLines(null));
        Assert.assertEquals((Object)"1: \n", (Object)StringUtils.getNumberedLines((String)""));
        Assert.assertEquals((Object)"1: foo\n", (Object)StringUtils.getNumberedLines((String)"foo"));
        Assert.assertEquals((Object)"1: foo\n2: bar\n", (Object)StringUtils.getNumberedLines((String)"foo\nbar"));
    }

    @Test
    public void testCompare() throws Exception {
        Assert.assertTrue((StringUtils.compare((String)"a", (String)"b") < 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringUtils.compare((String)"b", (String)"a") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringUtils.compare(null, (String)"b") < 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringUtils.compare((String)"b", null) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringUtils.compare(null, null) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetMatchPattern() throws Exception {
        Assert.assertTrue((boolean)StringUtils.getMatchPattern((String)"a").matcher("a").matches());
        Assert.assertTrue((boolean)StringUtils.getMatchPattern((String)"*a*").matcher("aaa").matches());
        Assert.assertFalse((boolean)StringUtils.getMatchPattern((String)"*b*").matcher("aaa").matches());
    }

    @Test
    public void testGetDuration() throws Exception {
        Assert.assertEquals((long)-1L, (long)StringUtils.getDuration(null));
        Assert.assertEquals((long)-1L, (long)StringUtils.getDuration((String)""));
        Assert.assertEquals((long)-1L, (long)StringUtils.getDuration((String)" "));
        Assert.assertEquals((long)1L, (long)StringUtils.getDuration((String)"1"));
        Assert.assertEquals((long)10L, (long)StringUtils.getDuration((String)"10"));
        Assert.assertEquals((long)10L, (long)StringUtils.getDuration((String)"10"));
        long s = 1000L;
        long m = s * 60L;
        long h = m * 60L;
        long d = h * 24L;
        long w = d * 7L;
        Assert.assertEquals((long)(10L * s), (long)StringUtils.getDuration((String)"10s"));
        Assert.assertEquals((long)(10L * s), (long)StringUtils.getDuration((String)"10 s"));
        Assert.assertEquals((long)(10L * s), (long)StringUtils.getDuration((String)"  10  s  "));
        Assert.assertEquals((long)(10L * s), (long)StringUtils.getDuration((String)"10sec"));
        Assert.assertEquals((long)(10L * s), (long)StringUtils.getDuration((String)"10 sec"));
        Assert.assertEquals((long)(10L * s), (long)StringUtils.getDuration((String)"  10  sec  "));
        Assert.assertEquals((long)(10L * s), (long)StringUtils.getDuration((String)"10seconds"));
        Assert.assertEquals((long)(10L * s), (long)StringUtils.getDuration((String)"10 seconds"));
        Assert.assertEquals((long)(10L * s), (long)StringUtils.getDuration((String)"  10  seconds  "));
        Assert.assertEquals((long)(10L * s), (long)StringUtils.getDuration((String)"10S"));
        Assert.assertEquals((long)(10L * s), (long)StringUtils.getDuration((String)"10 S"));
        Assert.assertEquals((long)(10L * s), (long)StringUtils.getDuration((String)"  10  S  "));
        Assert.assertEquals((long)(10L * m), (long)StringUtils.getDuration((String)"10m"));
        Assert.assertEquals((long)(10L * m), (long)StringUtils.getDuration((String)"10 m"));
        Assert.assertEquals((long)(10L * m), (long)StringUtils.getDuration((String)"  10  m  "));
        Assert.assertEquals((long)(10L * m), (long)StringUtils.getDuration((String)"10min"));
        Assert.assertEquals((long)(10L * m), (long)StringUtils.getDuration((String)"10 min"));
        Assert.assertEquals((long)(10L * m), (long)StringUtils.getDuration((String)"  10  min  "));
        Assert.assertEquals((long)(10L * m), (long)StringUtils.getDuration((String)"10minutes"));
        Assert.assertEquals((long)(10L * m), (long)StringUtils.getDuration((String)"10 minutes"));
        Assert.assertEquals((long)(10L * m), (long)StringUtils.getDuration((String)"  10  minutes  "));
        Assert.assertEquals((long)(10L * m), (long)StringUtils.getDuration((String)"10M"));
        Assert.assertEquals((long)(10L * m), (long)StringUtils.getDuration((String)"10 M"));
        Assert.assertEquals((long)(10L * m), (long)StringUtils.getDuration((String)"  10  M  "));
        Assert.assertEquals((long)(10L * h), (long)StringUtils.getDuration((String)"10h"));
        Assert.assertEquals((long)(10L * h), (long)StringUtils.getDuration((String)"10 h"));
        Assert.assertEquals((long)(10L * h), (long)StringUtils.getDuration((String)"  10  h  "));
        Assert.assertEquals((long)(10L * h), (long)StringUtils.getDuration((String)"10hour"));
        Assert.assertEquals((long)(10L * h), (long)StringUtils.getDuration((String)"10 hour"));
        Assert.assertEquals((long)(10L * h), (long)StringUtils.getDuration((String)"  10  hour  "));
        Assert.assertEquals((long)(10L * h), (long)StringUtils.getDuration((String)"10hours"));
        Assert.assertEquals((long)(10L * h), (long)StringUtils.getDuration((String)"10 hours"));
        Assert.assertEquals((long)(10L * h), (long)StringUtils.getDuration((String)"  10  hours  "));
        Assert.assertEquals((long)(10L * h), (long)StringUtils.getDuration((String)"10H"));
        Assert.assertEquals((long)(10L * h), (long)StringUtils.getDuration((String)"10 H"));
        Assert.assertEquals((long)(10L * h), (long)StringUtils.getDuration((String)"  10  H  "));
        Assert.assertEquals((long)(10L * d), (long)StringUtils.getDuration((String)"10d"));
        Assert.assertEquals((long)(10L * d), (long)StringUtils.getDuration((String)"10 d"));
        Assert.assertEquals((long)(10L * d), (long)StringUtils.getDuration((String)"  10  d  "));
        Assert.assertEquals((long)(10L * d), (long)StringUtils.getDuration((String)"10day"));
        Assert.assertEquals((long)(10L * d), (long)StringUtils.getDuration((String)"10 day"));
        Assert.assertEquals((long)(10L * d), (long)StringUtils.getDuration((String)"  10  day  "));
        Assert.assertEquals((long)(10L * d), (long)StringUtils.getDuration((String)"10days"));
        Assert.assertEquals((long)(10L * d), (long)StringUtils.getDuration((String)"10 days"));
        Assert.assertEquals((long)(10L * d), (long)StringUtils.getDuration((String)"  10  days  "));
        Assert.assertEquals((long)(10L * d), (long)StringUtils.getDuration((String)"10D"));
        Assert.assertEquals((long)(10L * d), (long)StringUtils.getDuration((String)"10 D"));
        Assert.assertEquals((long)(10L * d), (long)StringUtils.getDuration((String)"  10  D  "));
        Assert.assertEquals((long)(10L * w), (long)StringUtils.getDuration((String)"10w"));
        Assert.assertEquals((long)(10L * w), (long)StringUtils.getDuration((String)"10 w"));
        Assert.assertEquals((long)(10L * w), (long)StringUtils.getDuration((String)"  10  w  "));
        Assert.assertEquals((long)(10L * w), (long)StringUtils.getDuration((String)"10week"));
        Assert.assertEquals((long)(10L * w), (long)StringUtils.getDuration((String)"10 week"));
        Assert.assertEquals((long)(10L * w), (long)StringUtils.getDuration((String)"  10  week  "));
        Assert.assertEquals((long)(10L * w), (long)StringUtils.getDuration((String)"10weeks"));
        Assert.assertEquals((long)(10L * w), (long)StringUtils.getDuration((String)"10 weeks"));
        Assert.assertEquals((long)(10L * w), (long)StringUtils.getDuration((String)"  10  weeks  "));
        Assert.assertEquals((long)(10L * w), (long)StringUtils.getDuration((String)"10W"));
        Assert.assertEquals((long)(10L * w), (long)StringUtils.getDuration((String)"10 W"));
        Assert.assertEquals((long)(10L * w), (long)StringUtils.getDuration((String)"  10  W  "));
    }

    @Test
    public void testStripInvalidHttpHeaderChars() throws Exception {
        Assert.assertEquals((Object)"xxx", (Object)StringUtils.stripInvalidHttpHeaderChars((String)"xxx"));
        Assert.assertEquals((Object)"\t []^x", (Object)StringUtils.stripInvalidHttpHeaderChars((String)"\u0000\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\t\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019 \\[]^x"));
    }

    @Test
    public void testAbbrevate() throws Exception {
        Assert.assertNull((String)"xxx", (Object)StringUtils.abbreviate(null, (int)0));
        Assert.assertEquals((Object)"foo", (Object)StringUtils.abbreviate((String)"foo", (int)3));
        Assert.assertEquals((Object)"...", (Object)StringUtils.abbreviate((String)"fooo", (int)3));
        Assert.assertEquals((Object)"f...", (Object)StringUtils.abbreviate((String)"foooo", (int)4));
        Assert.assertEquals((Object)"foo", (Object)StringUtils.abbreviate((String)"foo", (int)2));
    }

    private static abstract class BadNumber
    extends Number {
        private BadNumber() {
        }
    }
}

