/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.utils;

import org.apache.juneau.internal.StringBuilderWriter;
import org.junit.Assert;
import org.junit.Test;

public class StringBuilderWriterTest {
    @Test
    public void test() throws Exception {
        StringBuilderWriter sbw = new StringBuilderWriter();
        sbw.write("abc");
        Assert.assertEquals((Object)"abc", (Object)sbw.toString());
        sbw.append((CharSequence)"abc");
        Assert.assertEquals((Object)"abcabc", (Object)sbw.toString());
        sbw.write("abc", 1, 1);
        Assert.assertEquals((Object)"abcabcb", (Object)sbw.toString());
        sbw.append((CharSequence)"abc", 1, 2);
        Assert.assertEquals((Object)"abcabcbb", (Object)sbw.toString());
        sbw.write((String)null);
        Assert.assertEquals((Object)"abcabcbbnull", (Object)sbw.toString());
        sbw.append((CharSequence)null);
        Assert.assertEquals((Object)"abcabcbbnullnull", (Object)sbw.toString());
        sbw.append((CharSequence)null, 0, 4);
        Assert.assertEquals((Object)"abcabcbbnullnullnull", (Object)sbw.toString());
        char[] buff = "abc".toCharArray();
        sbw = new StringBuilderWriter();
        sbw.write(buff, 0, buff.length);
        Assert.assertEquals((Object)"abc", (Object)sbw.toString());
        sbw.write(buff, 0, 0);
        Assert.assertEquals((Object)"abc", (Object)sbw.toString());
        try {
            sbw.write(buff, -1, buff.length);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sbw.write(buff, buff.length + 1, 0);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sbw.write(buff, buff.length - 1, 2);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sbw.write(buff, 0, buff.length + 1);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sbw.write(buff, 0, -1);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        sbw.flush();
        sbw.close();
    }
}

