/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.utils;

import java.util.List;
import org.apache.juneau.testutils.TestUtils;
import org.apache.juneau.utils.StackTraceDatabase;
import org.apache.juneau.utils.StackTraceInfo;
import org.junit.Assert;
import org.junit.Test;

public class StackTraceDatabaseTest {
    @Test
    public void testBasic() {
        Throwable t1 = new Throwable();
        t1.fillInStackTrace();
        Throwable t2 = new Throwable();
        t2.fillInStackTrace();
        StackTraceDatabase db = new StackTraceDatabase();
        db.add(t1);
        StackTraceInfo t1a = db.getStackTraceInfo(t1);
        db.add(t1);
        StackTraceInfo t1b = db.getStackTraceInfo(t1);
        db.add(t2);
        StackTraceInfo t2a = db.getStackTraceInfo(t2);
        Assert.assertEquals((Object)t1a.getHash(), (Object)t1b.getHash());
        Assert.assertNotEquals((Object)t1a.getHash(), (Object)t2a.getHash());
        Assert.assertEquals((long)1L, (long)t1a.getCount());
        Assert.assertEquals((long)2L, (long)t1b.getCount());
        Assert.assertEquals((long)1L, (long)t2a.getCount());
    }

    @Test
    public void testGetClonedStackTraceInfos() {
        Throwable t1 = new Throwable();
        t1.fillInStackTrace();
        Throwable t2 = new Throwable();
        t2.fillInStackTrace();
        StackTraceDatabase db = new StackTraceDatabase();
        db.add(t1);
        db.add(t1);
        db.add(t2);
        List l = db.getClonedStackTraceInfos();
        db.add(t1);
        TestUtils.assertObjectMatches("[{exception:'Throwable',hash:'*',count:2},{exception:'Throwable',hash:'*',count:1}]", l);
    }

    @Test
    public void testTimeout() {
        Throwable t1 = new Throwable();
        t1.fillInStackTrace();
        Throwable t2 = new Throwable();
        t2.fillInStackTrace();
        StackTraceDatabase db = new StackTraceDatabase(-2L, null);
        db.add(t1);
        StackTraceInfo t1a = db.getStackTraceInfo(t1);
        db.add(t1);
        StackTraceInfo t1b = db.getStackTraceInfo(t1);
        db.add(t2);
        StackTraceInfo t2a = db.getStackTraceInfo(t2);
        Assert.assertEquals((Object)t1a.getHash(), (Object)t1b.getHash());
        Assert.assertNotEquals((Object)t1a.getHash(), (Object)t2a.getHash());
        Assert.assertEquals((long)0L, (long)t1a.getCount());
        Assert.assertEquals((long)0L, (long)t1b.getCount());
        Assert.assertEquals((long)0L, (long)t2a.getCount());
    }

    @Test
    public void testReset() {
        Throwable t1 = new Throwable();
        t1.fillInStackTrace();
        StackTraceDatabase db = new StackTraceDatabase();
        db.add(t1);
        StackTraceInfo t1a = db.getStackTraceInfo(t1);
        Assert.assertEquals((long)1L, (long)t1a.getCount());
        db.reset();
        t1a = db.getStackTraceInfo(t1);
        Assert.assertEquals((long)0L, (long)t1a.getCount());
    }

    @Test
    public void testNullException() {
        StackTraceDatabase db = new StackTraceDatabase();
        db.add(null).add(null);
        StackTraceInfo t1a = db.getStackTraceInfo(null);
        Assert.assertEquals((long)2L, (long)t1a.getCount());
    }

    @Test
    public void testSameStackTraces() {
        StackTraceDatabase db = new StackTraceDatabase();
        Throwable t1 = new Throwable(){

            @Override
            public StackTraceElement[] getStackTrace() {
                return new StackTraceElement[]{new StackTraceElement("Foo", "bar", "Foo.class", 1), new StackTraceElement("Foo", "baz", "Foo.class", 2), new StackTraceElement("Stop", "baz", "Stop.class", 3), new StackTraceElement("Object", "baz", "Object.class", 6)};
            }
        };
        Throwable t2 = new Throwable(){

            @Override
            public StackTraceElement[] getStackTrace() {
                return new StackTraceElement[]{new StackTraceElement("Foo", "bar", "Foo.class", 1), new StackTraceElement("Foo", "baz", "Foo.class", 2), new StackTraceElement("Stop", "baz", "Stop.class", 3), new StackTraceElement("Object", "baz", "Object.class", 6)};
            }
        };
        StackTraceInfo sti1 = db.getStackTraceInfo(t1);
        StackTraceInfo sti2 = db.getStackTraceInfo(t2);
        Assert.assertEquals((Object)sti1.getHash(), (Object)sti2.getHash());
    }

    @Test
    public void testSlightlyDifferentStackTraces() {
        StackTraceDatabase db = new StackTraceDatabase();
        Throwable t1 = new Throwable(){

            @Override
            public StackTraceElement[] getStackTrace() {
                return new StackTraceElement[]{new StackTraceElement("Foo", "bar", "Foo.class", 1), new StackTraceElement("Foo", "baz", "Foo.class", 2), new StackTraceElement("Stop", "baz", "Stop.class", 3), new StackTraceElement("Object", "baz", "Object.class", 6)};
            }
        };
        Throwable t2 = new Throwable(){

            @Override
            public StackTraceElement[] getStackTrace() {
                return new StackTraceElement[]{new StackTraceElement("Foo", "bar", "Foo.class", 1), new StackTraceElement("Foo", "baz", "Foo.class", 2), new StackTraceElement("Stop", "baz", "Stop.class", 3), new StackTraceElement("Object", "baz", "Object.class", 7)};
            }
        };
        StackTraceInfo sti1 = db.getStackTraceInfo(t1);
        StackTraceInfo sti2 = db.getStackTraceInfo(t2);
        Assert.assertNotEquals((Object)sti1.getHash(), (Object)sti2.getHash());
    }

    @Test
    public void testStopClass() {
        StackTraceDatabase db = new StackTraceDatabase(-1L, StopClass.class);
        Throwable t1 = new Throwable(){

            @Override
            public StackTraceElement[] getStackTrace() {
                return new StackTraceElement[]{new StackTraceElement("Foo", "bar", "Foo.class", 1), new StackTraceElement("Foo", "baz", "Foo.class", 2), new StackTraceElement(StopClass.class.getName(), "baz", "Stop.class", 3), new StackTraceElement("Object", "baz", "Object.class", 6)};
            }
        };
        Throwable t2 = new Throwable(){

            @Override
            public StackTraceElement[] getStackTrace() {
                return new StackTraceElement[]{new StackTraceElement("Foo", "bar", "Foo.class", 1), new StackTraceElement("Foo", "baz", "Foo.class", 2), new StackTraceElement(StopClass.class.getName(), "baz", "Stop.class", 4), new StackTraceElement("Object", "baz", "Object.class", 7)};
            }
        };
        StackTraceInfo sti1 = db.getStackTraceInfo(t1);
        StackTraceInfo sti2 = db.getStackTraceInfo(t2);
        Assert.assertEquals((Object)sti1.getHash(), (Object)sti2.getHash());
    }

    @Test
    public void testProxyElements() {
        StackTraceDatabase db = new StackTraceDatabase();
        Throwable t1 = new Throwable(){

            @Override
            public StackTraceElement[] getStackTrace() {
                return new StackTraceElement[]{new StackTraceElement("Foo", "bar", "Foo.class", 1), new StackTraceElement("Foo", "baz", "Foo.class", 2), new StackTraceElement("Stop$1", "baz", "Stop.class", 5), new StackTraceElement("Object", "baz", "Object.class", 6)};
            }
        };
        Throwable t2 = new Throwable(){

            @Override
            public StackTraceElement[] getStackTrace() {
                return new StackTraceElement[]{new StackTraceElement("Foo", "bar", "Foo.class", 1), new StackTraceElement("Foo", "baz", "Foo.class", 2), new StackTraceElement("Stop$2", "baz", "Stop.class", 6), new StackTraceElement("Object", "baz", "Object.class", 6)};
            }
        };
        StackTraceInfo sti1 = db.getStackTraceInfo(t1);
        StackTraceInfo sti2 = db.getStackTraceInfo(t2);
        Assert.assertEquals((Object)sti1.getHash(), (Object)sti2.getHash());
    }

    private static final class StopClass {
        private StopClass() {
        }
    }
}

