/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.utils;

import java.util.Map;
import org.apache.juneau.internal.SimpleMap;
import org.apache.juneau.testutils.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class SimpleMapTest {
    @Test
    public void doTest() throws Exception {
        Object[] keys = new String[]{"a", "b"};
        Object[] vals = new Object[]{"A", "B"};
        SimpleMap m = new SimpleMap(keys, vals);
        Assert.assertEquals((long)2L, (long)m.size());
        Assert.assertEquals((Object)"A", (Object)m.get((Object)"a"));
        Assert.assertEquals((Object)"B", (Object)m.get((Object)"b"));
        TestUtils.assertObjectEquals("{a:'A',b:'B'}", m);
        TestUtils.assertObjectEquals("['a','b']", m.keySet());
        m.put((Object)"a", (Object)"1");
        TestUtils.assertObjectEquals("{a:'1',b:'B'}", m);
        ((Map.Entry)m.entrySet().iterator().next()).setValue("2");
        TestUtils.assertObjectEquals("{a:'2',b:'B'}", m);
        try {
            m.put((Object)"c", (Object)"1");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertNull((Object)m.get((Object)"c"));
        try {
            m = new SimpleMap(null, vals);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            m = new SimpleMap(keys, null);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            m = new SimpleMap(keys, new Object[0]);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        keys[0] = null;
        try {
            m = new SimpleMap(keys, vals);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

