/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.juneau.testutils.TestUtils;
import org.apache.juneau.utils.ReflectionMap;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class ReflectionMapTest {
    static ReflectionMap<Number> A1_SIMPLE = ReflectionMapTest.create().append("A1", (Object)1).build();
    static ReflectionMap<Number> A1b_SIMPLE = ReflectionMapTest.create().append("ReflectionMapTest$A1", (Object)1).build();
    static ReflectionMap<Number> A1_FULL = ReflectionMapTest.create().append("org.apache.juneau.utils.ReflectionMapTest$A1", (Object)1).build();
    static ReflectionMap<Number> B1m1_SIMPLE = ReflectionMapTest.create().append("B1.m1", (Object)1).build();
    static ReflectionMap<Number> B1m1i_SIMPLE = ReflectionMapTest.create().append("B1.m1(int)", (Object)1).build();
    static ReflectionMap<Number> B1m1s_SIMPLE = ReflectionMapTest.create().append("B1.m1(String)", (Object)1).build();
    static ReflectionMap<Number> B1m1ss_SIMPLE = ReflectionMapTest.create().append("B1.m1(java.lang.String)", (Object)1).build();
    static ReflectionMap<Number> B1m1si_SIMPLE = ReflectionMapTest.create().append("B1.m1(String,int)", (Object)1).build();
    static ReflectionMap<Number> B1m1ssi_SIMPLE = ReflectionMapTest.create().append("B1.m1(java.lang.String , int)", (Object)1).build();
    static ReflectionMap<Number> B1m1_FULL = ReflectionMapTest.create().append("org.apache.juneau.utils.ReflectionMapTest$B1.m1", (Object)1).build();
    static ReflectionMap<Number> B1m1i_FULL = ReflectionMapTest.create().append("org.apache.juneau.utils.ReflectionMapTest$B1.m1(int)", (Object)1).build();
    static ReflectionMap<Number> B1m1s_FULL = ReflectionMapTest.create().append("org.apache.juneau.utils.ReflectionMapTest$B1.m1(String)", (Object)1).build();
    static ReflectionMap<Number> B1m1ss_FULL = ReflectionMapTest.create().append("org.apache.juneau.utils.ReflectionMapTest$B1.m1(java.lang.String)", (Object)1).build();
    static ReflectionMap<Number> B1m1si_FULL = ReflectionMapTest.create().append("org.apache.juneau.utils.ReflectionMapTest$B1.m1(String,int)", (Object)1).build();
    static ReflectionMap<Number> B1m1ssi_FULL = ReflectionMapTest.create().append("org.apache.juneau.utils.ReflectionMapTest$B1.m1(java.lang.String , int)", (Object)1).build();
    static ReflectionMap<Number> C1f1_SIMPLE = ReflectionMapTest.create().append("C1.f1", (Object)1).build();
    static ReflectionMap<Number> C1f1_FULL = ReflectionMapTest.create().append("org.apache.juneau.utils.ReflectionMapTest$C1.f1", (Object)1).build();
    static ReflectionMap<Number> D_SIMPLE = ReflectionMapTest.create().append("D1()", (Object)1).build();
    static ReflectionMap<Number> Di_SIMPLE = ReflectionMapTest.create().append("D1(int)", (Object)1).build();
    static ReflectionMap<Number> Ds_SIMPLE = ReflectionMapTest.create().append("D1(String)", (Object)1).build();
    static ReflectionMap<Number> Dss_SIMPLE = ReflectionMapTest.create().append("D1(java.lang.String)", (Object)1).build();
    static ReflectionMap<Number> Dsi_SIMPLE = ReflectionMapTest.create().append("D1(String, int)", (Object)1).build();
    static ReflectionMap<Number> Dssi_SIMPLE = ReflectionMapTest.create().append("D1(java.lang.String, int)", (Object)1).build();
    static ReflectionMap<Number> D_FULL = ReflectionMapTest.create().append("org.apache.juneau.utils.ReflectionMapTest$D1()", (Object)1).build();
    static ReflectionMap<Number> Di_FULL = ReflectionMapTest.create().append("org.apache.juneau.utils.ReflectionMapTest$D1(int)", (Object)1).build();
    static ReflectionMap<Number> Ds_FULL = ReflectionMapTest.create().append("org.apache.juneau.utils.ReflectionMapTest$D1(String)", (Object)1).build();
    static ReflectionMap<Number> Dss_FULL = ReflectionMapTest.create().append("org.apache.juneau.utils.ReflectionMapTest$D1(java.lang.String)", (Object)1).build();
    static ReflectionMap<Number> Dsi_FULL = ReflectionMapTest.create().append("org.apache.juneau.utils.ReflectionMapTest$D1(String, int)", (Object)1).build();
    static ReflectionMap<Number> Dssi_FULL = ReflectionMapTest.create().append("org.apache.juneau.utils.ReflectionMapTest$D1(java.lang.String, int)", (Object)1).build();
    static ReflectionMap<Number> RM_F = ReflectionMapTest.create().append("F2, F1", (Object)1).build();
    static ReflectionMap<Number> RM_G = ReflectionMapTest.create().build();

    private static ReflectionMap.Builder<Number> create() {
        return ReflectionMap.create(Number.class);
    }

    private void checkEntries(ReflectionMap<?> m, boolean hasClass, boolean hasMethods, boolean hasFields, boolean hasConstructors) {
        Assert.assertEquals((Object)m.noClassEntries, (Object)(!hasClass ? 1 : 0));
        Assert.assertEquals((Object)m.noMethodEntries, (Object)(!hasMethods ? 1 : 0));
        Assert.assertEquals((Object)m.noFieldEntries, (Object)(!hasFields ? 1 : 0));
        Assert.assertEquals((Object)m.noConstructorEntries, (Object)(!hasConstructors ? 1 : 0));
    }

    @Test
    public void a01_classNames_checkEntries() {
        this.checkEntries(A1_SIMPLE, true, false, false, false);
        this.checkEntries(A1_FULL, true, false, true, false);
    }

    private void checkA(Class<?> c, boolean match_A1_SIMPLE, boolean match_A1b_SIMPLE, boolean match_A1_FULL) {
        Assert.assertEquals((Object)match_A1_SIMPLE, (Object)A1_SIMPLE.find(c, null).isPresent());
        Assert.assertEquals((Object)match_A1b_SIMPLE, (Object)A1b_SIMPLE.find(c, null).isPresent());
        Assert.assertEquals((Object)match_A1_FULL, (Object)A1_FULL.find(c, null).isPresent());
        Assert.assertEquals((Object)match_A1_SIMPLE, (Object)A1_SIMPLE.find(c, Integer.class).isPresent());
        Assert.assertEquals((Object)match_A1b_SIMPLE, (Object)A1b_SIMPLE.find(c, Integer.class).isPresent());
        Assert.assertEquals((Object)match_A1_FULL, (Object)A1_FULL.find(c, Integer.class).isPresent());
        Assert.assertFalse((boolean)A1_SIMPLE.find(c, Long.class).isPresent());
        Assert.assertFalse((boolean)A1b_SIMPLE.find(c, Long.class).isPresent());
        Assert.assertFalse((boolean)A1_FULL.find(c, Long.class).isPresent());
    }

    @Test
    public void a02_classNames_find() {
        this.checkA(A1.class, true, true, true);
        this.checkA(A2.class, false, false, false);
        this.checkA(null, false, false, false);
    }

    @Test
    public void b01_methodNames_checkEntries() {
        this.checkEntries(B1m1_SIMPLE, false, true, true, false);
        this.checkEntries(B1m1i_SIMPLE, false, true, false, false);
        this.checkEntries(B1m1s_SIMPLE, false, true, false, false);
        this.checkEntries(B1m1ss_SIMPLE, false, true, false, false);
        this.checkEntries(B1m1si_SIMPLE, false, true, false, false);
        this.checkEntries(B1m1ssi_SIMPLE, false, true, false, false);
        this.checkEntries(B1m1_FULL, false, true, true, false);
        this.checkEntries(B1m1i_FULL, false, true, false, false);
        this.checkEntries(B1m1s_FULL, false, true, false, false);
        this.checkEntries(B1m1ss_FULL, false, true, false, false);
        this.checkEntries(B1m1si_FULL, false, true, false, false);
        this.checkEntries(B1m1ssi_FULL, false, true, false, false);
    }

    private void checkB(Method m, boolean match_B1m1_SIMPLE, boolean match_B1m1i_SIMPLE, boolean match_B1m1s_SIMPLE, boolean match_B1m1ss_SIMPLE, boolean match_B1m1si_SIMPLE, boolean match_B1m1ssi_SIMPLE, boolean match_B1m1_FULL, boolean match_B1m1i_FULL, boolean match_B1m1s_FULL, boolean match_B1m1ss_FULL, boolean match_B1m1si_FULL, boolean match_B1m1ssi_FULL) {
        Assert.assertEquals((Object)match_B1m1_SIMPLE, (Object)B1m1_SIMPLE.find(m, null).isPresent());
        Assert.assertEquals((Object)match_B1m1i_SIMPLE, (Object)B1m1i_SIMPLE.find(m, null).isPresent());
        Assert.assertEquals((Object)match_B1m1s_SIMPLE, (Object)B1m1s_SIMPLE.find(m, null).isPresent());
        Assert.assertEquals((Object)match_B1m1ss_SIMPLE, (Object)B1m1ss_SIMPLE.find(m, null).isPresent());
        Assert.assertEquals((Object)match_B1m1si_SIMPLE, (Object)B1m1si_SIMPLE.find(m, null).isPresent());
        Assert.assertEquals((Object)match_B1m1ssi_SIMPLE, (Object)B1m1ssi_SIMPLE.find(m, null).isPresent());
        Assert.assertEquals((Object)match_B1m1_FULL, (Object)B1m1_FULL.find(m, null).isPresent());
        Assert.assertEquals((Object)match_B1m1i_FULL, (Object)B1m1i_FULL.find(m, null).isPresent());
        Assert.assertEquals((Object)match_B1m1s_FULL, (Object)B1m1s_FULL.find(m, null).isPresent());
        Assert.assertEquals((Object)match_B1m1ss_FULL, (Object)B1m1ss_FULL.find(m, null).isPresent());
        Assert.assertEquals((Object)match_B1m1si_FULL, (Object)B1m1si_FULL.find(m, null).isPresent());
        Assert.assertEquals((Object)match_B1m1ssi_FULL, (Object)B1m1ssi_FULL.find(m, null).isPresent());
        Assert.assertEquals((Object)match_B1m1_SIMPLE, (Object)B1m1_SIMPLE.find(m, Integer.class).isPresent());
        Assert.assertEquals((Object)match_B1m1i_SIMPLE, (Object)B1m1i_SIMPLE.find(m, Integer.class).isPresent());
        Assert.assertEquals((Object)match_B1m1s_SIMPLE, (Object)B1m1s_SIMPLE.find(m, Integer.class).isPresent());
        Assert.assertEquals((Object)match_B1m1ss_SIMPLE, (Object)B1m1ss_SIMPLE.find(m, Integer.class).isPresent());
        Assert.assertEquals((Object)match_B1m1si_SIMPLE, (Object)B1m1si_SIMPLE.find(m, Integer.class).isPresent());
        Assert.assertEquals((Object)match_B1m1ssi_SIMPLE, (Object)B1m1ssi_SIMPLE.find(m, Integer.class).isPresent());
        Assert.assertEquals((Object)match_B1m1_FULL, (Object)B1m1_FULL.find(m, Integer.class).isPresent());
        Assert.assertEquals((Object)match_B1m1i_FULL, (Object)B1m1i_FULL.find(m, Integer.class).isPresent());
        Assert.assertEquals((Object)match_B1m1s_FULL, (Object)B1m1s_FULL.find(m, Integer.class).isPresent());
        Assert.assertEquals((Object)match_B1m1ss_FULL, (Object)B1m1ss_FULL.find(m, Integer.class).isPresent());
        Assert.assertEquals((Object)match_B1m1si_FULL, (Object)B1m1si_FULL.find(m, Integer.class).isPresent());
        Assert.assertEquals((Object)match_B1m1ssi_FULL, (Object)B1m1ssi_FULL.find(m, Integer.class).isPresent());
        Assert.assertFalse((boolean)B1m1_SIMPLE.find(m, Long.class).isPresent());
        Assert.assertFalse((boolean)B1m1i_SIMPLE.find(m, Long.class).isPresent());
        Assert.assertFalse((boolean)B1m1s_SIMPLE.find(m, Long.class).isPresent());
        Assert.assertFalse((boolean)B1m1ss_SIMPLE.find(m, Long.class).isPresent());
        Assert.assertFalse((boolean)B1m1si_SIMPLE.find(m, Long.class).isPresent());
        Assert.assertFalse((boolean)B1m1ssi_SIMPLE.find(m, Long.class).isPresent());
        Assert.assertFalse((boolean)B1m1_FULL.find(m, Long.class).isPresent());
        Assert.assertFalse((boolean)B1m1i_FULL.find(m, Long.class).isPresent());
        Assert.assertFalse((boolean)B1m1s_FULL.find(m, Long.class).isPresent());
        Assert.assertFalse((boolean)B1m1ss_FULL.find(m, Long.class).isPresent());
        Assert.assertFalse((boolean)B1m1si_FULL.find(m, Long.class).isPresent());
        Assert.assertFalse((boolean)B1m1ssi_FULL.find(m, Long.class).isPresent());
    }

    @Test
    public void b02_methodName_find() throws Exception {
        this.checkB(B1.class.getMethod("m1", new Class[0]), true, false, false, false, false, false, true, false, false, false, false, false);
        this.checkB(B1.class.getMethod("m1", Integer.TYPE), true, true, false, false, false, false, true, true, false, false, false, false);
        this.checkB(B1.class.getMethod("m1", String.class), true, false, true, true, false, false, true, false, true, true, false, false);
        this.checkB(B1.class.getMethod("m1", String.class, Integer.TYPE), true, false, false, false, true, true, true, false, false, false, true, true);
        this.checkB(B1.class.getMethod("m2", Integer.TYPE), false, false, false, false, false, false, false, false, false, false, false, false);
        this.checkB(B2.class.getMethod("m1", new Class[0]), false, false, false, false, false, false, false, false, false, false, false, false);
        this.checkB(null, false, false, false, false, false, false, false, false, false, false, false, false);
    }

    @Test
    public void c01_fieldNames_checkEntries() {
        this.checkEntries(C1f1_SIMPLE, false, true, true, false);
        this.checkEntries(C1f1_FULL, false, true, true, false);
    }

    private void checkC(Field f, boolean match_C1f1_SIMPLE, boolean match_C1f1_FULL) {
        Assert.assertEquals((Object)match_C1f1_SIMPLE, (Object)C1f1_SIMPLE.find(f, null).isPresent());
        Assert.assertEquals((Object)match_C1f1_FULL, (Object)C1f1_FULL.find(f, null).isPresent());
        Assert.assertEquals((Object)match_C1f1_SIMPLE, (Object)C1f1_SIMPLE.find(f, Integer.class).isPresent());
        Assert.assertEquals((Object)match_C1f1_FULL, (Object)C1f1_FULL.find(f, Integer.class).isPresent());
        Assert.assertFalse((boolean)C1f1_SIMPLE.find(f, Long.class).isPresent());
        Assert.assertFalse((boolean)C1f1_FULL.find(f, Long.class).isPresent());
    }

    @Test
    public void c02_fieldName_find() throws Exception {
        this.checkC(C1.class.getField("f1"), true, true);
        this.checkC(C1.class.getField("f2"), false, false);
        this.checkC(C2.class.getField("f1"), false, false);
        this.checkC(null, false, false);
    }

    @Test
    public void d01_constructorNames_checkEntries() {
        this.checkEntries(D_SIMPLE, false, false, false, true);
        this.checkEntries(Di_SIMPLE, false, false, false, true);
        this.checkEntries(Ds_SIMPLE, false, false, false, true);
        this.checkEntries(Dss_SIMPLE, false, false, false, true);
        this.checkEntries(Dsi_SIMPLE, false, false, false, true);
        this.checkEntries(Dssi_SIMPLE, false, false, false, true);
        this.checkEntries(D_FULL, false, false, false, true);
        this.checkEntries(Di_FULL, false, false, false, true);
        this.checkEntries(Ds_FULL, false, false, false, true);
        this.checkEntries(Dss_FULL, false, false, false, true);
        this.checkEntries(Dsi_FULL, false, false, false, true);
        this.checkEntries(Dssi_FULL, false, false, false, true);
    }

    private void checkD(Constructor<?> c, boolean match_D_SIMPLE, boolean match_Di_SIMPLE, boolean match_Ds_SIMPLE, boolean match_Dss_SIMPLE, boolean match_Dsi_SIMPLE, boolean match_Dssi_SIMPLE, boolean match_D_FULL, boolean match_Di_FULL, boolean match_Ds_FULL, boolean match_Dss_FULL, boolean match_Dsi_FULL, boolean match_Dssi_FULL) {
        Assert.assertEquals((Object)match_D_SIMPLE, (Object)D_SIMPLE.find(c, null).isPresent());
        Assert.assertEquals((Object)match_Di_SIMPLE, (Object)Di_SIMPLE.find(c, null).isPresent());
        Assert.assertEquals((Object)match_Ds_SIMPLE, (Object)Ds_SIMPLE.find(c, null).isPresent());
        Assert.assertEquals((Object)match_Dss_SIMPLE, (Object)Dss_SIMPLE.find(c, null).isPresent());
        Assert.assertEquals((Object)match_Dsi_SIMPLE, (Object)Dsi_SIMPLE.find(c, null).isPresent());
        Assert.assertEquals((Object)match_Dssi_SIMPLE, (Object)Dssi_SIMPLE.find(c, null).isPresent());
        Assert.assertEquals((Object)match_D_FULL, (Object)D_FULL.find(c, null).isPresent());
        Assert.assertEquals((Object)match_Di_FULL, (Object)Di_FULL.find(c, null).isPresent());
        Assert.assertEquals((Object)match_Ds_FULL, (Object)Ds_FULL.find(c, null).isPresent());
        Assert.assertEquals((Object)match_Dss_FULL, (Object)Dss_FULL.find(c, null).isPresent());
        Assert.assertEquals((Object)match_Dsi_FULL, (Object)Dsi_FULL.find(c, null).isPresent());
        Assert.assertEquals((Object)match_Dssi_FULL, (Object)Dssi_FULL.find(c, null).isPresent());
        Assert.assertEquals((Object)match_D_SIMPLE, (Object)D_SIMPLE.find(c, Integer.class).isPresent());
        Assert.assertEquals((Object)match_Di_SIMPLE, (Object)Di_SIMPLE.find(c, Integer.class).isPresent());
        Assert.assertEquals((Object)match_Ds_SIMPLE, (Object)Ds_SIMPLE.find(c, Integer.class).isPresent());
        Assert.assertEquals((Object)match_Dss_SIMPLE, (Object)Dss_SIMPLE.find(c, Integer.class).isPresent());
        Assert.assertEquals((Object)match_Dsi_SIMPLE, (Object)Dsi_SIMPLE.find(c, Integer.class).isPresent());
        Assert.assertEquals((Object)match_Dssi_SIMPLE, (Object)Dssi_SIMPLE.find(c, Integer.class).isPresent());
        Assert.assertEquals((Object)match_D_FULL, (Object)D_FULL.find(c, Integer.class).isPresent());
        Assert.assertEquals((Object)match_Di_FULL, (Object)Di_FULL.find(c, Integer.class).isPresent());
        Assert.assertEquals((Object)match_Ds_FULL, (Object)Ds_FULL.find(c, Integer.class).isPresent());
        Assert.assertEquals((Object)match_Dss_FULL, (Object)Dss_FULL.find(c, Integer.class).isPresent());
        Assert.assertEquals((Object)match_Dsi_FULL, (Object)Dsi_FULL.find(c, Integer.class).isPresent());
        Assert.assertEquals((Object)match_Dssi_FULL, (Object)Dssi_FULL.find(c, Integer.class).isPresent());
        Assert.assertFalse((boolean)D_SIMPLE.find(c, Long.class).isPresent());
        Assert.assertFalse((boolean)Di_SIMPLE.find(c, Long.class).isPresent());
        Assert.assertFalse((boolean)Ds_SIMPLE.find(c, Long.class).isPresent());
        Assert.assertFalse((boolean)Dss_SIMPLE.find(c, Long.class).isPresent());
        Assert.assertFalse((boolean)Dsi_SIMPLE.find(c, Long.class).isPresent());
        Assert.assertFalse((boolean)Dssi_SIMPLE.find(c, Long.class).isPresent());
        Assert.assertFalse((boolean)D_FULL.find(c, Long.class).isPresent());
        Assert.assertFalse((boolean)Di_FULL.find(c, Long.class).isPresent());
        Assert.assertFalse((boolean)Ds_FULL.find(c, Long.class).isPresent());
        Assert.assertFalse((boolean)Dss_FULL.find(c, Long.class).isPresent());
        Assert.assertFalse((boolean)Dsi_FULL.find(c, Long.class).isPresent());
        Assert.assertFalse((boolean)Dssi_FULL.find(c, Long.class).isPresent());
    }

    @Test
    public void d02_constructorName_find() throws Exception {
        this.checkD(D1.class.getConstructor(new Class[0]), true, false, false, false, false, false, true, false, false, false, false, false);
        this.checkD(D1.class.getConstructor(Integer.TYPE), false, true, false, false, false, false, false, true, false, false, false, false);
        this.checkD(D1.class.getConstructor(String.class), false, false, true, true, false, false, false, false, true, true, false, false);
        this.checkD(D1.class.getConstructor(String.class, Integer.TYPE), false, false, false, false, true, true, false, false, false, false, true, true);
        this.checkD(D2.class.getConstructor(new Class[0]), false, false, false, false, false, false, false, false, false, false, false, false);
        this.checkD(null, false, false, false, false, false, false, false, false, false, false, false, false);
    }

    @Test
    public void e01_blankInput() throws Exception {
        try {
            ReflectionMapTest.create().append("", (Object)1);
            Assert.fail();
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)"Invalid reflection signature: []", (Object)e.getMessage());
        }
    }

    @Test
    public void e02_nullInput() throws Exception {
        try {
            ReflectionMapTest.create().append(null, (Object)1);
            Assert.fail();
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)"Invalid reflection signature: [null]", (Object)e.getMessage());
        }
    }

    @Test
    public void e03_badInput() throws Exception {
        try {
            ReflectionMapTest.create().append("foo)", (Object)1);
            Assert.fail();
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)"Invalid reflection signature: [foo)]", (Object)e.getMessage());
        }
    }

    @Test
    public void f01_cdl() {
        TestUtils.assertObjectEquals("1", RM_F.find(F1.class, null));
    }

    @Test
    public void g01_emptyReflectionMap() throws Exception {
        Assert.assertFalse((boolean)RM_G.find(A1.class, null).isPresent());
        Assert.assertFalse((boolean)RM_G.find(B1.class.getMethod("m1", new Class[0]), null).isPresent());
        Assert.assertFalse((boolean)RM_G.find(C1.class.getField("f1"), null).isPresent());
        Assert.assertFalse((boolean)RM_G.find(D1.class.getConstructor(new Class[0]), null).isPresent());
    }

    @Test
    public void h01_splitNamesTest() throws Exception {
        TestUtils.assertObjectEquals("['foo']", ReflectionMap.splitNames((String)"foo"));
        TestUtils.assertObjectEquals("['foo']", ReflectionMap.splitNames((String)" foo "));
        TestUtils.assertObjectEquals("['foo','bar']", ReflectionMap.splitNames((String)"foo,bar"));
        TestUtils.assertObjectEquals("['foo','bar']", ReflectionMap.splitNames((String)" foo , bar "));
        TestUtils.assertObjectEquals("['foo()','bar()']", ReflectionMap.splitNames((String)"foo(),bar()"));
        TestUtils.assertObjectEquals("['foo()','bar()']", ReflectionMap.splitNames((String)" foo() , bar() "));
        TestUtils.assertObjectEquals("['foo(bar,baz)','bar(baz,qux)']", ReflectionMap.splitNames((String)"foo(bar,baz),bar(baz,qux)"));
        TestUtils.assertObjectEquals("['foo(bar,baz)','bar(baz,qux)']", ReflectionMap.splitNames((String)" foo(bar,baz) , bar(baz,qux) "));
    }

    static class F1 {
        F1() {
        }
    }

    static class D2 {
    }

    static class D1 {
        public D1() {
        }

        public D1(int x) {
        }

        public D1(String x) {
        }

        public D1(String x, int y) {
        }
    }

    static class C2 {
        public int f1;

        C2() {
        }
    }

    static class C1 {
        public int f1;
        public int f2;

        C1() {
        }
    }

    static class B2 {
        B2() {
        }

        public void m1() {
        }
    }

    static class B1 {
        B1() {
        }

        public void m1() {
        }

        public void m1(int x) {
        }

        public void m1(String x) {
        }

        public void m1(String x, int y) {
        }

        public void m2(int x) {
        }
    }

    static class A2 {
        A2() {
        }
    }

    static class A1 {
        A1() {
        }
    }
}

