/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.utils;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.juneau.InvalidDataConversionException;
import org.apache.juneau.ObjectList;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.json.SimpleJsonSerializer;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.ReaderParser;
import org.apache.juneau.utils.PojoRest;
import org.apache.juneau.utils.PojoRestException;
import org.junit.Assert;
import org.junit.Test;

public class PojoRestTest {
    @Test
    public void testBasic() {
        PojoRest model = new PojoRest((Object)new ObjectMap());
        model.put("A", (Object)new ObjectMap());
        model.put("A/B", (Object)new ObjectMap());
        model.put("A/B/C", (Object)"A new string");
        Assert.assertEquals((Object)"{A:{B:{C:'A new string'}}}", (Object)model.toString());
        model.put("A/B/C", new LinkedList());
        model.post("A/B/C", (Object)"String #1");
        model.post("A/B/C", (Object)"String #2");
        Assert.assertEquals((Object)"{A:{B:{C:['String #1','String #2']}}}", (Object)model.toString());
        String s = (String)model.get("A/B/C/0");
        Assert.assertEquals((Object)"String #1", (Object)s);
        Map m = (Map)model.get("A/B");
        Assert.assertEquals((Object)"{C:['String #1','String #2']}", (Object)m.toString());
    }

    @Test
    public void testBeans() throws Exception {
        PojoRest model = new PojoRest((Object)new ObjectMap());
        Person p = new Person("some name", 123, new Address("street A", "city A", "state A", 12345, true), new Address("street B", "city B", "state B", 12345, false));
        model.put("/person1", (Object)p);
        JsonSerializer serializer = JsonSerializer.create().ssq().addBeanTypes(false).addRootType().build();
        Assert.assertEquals((Object)"{person1:{name:'some name',age:123,addresses:[{street:'street A',city:'city A',state:'state A',zip:12345,isCurrent:true},{street:'street B',city:'city B',state:'state B',zip:12345,isCurrent:false}]}}", (Object)serializer.serialize(model.getRootObject()));
        p = (Person)model.get("/person1");
        Assert.assertEquals((Object)"city B", (Object)p.addresses[1].city);
        Address a3 = (Address)model.get("/person1/addresses/1");
        Assert.assertEquals((Object)"city B", (Object)a3.city);
        serializer = SimpleJsonSerializer.DEFAULT.builder().addBeanTypes().addRootType().build();
        p = new Person("some name", 123, new Address("street A", "city A", "state A", 12345, true), new Address("street B", "city B", "state B", 12345, false));
        String s = serializer.serialize((Object)p);
        String expectedValue = "{_type:'Person',name:'some name',age:123,addresses:[{street:'street A',city:'city A',state:'state A',zip:12345,isCurrent:true},{street:'street B',city:'city B',state:'state B',zip:12345,isCurrent:false}]}";
        Assert.assertEquals((Object)expectedValue, (Object)s);
        p = (Person)JsonParser.create().dictionary(new Class[]{Person.class}).build().parse(s, Object.class);
        expectedValue = "city B";
        s = p.addresses[1].city;
        Assert.assertEquals((Object)expectedValue, (Object)s);
        s = serializer.serialize((Object)p);
        expectedValue = "{_type:'Person',name:'some name',age:123,addresses:[{street:'street A',city:'city A',state:'state A',zip:12345,isCurrent:true},{street:'street B',city:'city B',state:'state B',zip:12345,isCurrent:false}]}";
        Assert.assertEquals((Object)expectedValue, (Object)s);
        model = new PojoRest((Object)p);
        model.post("addresses", (Object)new Address("street C", "city C", "state C", 12345, true));
        s = ((Address)model.get("addresses/2")).toString();
        expectedValue = "Address(street=street C,city=city C,state=state C,zip=12345,isCurrent=true)";
        Assert.assertEquals((Object)expectedValue, (Object)s);
        model.put("addresses/0", (Object)new Address("street D", "city D", "state D", 12345, false));
        model.put("addresses/1", (Object)new Address("street E", "city E", "state E", 12345, false));
        model.put("addresses/2", (Object)new Address("street F", "city F", "state F", 12345, false));
        serializer = JsonSerializer.create().ssq().build();
        s = serializer.serialize((Object)p);
        expectedValue = "{name:'some name',age:123,addresses:[{street:'street D',city:'city D',state:'state D',zip:12345,isCurrent:false},{street:'street E',city:'city E',state:'state E',zip:12345,isCurrent:false},{street:'street F',city:'city F',state:'state F',zip:12345,isCurrent:false}]}";
        Assert.assertEquals((Object)expectedValue, (Object)s);
        model.delete("addresses/1");
        s = serializer.serialize((Object)p);
        expectedValue = "{name:'some name',age:123,addresses:[{street:'street D',city:'city D',state:'state D',zip:12345,isCurrent:false},{street:'street F',city:'city F',state:'state F',zip:12345,isCurrent:false}]}";
        Assert.assertEquals((Object)expectedValue, (Object)s);
        model.delete("addresses/0");
        model.delete("addresses/0");
        s = serializer.serialize((Object)p);
        expectedValue = "{name:'some name',age:123,addresses:[]}";
        Assert.assertEquals((Object)expectedValue, (Object)s);
        model.put("addresses/2", (Object)new Address("street A", "city A", "state A", 12345, true));
        s = serializer.serialize((Object)p);
        expectedValue = "{name:'some name',age:123,addresses:[null,null,{street:'street A',city:'city A',state:'state A',zip:12345,isCurrent:true}]}";
        Assert.assertEquals((Object)expectedValue, (Object)s);
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("street", "street D");
        m.put("city", "city D");
        m.put("state", "state D");
        m.put("zip", new Integer(12345));
        model.put("addresses/1", m);
        s = ((Address)model.get("addresses/1")).toString();
        expectedValue = "Address(street=street D,city=city D,state=state D,zip=12345,isCurrent=false)";
        Assert.assertEquals((Object)expectedValue, (Object)s);
        model.put("addresses/1/zip", (Object)new Integer(99999));
        s = model.get("addresses/1/zip").toString();
        expectedValue = "99999";
        Assert.assertEquals((Object)expectedValue, (Object)s);
        model = new PojoRest((Object)new ObjectMap());
        Object o = model.get("xxx");
        Assert.assertEquals((Object)"null", (Object)("" + o));
        s = model.get("").toString();
        Assert.assertEquals((Object)"{}", (Object)s);
        s = model.get("/").toString();
        Assert.assertEquals((Object)"{}", (Object)s);
        ObjectMap m2 = new ObjectMap((CharSequence)"{x:1}");
        model.put("", (Object)m2);
        s = model.get("").toString();
        Assert.assertEquals((Object)"{x:1}", (Object)s);
        m2 = new ObjectMap((CharSequence)"{x:2}");
        model.put("/", (Object)m2);
        s = model.get("").toString();
        Assert.assertEquals((Object)"{x:2}", (Object)s);
        model = new PojoRest((Object)new ObjectList());
        model.post("", (Object)new Integer(1));
        model.post("/", (Object)new Integer(2));
        s = model.get("").toString();
        Assert.assertEquals((Object)"[1,2]", (Object)s);
    }

    @Test
    public void testAddressBook() {
        PojoRest model = new PojoRest((Object)new AddressBook());
        Person billClinton = new Person("Bill Clinton", 65, new Address("55W. 125th Street", "New York", "NY", 10027, true));
        model.post("/", (Object)billClinton);
        billClinton = (Person)model.get("/0");
    }

    @Test
    public void testConstructors() throws Exception {
        PojoRest model = new PojoRest((Object)new AddressBook(), (ReaderParser)JsonParser.DEFAULT);
        Person billClinton = new Person("Bill Clinton", 65, new Address("55W. 125th Street", "New York", "NY", 10027, true));
        model.post("/", (Object)billClinton);
        billClinton = (Person)model.get("/0");
    }

    @Test
    public void testRootLocked() throws Exception {
        PojoRest model = new PojoRest((Object)new AddressBook()).setRootLocked();
        try {
            model.put("", (Object)new AddressBook());
            Assert.fail();
        }
        catch (PojoRestException e) {
            Assert.assertEquals((Object)"Cannot overwrite root object", (Object)e.getLocalizedMessage());
        }
        try {
            model.put(null, (Object)new AddressBook());
            Assert.fail();
        }
        catch (PojoRestException e) {
            Assert.assertEquals((Object)"Cannot overwrite root object", (Object)e.getLocalizedMessage());
        }
        try {
            model.put("/", (Object)new AddressBook());
            Assert.fail();
        }
        catch (PojoRestException e) {
            Assert.assertEquals((Object)"Cannot overwrite root object", (Object)e.getLocalizedMessage());
        }
    }

    @Test
    public void testGetRootObject() throws Exception {
        PojoRest model = new PojoRest((Object)new AddressBook());
        Assert.assertTrue((boolean)(model.getRootObject() instanceof AddressBook));
        model.put("", (Object)"foobar");
        Assert.assertTrue((boolean)(model.getRootObject() instanceof String));
        model.put("", null);
        Assert.assertNull((Object)model.getRootObject());
    }

    @Test
    public void testGetMethods() throws Exception {
        PojoRest model = new PojoRest((Object)new A());
        ObjectList l = new ObjectList((CharSequence)"[{a:'b'}]");
        ObjectMap m = new ObjectMap((CharSequence)"{a:'b'}");
        Assert.assertNull((Object)model.get("f1"));
        Assert.assertEquals((Object)0, (Object)model.get("f2"));
        Assert.assertEquals((Object)0L, (Object)model.get("f3"));
        Assert.assertFalse((boolean)((Boolean)model.get("f4")));
        Assert.assertNull((Object)model.get("f2a"));
        Assert.assertNull((Object)model.get("f3a"));
        Assert.assertNull((Object)model.get("f4a"));
        Assert.assertNull((Object)model.get("f5"));
        Assert.assertNull((Object)model.get("f6"));
        Assert.assertNull((Object)model.get("f7"));
        Assert.assertNull((Object)model.get("f8"));
        Assert.assertEquals((Object)"foo", (Object)model.getWithDefault("f1", (Object)"foo"));
        Assert.assertEquals((Object)0, (Object)model.getWithDefault("f2", (Object)"foo"));
        Assert.assertEquals((Object)0L, (Object)model.getWithDefault("f3", (Object)"foo"));
        Assert.assertEquals((Object)false, (Object)model.getWithDefault("f4", (Object)"foo"));
        Assert.assertEquals((Object)"foo", (Object)model.getWithDefault("f2a", (Object)"foo"));
        Assert.assertEquals((Object)"foo", (Object)model.getWithDefault("f3a", (Object)"foo"));
        Assert.assertEquals((Object)"foo", (Object)model.getWithDefault("f4a", (Object)"foo"));
        Assert.assertEquals((Object)"foo", (Object)model.getWithDefault("f5", (Object)"foo"));
        Assert.assertEquals((Object)"foo", (Object)model.getWithDefault("f6", (Object)"foo"));
        Assert.assertEquals((Object)"foo", (Object)model.getWithDefault("f7", (Object)"foo"));
        Assert.assertEquals((Object)"foo", (Object)model.getWithDefault("f8", (Object)"foo"));
        Assert.assertNull((Object)model.getString("f1"));
        Assert.assertEquals((Object)"0", (Object)model.getString("f2"));
        Assert.assertEquals((Object)"0", (Object)model.getString("f3"));
        Assert.assertEquals((Object)"false", (Object)model.getString("f4"));
        Assert.assertNull((Object)model.getString("f2a"));
        Assert.assertNull((Object)model.getString("f3a"));
        Assert.assertNull((Object)model.getString("f4a"));
        Assert.assertNull((Object)model.getString("f5"));
        Assert.assertNull((Object)model.getString("f6"));
        Assert.assertNull((Object)model.getString("f7"));
        Assert.assertNull((Object)model.getString("f8"));
        Assert.assertEquals((Object)"foo", (Object)model.getString("f1", "foo"));
        Assert.assertEquals((Object)"0", (Object)model.getString("f2", "foo"));
        Assert.assertEquals((Object)"0", (Object)model.getString("f3", "foo"));
        Assert.assertEquals((Object)"false", (Object)model.getString("f4", "foo"));
        Assert.assertEquals((Object)"foo", (Object)model.getString("f2a", "foo"));
        Assert.assertEquals((Object)"foo", (Object)model.getString("f3a", "foo"));
        Assert.assertEquals((Object)"foo", (Object)model.getString("f4a", "foo"));
        Assert.assertEquals((Object)"foo", (Object)model.getString("f5", "foo"));
        Assert.assertEquals((Object)"foo", (Object)model.getString("f6", "foo"));
        Assert.assertEquals((Object)"foo", (Object)model.getString("f7", "foo"));
        Assert.assertEquals((Object)"foo", (Object)model.getString("f8", "foo"));
        Assert.assertNull((Object)model.getInt("f1"));
        Assert.assertEquals((long)0L, (long)model.getInt("f2").intValue());
        Assert.assertEquals((long)0L, (long)model.getInt("f3").intValue());
        Assert.assertEquals((long)0L, (long)model.getInt("f4").intValue());
        Assert.assertNull((Object)model.getInt("f2a"));
        Assert.assertNull((Object)model.getInt("f3a"));
        Assert.assertNull((Object)model.getInt("f4a"));
        Assert.assertNull((Object)model.getInt("f5"));
        Assert.assertNull((Object)model.getInt("f6"));
        Assert.assertNull((Object)model.getInt("f7"));
        Assert.assertNull((Object)model.getInt("f8"));
        Assert.assertEquals((long)1L, (long)model.getInt("f1", Integer.valueOf(1)).intValue());
        Assert.assertEquals((long)0L, (long)model.getInt("f2", Integer.valueOf(1)).intValue());
        Assert.assertEquals((long)0L, (long)model.getInt("f3", Integer.valueOf(1)).intValue());
        Assert.assertEquals((long)0L, (long)model.getInt("f4", Integer.valueOf(1)).intValue());
        Assert.assertEquals((long)1L, (long)model.getInt("f2a", Integer.valueOf(1)).intValue());
        Assert.assertEquals((long)1L, (long)model.getInt("f3a", Integer.valueOf(1)).intValue());
        Assert.assertEquals((long)1L, (long)model.getInt("f4a", Integer.valueOf(1)).intValue());
        Assert.assertEquals((long)1L, (long)model.getInt("f5", Integer.valueOf(1)).intValue());
        Assert.assertEquals((long)1L, (long)model.getInt("f6", Integer.valueOf(1)).intValue());
        Assert.assertEquals((long)1L, (long)model.getInt("f7", Integer.valueOf(1)).intValue());
        Assert.assertEquals((long)1L, (long)model.getInt("f8", Integer.valueOf(1)).intValue());
        Assert.assertNull((Object)model.getLong("f1"));
        Assert.assertEquals((long)0L, (long)model.getLong("f2"));
        Assert.assertEquals((long)0L, (long)model.getLong("f3"));
        Assert.assertEquals((long)0L, (long)model.getLong("f4"));
        Assert.assertNull((Object)model.getLong("f2a"));
        Assert.assertNull((Object)model.getLong("f3a"));
        Assert.assertNull((Object)model.getLong("f4a"));
        Assert.assertNull((Object)model.getLong("f5"));
        Assert.assertNull((Object)model.getLong("f6"));
        Assert.assertNull((Object)model.getLong("f7"));
        Assert.assertNull((Object)model.getLong("f8"));
        Assert.assertEquals((long)1L, (long)model.getLong("f1", Long.valueOf(1L)));
        Assert.assertEquals((long)0L, (long)model.getLong("f2", Long.valueOf(1L)));
        Assert.assertEquals((long)0L, (long)model.getLong("f3", Long.valueOf(1L)));
        Assert.assertEquals((long)0L, (long)model.getLong("f4", Long.valueOf(1L)));
        Assert.assertEquals((long)1L, (long)model.getLong("f2a", Long.valueOf(1L)));
        Assert.assertEquals((long)1L, (long)model.getLong("f3a", Long.valueOf(1L)));
        Assert.assertEquals((long)1L, (long)model.getLong("f4a", Long.valueOf(1L)));
        Assert.assertEquals((long)1L, (long)model.getLong("f5", Long.valueOf(1L)));
        Assert.assertEquals((long)1L, (long)model.getLong("f6", Long.valueOf(1L)));
        Assert.assertEquals((long)1L, (long)model.getLong("f7", Long.valueOf(1L)));
        Assert.assertEquals((long)1L, (long)model.getLong("f8", Long.valueOf(1L)));
        Assert.assertNull((Object)model.getBoolean("f1"));
        Assert.assertEquals((Object)false, (Object)model.getBoolean("f2"));
        Assert.assertEquals((Object)false, (Object)model.getBoolean("f3"));
        Assert.assertEquals((Object)false, (Object)model.getBoolean("f4"));
        Assert.assertNull((Object)model.getBoolean("f2a"));
        Assert.assertNull((Object)model.getBoolean("f3a"));
        Assert.assertNull((Object)model.getBoolean("f4a"));
        Assert.assertNull((Object)model.getBoolean("f5"));
        Assert.assertNull((Object)model.getBoolean("f6"));
        Assert.assertNull((Object)model.getBoolean("f7"));
        Assert.assertNull((Object)model.getBoolean("f8"));
        Assert.assertEquals((Object)true, (Object)model.getBoolean("f1", Boolean.valueOf(true)));
        Assert.assertEquals((Object)false, (Object)model.getBoolean("f2", Boolean.valueOf(true)));
        Assert.assertEquals((Object)false, (Object)model.getBoolean("f3", Boolean.valueOf(true)));
        Assert.assertEquals((Object)false, (Object)model.getBoolean("f4", Boolean.valueOf(true)));
        Assert.assertEquals((Object)true, (Object)model.getBoolean("f2a", Boolean.valueOf(true)));
        Assert.assertEquals((Object)true, (Object)model.getBoolean("f3a", Boolean.valueOf(true)));
        Assert.assertEquals((Object)true, (Object)model.getBoolean("f4a", Boolean.valueOf(true)));
        Assert.assertEquals((Object)true, (Object)model.getBoolean("f5", Boolean.valueOf(true)));
        Assert.assertEquals((Object)true, (Object)model.getBoolean("f6", Boolean.valueOf(true)));
        Assert.assertEquals((Object)true, (Object)model.getBoolean("f7", Boolean.valueOf(true)));
        Assert.assertEquals((Object)true, (Object)model.getBoolean("f8", Boolean.valueOf(true)));
        Assert.assertNull((Object)model.getMap("f1"));
        try {
            model.getMap("f2");
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getMap("f3");
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getMap("f4");
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        Assert.assertNull((Object)model.getMap("f2a"));
        Assert.assertNull((Object)model.getMap("f3a"));
        Assert.assertNull((Object)model.getMap("f4a"));
        Assert.assertNull((Object)model.getMap("f5"));
        Assert.assertNull((Object)model.getMap("f6"));
        Assert.assertNull((Object)model.getMap("f7"));
        Assert.assertNull((Object)model.getMap("f8"));
        Assert.assertEquals((Object)"{a:'b'}", (Object)model.getMap("f1", (Map)m).toString());
        try {
            model.getMap("f2", (Map)m);
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getMap("f3", (Map)m);
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getMap("f4", (Map)m);
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        Assert.assertEquals((Object)"{a:'b'}", (Object)model.getMap("f2a", (Map)m).toString());
        Assert.assertEquals((Object)"{a:'b'}", (Object)model.getMap("f3a", (Map)m).toString());
        Assert.assertEquals((Object)"{a:'b'}", (Object)model.getMap("f4a", (Map)m).toString());
        Assert.assertEquals((Object)"{a:'b'}", (Object)model.getMap("f5", (Map)m).toString());
        Assert.assertEquals((Object)"{a:'b'}", (Object)model.getMap("f6", (Map)m).toString());
        Assert.assertEquals((Object)"{a:'b'}", (Object)model.getMap("f7", (Map)m).toString());
        Assert.assertEquals((Object)"{a:'b'}", (Object)model.getMap("f8", (Map)m).toString());
        Assert.assertNull((Object)model.getMap("f1"));
        try {
            model.getObjectMap("f2");
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getObjectMap("f3");
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getObjectMap("f4");
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        Assert.assertNull((Object)model.getObjectMap("f2a"));
        Assert.assertNull((Object)model.getObjectMap("f3a"));
        Assert.assertNull((Object)model.getObjectMap("f4a"));
        Assert.assertNull((Object)model.getObjectMap("f5"));
        Assert.assertNull((Object)model.getObjectMap("f6"));
        Assert.assertNull((Object)model.getObjectMap("f7"));
        Assert.assertNull((Object)model.getObjectMap("f8"));
        Assert.assertEquals((Object)"{a:'b'}", (Object)model.getObjectMap("f1", m).toString());
        try {
            model.getObjectMap("f2", m);
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getObjectMap("f3", m);
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getObjectMap("f4", m);
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        Assert.assertEquals((Object)"{a:'b'}", (Object)model.getObjectMap("f2a", m).toString());
        Assert.assertEquals((Object)"{a:'b'}", (Object)model.getObjectMap("f3a", m).toString());
        Assert.assertEquals((Object)"{a:'b'}", (Object)model.getObjectMap("f4a", m).toString());
        Assert.assertEquals((Object)"{a:'b'}", (Object)model.getObjectMap("f5", m).toString());
        Assert.assertEquals((Object)"{a:'b'}", (Object)model.getObjectMap("f6", m).toString());
        Assert.assertEquals((Object)"{a:'b'}", (Object)model.getObjectMap("f7", m).toString());
        Assert.assertEquals((Object)"{a:'b'}", (Object)model.getObjectMap("f8", m).toString());
        Assert.assertNull((Object)model.getList("f1"));
        try {
            model.getList("f2");
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getList("f3");
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getList("f4");
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        Assert.assertNull((Object)model.getList("f2a"));
        Assert.assertNull((Object)model.getList("f3a"));
        Assert.assertNull((Object)model.getList("f4a"));
        Assert.assertNull((Object)model.getList("f5"));
        Assert.assertNull((Object)model.getList("f6"));
        Assert.assertNull((Object)model.getList("f7"));
        Assert.assertNull((Object)model.getList("f8"));
        Assert.assertEquals((Object)"[{a:'b'}]", (Object)model.getList("f1", (List)l).toString());
        try {
            model.getList("f2", (List)l);
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getList("f3", (List)l);
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getList("f4", (List)l);
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        Assert.assertEquals((Object)"[{a:'b'}]", (Object)model.getList("f2a", (List)l).toString());
        Assert.assertEquals((Object)"[{a:'b'}]", (Object)model.getList("f3a", (List)l).toString());
        Assert.assertEquals((Object)"[{a:'b'}]", (Object)model.getList("f4a", (List)l).toString());
        Assert.assertEquals((Object)"[{a:'b'}]", (Object)model.getList("f5", (List)l).toString());
        Assert.assertEquals((Object)"[{a:'b'}]", (Object)model.getList("f6", (List)l).toString());
        Assert.assertEquals((Object)"[{a:'b'}]", (Object)model.getList("f7", (List)l).toString());
        Assert.assertEquals((Object)"[{a:'b'}]", (Object)model.getList("f8", (List)l).toString());
        Assert.assertNull((Object)model.getObjectList("f1"));
        try {
            model.getObjectList("f2");
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getObjectList("f3");
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getObjectList("f4");
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        Assert.assertNull((Object)model.getObjectList("f2a"));
        Assert.assertNull((Object)model.getObjectList("f3a"));
        Assert.assertNull((Object)model.getObjectList("f4a"));
        Assert.assertNull((Object)model.getObjectList("f5"));
        Assert.assertNull((Object)model.getObjectList("f6"));
        Assert.assertNull((Object)model.getObjectList("f7"));
        Assert.assertNull((Object)model.getObjectList("f8"));
        Assert.assertEquals((Object)"[{a:'b'}]", (Object)model.getObjectList("f1", l).toString());
        try {
            model.getObjectList("f2", l);
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getObjectList("f3", l);
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getObjectList("f4", l);
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        Assert.assertEquals((Object)"[{a:'b'}]", (Object)model.getObjectList("f2a", l).toString());
        Assert.assertEquals((Object)"[{a:'b'}]", (Object)model.getObjectList("f3a", l).toString());
        Assert.assertEquals((Object)"[{a:'b'}]", (Object)model.getObjectList("f4a", l).toString());
        Assert.assertEquals((Object)"[{a:'b'}]", (Object)model.getObjectList("f5", l).toString());
        Assert.assertEquals((Object)"[{a:'b'}]", (Object)model.getObjectList("f6", l).toString());
        Assert.assertEquals((Object)"[{a:'b'}]", (Object)model.getObjectList("f7", l).toString());
        Assert.assertEquals((Object)"[{a:'b'}]", (Object)model.getObjectList("f8", l).toString());
        ((A)model.getRootObject()).init();
        Assert.assertEquals((Object)"1", (Object)model.get("f1"));
        Assert.assertEquals((Object)"2", (Object)model.get("f2").toString());
        Assert.assertEquals((Object)"3", (Object)model.get("f3").toString());
        Assert.assertEquals((Object)"true", (Object)model.get("f4").toString());
        Assert.assertEquals((Object)"2", (Object)model.get("f2a").toString());
        Assert.assertEquals((Object)"3", (Object)model.get("f3a").toString());
        Assert.assertEquals((Object)"true", (Object)model.get("f4a").toString());
        Assert.assertEquals((Object)"{f5a:'a'}", (Object)model.get("f5").toString());
        Assert.assertEquals((Object)"[{f6a:'a'}]", (Object)model.get("f6").toString());
        Assert.assertEquals((Object)"{f5a:'a'}", (Object)model.get("f7").toString());
        Assert.assertEquals((Object)"[{f6a:'a'}]", (Object)model.get("f8").toString());
        Assert.assertEquals((Object)"1", (Object)model.getWithDefault("f1", (Object)"foo"));
        Assert.assertEquals((Object)"2", (Object)model.getWithDefault("f2", (Object)"foo").toString());
        Assert.assertEquals((Object)"3", (Object)model.getWithDefault("f3", (Object)"foo").toString());
        Assert.assertEquals((Object)"true", (Object)model.getWithDefault("f4", (Object)"foo").toString());
        Assert.assertEquals((Object)"2", (Object)model.getWithDefault("f2a", (Object)"foo").toString());
        Assert.assertEquals((Object)"3", (Object)model.getWithDefault("f3a", (Object)"foo").toString());
        Assert.assertEquals((Object)"true", (Object)model.getWithDefault("f4a", (Object)"foo").toString());
        Assert.assertEquals((Object)"{f5a:'a'}", (Object)model.getWithDefault("f5", (Object)"foo").toString());
        Assert.assertEquals((Object)"[{f6a:'a'}]", (Object)model.getWithDefault("f6", (Object)"foo").toString());
        Assert.assertEquals((Object)"{f5a:'a'}", (Object)model.getWithDefault("f7", (Object)"foo").toString());
        Assert.assertEquals((Object)"[{f6a:'a'}]", (Object)model.getWithDefault("f8", (Object)"foo").toString());
        Assert.assertEquals((Object)"1", (Object)model.getString("f1"));
        Assert.assertEquals((Object)"2", (Object)model.getString("f2"));
        Assert.assertEquals((Object)"3", (Object)model.getString("f3"));
        Assert.assertEquals((Object)"true", (Object)model.getString("f4"));
        Assert.assertEquals((Object)"2", (Object)model.getString("f2a"));
        Assert.assertEquals((Object)"3", (Object)model.getString("f3a"));
        Assert.assertEquals((Object)"true", (Object)model.getString("f4a"));
        Assert.assertEquals((Object)"{f5a:'a'}", (Object)model.getString("f5"));
        Assert.assertEquals((Object)"[{f6a:'a'}]", (Object)model.getString("f6"));
        Assert.assertEquals((Object)"{f5a:'a'}", (Object)model.getString("f7"));
        Assert.assertEquals((Object)"[{f6a:'a'}]", (Object)model.getString("f8"));
        Assert.assertEquals((Object)"1", (Object)model.getString("f1", "foo"));
        Assert.assertEquals((Object)"2", (Object)model.getString("f2", "foo"));
        Assert.assertEquals((Object)"3", (Object)model.getString("f3", "foo"));
        Assert.assertEquals((Object)"true", (Object)model.getString("f4", "foo"));
        Assert.assertEquals((Object)"2", (Object)model.getString("f2a", "foo"));
        Assert.assertEquals((Object)"3", (Object)model.getString("f3a", "foo"));
        Assert.assertEquals((Object)"true", (Object)model.getString("f4a", "foo"));
        Assert.assertEquals((Object)"{f5a:'a'}", (Object)model.getString("f5", "foo"));
        Assert.assertEquals((Object)"[{f6a:'a'}]", (Object)model.getString("f6", "foo"));
        Assert.assertEquals((Object)"{f5a:'a'}", (Object)model.getString("f7", "foo"));
        Assert.assertEquals((Object)"[{f6a:'a'}]", (Object)model.getString("f8", "foo"));
        Assert.assertEquals((long)1L, (long)model.getInt("f1").intValue());
        Assert.assertEquals((long)2L, (long)model.getInt("f2").intValue());
        Assert.assertEquals((long)3L, (long)model.getInt("f3").intValue());
        Assert.assertEquals((long)1L, (long)model.getInt("f4").intValue());
        Assert.assertEquals((long)2L, (long)model.getInt("f2a").intValue());
        Assert.assertEquals((long)3L, (long)model.getInt("f3a").intValue());
        Assert.assertEquals((long)1L, (long)model.getInt("f4a").intValue());
        try {
            model.getInt("f5");
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getInt("f6");
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getInt("f7");
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getInt("f8");
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)model.getInt("f1", Integer.valueOf(9)).intValue());
        Assert.assertEquals((long)2L, (long)model.getInt("f2", Integer.valueOf(9)).intValue());
        Assert.assertEquals((long)3L, (long)model.getInt("f3", Integer.valueOf(9)).intValue());
        Assert.assertEquals((long)1L, (long)model.getInt("f4", Integer.valueOf(9)).intValue());
        Assert.assertEquals((long)2L, (long)model.getInt("f2a", Integer.valueOf(9)).intValue());
        Assert.assertEquals((long)3L, (long)model.getInt("f3a", Integer.valueOf(9)).intValue());
        Assert.assertEquals((long)1L, (long)model.getInt("f4a", Integer.valueOf(9)).intValue());
        try {
            model.getInt("f5", Integer.valueOf(9));
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getInt("f6", Integer.valueOf(9));
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getInt("f7", Integer.valueOf(9));
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getInt("f8", Integer.valueOf(9));
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)model.getLong("f1"));
        Assert.assertEquals((long)2L, (long)model.getLong("f2"));
        Assert.assertEquals((long)3L, (long)model.getLong("f3"));
        Assert.assertEquals((long)1L, (long)model.getLong("f4"));
        Assert.assertEquals((long)2L, (long)model.getLong("f2a"));
        Assert.assertEquals((long)3L, (long)model.getLong("f3a"));
        Assert.assertEquals((long)1L, (long)model.getLong("f4a"));
        try {
            model.getLong("f5");
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getLong("f6");
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getLong("f7");
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getInt("f8");
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)model.getLong("f1", Long.valueOf(9L)));
        Assert.assertEquals((long)2L, (long)model.getLong("f2", Long.valueOf(9L)));
        Assert.assertEquals((long)3L, (long)model.getLong("f3", Long.valueOf(9L)));
        Assert.assertEquals((long)1L, (long)model.getLong("f4", Long.valueOf(9L)));
        Assert.assertEquals((long)2L, (long)model.getLong("f2a", Long.valueOf(9L)));
        Assert.assertEquals((long)3L, (long)model.getLong("f3a", Long.valueOf(9L)));
        Assert.assertEquals((long)1L, (long)model.getLong("f4a", Long.valueOf(9L)));
        try {
            model.getLong("f5", Long.valueOf(9L));
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getLong("f6", Long.valueOf(9L));
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getLong("f7", Long.valueOf(9L));
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getLong("f8", Long.valueOf(9L));
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        Assert.assertEquals((Object)false, (Object)model.getBoolean("f1"));
        Assert.assertEquals((Object)true, (Object)model.getBoolean("f2"));
        Assert.assertEquals((Object)true, (Object)model.getBoolean("f3"));
        Assert.assertEquals((Object)true, (Object)model.getBoolean("f4"));
        Assert.assertEquals((Object)true, (Object)model.getBoolean("f2a"));
        Assert.assertEquals((Object)true, (Object)model.getBoolean("f3a"));
        Assert.assertEquals((Object)true, (Object)model.getBoolean("f4a"));
        Assert.assertEquals((Object)false, (Object)model.getBoolean("f5"));
        Assert.assertEquals((Object)false, (Object)model.getBoolean("f6"));
        Assert.assertEquals((Object)false, (Object)model.getBoolean("f7"));
        Assert.assertEquals((Object)false, (Object)model.getBoolean("f8"));
        Assert.assertEquals((Object)false, (Object)model.getBoolean("f1", Boolean.valueOf(true)));
        Assert.assertEquals((Object)true, (Object)model.getBoolean("f2", Boolean.valueOf(true)));
        Assert.assertEquals((Object)true, (Object)model.getBoolean("f3", Boolean.valueOf(true)));
        Assert.assertEquals((Object)true, (Object)model.getBoolean("f4", Boolean.valueOf(true)));
        Assert.assertEquals((Object)true, (Object)model.getBoolean("f2a", Boolean.valueOf(true)));
        Assert.assertEquals((Object)true, (Object)model.getBoolean("f3a", Boolean.valueOf(true)));
        Assert.assertEquals((Object)true, (Object)model.getBoolean("f4a", Boolean.valueOf(true)));
        Assert.assertEquals((Object)false, (Object)model.getBoolean("f5", Boolean.valueOf(true)));
        Assert.assertEquals((Object)false, (Object)model.getBoolean("f6", Boolean.valueOf(true)));
        Assert.assertEquals((Object)false, (Object)model.getBoolean("f7", Boolean.valueOf(true)));
        Assert.assertEquals((Object)false, (Object)model.getBoolean("f8", Boolean.valueOf(true)));
        try {
            model.getMap("f1");
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getMap("f2");
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getMap("f3");
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getMap("f4");
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getMap("f2a");
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getMap("f3a");
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getMap("f4a");
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        Assert.assertEquals((Object)"{f5a:'a'}", (Object)model.getMap("f5").toString());
        try {
            model.getMap("f6");
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        Assert.assertEquals((Object)"{f5a:'a'}", (Object)model.getMap("f7").toString());
        try {
            model.getMap("f8");
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getMap("f1", (Map)m);
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getMap("f2", (Map)m);
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getMap("f3", (Map)m);
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getMap("f4", (Map)m);
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getMap("f2a", (Map)m);
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getMap("f3a", (Map)m);
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getMap("f4a", (Map)m);
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        Assert.assertEquals((Object)"{f5a:'a'}", (Object)model.getMap("f5", (Map)m).toString());
        try {
            model.getMap("f6", (Map)m);
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        Assert.assertEquals((Object)"{f5a:'a'}", (Object)model.getMap("f7", (Map)m).toString());
        try {
            model.getMap("f8", (Map)m);
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getObjectMap("f1");
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getObjectMap("f2");
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getObjectMap("f3");
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getObjectMap("f4");
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getObjectMap("f2a");
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getObjectMap("f3a");
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getObjectMap("f4a");
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        Assert.assertEquals((Object)"{f5a:'a'}", (Object)model.getObjectMap("f5").toString());
        try {
            model.getObjectMap("f6");
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        Assert.assertEquals((Object)"{f5a:'a'}", (Object)model.getObjectMap("f7").toString());
        try {
            model.getObjectMap("f8");
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getObjectMap("f1", m);
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getObjectMap("f2", m);
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getObjectMap("f3", m);
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getObjectMap("f4", m);
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getObjectMap("f2a", m);
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getObjectMap("f3a", m);
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getObjectMap("f4a", m);
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        Assert.assertEquals((Object)"{f5a:'a'}", (Object)model.getObjectMap("f5", m).toString());
        try {
            model.getObjectMap("f6", m);
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        Assert.assertEquals((Object)"{f5a:'a'}", (Object)model.getObjectMap("f7", m).toString());
        try {
            model.getObjectMap("f8", m);
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getList("f1");
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getList("f2");
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getList("f3");
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getList("f4");
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getList("f2a");
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getList("f3a");
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getList("f4a");
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        Assert.assertEquals((Object)"[{f5a:'a'}]", (Object)model.getList("f5").toString());
        Assert.assertEquals((Object)"[{f6a:'a'}]", (Object)model.getList("f6").toString());
        Assert.assertEquals((Object)"[{f5a:'a'}]", (Object)model.getList("f7").toString());
        Assert.assertEquals((Object)"[{f6a:'a'}]", (Object)model.getList("f8").toString());
        try {
            model.getList("f1", (List)l);
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getList("f2", (List)l);
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getList("f3", (List)l);
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getList("f4", (List)l);
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getList("f2a", (List)l);
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getList("f3a", (List)l);
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getList("f4a", (List)l);
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        Assert.assertEquals((Object)"[{f5a:'a'}]", (Object)model.getList("f5", (List)l).toString());
        Assert.assertEquals((Object)"[{f6a:'a'}]", (Object)model.getList("f6", (List)l).toString());
        Assert.assertEquals((Object)"[{f5a:'a'}]", (Object)model.getList("f7", (List)l).toString());
        Assert.assertEquals((Object)"[{f6a:'a'}]", (Object)model.getList("f8", (List)l).toString());
        try {
            model.getObjectList("f1");
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getObjectList("f2");
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getObjectList("f3");
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getObjectList("f4");
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getObjectList("f2a");
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getObjectList("f3a");
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getObjectList("f4a");
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        Assert.assertEquals((Object)"[{f5a:'a'}]", (Object)model.getObjectList("f5").toString());
        Assert.assertEquals((Object)"[{f6a:'a'}]", (Object)model.getObjectList("f6").toString());
        Assert.assertEquals((Object)"[{f5a:'a'}]", (Object)model.getObjectList("f7").toString());
        Assert.assertEquals((Object)"[{f6a:'a'}]", (Object)model.getObjectList("f8").toString());
        try {
            model.getObjectList("f1", l);
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getObjectList("f2", l);
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getObjectList("f3", l);
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getObjectList("f4", l);
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getObjectList("f2a", l);
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getObjectList("f3a", l);
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            model.getObjectList("f4a", l);
            Assert.fail();
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        Assert.assertEquals((Object)"[{f5a:'a'}]", (Object)model.getObjectList("f5", l).toString());
        Assert.assertEquals((Object)"[{f6a:'a'}]", (Object)model.getObjectList("f6", l).toString());
        Assert.assertEquals((Object)"[{f5a:'a'}]", (Object)model.getObjectList("f7", l).toString());
        Assert.assertEquals((Object)"[{f6a:'a'}]", (Object)model.getObjectList("f8", l).toString());
    }

    @Test
    public void testInvokeMethod() throws Exception {
        PojoRest model = new PojoRest((Object)new AddressBook().init());
        Assert.assertEquals((Object)"Person(name=Bill Clinton,age=65)", (Object)model.invokeMethod("0", "toString", ""));
        model = new PojoRest((Object)new AddressBook().init(), (ReaderParser)JsonParser.DEFAULT);
        Assert.assertEquals((Object)"Person(name=Bill Clinton,age=65)", (Object)model.invokeMethod("0", "toString", ""));
        Assert.assertEquals((Object)"NY", (Object)model.invokeMethod("0/addresses/0/state", "toString", ""));
        Assert.assertNull((Object)model.invokeMethod("1", "toString", ""));
    }

    @Test
    public void testGetPublicMethods() throws Exception {
        PojoRest model = new PojoRest((Object)new AddressBook().init());
        Assert.assertTrue((boolean)SimpleJsonSerializer.DEFAULT.toString((Object)model.getPublicMethods("0")).contains("'toString'"));
        Assert.assertTrue((boolean)SimpleJsonSerializer.DEFAULT.toString((Object)model.getPublicMethods("0/addresses/0/state")).contains("'toString'"));
        Assert.assertNull((Object)model.getPublicMethods("1"));
    }

    @Test
    public void testGetClassMeta() throws Exception {
        PojoRest model = new PojoRest((Object)new AddressBook().init());
        Assert.assertEquals((Object)"Person", (Object)model.getClassMeta("0").getInnerClass().getSimpleName());
        Assert.assertEquals((Object)"String", (Object)model.getClassMeta("0/addresses/0/state").getInnerClass().getSimpleName());
        Assert.assertNull((Object)model.getClassMeta("1"));
        Assert.assertNull((Object)model.getClassMeta("0/addresses/1/state"));
    }

    public static class A {
        public String f1;
        public int f2;
        public long f3;
        public boolean f4;
        public Integer f2a;
        public Long f3a;
        public Boolean f4a;
        public Map f5;
        public List f6;
        public ObjectMap f7;
        public ObjectList f8;

        public A init() {
            this.f1 = "1";
            this.f2 = 2;
            this.f3 = 3L;
            this.f4 = true;
            this.f2a = 2;
            this.f3a = 3L;
            this.f4a = true;
            try {
                this.f5 = new ObjectMap((CharSequence)"{f5a:'a'}");
                this.f6 = new ObjectList((CharSequence)"[{f6a:'a'}]");
                this.f7 = new ObjectMap((CharSequence)"{f5a:'a'}");
                this.f8 = new ObjectList((CharSequence)"[{f6a:'a'}]");
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
            return this;
        }
    }

    @Bean(typeName="Person", bpi="name,age,addresses")
    public static class Person {
        public String name;
        public int age;
        public Address[] addresses;

        public Person() {
        }

        public Person(String name, int age, Address ... addresses) {
            this.name = name;
            this.age = age;
            this.addresses = addresses;
        }

        public String toString() {
            return "Person(name=" + this.name + ",age=" + this.age + ")";
        }
    }

    @Bean(bpi="street,city,state,zip,isCurrent")
    public static class Address {
        public String street;
        public String city;
        public String state;
        public int zip;
        public boolean isCurrent;

        public Address() {
        }

        public Address(String street, String city, String state, int zip, boolean isCurrent) {
            this.street = street;
            this.city = city;
            this.state = state;
            this.zip = zip;
            this.isCurrent = isCurrent;
        }

        public String toString() {
            return "Address(street=" + this.street + ",city=" + this.city + ",state=" + this.state + ",zip=" + this.zip + ",isCurrent=" + this.isCurrent + ")";
        }
    }

    public static class AddressBook
    extends LinkedList<Person> {
        public AddressBook init() {
            this.add(new Person("Bill Clinton", 65, new Address("55W. 125th Street", "New York", "NY", 10027, true)));
            return this;
        }
    }
}

