/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.utils;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanSession;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.testutils.TestUtils;
import org.apache.juneau.transforms.TemporalCalendarSwap;
import org.apache.juneau.utils.AList;
import org.apache.juneau.utils.PojoQuery;
import org.apache.juneau.utils.SearchArgs;
import org.junit.Assert;
import org.junit.Test;

public class PojoQueryTest {
    @Test
    public void testFilterCollectionStringSearchOneLevel() throws Exception {
        AList in = new AList().append((Object)new A("foo")).append((Object)new A("bar")).append((Object)new A("baz"));
        PojoQuery q = new PojoQuery((Object)in, BeanContext.DEFAULT.createSession());
        SearchArgs sa = SearchArgs.builder().search("f=foo").build();
        List results = q.filter(sa);
        TestUtils.assertObjectEquals("[{f:'foo'}]", results);
        sa = SearchArgs.builder().search("f=fo*").build();
        results = q.filter(sa);
        TestUtils.assertObjectEquals("[{f:'foo'}]", results);
        sa = SearchArgs.builder().search("f=*ar").build();
        results = q.filter(sa);
        TestUtils.assertObjectEquals("[{f:'bar'}]", results);
        sa = SearchArgs.builder().search("f=foo bar").build();
        results = q.filter(sa);
        TestUtils.assertObjectEquals("[{f:'foo'},{f:'bar'}]", results);
    }

    @Test
    public void testFilterCollectionDateSearchOneLevel() throws Exception {
        BeanSession session = BeanContext.DEFAULT.createSession();
        JsonSerializer s = JsonSerializer.create().ssq().pojoSwaps(new Class[]{TemporalCalendarSwap.IsoLocalDateTime.class}).build();
        B[] in = new B[]{new B(2010, 0, 1), new B(2011, 0, 1), new B(2011, 0, 31), new B(2012, 0, 1)};
        PojoQuery q = new PojoQuery((Object)in, session);
        SearchArgs sa = SearchArgs.builder().search("f=2011").build();
        List results = q.filter(sa);
        Assert.assertEquals((Object)"[{f:'2011-01-01T00:00:00'},{f:'2011-01-31T00:00:00'}]", (Object)s.serialize((Object)results));
        sa = SearchArgs.builder().search("f=2011.01").build();
        results = q.filter(sa);
        Assert.assertEquals((Object)"[{f:'2011-01-01T00:00:00'},{f:'2011-01-31T00:00:00'}]", (Object)s.serialize((Object)results));
        sa = SearchArgs.builder().search("f=2011.01.01").build();
        results = q.filter(sa);
        Assert.assertEquals((Object)"[{f:'2011-01-01T00:00:00'}]", (Object)s.serialize((Object)results));
        in = new B[]{new B(2011, 0, 1, 11, 59, 59), new B(2011, 0, 1, 12, 0, 0), new B(2011, 0, 1, 12, 59, 59), new B(2011, 0, 1, 13, 0, 0)};
        q = new PojoQuery((Object)in, session);
        sa = SearchArgs.builder().search("f=2011.01.01.12").build();
        results = q.filter(sa);
        Assert.assertEquals((Object)"[{f:'2011-01-01T12:00:00'},{f:'2011-01-01T12:59:59'}]", (Object)s.serialize((Object)results));
        in = new B[]{new B(2011, 0, 1, 12, 29, 59), new B(2011, 0, 1, 12, 30, 0), new B(2011, 0, 1, 12, 30, 59), new B(2011, 0, 1, 12, 31, 0)};
        q = new PojoQuery((Object)in, session);
        sa = SearchArgs.builder().search("f=2011.01.01.12.30").build();
        results = q.filter(sa);
        Assert.assertEquals((Object)"[{f:'2011-01-01T12:30:00'},{f:'2011-01-01T12:30:59'}]", (Object)s.serialize((Object)results));
        in = new B[]{new B(2011, 0, 1, 12, 30, 29), new B(2011, 0, 1, 12, 30, 30), new B(2011, 0, 1, 12, 30, 31)};
        q = new PojoQuery((Object)in, session);
        sa = SearchArgs.builder().search("f=2011.01.01.12.30.30").build();
        results = q.filter(sa);
        Assert.assertEquals((Object)"[{f:'2011-01-01T12:30:30'}]", (Object)s.serialize((Object)results));
        in = new B[]{new B(2000, 11, 31), new B(2001, 0, 1)};
        q = new PojoQuery((Object)in, session);
        sa = SearchArgs.builder().search("f>2000").build();
        results = q.filter(sa);
        Assert.assertEquals((Object)"[{f:'2001-01-01T00:00:00'}]", (Object)s.serialize((Object)results));
        sa = SearchArgs.builder().search("f>=2001").build();
        results = q.filter(sa);
        Assert.assertEquals((Object)"[{f:'2001-01-01T00:00:00'}]", (Object)s.serialize((Object)results));
        sa = SearchArgs.builder().search("f<2001").build();
        results = q.filter(sa);
        Assert.assertEquals((Object)"[{f:'2000-12-31T00:00:00'}]", (Object)s.serialize((Object)results));
        sa = SearchArgs.builder().search("f<=2000").build();
        results = q.filter(sa);
        Assert.assertEquals((Object)"[{f:'2000-12-31T00:00:00'}]", (Object)s.serialize((Object)results));
        in = new B[]{new B(2011, 0, 1, 12, 29, 59), new B(2011, 0, 1, 12, 30, 0)};
        q = new PojoQuery((Object)in, session);
        sa = SearchArgs.builder().search("f>=2011.01.01.12.30").build();
        results = q.filter(sa);
        Assert.assertEquals((Object)"[{f:'2011-01-01T12:30:00'}]", (Object)s.serialize((Object)results));
        sa = SearchArgs.builder().search("f<2011.01.01.12.30").build();
        results = q.filter(sa);
        Assert.assertEquals((Object)"[{f:'2011-01-01T12:29:59'}]", (Object)s.serialize((Object)results));
        in = new B[]{new B(2011, 0, 1, 12, 30, 59), new B(2011, 0, 1, 12, 31, 0)};
        q = new PojoQuery((Object)in, session);
        sa = SearchArgs.builder().search("f>2011.01.01.12.30").build();
        results = q.filter(sa);
        Assert.assertEquals((Object)"[{f:'2011-01-01T12:31:00'}]", (Object)s.serialize((Object)results));
        sa = SearchArgs.builder().search("f<=2011.01.01.12.30").build();
        results = q.filter(sa);
        Assert.assertEquals((Object)"[{f:'2011-01-01T12:30:59'}]", (Object)s.serialize((Object)results));
        in = new B[]{new B(2000, 11, 31, 23, 59, 59), new B(2001, 0, 1, 0, 0, 0), new B(2003, 5, 30, 23, 59, 59), new B(2003, 6, 1, 0, 0, 0)};
        q = new PojoQuery((Object)in, session);
        sa = SearchArgs.builder().search("f=2001 - 2003.06.30").build();
        results = q.filter(sa);
        Assert.assertEquals((Object)"[{f:'2001-01-01T00:00:00'},{f:'2003-06-30T23:59:59'}]", (Object)s.serialize((Object)results));
        in = new B[]{new B(2000, 11, 31), new B(2001, 0, 1), new B(2001, 11, 31), new B(2002, 0, 1)};
        q = new PojoQuery((Object)in, session);
        sa = SearchArgs.builder().search("f=2001 2003 2005").build();
        results = q.filter(sa);
        Assert.assertEquals((Object)"[{f:'2001-01-01T00:00:00'},{f:'2001-12-31T00:00:00'}]", (Object)s.serialize((Object)results));
        in = new B[]{new B(2002, 11, 31), new B(2003, 0, 1), new B(2003, 11, 31), new B(2004, 0, 1)};
        q = new PojoQuery((Object)in, session);
        sa = SearchArgs.builder().search("f=2001 2003 2005").build();
        results = q.filter(sa);
        Assert.assertEquals((Object)"[{f:'2003-01-01T00:00:00'},{f:'2003-12-31T00:00:00'}]", (Object)s.serialize((Object)results));
        in = new B[]{new B(2004, 11, 31), new B(2005, 0, 1), new B(2005, 11, 31), new B(2006, 0, 1)};
        q = new PojoQuery((Object)in, session);
        sa = SearchArgs.builder().search("f=2001 2003 2005").build();
        results = q.filter(sa);
        Assert.assertEquals((Object)"[{f:'2005-01-01T00:00:00'},{f:'2005-12-31T00:00:00'}]", (Object)s.serialize((Object)results));
    }

    @Test
    public void testFilterCollectionIntSearchOneLevel() throws Exception {
        BeanSession session = BeanContext.DEFAULT.createSession();
        AList in = new AList().append((Object)new C(1)).append((Object)new C(2)).append((Object)new C(3));
        PojoQuery q = new PojoQuery((Object)in, session);
        SearchArgs sa = SearchArgs.builder().search("f=1").build();
        List results = q.filter(sa);
        TestUtils.assertObjectEquals("[{f:1}]", results);
        sa = SearchArgs.builder().search("f>1").build();
        results = q.filter(sa);
        TestUtils.assertObjectEquals("[{f:2},{f:3}]", results);
        sa = SearchArgs.builder().search("f>=2").build();
        results = q.filter(sa);
        TestUtils.assertObjectEquals("[{f:2},{f:3}]", results);
        sa = SearchArgs.builder().search("f<=2").build();
        results = q.filter(sa);
        TestUtils.assertObjectEquals("[{f:1},{f:2}]", results);
        sa = SearchArgs.builder().search("f<2").build();
        results = q.filter(sa);
        TestUtils.assertObjectEquals("[{f:1}]", results);
        sa = SearchArgs.builder().search("f=1 3").build();
        results = q.filter(sa);
        TestUtils.assertObjectEquals("[{f:1},{f:3}]", results);
    }

    @Test
    public void testFilterCollectionViewOneLevel() throws Exception {
        BeanSession session = BeanContext.DEFAULT.createSession();
        AList in = new AList().append((Object)new E("foo", 1, true)).append((Object)new E("bar", 2, false)).append((Object)new E("baz", 3, true));
        PojoQuery q = new PojoQuery((Object)in, session);
        SearchArgs sa = SearchArgs.builder().view("f1").build();
        List results = q.filter(sa);
        TestUtils.assertObjectEquals("[{f1:'foo'},{f1:'bar'},{f1:'baz'}]", results);
        sa = SearchArgs.builder().view("f2").build();
        results = q.filter(sa);
        TestUtils.assertObjectEquals("[{f2:1},{f2:2},{f2:3}]", results);
        sa = SearchArgs.builder().view("f3").build();
        results = q.filter(sa);
        TestUtils.assertObjectEquals("[{f3:true},{f3:false},{f3:true}]", results);
        sa = SearchArgs.builder().view("f3,f2,f1").build();
        results = q.filter(sa);
        TestUtils.assertObjectEquals("[{f3:true,f2:1,f1:'foo'},{f3:false,f2:2,f1:'bar'},{f3:true,f2:3,f1:'baz'}]", results);
    }

    @Test
    public void testSorting() throws Exception {
        BeanSession session = BeanContext.DEFAULT.createSession();
        JsonSerializer s = JsonSerializer.create().ssq().pojoSwaps(new Class[]{TemporalCalendarSwap.IsoLocalDateTime.class}).build();
        I[] in = new I[]{new I(1, "foo", true, 2010, 1, 1), new I(2, "bar", false, 2011, 1, 1), new I(3, "baz", true, 2012, 1, 1)};
        PojoQuery q = new PojoQuery((Object)in, session);
        SearchArgs sa = SearchArgs.builder().sort("f2").view("f1, f2").build();
        List results = q.filter(sa);
        Assert.assertEquals((Object)"[{f1:2,f2:'bar'},{f1:3,f2:'baz'},{f1:1,f2:'foo'}]", (Object)s.serialize((Object)results));
        sa = SearchArgs.builder().sort("f2-").view("f1,f2").build();
        results = q.filter(sa);
        Assert.assertEquals((Object)"[{f1:1,f2:'foo'},{f1:3,f2:'baz'},{f1:2,f2:'bar'}]", (Object)s.serialize((Object)results));
        sa = SearchArgs.builder().sort("f3").view("f1,f3").build();
        results = q.filter(sa);
        Assert.assertEquals((Object)"[{f1:2,f3:false},{f1:1,f3:true},{f1:3,f3:true}]", (Object)s.serialize((Object)results));
        sa = SearchArgs.builder().sort("f3,f1+").view("f1,f3").build();
        results = q.filter(sa);
        Assert.assertEquals((Object)"[{f1:2,f3:false},{f1:1,f3:true},{f1:3,f3:true}]", (Object)s.serialize((Object)results));
        sa = SearchArgs.builder().sort("f3,f1-").view("f1,f3").build();
        results = q.filter(sa);
        Assert.assertEquals((Object)"[{f1:2,f3:false},{f1:3,f3:true},{f1:1,f3:true}]", (Object)s.serialize((Object)results));
        sa = SearchArgs.builder().sort("f1").view("f1").limit(1).position(0).build();
        results = q.filter(sa);
        Assert.assertEquals((Object)"[{f1:1}]", (Object)s.serialize((Object)results));
        sa = SearchArgs.builder().sort("f1").view("f1").limit(3).position(0).build();
        results = q.filter(sa);
        Assert.assertEquals((Object)"[{f1:1},{f1:2},{f1:3}]", (Object)s.serialize((Object)results));
        sa = SearchArgs.builder().sort("f1").view("f1").limit(1).position(2).build();
        results = q.filter(sa);
        Assert.assertEquals((Object)"[{f1:3}]", (Object)s.serialize((Object)results));
        sa = SearchArgs.builder().sort("f1").view("f1").limit(100).position(2).build();
        results = q.filter(sa);
        Assert.assertEquals((Object)"[{f1:3}]", (Object)s.serialize((Object)results));
    }

    public class I {
        public int f1;
        public String f2;
        public boolean f3;
        public Calendar f4;

        I() {
        }

        I(int f1, String f2, boolean f3, int year, int month, int day) {
            this.f1 = f1;
            this.f2 = f2;
            this.f3 = f3;
            this.f4 = new GregorianCalendar(year, month, day);
        }
    }

    public class E {
        public String f1;
        public int f2;
        public boolean f3;

        E() {
        }

        E(String f1, int f2, boolean f3) {
            this.f1 = f1;
            this.f2 = f2;
            this.f3 = f3;
        }
    }

    public class C {
        public int f;

        C() {
        }

        C(int f) {
            this.f = f;
        }
    }

    public class B {
        public Calendar f;

        B() {
        }

        B(int year, int month, int day) {
            this.f = new GregorianCalendar(year, month, day);
        }

        B(int year, int month, int day, int hour, int minute, int second) {
            this.f = new GregorianCalendar(year, month, day, hour, minute, second);
        }
    }

    public class A {
        public String f;

        A() {
        }

        A(String f) {
            this.f = f;
        }
    }
}

