/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.utils;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.juneau.internal.MultiSet;
import org.apache.juneau.testutils.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class MultiSetTest {
    @Test
    public void doTest() throws Exception {
        List<String> l1 = Arrays.asList("1", "2");
        List<String> l2 = Arrays.asList("3", "4");
        MultiSet ms = new MultiSet(new Collection[]{l1, l2});
        Iterator i = ms.iterator();
        Assert.assertTrue((boolean)i.hasNext());
        Assert.assertEquals((Object)"1", i.next());
        Assert.assertTrue((boolean)i.hasNext());
        Assert.assertEquals((Object)"2", i.next());
        Assert.assertTrue((boolean)i.hasNext());
        Assert.assertEquals((Object)"3", i.next());
        Assert.assertTrue((boolean)i.hasNext());
        Assert.assertEquals((Object)"4", i.next());
        Assert.assertFalse((boolean)i.hasNext());
        try {
            i.next();
            Assert.fail((String)"Exception expected");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        l1 = Arrays.asList("1", "2");
        l2 = Arrays.asList(new String[0]);
        ms = new MultiSet(new Collection[]{l1, l2});
        i = ms.iterator();
        Assert.assertTrue((boolean)i.hasNext());
        Assert.assertEquals((Object)"1", i.next());
        Assert.assertTrue((boolean)i.hasNext());
        Assert.assertEquals((Object)"2", i.next());
        Assert.assertFalse((boolean)i.hasNext());
        try {
            i.next();
            Assert.fail((String)"Exception expected");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        l1 = Arrays.asList(new String[0]);
        l2 = Arrays.asList("3", "4");
        ms = new MultiSet(new Collection[]{l1, l2});
        i = ms.iterator();
        Assert.assertTrue((boolean)i.hasNext());
        Assert.assertEquals((Object)"3", i.next());
        Assert.assertTrue((boolean)i.hasNext());
        Assert.assertEquals((Object)"4", i.next());
        Assert.assertFalse((boolean)i.hasNext());
        try {
            i.next();
            Assert.fail((String)"Exception expected");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        l1 = Arrays.asList(new String[0]);
        l2 = Arrays.asList(new String[0]);
        ms = new MultiSet(new Collection[]{l1, l2});
        i = ms.iterator();
        Assert.assertFalse((boolean)i.hasNext());
        try {
            i.next();
            Assert.fail((String)"Exception expected");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        l1 = Arrays.asList("1", "2");
        ms = new MultiSet(new Collection[]{l1});
        i = ms.iterator();
        Assert.assertTrue((boolean)i.hasNext());
        Assert.assertEquals((Object)"1", i.next());
        Assert.assertTrue((boolean)i.hasNext());
        Assert.assertEquals((Object)"2", i.next());
        Assert.assertFalse((boolean)i.hasNext());
        try {
            i.next();
            Assert.fail((String)"Exception expected");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        l1 = new LinkedList<String>(Arrays.asList("1", "2"));
        l2 = new LinkedList<String>(Arrays.asList("3", "4"));
        ms = new MultiSet(new Collection[]{l1}).append(l2);
        TestUtils.assertObjectEquals("['1','2','3','4']", ms);
        TestUtils.assertObjectEquals("['1','2','3','4']", ms.enumerator());
        Assert.assertEquals((long)4L, (long)ms.size());
        Iterator t = ms.iterator();
        t.next();
        t.remove();
        TestUtils.assertObjectEquals("['2','3','4']", ms.enumerator());
        t = ms.iterator();
        t.next();
        t.remove();
        TestUtils.assertObjectEquals("['3','4']", ms.enumerator());
        t = ms.iterator();
        t.next();
        t.remove();
        TestUtils.assertObjectEquals("['4']", ms.enumerator());
        t = ms.iterator();
        t.next();
        t.remove();
        TestUtils.assertObjectEquals("[]", ms.enumerator());
        Assert.assertEquals((long)0L, (long)ms.size());
        ms = new MultiSet(new Collection[0]);
        TestUtils.assertObjectEquals("[]", ms);
        Assert.assertEquals((long)0L, (long)ms.size());
        try {
            ms = new MultiSet(new Collection[]{null});
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new MultiSet(new Collection[0]).iterator().next();
            Assert.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        try {
            new MultiSet(new Collection[0]).iterator().remove();
            Assert.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }
}

