/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.utils;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.juneau.ObjectList;
import org.apache.juneau.internal.MultiIterable;
import org.apache.juneau.testutils.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class MultiIterableTest {
    @Test
    public void test() throws Exception {
        ObjectList l1 = new ObjectList();
        ObjectList l2 = new ObjectList((CharSequence)"['a','b']");
        ObjectList l3 = new ObjectList((CharSequence)"['c']");
        MultiIterable mi = new MultiIterable(new Iterator[]{l1.iterator(), l2.iterator()});
        mi.append(l3.iterator());
        TestUtils.assertObjectEquals("['a','b','c']", mi.iterator());
        mi = new MultiIterable(new Iterator[]{l1.iterator()});
        TestUtils.assertObjectEquals("[]", mi.iterator());
        mi = new MultiIterable(new Iterator[]{l2.iterator(), l1.iterator()});
        TestUtils.assertObjectEquals("['a','b']", mi.iterator());
        mi = new MultiIterable(new Iterator[]{l2.iterator(), l1.iterator(), l3.iterator()});
        TestUtils.assertObjectEquals("['a','b','c']", mi.iterator());
        mi = new MultiIterable(new Iterator[0]);
        TestUtils.assertObjectEquals("[]", mi.iterator());
        try {
            mi.append(null);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        mi = new MultiIterable(new Iterator[]{l1.iterator()});
        try {
            mi.iterator().next();
            Assert.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        mi = new MultiIterable(new Iterator[]{l1.iterator()});
        Iterator i = mi.iterator();
        Assert.assertFalse((boolean)i.hasNext());
        try {
            i.remove();
            Assert.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        mi = new MultiIterable(new Iterator[]{l2.iterator()});
        i = mi.iterator();
        Assert.assertTrue((boolean)i.hasNext());
        Assert.assertEquals((Object)"a", i.next());
        i.remove();
    }
}

