/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.utils;

import java.lang.reflect.Method;
import org.apache.juneau.testutils.TestUtils;
import org.apache.juneau.utils.MethodExecStats;
import org.apache.juneau.utils.MethodInvoker;
import org.junit.Assert;
import org.junit.Test;

public class MethodInvokerTest {
    @Test
    public void testBasic() throws Exception {
        Method m = A.class.getMethod("foo", new Class[0]);
        MethodExecStats mes = new MethodExecStats(m);
        MethodInvoker mi = new MethodInvoker(m, mes);
        A a = new A();
        mi.invoke((Object)a, new Object[0]);
        mi.invoke((Object)a, new Object[0]);
        mi.invoke((Object)a, new Object[0]);
        TestUtils.assertObjectMatches("{method:'A.foo',runs:3,running:0,errors:0,minTime:*,maxTime:*,avgTime:*,totalTime:*,exceptions:[]}", mes);
    }

    @Test
    public void testException() throws Exception {
        Method m = A.class.getMethod("bar", new Class[0]);
        MethodExecStats mes = new MethodExecStats(m);
        MethodInvoker mi = new MethodInvoker(m, mes);
        A a = new A();
        try {
            mi.invoke((Object)a, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            mi.invoke((Object)a, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            mi.invoke((Object)a, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        TestUtils.assertObjectMatches("{method:'A.bar',runs:3,running:0,errors:3,minTime:*,maxTime:*,avgTime:*,totalTime:*,exceptions:[{exception:'RuntimeException',hash:'*',count:3}]}", mes);
    }

    @Test
    public void testIllegalArgument() throws Exception {
        Method m = A.class.getMethod("baz", Integer.TYPE);
        MethodExecStats mes = new MethodExecStats(m);
        MethodInvoker mi = new MethodInvoker(m, mes);
        A a = new A();
        try {
            mi.invoke((Object)a, new Object[]{"x"});
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            mi.invoke((Object)a, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            mi.invoke((Object)a, new Object[]{1, "x"});
        }
        catch (Exception exception) {
            // empty catch block
        }
        TestUtils.assertObjectMatches("{method:'A.baz',runs:3,running:0,errors:3,minTime:*,maxTime:*,avgTime:*,totalTime:*,exceptions:[{exception:'IllegalArgumentException',hash:'*',count:3}]}", mes);
    }

    @Test
    public void testOtherMethods() throws Exception {
        Method m = A.class.getMethod("foo", new Class[0]);
        MethodExecStats mes = new MethodExecStats(m);
        MethodInvoker mi = new MethodInvoker(m, mes);
        Assert.assertEquals((Object)m, (Object)mi.inner());
        Assert.assertEquals((Object)"A", (Object)mi.getDeclaringClass().getSimpleName());
        Assert.assertEquals((Object)"foo", (Object)mi.getName());
    }

    public static class A {
        public int foo() {
            return 0;
        }

        public int bar() {
            throw new RuntimeException("bar");
        }

        public void baz(int x) {
        }
    }
}

