/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.utils.IOPipe;
import org.junit.Assert;
import org.junit.Test;

public class IOUtilsTest {
    @Test
    public void testRead() throws Exception {
        TestReader in = new TestReader("foobar");
        TestWriter out = new TestWriter();
        IOPipe.create((Object)in, (Object)out).run();
        Assert.assertTrue((boolean)in.closed);
        Assert.assertFalse((boolean)out.closed);
        Assert.assertEquals((Object)"foobar", (Object)out.toString());
    }

    @Test
    public void testLoadSystemResourceAsString() throws Exception {
        Assert.assertNotNull((Object)IOUtils.loadSystemResourceAsString((String)"test1.txt", (String[])new String[]{"."}));
        Assert.assertNull((Object)IOUtils.loadSystemResourceAsString((String)"test2.txt", (String[])new String[]{"."}));
        Assert.assertNotNull((Object)IOUtils.loadSystemResourceAsString((String)"test2.txt", (String[])new String[]{".", "files"}));
        Assert.assertNull((Object)IOUtils.loadSystemResourceAsString((String)"test3.txt", (String[])new String[]{"sub"}));
        Assert.assertNull((Object)IOUtils.loadSystemResourceAsString((String)"test3.txt", (String[])new String[]{"sub2"}));
        Assert.assertNotNull((Object)IOUtils.loadSystemResourceAsString((String)"test3.txt", (String[])new String[]{"."}));
        Assert.assertNotNull((Object)IOUtils.loadSystemResourceAsString((String)"test4.txt", (String[])new String[]{".", "sub"}));
        Assert.assertNotNull((Object)IOUtils.loadSystemResourceAsString((String)"test4.txt", (String[])new String[]{"sub"}));
    }

    public static class TestOutputStream
    extends ByteArrayOutputStream {
        boolean closed;

        @Override
        public void close() throws IOException {
            super.close();
            this.closed = true;
        }

        @Override
        public String toString() {
            return new String(this.toByteArray(), IOUtils.UTF8);
        }
    }

    public static class TestInputStream
    extends ByteArrayInputStream {
        boolean closed;

        public TestInputStream(String s) {
            super(s.getBytes());
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.closed = true;
        }
    }

    public static class TestWriter
    extends StringWriter {
        boolean closed;

        @Override
        public void close() {
            this.closed = true;
        }
    }

    public static class TestReader
    extends StringReader {
        boolean closed;

        public TestReader(String s) {
            super(s);
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }
}

