/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.utils.IOPipe;
import org.junit.Assert;
import org.junit.Test;

public class IOPipeTest {
    @Test
    public void testConstructor() throws Exception {
        try {
            IOPipe.create(null, (Object)new StringWriter());
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            IOPipe.create((Object)new StringReader(""), null);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            IOPipe.create((Object)new Integer(1), (Object)new StringWriter());
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            IOPipe.create((Object)"", (Object)new Integer(1));
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testClose() throws Exception {
        TestReader in = new TestReader("foobar");
        TestWriter out = new TestWriter();
        IOPipe.create((Object)in, (Object)out).run();
        Assert.assertTrue((boolean)in.closed);
        Assert.assertFalse((boolean)out.closed);
        Assert.assertEquals((Object)"foobar", (Object)out.toString());
        in = new TestReader("foobar");
        out = new TestWriter();
        IOPipe.create((Object)in, (Object)out).closeOut().run();
        Assert.assertTrue((boolean)in.closed);
        Assert.assertTrue((boolean)out.closed);
        Assert.assertEquals((Object)"foobar", (Object)out.toString());
        in = new TestReader("foobar");
        out = new TestWriter();
        IOPipe.create((Object)in, (Object)out).close(false, true).run();
        Assert.assertFalse((boolean)in.closed);
        Assert.assertTrue((boolean)out.closed);
        Assert.assertEquals((Object)"foobar", (Object)out.toString());
        TestInputStream in2 = new TestInputStream("foobar");
        TestOutputStream out2 = new TestOutputStream();
        IOPipe.create((Object)in2, (Object)out2).run();
        Assert.assertTrue((boolean)in2.closed);
        Assert.assertFalse((boolean)out2.closed);
        Assert.assertEquals((Object)"foobar", (Object)out2.toString());
        in2 = new TestInputStream("foobar");
        out2 = new TestOutputStream();
        IOPipe.create((Object)in2, (Object)out2).closeOut().run();
        Assert.assertTrue((boolean)in2.closed);
        Assert.assertTrue((boolean)out2.closed);
        Assert.assertEquals((Object)"foobar", (Object)out2.toString());
        in2 = new TestInputStream("foobar");
        out2 = new TestOutputStream();
        IOPipe.create((Object)in2, (Object)out2).close(false, true).run();
        Assert.assertFalse((boolean)in2.closed);
        Assert.assertTrue((boolean)out2.closed);
        Assert.assertEquals((Object)"foobar", (Object)out2.toString());
        in = new TestReader("foobar");
        out2 = new TestOutputStream();
        IOPipe.create((Object)in, (Object)out2).run();
        Assert.assertTrue((boolean)in.closed);
        Assert.assertFalse((boolean)out2.closed);
        Assert.assertEquals((Object)"foobar", (Object)out.toString());
        in = new TestReader("foobar");
        out2 = new TestOutputStream();
        IOPipe.create((Object)in, (Object)out2).closeOut().run();
        Assert.assertTrue((boolean)in.closed);
        Assert.assertTrue((boolean)out2.closed);
        Assert.assertEquals((Object)"foobar", (Object)out.toString());
        in = new TestReader("foobar");
        out2 = new TestOutputStream();
        IOPipe.create((Object)in, (Object)out2).close(false, true).run();
        Assert.assertFalse((boolean)in.closed);
        Assert.assertTrue((boolean)out2.closed);
        Assert.assertEquals((Object)"foobar", (Object)out.toString());
        in2 = new TestInputStream("foobar");
        out = new TestWriter();
        IOPipe.create((Object)in2, (Object)out).run();
        Assert.assertTrue((boolean)in2.closed);
        Assert.assertFalse((boolean)out.closed);
        Assert.assertEquals((Object)"foobar", (Object)out2.toString());
        in2 = new TestInputStream("foobar");
        out = new TestWriter();
        IOPipe.create((Object)in2, (Object)out).closeOut().run();
        Assert.assertTrue((boolean)in2.closed);
        Assert.assertTrue((boolean)out.closed);
        Assert.assertEquals((Object)"foobar", (Object)out2.toString());
        in2 = new TestInputStream("foobar");
        out = new TestWriter();
        IOPipe.create((Object)in2, (Object)out).close(false, true).run();
        Assert.assertFalse((boolean)in2.closed);
        Assert.assertTrue((boolean)out.closed);
        Assert.assertEquals((Object)"foobar", (Object)out2.toString());
    }

    @Test
    public void testByLines() throws Exception {
        TestReader in = new TestReader("foo\nbar");
        TestWriter out = new TestWriter(){

            @Override
            public void write(String s) {
                super.write("[" + s + "]");
            }
        };
        IOPipe.create((Object)in, (Object)out).byLines().run();
        Assert.assertEquals((Object)"[foo][][bar][]", (Object)out.toString().replaceAll("[\\r\\n]", ""));
        in = new TestReader("foo\nbar");
        out = new TestWriter(){

            @Override
            public void write(String s) {
                super.write("[" + s + "]");
            }
        };
        IOPipe.create((Object)in, (Object)out).byLines(true).run();
        Assert.assertEquals((Object)"[foo][][bar][]", (Object)out.toString().replaceAll("[\\r\\n]", ""));
        in = new TestReader("foo\nbar");
        out = new TestWriter(){

            @Override
            public void write(String s) {
                super.write("[" + s + "]");
            }
        };
        IOPipe.create((Object)in, (Object)out).byLines(false).run();
        Assert.assertEquals((Object)"foo\nbar", (Object)out.toString());
    }

    @Test
    public void testLineProcessor() throws Exception {
        IOPipe.LineProcessor lp = new IOPipe.LineProcessor(){

            public String process(String line) {
                return "[" + line + "]";
            }
        };
        TestReader in = new TestReader("foo\nbar");
        TestWriter out = new TestWriter();
        IOPipe.create((Object)in, (Object)out).lineProcessor(lp).run();
        Assert.assertEquals((Object)"[foo][bar]", (Object)out.toString().replaceAll("[\\r\\n]", ""));
        IOPipe.LineProcessor lp2 = new IOPipe.LineProcessor(){

            public String process(String line) {
                return line.equals("foo") ? null : line;
            }
        };
        in = new TestReader("foo\nbar");
        out = new TestWriter();
        IOPipe.create((Object)in, (Object)out).lineProcessor(lp2).run();
        Assert.assertEquals((Object)"bar", (Object)out.toString().replaceAll("[\\r\\n]", ""));
        TestInputStream in2 = new TestInputStream("foo\nbar");
        TestOutputStream out2 = new TestOutputStream();
        IOPipe.create((Object)in2, (Object)out2).lineProcessor(lp).run();
        Assert.assertEquals((Object)"[foo][bar]", (Object)out2.toString().replaceAll("[\\r\\n]", ""));
    }

    @Test
    public void testBuffSize() throws Exception {
        TestReader in = new TestReader("foobar");
        TestWriter out = new TestWriter();
        IOPipe.create((Object)in, (Object)out).buffSize(1).run();
        Assert.assertEquals((Object)"foobar", (Object)out.toString().replaceAll("[\\r\\n]", ""));
        try {
            IOPipe.create((Object)in, (Object)out).buffSize(0);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public static class TestOutputStream
    extends ByteArrayOutputStream {
        boolean closed;

        @Override
        public void close() throws IOException {
            super.close();
            this.closed = true;
        }

        @Override
        public String toString() {
            return new String(this.toByteArray(), IOUtils.UTF8);
        }
    }

    public static class TestInputStream
    extends ByteArrayInputStream {
        boolean closed;

        public TestInputStream(String s) {
            super(s.getBytes());
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.closed = true;
        }
    }

    public static class TestWriter
    extends StringWriter {
        boolean closed;

        @Override
        public void close() {
            this.closed = true;
        }
    }

    public static class TestReader
    extends StringReader {
        boolean closed;

        public TestReader(String s) {
            super(s);
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }
}

