/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.utils;

import java.lang.reflect.Method;
import org.apache.juneau.internal.HttpUtils;
import org.junit.Assert;
import org.junit.Test;

public class HttpUtilsTest {
    @Test
    public void testGetHttpMethod_detect_nodefault() throws Exception {
        Assert.assertEquals((Object)"GET", (Object)HttpUtils.detectHttpMethod((Method)A.class.getMethod("doGet", new Class[0]), (boolean)true, null));
        Assert.assertEquals((Object)"GET", (Object)HttpUtils.detectHttpMethod((Method)A.class.getMethod("doGET", new Class[0]), (boolean)true, null));
        Assert.assertEquals((Object)"POST", (Object)HttpUtils.detectHttpMethod((Method)A.class.getMethod("doPOST", new Class[0]), (boolean)true, null));
        Assert.assertEquals(null, (Object)HttpUtils.detectHttpMethod((Method)A.class.getMethod("doFOO", new Class[0]), (boolean)true, null));
        Assert.assertEquals((Object)"GET", (Object)HttpUtils.detectHttpMethod((Method)A.class.getMethod("getFoo", new Class[0]), (boolean)true, null));
        Assert.assertEquals((Object)"POST", (Object)HttpUtils.detectHttpMethod((Method)A.class.getMethod("postFoo", new Class[0]), (boolean)true, null));
        Assert.assertEquals((Object)"GET", (Object)HttpUtils.detectHttpMethod((Method)A.class.getMethod("get", new Class[0]), (boolean)true, null));
        Assert.assertEquals((Object)"POST", (Object)HttpUtils.detectHttpMethod((Method)A.class.getMethod("post", new Class[0]), (boolean)true, null));
        Assert.assertEquals(null, (Object)HttpUtils.detectHttpMethod((Method)A.class.getMethod("createFoo", new Class[0]), (boolean)true, null));
    }

    @Test
    public void testGetHttpMethod_detect_default() throws Exception {
        Assert.assertEquals((Object)"GET", (Object)HttpUtils.detectHttpMethod((Method)A.class.getMethod("doGet", new Class[0]), (boolean)true, (String)"DELETE"));
        Assert.assertEquals((Object)"GET", (Object)HttpUtils.detectHttpMethod((Method)A.class.getMethod("doGET", new Class[0]), (boolean)true, (String)"DELETE"));
        Assert.assertEquals((Object)"POST", (Object)HttpUtils.detectHttpMethod((Method)A.class.getMethod("doPOST", new Class[0]), (boolean)true, (String)"DELETE"));
        Assert.assertEquals((Object)"DELETE", (Object)HttpUtils.detectHttpMethod((Method)A.class.getMethod("doFOO", new Class[0]), (boolean)true, (String)"DELETE"));
        Assert.assertEquals((Object)"GET", (Object)HttpUtils.detectHttpMethod((Method)A.class.getMethod("getFoo", new Class[0]), (boolean)true, (String)"DELETE"));
        Assert.assertEquals((Object)"POST", (Object)HttpUtils.detectHttpMethod((Method)A.class.getMethod("postFoo", new Class[0]), (boolean)true, (String)"DELETE"));
        Assert.assertEquals((Object)"GET", (Object)HttpUtils.detectHttpMethod((Method)A.class.getMethod("get", new Class[0]), (boolean)true, (String)"DELETE"));
        Assert.assertEquals((Object)"POST", (Object)HttpUtils.detectHttpMethod((Method)A.class.getMethod("post", new Class[0]), (boolean)true, (String)"DELETE"));
        Assert.assertEquals((Object)"DELETE", (Object)HttpUtils.detectHttpMethod((Method)A.class.getMethod("createFoo", new Class[0]), (boolean)true, (String)"DELETE"));
    }

    @Test
    public void testGetHttpMethod_nodetect_nodefault() throws Exception {
        Assert.assertEquals(null, (Object)HttpUtils.detectHttpMethod((Method)A.class.getMethod("doGet", new Class[0]), (boolean)false, null));
        Assert.assertEquals(null, (Object)HttpUtils.detectHttpMethod((Method)A.class.getMethod("doGET", new Class[0]), (boolean)false, null));
        Assert.assertEquals(null, (Object)HttpUtils.detectHttpMethod((Method)A.class.getMethod("doPOST", new Class[0]), (boolean)false, null));
        Assert.assertEquals(null, (Object)HttpUtils.detectHttpMethod((Method)A.class.getMethod("doFOO", new Class[0]), (boolean)false, null));
        Assert.assertEquals(null, (Object)HttpUtils.detectHttpMethod((Method)A.class.getMethod("getFoo", new Class[0]), (boolean)false, null));
        Assert.assertEquals(null, (Object)HttpUtils.detectHttpMethod((Method)A.class.getMethod("postFoo", new Class[0]), (boolean)false, null));
        Assert.assertEquals(null, (Object)HttpUtils.detectHttpMethod((Method)A.class.getMethod("get", new Class[0]), (boolean)false, null));
        Assert.assertEquals(null, (Object)HttpUtils.detectHttpMethod((Method)A.class.getMethod("post", new Class[0]), (boolean)false, null));
        Assert.assertEquals(null, (Object)HttpUtils.detectHttpMethod((Method)A.class.getMethod("createFoo", new Class[0]), (boolean)false, null));
    }

    @Test
    public void testGetHttpMethod_nodetect_default() throws Exception {
        Assert.assertEquals((Object)"DELETE", (Object)HttpUtils.detectHttpMethod((Method)A.class.getMethod("doGet", new Class[0]), (boolean)false, (String)"DELETE"));
        Assert.assertEquals((Object)"DELETE", (Object)HttpUtils.detectHttpMethod((Method)A.class.getMethod("doGET", new Class[0]), (boolean)false, (String)"DELETE"));
        Assert.assertEquals((Object)"DELETE", (Object)HttpUtils.detectHttpMethod((Method)A.class.getMethod("doPOST", new Class[0]), (boolean)false, (String)"DELETE"));
        Assert.assertEquals((Object)"DELETE", (Object)HttpUtils.detectHttpMethod((Method)A.class.getMethod("doFOO", new Class[0]), (boolean)false, (String)"DELETE"));
        Assert.assertEquals((Object)"DELETE", (Object)HttpUtils.detectHttpMethod((Method)A.class.getMethod("getFoo", new Class[0]), (boolean)false, (String)"DELETE"));
        Assert.assertEquals((Object)"DELETE", (Object)HttpUtils.detectHttpMethod((Method)A.class.getMethod("postFoo", new Class[0]), (boolean)false, (String)"DELETE"));
        Assert.assertEquals((Object)"DELETE", (Object)HttpUtils.detectHttpMethod((Method)A.class.getMethod("get", new Class[0]), (boolean)false, (String)"DELETE"));
        Assert.assertEquals((Object)"DELETE", (Object)HttpUtils.detectHttpMethod((Method)A.class.getMethod("post", new Class[0]), (boolean)false, (String)"DELETE"));
        Assert.assertEquals((Object)"DELETE", (Object)HttpUtils.detectHttpMethod((Method)A.class.getMethod("createFoo", new Class[0]), (boolean)false, (String)"DELETE"));
    }

    @Test
    public void testGetHttpPath_noargs_detect() throws Exception {
        Assert.assertEquals((Object)"/", (Object)HttpUtils.detectHttpPath((Method)B1.class.getMethod("doGet", new Class[0]), (boolean)true));
        Assert.assertEquals((Object)"/", (Object)HttpUtils.detectHttpPath((Method)B1.class.getMethod("doGET", new Class[0]), (boolean)true));
        Assert.assertEquals((Object)"/", (Object)HttpUtils.detectHttpPath((Method)B1.class.getMethod("doPOST", new Class[0]), (boolean)true));
        Assert.assertEquals((Object)"/doFOO", (Object)HttpUtils.detectHttpPath((Method)B1.class.getMethod("doFOO", new Class[0]), (boolean)true));
        Assert.assertEquals((Object)"/foo", (Object)HttpUtils.detectHttpPath((Method)B1.class.getMethod("getFoo", new Class[0]), (boolean)true));
        Assert.assertEquals((Object)"/foo", (Object)HttpUtils.detectHttpPath((Method)B1.class.getMethod("postFoo", new Class[0]), (boolean)true));
        Assert.assertEquals((Object)"/", (Object)HttpUtils.detectHttpPath((Method)B1.class.getMethod("get", new Class[0]), (boolean)true));
        Assert.assertEquals((Object)"/", (Object)HttpUtils.detectHttpPath((Method)B1.class.getMethod("post", new Class[0]), (boolean)true));
        Assert.assertEquals((Object)"/createFoo", (Object)HttpUtils.detectHttpPath((Method)B1.class.getMethod("createFoo", new Class[0]), (boolean)true));
    }

    @Test
    public void testGetHttpPath_noargs_nodetect() throws Exception {
        Assert.assertEquals((Object)"/doGet", (Object)HttpUtils.detectHttpPath((Method)B1.class.getMethod("doGet", new Class[0]), (boolean)false));
        Assert.assertEquals((Object)"/doGET", (Object)HttpUtils.detectHttpPath((Method)B1.class.getMethod("doGET", new Class[0]), (boolean)false));
        Assert.assertEquals((Object)"/doPOST", (Object)HttpUtils.detectHttpPath((Method)B1.class.getMethod("doPOST", new Class[0]), (boolean)false));
        Assert.assertEquals((Object)"/doFOO", (Object)HttpUtils.detectHttpPath((Method)B1.class.getMethod("doFOO", new Class[0]), (boolean)false));
        Assert.assertEquals((Object)"/getFoo", (Object)HttpUtils.detectHttpPath((Method)B1.class.getMethod("getFoo", new Class[0]), (boolean)false));
        Assert.assertEquals((Object)"/postFoo", (Object)HttpUtils.detectHttpPath((Method)B1.class.getMethod("postFoo", new Class[0]), (boolean)false));
        Assert.assertEquals((Object)"/get", (Object)HttpUtils.detectHttpPath((Method)B1.class.getMethod("get", new Class[0]), (boolean)false));
        Assert.assertEquals((Object)"/post", (Object)HttpUtils.detectHttpPath((Method)B1.class.getMethod("post", new Class[0]), (boolean)false));
        Assert.assertEquals((Object)"/createFoo", (Object)HttpUtils.detectHttpPath((Method)B1.class.getMethod("createFoo", new Class[0]), (boolean)false));
    }

    @Test
    public void testGetHttpPath_args_detect() throws Exception {
        Assert.assertEquals((Object)"/", (Object)HttpUtils.detectHttpPath((Method)B2.class.getMethod("doGet", Integer.TYPE, A.class), (boolean)true));
        Assert.assertEquals((Object)"/", (Object)HttpUtils.detectHttpPath((Method)B2.class.getMethod("doGET", Integer.TYPE, A.class), (boolean)true));
        Assert.assertEquals((Object)"/", (Object)HttpUtils.detectHttpPath((Method)B2.class.getMethod("doPOST", Integer.TYPE, A.class), (boolean)true));
        Assert.assertEquals((Object)"/doFOO", (Object)HttpUtils.detectHttpPath((Method)B2.class.getMethod("doFOO", Integer.TYPE, A.class), (boolean)true));
        Assert.assertEquals((Object)"/foo", (Object)HttpUtils.detectHttpPath((Method)B2.class.getMethod("getFoo", Integer.TYPE, A.class), (boolean)true));
        Assert.assertEquals((Object)"/foo", (Object)HttpUtils.detectHttpPath((Method)B2.class.getMethod("postFoo", Integer.TYPE, A.class), (boolean)true));
        Assert.assertEquals((Object)"/", (Object)HttpUtils.detectHttpPath((Method)B2.class.getMethod("get", Integer.TYPE, A.class), (boolean)true));
        Assert.assertEquals((Object)"/", (Object)HttpUtils.detectHttpPath((Method)B2.class.getMethod("post", Integer.TYPE, A.class), (boolean)true));
        Assert.assertEquals((Object)"/createFoo", (Object)HttpUtils.detectHttpPath((Method)B2.class.getMethod("createFoo", Integer.TYPE, A.class), (boolean)true));
    }

    @Test
    public void testGetHttpPath_args_nodetect() throws Exception {
        Assert.assertEquals((Object)"/doGet", (Object)HttpUtils.detectHttpPath((Method)B2.class.getMethod("doGet", Integer.TYPE, A.class), (boolean)false));
        Assert.assertEquals((Object)"/doGET", (Object)HttpUtils.detectHttpPath((Method)B2.class.getMethod("doGET", Integer.TYPE, A.class), (boolean)false));
        Assert.assertEquals((Object)"/doPOST", (Object)HttpUtils.detectHttpPath((Method)B2.class.getMethod("doPOST", Integer.TYPE, A.class), (boolean)false));
        Assert.assertEquals((Object)"/doFOO", (Object)HttpUtils.detectHttpPath((Method)B2.class.getMethod("doFOO", Integer.TYPE, A.class), (boolean)false));
        Assert.assertEquals((Object)"/getFoo", (Object)HttpUtils.detectHttpPath((Method)B2.class.getMethod("getFoo", Integer.TYPE, A.class), (boolean)false));
        Assert.assertEquals((Object)"/postFoo", (Object)HttpUtils.detectHttpPath((Method)B2.class.getMethod("postFoo", Integer.TYPE, A.class), (boolean)false));
        Assert.assertEquals((Object)"/get", (Object)HttpUtils.detectHttpPath((Method)B2.class.getMethod("get", Integer.TYPE, A.class), (boolean)false));
        Assert.assertEquals((Object)"/post", (Object)HttpUtils.detectHttpPath((Method)B2.class.getMethod("post", Integer.TYPE, A.class), (boolean)false));
        Assert.assertEquals((Object)"/createFoo", (Object)HttpUtils.detectHttpPath((Method)B2.class.getMethod("createFoo", Integer.TYPE, A.class), (boolean)false));
    }

    public static interface B2 {
        public void doGet(int var1, A var2);

        public void doGET(int var1, A var2);

        public void doPOST(int var1, A var2);

        public void doFOO(int var1, A var2);

        public void getFoo(int var1, A var2);

        public void postFoo(int var1, A var2);

        public void get(int var1, A var2);

        public void post(int var1, A var2);

        public void createFoo(int var1, A var2);
    }

    public static interface B1 {
        public void doGet();

        public void doGET();

        public void doPOST();

        public void doFOO();

        public void getFoo();

        public void postFoo();

        public void get();

        public void post();

        public void createFoo();
    }

    public static interface A {
        public void doGet();

        public void doGET();

        public void doPOST();

        public void doFOO();

        public void getFoo();

        public void postFoo();

        public void get();

        public void post();

        public void createFoo();
    }
}

