/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.utils;

import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.juneau.internal.CollectionUtils;
import org.junit.Assert;
import org.junit.Test;

public class CollectionUtilsTest {
    private String[] strings(String s) {
        return StringUtils.split((String)s, (char)',');
    }

    @Test
    public void testSortedCaseInsensitiveSet() {
        Set s = CollectionUtils.newSortedCaseInsensitiveSet((String)"foo,Bar,BAZ");
        for (String ss : this.strings("foo,Foo,FOO,bar,Bar,BAR,baz,Baz,BAZ")) {
            Assert.assertTrue((boolean)s.contains(ss));
        }
        for (String ss : this.strings("qux")) {
            Assert.assertFalse((boolean)s.contains(ss));
        }
    }

    @Test
    public void testSortedCaseInsensitiveSet_empty() {
        Set s = CollectionUtils.newSortedCaseInsensitiveSet((String)"");
        Assert.assertFalse((boolean)s.contains("foo"));
        Assert.assertFalse((boolean)s.contains(""));
        Assert.assertFalse((boolean)s.contains(null));
    }

    @Test
    public void testSortedCaseInsensitiveSet_null() {
        String ss = null;
        Set s = CollectionUtils.newSortedCaseInsensitiveSet(ss);
        Assert.assertFalse((boolean)s.contains("foo"));
        Assert.assertFalse((boolean)s.contains(""));
        Assert.assertFalse((boolean)s.contains(null));
    }

    @Test
    public void testSortedCaseInsensitiveSet_containsNull() {
        Set s = CollectionUtils.newSortedCaseInsensitiveSet((String[])new String[]{null, "foo"});
        Assert.assertTrue((boolean)s.contains("foo"));
        Assert.assertFalse((boolean)s.contains(""));
        Assert.assertFalse((boolean)s.contains(null));
    }
}

