/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.utils;

import java.util.Set;
import org.apache.juneau.BeanContext;
import org.apache.juneau.utils.ASet;
import org.apache.juneau.utils.BeanDiff;
import org.junit.Assert;
import org.junit.Test;

public class BeanDiffTest {
    @Test
    public void testSame() throws Exception {
        BeanDiff bd = BeanDiff.create((Object)A.create(1, "a"), (Object)A.create(1, "a")).build();
        Assert.assertFalse((boolean)bd.hasDiffs());
        Assert.assertEquals((Object)"{v1:{},v2:{}}", (Object)bd.toString());
    }

    @Test
    public void testDifferent() throws Exception {
        BeanDiff bd = BeanDiff.create((Object)A.create(1, "a"), (Object)A.create(2, "b")).build();
        Assert.assertTrue((boolean)bd.hasDiffs());
        Assert.assertEquals((Object)"{v1:{f1:1,f2:'a'},v2:{f1:2,f2:'b'}}", (Object)bd.toString());
    }

    @Test
    public void testFirstNull() throws Exception {
        BeanDiff bd = BeanDiff.create(null, (Object)A.create(2, "b")).build();
        Assert.assertTrue((boolean)bd.hasDiffs());
        Assert.assertEquals((Object)"{v1:{},v2:{f1:2,f2:'b'}}", (Object)bd.toString());
    }

    @Test
    public void testSecondNull() throws Exception {
        BeanDiff bd = BeanDiff.create((Object)A.create(1, "a"), null).build();
        Assert.assertTrue((boolean)bd.hasDiffs());
        Assert.assertEquals((Object)"{v1:{f1:1,f2:'a'},v2:{}}", (Object)bd.toString());
    }

    @Test
    public void testBothNull() throws Exception {
        BeanDiff bd = BeanDiff.create(null, null).build();
        Assert.assertFalse((boolean)bd.hasDiffs());
        Assert.assertEquals((Object)"{v1:{},v2:{}}", (Object)bd.toString());
    }

    @Test
    public void testNullFields() throws Exception {
        BeanDiff bd = BeanDiff.create((Object)A.create(1, null), (Object)A.create(2, "b")).build();
        Assert.assertTrue((boolean)bd.hasDiffs());
        Assert.assertEquals((Object)"{v1:{f1:1},v2:{f1:2,f2:'b'}}", (Object)bd.toString());
    }

    @Test
    public void testIncludes() throws Exception {
        BeanDiff bd = BeanDiff.create((Object)A.create(1, null), (Object)A.create(2, "b")).include(new String[]{"f1"}).build();
        Assert.assertTrue((boolean)bd.hasDiffs());
        Assert.assertEquals((Object)"{v1:{f1:1},v2:{f1:2}}", (Object)bd.toString());
    }

    @Test
    public void testIncludesSet() throws Exception {
        BeanDiff bd = BeanDiff.create((Object)A.create(1, null), (Object)A.create(2, "b")).include((Set)ASet.create((Object[])new String[]{"f1"})).build();
        Assert.assertTrue((boolean)bd.hasDiffs());
        Assert.assertEquals((Object)"{v1:{f1:1},v2:{f1:2}}", (Object)bd.toString());
    }

    @Test
    public void testExcludes() throws Exception {
        BeanDiff bd = BeanDiff.create((Object)A.create(1, null), (Object)A.create(2, "b")).exclude(new String[]{"f2"}).build();
        Assert.assertTrue((boolean)bd.hasDiffs());
        Assert.assertEquals((Object)"{v1:{f1:1},v2:{f1:2}}", (Object)bd.toString());
    }

    @Test
    public void testExcludesSet() throws Exception {
        BeanDiff bd = BeanDiff.create((Object)A.create(1, null), (Object)A.create(2, "b")).exclude((Set)ASet.create((Object[])new String[]{"f2"})).build();
        Assert.assertTrue((boolean)bd.hasDiffs());
        Assert.assertEquals((Object)"{v1:{f1:1},v2:{f1:2}}", (Object)bd.toString());
    }

    @Test
    public void testDifferentBeanContext() throws Exception {
        BeanDiff bd = BeanDiff.create((Object)A.create(1, null), (Object)A.create(2, "b")).beanContext(BeanContext.DEFAULT_SORTED).build();
        Assert.assertTrue((boolean)bd.hasDiffs());
        Assert.assertEquals((Object)"{v1:{f1:1},v2:{f1:2,f2:'b'}}", (Object)bd.toString());
    }

    public static class A {
        public int f1;
        public String f2;

        static A create(int f1, String f2) {
            A a = new A();
            a.f1 = f1;
            a.f2 = f2;
            return a;
        }
    }
}

