/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.utils;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.testutils.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class ArrayUtilsTest {
    @Test
    public void testArrayIterator() throws Exception {
        TestUtils.assertObjectEquals("[1,2,3]", ArrayUtils.iterator((Object)new Object[]{1, 2, 3}));
        TestUtils.assertObjectEquals("[1,2,3]", ArrayUtils.iterator((Object)new int[]{1, 2, 3}));
        TestUtils.assertObjectEquals("[]", ArrayUtils.iterator(null));
    }

    @Test
    public void testAppendArrayToArray() throws Exception {
        Object[] s = new String[]{};
        s = (String[])ArrayUtils.append((Object[])s, (Object[])new String[]{"a", "b"});
        TestUtils.assertObjectEquals("['a','b']", s);
        s = (String[])ArrayUtils.append((Object[])s, (Object[])new String[]{"c"});
        TestUtils.assertObjectEquals("['a','b','c']", s);
        s = (String[])ArrayUtils.append((Object[])s, (Object[])new String[0]);
        TestUtils.assertObjectEquals("['a','b','c']", s);
        Object[] o = ArrayUtils.append((Object[])null, (Object[])new Object[0]);
        TestUtils.assertObjectEquals("[]", o);
        s = (String[])ArrayUtils.append((Object[])null, (Object[])new String[]{"a", "b"});
        TestUtils.assertObjectEquals("['a','b']", s);
    }

    @Test
    public void testAppendCollectionToArray() throws Exception {
        Object[] s = new String[]{};
        s = (String[])ArrayUtils.append((Object[])s, Arrays.asList("a", "b"));
        TestUtils.assertObjectEquals("['a','b']", s);
        s = (String[])ArrayUtils.append((Object[])s, Arrays.asList("c"));
        TestUtils.assertObjectEquals("['a','b','c']", s);
        s = (String[])ArrayUtils.append((Object[])s, Arrays.asList(new String[0]));
        TestUtils.assertObjectEquals("['a','b','c']", s);
        try {
            ArrayUtils.append((Object[])null, Collections.emptyList());
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testReverse() throws Exception {
        Object[] s = null;
        Assert.assertNull((Object)ArrayUtils.reverse(s));
        s = new String[]{};
        TestUtils.assertObjectEquals("[]", ArrayUtils.reverse((Object[])s));
        s = new String[]{"a"};
        TestUtils.assertObjectEquals("['a']", ArrayUtils.reverse((Object[])s));
        s = new String[]{"a", "b"};
        TestUtils.assertObjectEquals("['b','a']", ArrayUtils.reverse((Object[])s));
        s = new String[]{"a", "b", "c"};
        TestUtils.assertObjectEquals("['c','b','a']", ArrayUtils.reverse((Object[])s));
    }

    @Test
    public void testReverseInline() throws Exception {
        Object[] s = null;
        Assert.assertNull((Object)ArrayUtils.reverseInline(s));
        s = new String[]{};
        TestUtils.assertObjectEquals("[]", ArrayUtils.reverseInline((Object[])s));
        s = new String[]{"a"};
        TestUtils.assertObjectEquals("['a']", ArrayUtils.reverseInline((Object[])s));
        s = new String[]{"a", "b"};
        TestUtils.assertObjectEquals("['b','a']", ArrayUtils.reverseInline((Object[])s));
        s = new String[]{"a", "b", "c"};
        TestUtils.assertObjectEquals("['c','b','a']", ArrayUtils.reverseInline((Object[])s));
    }

    @Test
    public void testToReverseArray() throws Exception {
        String[] s = null;
        Assert.assertNull((Object)ArrayUtils.toReverseArray(String.class, null));
        s = new String[]{};
        TestUtils.assertObjectEquals("[]", ArrayUtils.toReverseArray(String.class, Arrays.asList(s)));
        s = new String[]{"a"};
        TestUtils.assertObjectEquals("['a']", ArrayUtils.toReverseArray(String.class, Arrays.asList(s)));
        s = new String[]{"a", "b"};
        TestUtils.assertObjectEquals("['b','a']", ArrayUtils.toReverseArray(String.class, Arrays.asList(s)));
        s = new String[]{"a", "b", "c"};
        TestUtils.assertObjectEquals("['c','b','a']", ArrayUtils.toReverseArray(String.class, Arrays.asList(s)));
    }

    @Test
    public void testAsSet() throws Exception {
        Object[] s = null;
        try {
            ArrayUtils.asSet(s);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        s = new String[]{"a"};
        Iterator i = ArrayUtils.asSet((Object[])s).iterator();
        Assert.assertEquals((Object)"a", i.next());
        try {
            i.remove();
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            i.next();
            Assert.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testIterator() throws Exception {
        String[] s = null;
        s = new String[]{"a"};
        Iterator i = ArrayUtils.iterator((Object)s);
        Assert.assertEquals((Object)"a", i.next());
        try {
            i.remove();
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            i.next();
            Assert.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testCombine() throws Exception {
        String[] s1 = new String[]{"a"};
        String[] s2 = new String[]{"b"};
        TestUtils.assertObjectEquals("['a','b']", ArrayUtils.combine((Object[][])new String[][]{s1, s2}));
        TestUtils.assertObjectEquals("['a']", ArrayUtils.combine((Object[][])new String[][]{s1}));
        TestUtils.assertObjectEquals("['b']", ArrayUtils.combine((Object[][])new String[][]{s2}));
        TestUtils.assertObjectEquals("['a']", ArrayUtils.combine((Object[][])new String[][]{s1, null}));
        TestUtils.assertObjectEquals("['b']", ArrayUtils.combine((Object[][])new String[][]{null, s2}));
        Assert.assertNull((Object)ArrayUtils.combine((Object[][])new Object[][]{null, null}));
        Assert.assertNull((Object)ArrayUtils.combine((Object[][])new Object[0][]));
    }
}

