/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.urlencoding;

import java.util.LinkedHashMap;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.annotation.Beanp;
import org.apache.juneau.urlencoding.DTOs;
import org.apache.juneau.urlencoding.DTOs2;
import org.apache.juneau.urlencoding.UrlEncodingSerializer;
import org.apache.juneau.utils.AList;
import org.apache.juneau.utils.AMap;
import org.junit.Assert;
import org.junit.Test;

public class UrlEncodingSerializerTest {
    static UrlEncodingSerializer s = UrlEncodingSerializer.DEFAULT.builder().addRootType().build();
    static UrlEncodingSerializer sr = UrlEncodingSerializer.DEFAULT_READABLE.builder().addRootType().build();

    @Test
    public void testBasic() throws Exception {
        Object t = "a";
        Assert.assertEquals((Object)"_value=a", (Object)s.serialize(t));
        t = new ObjectMap((CharSequence)"{a:'a'}");
        Assert.assertEquals((Object)"a=a", (Object)s.serialize(t));
        Assert.assertEquals((Object)"a=a", (Object)sr.serialize(t));
        t = new ObjectMap((CharSequence)"{a:'b',c:123,d:false,e:true,f:null}");
        Assert.assertEquals((Object)"a=b&c=123&d=false&e=true&f=null", (Object)s.serialize(t));
        Assert.assertEquals((Object)"a=b\n&c=123\n&d=false\n&e=true\n&f=null", (Object)sr.serialize(t));
        t = new ObjectMap((CharSequence)"{a:{a:'b',c:123,d:false,e:true,f:null}}");
        Assert.assertEquals((Object)"a=(a=b,c=123,d=false,e=true,f=null)", (Object)s.serialize(t));
        Assert.assertEquals((Object)"a=(\n\ta=b,\n\tc=123,\n\td=false,\n\te=true,\n\tf=null\n)", (Object)sr.serialize(t));
        t = new ObjectMap((CharSequence)"{a:'b',c:'123',d:'false',e:'true',f:'null'}");
        Assert.assertEquals((Object)"a=b&c='123'&d='false'&e='true'&f='null'", (Object)s.serialize(t));
        Assert.assertEquals((Object)"a=b\n&c='123'\n&d='false'\n&e='true'\n&f='null'", (Object)sr.serialize(t));
        t = null;
        Assert.assertEquals((Object)"_value=null", (Object)s.serialize(t));
        Assert.assertEquals((Object)"_value=null", (Object)sr.serialize(t));
        t = new ObjectMap((CharSequence)"{null:null}");
        Assert.assertEquals((Object)"null=null", (Object)s.serialize(t));
        Assert.assertEquals((Object)"null=null", (Object)sr.serialize(t));
        t = new ObjectMap((CharSequence)"{null:{null:null}}");
        Assert.assertEquals((Object)"null=(null=null)", (Object)s.serialize(t));
        Assert.assertEquals((Object)"null=(\n\tnull=null\n)", (Object)sr.serialize(t));
        t = new String[]{};
        Assert.assertEquals((Object)"", (Object)s.serialize(t));
        Assert.assertEquals((Object)"", (Object)sr.serialize(t));
        t = new ObjectMap((CharSequence)"{x:[]}");
        Assert.assertEquals((Object)"x=@()", (Object)s.serialize(t));
        Assert.assertEquals((Object)"x=@()", (Object)sr.serialize(t));
        t = new String[1][0];
        Assert.assertEquals((Object)"0=@()", (Object)s.serialize(t));
        Assert.assertEquals((Object)"0=@()", (Object)sr.serialize(t));
        t = new String[]{""};
        Assert.assertEquals((Object)"0=''", (Object)s.serialize(t));
        Assert.assertEquals((Object)"0=''", (Object)sr.serialize(t));
        t = new ObjectMap((CharSequence)"{x:['']}");
        Assert.assertEquals((Object)"x=@('')", (Object)s.serialize(t));
        Assert.assertEquals((Object)"x=@(\n\t''\n)", (Object)sr.serialize(t));
        t = new String[]{"", "", ""};
        Assert.assertEquals((Object)"0=''&1=''&2=''", (Object)s.serialize(t));
        Assert.assertEquals((Object)"0=''\n&1=''\n&2=''", (Object)sr.serialize(t));
        t = "\u0000";
        Assert.assertEquals((Object)"_value=%00", (Object)s.serialize(t));
        Assert.assertEquals((Object)"_value=%00", (Object)sr.serialize(t));
        t = new ObjectMap((CharSequence)"{'\u0000':'\u0000'}");
        Assert.assertEquals((Object)"%00=%00", (Object)s.serialize(t));
        Assert.assertEquals((Object)"%00=%00", (Object)sr.serialize(t));
        t = false;
        Assert.assertEquals((Object)"_value=false", (Object)s.serialize(t));
        Assert.assertEquals((Object)"_value=false", (Object)sr.serialize(t));
        t = new ObjectMap((CharSequence)"{x:false}");
        Assert.assertEquals((Object)"x=false", (Object)s.serialize(t));
        Assert.assertEquals((Object)"x=false", (Object)sr.serialize(t));
        t = 123;
        Assert.assertEquals((Object)"_value=123", (Object)s.serialize(t));
        Assert.assertEquals((Object)"_value=123", (Object)sr.serialize(t));
        t = new ObjectMap((CharSequence)"{x:123}");
        Assert.assertEquals((Object)"x=123", (Object)s.serialize(t));
        Assert.assertEquals((Object)"x=123", (Object)sr.serialize(t));
        t = "x;/?:@-_.!*'";
        Assert.assertEquals((Object)"_value=x;/?:@-_.!*~'", (Object)s.serialize(t));
        Assert.assertEquals((Object)"_value=x;/?:@-_.!*~'", (Object)sr.serialize(t));
        t = new ObjectMap((CharSequence)"{x:'x;/?:@-_.!*\\''}");
        Assert.assertEquals((Object)"x=x;/?:@-_.!*~'", (Object)s.serialize(t));
        Assert.assertEquals((Object)"x=x;/?:@-_.!*~'", (Object)sr.serialize(t));
        t = "x{}|\\^[]`<>#%\"&+";
        Assert.assertEquals((Object)"_value=x%7B%7D%7C%5C%5E%5B%5D%60%3C%3E%23%25%22%26%2B", (Object)s.serialize(t));
        Assert.assertEquals((Object)"_value=x%7B%7D%7C%5C%5E%5B%5D%60%3C%3E%23%25%22%26%2B", (Object)sr.serialize(t));
        t = new ObjectMap((CharSequence)"{'x{}|\\\\^[]`<>#%\"&+':'x{}|\\\\^[]`<>#%\"&+'}");
        Assert.assertEquals((Object)"x%7B%7D%7C%5C%5E%5B%5D%60%3C%3E%23%25%22%26%2B=x%7B%7D%7C%5C%5E%5B%5D%60%3C%3E%23%25%22%26%2B", (Object)s.serialize(t));
        Assert.assertEquals((Object)"x%7B%7D%7C%5C%5E%5B%5D%60%3C%3E%23%25%22%26%2B=x%7B%7D%7C%5C%5E%5B%5D%60%3C%3E%23%25%22%26%2B", (Object)sr.serialize(t));
        t = "x$,()~";
        Assert.assertEquals((Object)"_value='x$,()~~'", (Object)s.serialize(t));
        Assert.assertEquals((Object)"_value='x$,()~~'", (Object)sr.serialize(t));
        t = new ObjectMap((CharSequence)"{'x$,()~':'x$,()~'}");
        Assert.assertEquals((Object)"'x$,()~~'='x$,()~~'", (Object)s.serialize(t));
        Assert.assertEquals((Object)"'x$,()~~'='x$,()~~'", (Object)sr.serialize(t));
        t = new ObjectMap((CharSequence)"{'x$,()~':{'x$,()~':'x$,()~'}}");
        Assert.assertEquals((Object)"'x$,()~~'=('x$,()~~'='x$,()~~')", (Object)s.serialize(t));
        Assert.assertEquals((Object)"'x$,()~~'=(\n\t'x$,()~~'='x$,()~~'\n)", (Object)sr.serialize(t));
        t = "x=";
        Assert.assertEquals((Object)"_value='x='", (Object)s.serialize(t));
        Assert.assertEquals((Object)"_value='x='", (Object)sr.serialize(t));
        t = new ObjectMap((CharSequence)"{'x=':'x='}");
        Assert.assertEquals((Object)"'x%3D'='x='", (Object)s.serialize(t));
        Assert.assertEquals((Object)"'x%3D'='x='", (Object)sr.serialize(t));
        t = new ObjectMap((CharSequence)"{'x=':{'x=':'x='}}");
        Assert.assertEquals((Object)"'x%3D'=('x='='x=')", (Object)s.serialize(t));
        Assert.assertEquals((Object)"'x%3D'=(\n\t'x='='x='\n)", (Object)sr.serialize(t));
        t = "()";
        Assert.assertEquals((Object)"_value='()'", (Object)s.serialize(t));
        Assert.assertEquals((Object)"_value='()'", (Object)sr.serialize(t));
        t = new ObjectMap((CharSequence)"{'()':'()'}");
        Assert.assertEquals((Object)"'()'='()'", (Object)s.serialize(t));
        Assert.assertEquals((Object)"'()'='()'", (Object)sr.serialize(t));
        t = "$a";
        Assert.assertEquals((Object)"_value=$a", (Object)s.serialize(t));
        Assert.assertEquals((Object)"_value=$a", (Object)sr.serialize(t));
        t = new ObjectMap((CharSequence)"{$a:'$a'}");
        Assert.assertEquals((Object)"$a=$a", (Object)s.serialize(t));
        Assert.assertEquals((Object)"$a=$a", (Object)sr.serialize(t));
        t = "";
        Assert.assertEquals((Object)"_value=''", (Object)s.serialize(t));
        Assert.assertEquals((Object)"_value=''", (Object)sr.serialize(t));
        t = new ObjectMap((CharSequence)"{'':''}");
        Assert.assertEquals((Object)"''=''", (Object)s.serialize(t));
        Assert.assertEquals((Object)"''=''", (Object)sr.serialize(t));
        t = new ObjectMap((CharSequence)"{'':{'':''}}");
        Assert.assertEquals((Object)"''=(''='')", (Object)s.serialize(t));
        Assert.assertEquals((Object)"''=(\n\t''=''\n)", (Object)sr.serialize(t));
        t = "\n";
        Assert.assertEquals((Object)"_value='%0A'", (Object)s.serialize(t));
        Assert.assertEquals((Object)"_value='%0A'", (Object)sr.serialize(t));
        t = new ObjectMap((CharSequence)"{'\n':'\n'}");
        Assert.assertEquals((Object)"'%0A'='%0A'", (Object)s.serialize(t));
        Assert.assertEquals((Object)"'%0A'='%0A'", (Object)sr.serialize(t));
        t = new ObjectMap((CharSequence)"{'\n':{'\n':'\n'}}");
        Assert.assertEquals((Object)"'%0A'=('%0A'='%0A')", (Object)s.serialize(t));
        Assert.assertEquals((Object)"'%0A'=(\n\t'%0A'='%0A'\n)", (Object)sr.serialize(t));
    }

    @Test
    public void testUnicodeChars() throws Exception {
        String t = "\u00a2";
        Assert.assertEquals((Object)"_value=%C2%A2", (Object)s.serialize((Object)t));
        Assert.assertEquals((Object)"_value=%C2%A2", (Object)sr.serialize((Object)t));
        t = new ObjectMap((CharSequence)"{'\u00a2':'\u00a2'}");
        Assert.assertEquals((Object)"%C2%A2=%C2%A2", (Object)s.serialize((Object)t));
        Assert.assertEquals((Object)"%C2%A2=%C2%A2", (Object)sr.serialize((Object)t));
        t = new ObjectMap((CharSequence)"{'\u00a2':{'\u00a2':'\u00a2'}}");
        Assert.assertEquals((Object)"%C2%A2=(%C2%A2=%C2%A2)", (Object)s.serialize((Object)t));
        Assert.assertEquals((Object)"%C2%A2=(\n\t%C2%A2=%C2%A2\n)", (Object)sr.serialize((Object)t));
        t = "\u20ac";
        Assert.assertEquals((Object)"_value=%E2%82%AC", (Object)s.serialize((Object)t));
        Assert.assertEquals((Object)"_value=%E2%82%AC", (Object)sr.serialize((Object)t));
        t = new ObjectMap((CharSequence)"{'\u20ac':'\u20ac'}");
        Assert.assertEquals((Object)"%E2%82%AC=%E2%82%AC", (Object)s.serialize((Object)t));
        Assert.assertEquals((Object)"%E2%82%AC=%E2%82%AC", (Object)sr.serialize((Object)t));
        t = new ObjectMap((CharSequence)"{'\u20ac':{'\u20ac':'\u20ac'}}");
        Assert.assertEquals((Object)"%E2%82%AC=(%E2%82%AC=%E2%82%AC)", (Object)s.serialize((Object)t));
        Assert.assertEquals((Object)"%E2%82%AC=(\n\t%E2%82%AC=%E2%82%AC\n)", (Object)sr.serialize((Object)t));
        t = "\ud852\udf62";
        Assert.assertEquals((Object)"_value=%F0%A4%AD%A2", (Object)s.serialize((Object)t));
        Assert.assertEquals((Object)"_value=%F0%A4%AD%A2", (Object)sr.serialize((Object)t));
        t = new ObjectMap((CharSequence)"{'\ud852\udf62':'\ud852\udf62'}");
        Assert.assertEquals((Object)"%F0%A4%AD%A2=%F0%A4%AD%A2", (Object)s.serialize((Object)t));
        Assert.assertEquals((Object)"%F0%A4%AD%A2=%F0%A4%AD%A2", (Object)sr.serialize((Object)t));
        t = new ObjectMap((CharSequence)"{'\ud852\udf62':{'\ud852\udf62':'\ud852\udf62'}}");
        Assert.assertEquals((Object)"%F0%A4%AD%A2=(%F0%A4%AD%A2=%F0%A4%AD%A2)", (Object)s.serialize((Object)t));
        Assert.assertEquals((Object)"%F0%A4%AD%A2=(\n\t%F0%A4%AD%A2=%F0%A4%AD%A2\n)", (Object)sr.serialize((Object)t));
    }

    @Test
    public void testMultiPartParametersOnBeansViaProperty() throws Exception {
        DTOs.B t = DTOs.B.create();
        UrlEncodingSerializer s = UrlEncodingSerializer.DEFAULT;
        String r = s.serialize((Object)t);
        String e = "f01=@(a,b)&f02=@(c,d)&f03=@(1,2)&f04=@(3,4)&f05=@(@(e,f),@(g,h))&f06=@(@(i,j),@(k,l))&f07=@((a=a,b=1,c=true),(a=a,b=1,c=true))&f08=@((a=a,b=1,c=true),(a=a,b=1,c=true))&f09=@(@((a=a,b=1,c=true)),@((a=a,b=1,c=true)))&f10=@(@((a=a,b=1,c=true)),@((a=a,b=1,c=true)))&f11=@(a,b)&f12=@(c,d)&f13=@(1,2)&f14=@(3,4)&f15=@(@(e,f),@(g,h))&f16=@(@(i,j),@(k,l))&f17=@((a=a,b=1,c=true),(a=a,b=1,c=true))&f18=@((a=a,b=1,c=true),(a=a,b=1,c=true))&f19=@(@((a=a,b=1,c=true)),@((a=a,b=1,c=true)))&f20=@(@((a=a,b=1,c=true)),@((a=a,b=1,c=true)))";
        Assert.assertEquals((Object)e, (Object)r);
        s = UrlEncodingSerializer.create().expandedParams().build();
        r = s.serialize((Object)t);
        e = "f01=a&f01=b&f02=c&f02=d&f03=1&f03=2&f04=3&f04=4&f05=@(e,f)&f05=@(g,h)&f06=@(i,j)&f06=@(k,l)&f07=(a=a,b=1,c=true)&f07=(a=a,b=1,c=true)&f08=(a=a,b=1,c=true)&f08=(a=a,b=1,c=true)&f09=@((a=a,b=1,c=true))&f09=@((a=a,b=1,c=true))&f10=@((a=a,b=1,c=true))&f10=@((a=a,b=1,c=true))&f11=a&f11=b&f12=c&f12=d&f13=1&f13=2&f14=3&f14=4&f15=@(e,f)&f15=@(g,h)&f16=@(i,j)&f16=@(k,l)&f17=(a=a,b=1,c=true)&f17=(a=a,b=1,c=true)&f18=(a=a,b=1,c=true)&f18=(a=a,b=1,c=true)&f19=@((a=a,b=1,c=true))&f19=@((a=a,b=1,c=true))&f20=@((a=a,b=1,c=true))&f20=@((a=a,b=1,c=true))";
        Assert.assertEquals((Object)e, (Object)r);
    }

    @Test
    public void testMultiPartParametersOnBeansViaProperty_usingConfig() throws Exception {
        DTOs2.B t = DTOs2.B.create();
        UrlEncodingSerializer s = UrlEncodingSerializer.DEFAULT.builder().applyAnnotations(new Class[]{DTOs2.Annotations.class}).build();
        String r = s.serialize((Object)t);
        String e = "f01=@(a,b)&f02=@(c,d)&f03=@(1,2)&f04=@(3,4)&f05=@(@(e,f),@(g,h))&f06=@(@(i,j),@(k,l))&f07=@((a=a,b=1,c=true),(a=a,b=1,c=true))&f08=@((a=a,b=1,c=true),(a=a,b=1,c=true))&f09=@(@((a=a,b=1,c=true)),@((a=a,b=1,c=true)))&f10=@(@((a=a,b=1,c=true)),@((a=a,b=1,c=true)))&f11=@(a,b)&f12=@(c,d)&f13=@(1,2)&f14=@(3,4)&f15=@(@(e,f),@(g,h))&f16=@(@(i,j),@(k,l))&f17=@((a=a,b=1,c=true),(a=a,b=1,c=true))&f18=@((a=a,b=1,c=true),(a=a,b=1,c=true))&f19=@(@((a=a,b=1,c=true)),@((a=a,b=1,c=true)))&f20=@(@((a=a,b=1,c=true)),@((a=a,b=1,c=true)))";
        Assert.assertEquals((Object)e, (Object)r);
        s = UrlEncodingSerializer.create().expandedParams().applyAnnotations(new Class[]{DTOs2.Annotations.class}).build();
        r = s.serialize((Object)t);
        e = "f01=a&f01=b&f02=c&f02=d&f03=1&f03=2&f04=3&f04=4&f05=@(e,f)&f05=@(g,h)&f06=@(i,j)&f06=@(k,l)&f07=(a=a,b=1,c=true)&f07=(a=a,b=1,c=true)&f08=(a=a,b=1,c=true)&f08=(a=a,b=1,c=true)&f09=@((a=a,b=1,c=true))&f09=@((a=a,b=1,c=true))&f10=@((a=a,b=1,c=true))&f10=@((a=a,b=1,c=true))&f11=a&f11=b&f12=c&f12=d&f13=1&f13=2&f14=3&f14=4&f15=@(e,f)&f15=@(g,h)&f16=@(i,j)&f16=@(k,l)&f17=(a=a,b=1,c=true)&f17=(a=a,b=1,c=true)&f18=(a=a,b=1,c=true)&f18=(a=a,b=1,c=true)&f19=@((a=a,b=1,c=true))&f19=@((a=a,b=1,c=true))&f20=@((a=a,b=1,c=true))&f20=@((a=a,b=1,c=true))";
        Assert.assertEquals((Object)e, (Object)r);
    }

    @Test
    public void testMultiPartParametersOnBeansViaAnnotationOnClass() throws Exception {
        DTOs.C t = DTOs.C.create();
        UrlEncodingSerializer s = UrlEncodingSerializer.DEFAULT;
        String r = s.serialize((Object)t);
        String e = "f01=a&f01=b&f02=c&f02=d&f03=1&f03=2&f04=3&f04=4&f05=@(e,f)&f05=@(g,h)&f06=@(i,j)&f06=@(k,l)&f07=(a=a,b=1,c=true)&f07=(a=a,b=1,c=true)&f08=(a=a,b=1,c=true)&f08=(a=a,b=1,c=true)&f09=@((a=a,b=1,c=true))&f09=@((a=a,b=1,c=true))&f10=@((a=a,b=1,c=true))&f10=@((a=a,b=1,c=true))&f11=a&f11=b&f12=c&f12=d&f13=1&f13=2&f14=3&f14=4&f15=@(e,f)&f15=@(g,h)&f16=@(i,j)&f16=@(k,l)&f17=(a=a,b=1,c=true)&f17=(a=a,b=1,c=true)&f18=(a=a,b=1,c=true)&f18=(a=a,b=1,c=true)&f19=@((a=a,b=1,c=true))&f19=@((a=a,b=1,c=true))&f20=@((a=a,b=1,c=true))&f20=@((a=a,b=1,c=true))";
        Assert.assertEquals((Object)e, (Object)r);
        s = UrlEncodingSerializer.create().expandedParams().build();
        r = s.serialize((Object)t);
        e = "f01=a&f01=b&f02=c&f02=d&f03=1&f03=2&f04=3&f04=4&f05=@(e,f)&f05=@(g,h)&f06=@(i,j)&f06=@(k,l)&f07=(a=a,b=1,c=true)&f07=(a=a,b=1,c=true)&f08=(a=a,b=1,c=true)&f08=(a=a,b=1,c=true)&f09=@((a=a,b=1,c=true))&f09=@((a=a,b=1,c=true))&f10=@((a=a,b=1,c=true))&f10=@((a=a,b=1,c=true))&f11=a&f11=b&f12=c&f12=d&f13=1&f13=2&f14=3&f14=4&f15=@(e,f)&f15=@(g,h)&f16=@(i,j)&f16=@(k,l)&f17=(a=a,b=1,c=true)&f17=(a=a,b=1,c=true)&f18=(a=a,b=1,c=true)&f18=(a=a,b=1,c=true)&f19=@((a=a,b=1,c=true))&f19=@((a=a,b=1,c=true))&f20=@((a=a,b=1,c=true))&f20=@((a=a,b=1,c=true))";
        Assert.assertEquals((Object)e, (Object)r);
    }

    @Test
    public void testMultiPartParametersOnBeansViaAnnotationOnClass_usingConfig() throws Exception {
        DTOs2.C t = DTOs2.C.create();
        UrlEncodingSerializer s = UrlEncodingSerializer.DEFAULT.builder().applyAnnotations(new Class[]{DTOs2.Annotations.class}).build();
        String r = s.serialize((Object)t);
        String e = "f01=a&f01=b&f02=c&f02=d&f03=1&f03=2&f04=3&f04=4&f05=@(e,f)&f05=@(g,h)&f06=@(i,j)&f06=@(k,l)&f07=(a=a,b=1,c=true)&f07=(a=a,b=1,c=true)&f08=(a=a,b=1,c=true)&f08=(a=a,b=1,c=true)&f09=@((a=a,b=1,c=true))&f09=@((a=a,b=1,c=true))&f10=@((a=a,b=1,c=true))&f10=@((a=a,b=1,c=true))&f11=a&f11=b&f12=c&f12=d&f13=1&f13=2&f14=3&f14=4&f15=@(e,f)&f15=@(g,h)&f16=@(i,j)&f16=@(k,l)&f17=(a=a,b=1,c=true)&f17=(a=a,b=1,c=true)&f18=(a=a,b=1,c=true)&f18=(a=a,b=1,c=true)&f19=@((a=a,b=1,c=true))&f19=@((a=a,b=1,c=true))&f20=@((a=a,b=1,c=true))&f20=@((a=a,b=1,c=true))";
        Assert.assertEquals((Object)e, (Object)r);
        s = UrlEncodingSerializer.create().expandedParams().applyAnnotations(new Class[]{DTOs2.Annotations.class}).build();
        r = s.serialize((Object)t);
        e = "f01=a&f01=b&f02=c&f02=d&f03=1&f03=2&f04=3&f04=4&f05=@(e,f)&f05=@(g,h)&f06=@(i,j)&f06=@(k,l)&f07=(a=a,b=1,c=true)&f07=(a=a,b=1,c=true)&f08=(a=a,b=1,c=true)&f08=(a=a,b=1,c=true)&f09=@((a=a,b=1,c=true))&f09=@((a=a,b=1,c=true))&f10=@((a=a,b=1,c=true))&f10=@((a=a,b=1,c=true))&f11=a&f11=b&f12=c&f12=d&f13=1&f13=2&f14=3&f14=4&f15=@(e,f)&f15=@(g,h)&f16=@(i,j)&f16=@(k,l)&f17=(a=a,b=1,c=true)&f17=(a=a,b=1,c=true)&f18=(a=a,b=1,c=true)&f18=(a=a,b=1,c=true)&f19=@((a=a,b=1,c=true))&f19=@((a=a,b=1,c=true))&f20=@((a=a,b=1,c=true))&f20=@((a=a,b=1,c=true))";
        Assert.assertEquals((Object)e, (Object)r);
    }

    @Test
    public void testMultiPartParametersOnMapOfStringArrays() throws Exception {
        LinkedHashMap<String, String[]> t = new LinkedHashMap<String, String[]>();
        t.put("f1", new String[]{"bar"});
        t.put("f2", new String[]{"bar", "baz"});
        t.put("f3", new String[0]);
        UrlEncodingSerializer s = UrlEncodingSerializer.DEFAULT_EXPANDED;
        String r = s.serialize(t);
        String e = "f1=bar&f2=bar&f2=baz";
        Assert.assertEquals((Object)e, (Object)r);
    }

    @Test
    public void testPlainTextParams() throws Exception {
        UrlEncodingSerializer s = UrlEncodingSerializer.DEFAULT.builder().paramFormatPlain().build();
        Assert.assertEquals((Object)"_value=foo", (Object)s.serialize((Object)"foo"));
        Assert.assertEquals((Object)"_value='foo'", (Object)s.serialize((Object)"'foo'"));
        Assert.assertEquals((Object)"_value=(foo)", (Object)s.serialize((Object)"(foo)"));
        Assert.assertEquals((Object)"_value=@(foo)", (Object)s.serialize((Object)"@(foo)"));
        AMap m = new AMap().append((Object)"foo", (Object)"foo").append((Object)"'foo'", (Object)"'foo'").append((Object)"(foo)", (Object)"(foo)").append((Object)"@(foo)", (Object)"@(foo)");
        Assert.assertEquals((Object)"foo=foo&'foo'='foo'&(foo)=(foo)&@(foo)=@(foo)", (Object)s.serialize((Object)m));
        AList l = new AList().appendAll((Object[])new String[]{"foo", "'foo'", "(foo)", "@(foo)"});
        Assert.assertEquals((Object)"0=foo&1='foo'&2=(foo)&3=@(foo)", (Object)s.serialize((Object)l));
        A a = new A();
        Assert.assertEquals((Object)"'foo'='foo'&(foo)=(foo)&@(foo)=@(foo)&foo=foo", (Object)s.serialize((Object)a));
    }

    @Bean(sort=true)
    public static class A {
        @Beanp(name="foo")
        public String f1 = "foo";
        @Beanp(name="'foo'")
        public String f2 = "'foo'";
        @Beanp(name="(foo)")
        public String f3 = "(foo)";
        @Beanp(name="@(foo)")
        public String f4 = "@(foo)";
    }
}

