/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.urlencoding;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.testutils.TestUtils;
import org.apache.juneau.urlencoding.DTOs;
import org.apache.juneau.urlencoding.DTOs2;
import org.apache.juneau.urlencoding.UrlEncodingParser;
import org.junit.Assert;
import org.junit.Test;

public class UrlEncodingParserTest {
    static UrlEncodingParser p = UrlEncodingParser.DEFAULT;
    static BeanSession bs = p.createBeanSession();

    @Test
    public void testBasic() throws Exception {
        String t = "_value=a";
        Assert.assertEquals((Object)"a", (Object)p.parse(t, Object.class));
        Assert.assertEquals((Object)"a", (Object)p.parse(t, String.class));
        t = "_value='a'";
        Assert.assertEquals((Object)"a", (Object)p.parse(t, String.class));
        Assert.assertEquals((Object)"a", (Object)p.parse(t, Object.class));
        t = "_value= 'a' ";
        Assert.assertEquals((Object)"a", (Object)p.parse(t, String.class));
        t = "?a=a";
        Assert.assertEquals((Object)"a", ((Map)p.parse(t, Map.class)).get("a"));
        t = "?a=b&c=123&d=false&e=true&f=null";
        Map m = (Map)p.parse(t, Map.class);
        Assert.assertEquals((Object)"b", m.get("a"));
        Assert.assertTrue((boolean)(m.get("c") instanceof Number));
        Assert.assertEquals((Object)123, m.get("c"));
        Assert.assertTrue((boolean)(m.get("d") instanceof Boolean));
        Assert.assertEquals((Object)Boolean.FALSE, m.get("d"));
        Assert.assertTrue((boolean)(m.get("e") instanceof Boolean));
        Assert.assertEquals((Object)Boolean.TRUE, m.get("e"));
        Assert.assertNull(m.get("f"));
        t = "?a=true";
        m = (Map)p.parse(t, HashMap.class, new Type[]{String.class, Boolean.class});
        Assert.assertTrue((boolean)(m.get("a") instanceof Boolean));
        Assert.assertEquals((Object)"true", (Object)m.get("a").toString());
        t = "_value=null";
        Assert.assertNull((Object)p.parse(t, Object.class));
        t = "?null=null";
        m = (Map)p.parse(t, Map.class);
        Assert.assertTrue((boolean)m.containsKey(null));
        Assert.assertNull(m.get(null));
        t = "?null=null";
        m = (Map)p.parse(t, Map.class);
        Assert.assertTrue((boolean)m.containsKey(null));
        Assert.assertNull(m.get(null));
        t = "?null=(null=null)";
        m = (Map)p.parse(t, Map.class);
        Assert.assertTrue((boolean)((Map)m.get(null)).containsKey(null));
        Assert.assertNull(((Map)m.get(null)).get(null));
        t = "?x=@()";
        m = (Map)p.parse(t, HashMap.class, new Type[]{String.class, List.class});
        Assert.assertTrue((boolean)m.containsKey("x"));
        Assert.assertTrue((boolean)((List)m.get("x")).isEmpty());
        m = (Map)p.parse(t, Object.class);
        Assert.assertTrue((boolean)m.containsKey("x"));
        Assert.assertTrue((boolean)((List)m.get("x")).isEmpty());
        t = "?x=@()";
        m = (Map)p.parse(t, HashMap.class, new Type[]{String.class, List.class});
        Assert.assertTrue((boolean)m.containsKey("x"));
        Assert.assertTrue((boolean)((List)m.get("x")).isEmpty());
        t = "_value=@(@())";
        List l = (List)p.parse(t, Object.class);
        Assert.assertTrue((l.size() == 1 ? 1 : 0) != 0);
        l = (List)l.get(0);
        Assert.assertTrue((boolean)l.isEmpty());
        t = "0=@()";
        l = (List)p.parse(t, LinkedList.class, new Type[]{List.class});
        Assert.assertTrue((l.size() == 1 ? 1 : 0) != 0);
        l = (List)l.get(0);
        Assert.assertTrue((boolean)l.isEmpty());
        t = "_value=@('')";
        l = (List)p.parse(t, Object.class);
        Assert.assertTrue((l.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"", l.get(0));
        t = "0=''";
        l = (List)p.parse(t, List.class, new Type[]{String.class});
        Assert.assertTrue((l.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"", l.get(0));
        t = "?''=@('')";
        m = (Map)p.parse(t, Object.class);
        Assert.assertEquals((Object)"", ((List)m.get("")).get(0));
        t = "?''=@('')";
        m = (Map)p.parse(t, HashMap.class, new Type[]{String.class, List.class});
        Assert.assertEquals((Object)"", ((List)m.get("")).get(0));
        t = "_value=@('','','')";
        l = (List)p.parse(t, Object.class);
        Assert.assertTrue((l.size() == 3 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"", l.get(0));
        Assert.assertEquals((Object)"", l.get(1));
        Assert.assertEquals((Object)"", l.get(2));
        t = "0=''&1=''&2=''";
        l = (List)p.parse(t, List.class, new Type[]{Object.class});
        Assert.assertTrue((l.size() == 3 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"", l.get(0));
        Assert.assertEquals((Object)"", l.get(1));
        Assert.assertEquals((Object)"", l.get(2));
        t = "_value='\u0000'";
        Assert.assertEquals((Object)"\u0000", (Object)p.parse(t, Object.class));
        t = "_value='\u0000'";
        Assert.assertEquals((Object)"\u0000", (Object)p.parse(t, String.class));
        Assert.assertEquals((Object)"\u0000", (Object)p.parse(t, Object.class));
        t = "?'\u0000'='\u0000'";
        m = (Map)p.parse(t, Object.class);
        Assert.assertTrue((m.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"\u0000", m.get("\u0000"));
        m = (Map)p.parse(t, HashMap.class, new Type[]{String.class, Object.class});
        Assert.assertTrue((m.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"\u0000", m.get("\u0000"));
        t = "_value=false";
        Boolean b = (Boolean)p.parse(t, Object.class);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)b);
        b = (Boolean)p.parse(t, Boolean.class);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)b);
        t = "_value=false";
        b = (Boolean)p.parse(t, Boolean.class);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)b);
        t = "?x=false";
        m = (Map)p.parse(t, Object.class);
        Assert.assertEquals((Object)Boolean.FALSE, m.get("x"));
        t = "?x=false";
        m = (Map)p.parse(t, HashMap.class, new Type[]{String.class, Boolean.class});
        Assert.assertEquals((Object)Boolean.FALSE, m.get("x"));
        t = "_value=123";
        Integer i = (Integer)p.parse(t, Object.class);
        Assert.assertEquals((long)123L, (long)i.intValue());
        i = (Integer)p.parse(t, Integer.class);
        Assert.assertEquals((long)123L, (long)i.intValue());
        Double d = (Double)p.parse(t, Double.class);
        Assert.assertEquals((long)123L, (long)d.intValue());
        Float f = (Float)p.parse(t, Float.class);
        Assert.assertEquals((long)123L, (long)f.intValue());
        t = "_value=123";
        i = (Integer)p.parse(t, Integer.class);
        Assert.assertEquals((long)123L, (long)i.intValue());
        t = "?x=123";
        m = (Map)p.parse(t, Object.class);
        Assert.assertEquals((long)123L, (long)((Integer)m.get("x")).intValue());
        m = (Map)p.parse(t, HashMap.class, new Type[]{String.class, Double.class});
        Assert.assertEquals((long)123L, (long)((Double)m.get("x")).intValue());
        t = "_value=x;/?:@-_.!*'";
        Assert.assertEquals((Object)"x;/?:@-_.!*'", (Object)p.parse(t, Object.class));
        t = "?x;/?:@-_.!*'=x;/?:@-_.!*'";
        m = (Map)p.parse(t, Object.class);
        Assert.assertEquals((Object)"x;/?:@-_.!*'", m.get("x;/?:@-_.!*'"));
        m = (Map)p.parse(t, HashMap.class, new Type[]{String.class, Object.class});
        Assert.assertEquals((Object)"x;/?:@-_.!*'", m.get("x;/?:@-_.!*'"));
        m = (Map)p.parse(t, HashMap.class, new Type[]{String.class, String.class});
        Assert.assertEquals((Object)"x;/?:@-_.!*'", m.get("x;/?:@-_.!*'"));
        t = "_value=x{}|\\^[]`<>#%\"&+";
        try {
            Assert.assertEquals((Object)"x{}|\\^[]`<>#%\"&+", (Object)p.parse(t, Object.class));
            Assert.fail((String)"Expected parse exception from invalid hex sequence.");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        t = "_value=x%7B%7D%7C%5C%5E%5B%5D%60%3C%3E%23%25%22%26%2B";
        Assert.assertEquals((Object)"x{}|\\^[]`<>#%\"&+", (Object)p.parse(t, Object.class));
        Assert.assertEquals((Object)"x{}|\\^[]`<>#%\"&+", (Object)p.parse(t, String.class));
        t = "?x{}|\\^[]`<>#%\"&+=x{}|\\^[]`<>#%\"&+";
        try {
            m = (Map)p.parse(t, Object.class);
            Assert.fail((String)"Expected parse exception from invalid hex sequence.");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        t = "?x%7B%7D%7C%5C%5E%5B%5D%60%3C%3E%23%25%22%26%2B=x%7B%7D%7C%5C%5E%5B%5D%60%3C%3E%23%25%22%26%2B";
        m = (Map)p.parse(t, Object.class);
        Assert.assertEquals((Object)"x{}|\\^[]`<>#%\"&+", m.get("x{}|\\^[]`<>#%\"&+"));
        t = "_value='x$,()'";
        Assert.assertEquals((Object)"x$,()", (Object)p.parse(t, Object.class));
        t = "_value='x~~$~~,~~(~~)'";
        Assert.assertEquals((Object)"x~$~,~(~)", (Object)p.parse(t, Object.class));
        t = "?'x$,()'='x$,()'";
        m = (Map)p.parse(t, Object.class);
        Assert.assertEquals((Object)"x$,()", m.get("x$,()"));
        t = "?'x~~$~~,~~(~~)'='x~~$~~,~~(~~)'";
        m = (Map)p.parse(t, Object.class);
        Assert.assertEquals((Object)"x~$~,~(~)", m.get("x~$~,~(~)"));
        t = "_value='x='";
        Assert.assertEquals((Object)"x=", (Object)p.parse(t, Object.class));
        t = "_value='x%3D'";
        Assert.assertEquals((Object)"x=", (Object)p.parse(t, Object.class));
        t = "?'x%3D'='x%3D'";
        m = (Map)p.parse(t, Object.class);
        Assert.assertEquals((Object)"x=", m.get("x="));
        t = "?'x~~%3D'='x~~%3D'";
        m = (Map)p.parse(t, Object.class);
        Assert.assertEquals((Object)"x~=", m.get("x~="));
        t = "_value='()'";
        Assert.assertEquals((Object)"()", (Object)p.parse(t, Object.class));
        Assert.assertEquals((Object)"()", (Object)p.parse(t, String.class));
        t = "_value='()'";
        Assert.assertEquals((Object)"()", (Object)p.parse(t, Object.class));
        Assert.assertEquals((Object)"()", (Object)p.parse(t, String.class));
        t = "?'()'='()'";
        m = (Map)p.parse(t, Object.class);
        Assert.assertEquals((Object)"()", m.get("()"));
        t = "?'()'='()'";
        m = (Map)p.parse(t, HashMap.class, new Type[]{String.class, Object.class});
        Assert.assertEquals((Object)"()", m.get("()"));
        t = "_value=$a";
        Assert.assertEquals((Object)"$a", (Object)p.parse(t, Object.class));
        t = "_value=$a";
        Assert.assertEquals((Object)"$a", (Object)p.parse(t, Object.class));
        t = "?$a=$a";
        m = (Map)p.parse(t, Object.class);
        Assert.assertEquals((Object)"$a", m.get("$a"));
        m = (Map)p.parse(t, HashMap.class, new Type[]{String.class, Object.class});
        Assert.assertEquals((Object)"$a", m.get("$a"));
        t = "_value=";
        Assert.assertEquals((Object)"", (Object)p.parse(t, Object.class));
        t = "?=";
        m = (Map)p.parse(t, Object.class);
        Assert.assertEquals((Object)"", m.get(""));
        m = (Map)p.parse(t, HashMap.class, new Type[]{String.class, Object.class});
        Assert.assertEquals((Object)"", m.get(""));
        t = "?=(=)";
        m = (Map)p.parse(t, Object.class);
        Assert.assertEquals((Object)"", ((Map)m.get("")).get(""));
        t = "?=(=)";
        m = (Map)p.parse(t, HashMap.class, new Type[]{String.class, HashMap.class});
        Assert.assertEquals((Object)"", ((Map)m.get("")).get(""));
        t = "_value='%0A'";
        Assert.assertEquals((Object)"\n", (Object)p.parse(t, Object.class));
        t = "?'%0A'='%0A'";
        m = (Map)p.parse(t, Object.class);
        Assert.assertEquals((Object)"\n", m.get("\n"));
        t = "?'%0A'=('%0A'='%0A')";
        m = (Map)p.parse(t, Object.class);
        Assert.assertEquals((Object)"\n", ((Map)m.get("\n")).get("\n"));
    }

    @Test
    public void testUnicodeChars() throws Exception {
        String t = "_value=\u00a2";
        Assert.assertEquals((Object)"\u00a2", (Object)p.parse(t, Object.class));
        Assert.assertEquals((Object)"\u00a2", (Object)p.parse(t, String.class));
        t = "_value=%C2%A2";
        Assert.assertEquals((Object)"\u00a2", (Object)p.parse(t, Object.class));
        Assert.assertEquals((Object)"\u00a2", (Object)p.parse(t, String.class));
        t = "?%C2%A2=%C2%A2";
        Map m = (Map)p.parse(t, Object.class);
        Assert.assertEquals((Object)"\u00a2", m.get("\u00a2"));
        t = "?%C2%A2=(%C2%A2=%C2%A2)";
        m = (Map)p.parse(t, Object.class);
        Assert.assertEquals((Object)"\u00a2", ((Map)m.get("\u00a2")).get("\u00a2"));
        t = "_value=\u20ac";
        Assert.assertEquals((Object)"\u20ac", (Object)p.parse(t, Object.class));
        Assert.assertEquals((Object)"\u20ac", (Object)p.parse(t, String.class));
        t = "_value=%E2%82%AC";
        Assert.assertEquals((Object)"\u20ac", (Object)p.parse(t, Object.class));
        Assert.assertEquals((Object)"\u20ac", (Object)p.parse(t, String.class));
        t = "?%E2%82%AC=%E2%82%AC";
        m = (Map)p.parse(t, Object.class);
        Assert.assertEquals((Object)"\u20ac", m.get("\u20ac"));
        t = "?%E2%82%AC=(%E2%82%AC=%E2%82%AC)";
        m = (Map)p.parse(t, Object.class);
        Assert.assertEquals((Object)"\u20ac", ((Map)m.get("\u20ac")).get("\u20ac"));
        t = "_value=\ud852\udf62";
        Assert.assertEquals((Object)"\ud852\udf62", (Object)p.parse(t, Object.class));
        Assert.assertEquals((Object)"\ud852\udf62", (Object)p.parse(t, String.class));
        t = "_value=%F0%A4%AD%A2";
        Assert.assertEquals((Object)"\ud852\udf62", (Object)p.parse(t, Object.class));
        Assert.assertEquals((Object)"\ud852\udf62", (Object)p.parse(t, String.class));
        t = "?%F0%A4%AD%A2=%F0%A4%AD%A2";
        m = (Map)p.parse(t, Object.class);
        Assert.assertEquals((Object)"\ud852\udf62", m.get("\ud852\udf62"));
        t = "?%F0%A4%AD%A2=(%F0%A4%AD%A2=%F0%A4%AD%A2)";
        m = (Map)p.parse(t, Object.class);
        Assert.assertEquals((Object)"\ud852\udf62", ((Map)m.get("\ud852\udf62")).get("\ud852\udf62"));
    }

    @Test
    public void testSimpleBean() throws Exception {
        UrlEncodingParser p = UrlEncodingParser.DEFAULT;
        String s = "?f1=foo&f2=123";
        A t = (A)p.parse(s, A.class);
        Assert.assertEquals((Object)"foo", (Object)t.f1);
        Assert.assertEquals((long)123L, (long)t.f2);
    }

    @Test
    public void testNoValues() throws Exception {
        UrlEncodingParser p = UrlEncodingParser.DEFAULT;
        String s = "?f1";
        ObjectMap m = (ObjectMap)p.parse(s, ObjectMap.class);
        Assert.assertTrue((boolean)m.containsKey((Object)"f1"));
        Assert.assertNull((Object)m.get((Object)"f1"));
        s = "?f1=f2&f3";
        m = (ObjectMap)p.parse(s, ObjectMap.class);
        Assert.assertEquals((Object)"f2", (Object)m.get((Object)"f1"));
        Assert.assertTrue((boolean)m.containsKey((Object)"f3"));
        Assert.assertNull((Object)m.get((Object)"f3"));
    }

    @Test
    public void testCommaDelimitedLists() throws Exception {
        UrlEncodingParser p = UrlEncodingParser.DEFAULT;
        String s = "?f1=1,2,3&f2=a,b,c&f3=true,false&f4=&f5";
        C c = (C)p.parse(s, C.class);
        TestUtils.assertObjectEquals("{f1:[1,2,3],f2:['a','b','c'],f3:[true,false],f4:[]}", c);
    }

    @Test
    public void testCommaDelimitedListsWithSpecialChars() throws Exception {
        UrlEncodingParser p = UrlEncodingParser.DEFAULT;
        String s = "?f1=a~b,a~b";
        C1 c = (C1)p.parse(s, C1.class);
        TestUtils.assertObjectEquals("{f1:['a~b','a~b']}", c);
        s = "?f1=@(a~b,a~b)";
        c = (C1)p.parse(s, C1.class);
        TestUtils.assertObjectEquals("{f1:['a~b','a~b']}", c);
        s = "?f1=@('a~b','a~b')";
        c = (C1)p.parse(s, C1.class);
        TestUtils.assertObjectEquals("{f1:['a~b','a~b']}", c);
        s = "?f1=@('a~b','a~b')";
        c = (C1)p.parse(s, C1.class);
        TestUtils.assertObjectEquals("{f1:['a~b','a~b']}", c);
        s = "?f1=@('a~b','a~b')";
        c = (C1)p.parse(s, C1.class);
        TestUtils.assertObjectEquals("{f1:['a~b','a~b']}", c);
        s = "?f1=~~,~~";
        c = (C1)p.parse(s, C1.class);
        TestUtils.assertObjectEquals("{f1:['~','~']}", c);
        s = "?f1=@(~~,~~)";
        c = (C1)p.parse(s, C1.class);
        TestUtils.assertObjectEquals("{f1:['~','~']}", c);
        s = "?f1=@(~~~~~~,~~~~~~)";
        c = (C1)p.parse(s, C1.class);
        TestUtils.assertObjectEquals("{f1:['~~~','~~~']}", c);
        s = "?f1=@('~~~~~~','~~~~~~')";
        c = (C1)p.parse(s, C1.class);
        TestUtils.assertObjectEquals("{f1:['~~~','~~~']}", c);
        s = "?f1=~'~~,~'~~";
        c = (C1)p.parse(s, C1.class);
        TestUtils.assertObjectEquals("{f1:['\\'~','\\'~']}", c);
        s = "?f1=@(~'~~,~'~~)";
        c = (C1)p.parse(s, C1.class);
        TestUtils.assertObjectEquals("{f1:['\\'~','\\'~']}", c);
        s = "?f1=@('~'~~','~'~~')";
        c = (C1)p.parse(s, C1.class);
        TestUtils.assertObjectEquals("{f1:['\\'~','\\'~']}", c);
        s = "?a~b=a~b";
        ObjectMap m = (ObjectMap)p.parse(s, ObjectMap.class);
        Assert.assertEquals((Object)"{'a~b':'a~b'}", (Object)m.toString());
        s = "?'a~b'='a~b'";
        m = (ObjectMap)p.parse(s, ObjectMap.class);
        Assert.assertEquals((Object)"{'a~b':'a~b'}", (Object)m.toString());
        s = "?~~=~~";
        m = (ObjectMap)p.parse(s, ObjectMap.class);
        Assert.assertEquals((Object)"{'~':'~'}", (Object)m.toString());
        s = "?'~~'='~~'";
        m = (ObjectMap)p.parse(s, ObjectMap.class);
        Assert.assertEquals((Object)"{'~':'~'}", (Object)m.toString());
        s = "?~~~~~~=~~~~~~";
        m = (ObjectMap)p.parse(s, ObjectMap.class);
        Assert.assertEquals((Object)"{'~~~':'~~~'}", (Object)m.toString());
        s = "?'~~~~~~'='~~~~~~'";
        m = (ObjectMap)p.parse(s, ObjectMap.class);
        Assert.assertEquals((Object)"{'~~~':'~~~'}", (Object)m.toString());
    }

    @Test
    public void testWhitespace() throws Exception {
        UrlEncodingParser p = UrlEncodingParser.DEFAULT;
        String s = "?f1=foo\n\t&f2=bar\n\t";
        ObjectMap m = (ObjectMap)p.parse(s, ObjectMap.class);
        Assert.assertEquals((Object)"{f1:'foo',f2:'bar'}", (Object)m.toString());
        s = "?f1='\n\t'&f2='\n\t'";
        m = (ObjectMap)p.parse(s, ObjectMap.class);
        Assert.assertEquals((Object)"\n\t", (Object)m.getString("f1"));
        Assert.assertEquals((Object)"\n\t", (Object)m.getString("f2"));
        s = "?f1='\n\t'\n\t&f2='\n\t'\n\t";
        m = (ObjectMap)p.parse(s, ObjectMap.class);
        Assert.assertEquals((Object)"\n\t", (Object)m.getString("f1"));
        Assert.assertEquals((Object)"\n\t", (Object)m.getString("f2"));
        Assert.assertEquals((Object)"{f1:'\\n\\t',f2:'\\n\\t'}", (Object)m.toString());
        s = "?f1='\n\t'\n\t&f2='\n\t'\n\t";
        m = (ObjectMap)p.parse(s, ObjectMap.class);
        Assert.assertEquals((Object)"\n\t", (Object)m.getString("f1"));
        Assert.assertEquals((Object)"\n\t", (Object)m.getString("f2"));
        Assert.assertEquals((Object)"{f1:'\\n\\t',f2:'\\n\\t'}", (Object)m.toString());
        s = "?f1=(\n\tf1a=a,\n\tf1b=b\n\t)\n\t&f2=(\n\tf2a=a,\n\tf2b=b\n\t)\n\t";
        m = (ObjectMap)p.parse(s, ObjectMap.class);
        Assert.assertEquals((Object)"{f1:{f1a:'a',f1b:'b'},f2:{f2a:'a',f2b:'b'}}", (Object)m.toString());
        D d = (D)p.parse(s, D.class);
        TestUtils.assertObjectEquals("{f1:{f1a:'a',f1b:'b'},f2:{f2a:'a',f2b:'b'}}", d);
        s = "?f1=(\n\tf1a='\n\t',\n\tf1b='\n\t'\n\t)\n\t&f2=(\n\tf2a='\n\t',\n\tf2b='\n\t'\n\t)\n\t";
        m = (ObjectMap)p.parse(s, ObjectMap.class);
        Assert.assertEquals((Object)"{f1:{f1a:'\\n\\t',f1b:'\\n\\t'},f2:{f2a:'\\n\\t',f2b:'\\n\\t'}}", (Object)m.toString());
        d = (D)p.parse(s, D.class);
        TestUtils.assertObjectEquals("{f1:{f1a:'\\n\\t',f1b:'\\n\\t'},f2:{f2a:'\\n\\t',f2b:'\\n\\t'}}", d);
        s = "?f1=@(\n\tfoo,\n\tbar\n\t)\n\t&f2=@(\n\tfoo,\n\tbar\n\t)\n\t";
        m = (ObjectMap)p.parse(s, ObjectMap.class);
        Assert.assertEquals((Object)"{f1:['foo','bar'],f2:['foo','bar']}", (Object)m.toString());
        s = "f1=a,\n\tb,\n\tc\n\t&f2=1,\n\t2,\n\t3\n\t&f3=true,\n\tfalse\n\t";
        E e = (E)p.parse(s, E.class);
        TestUtils.assertObjectEquals("{f1:['a','b','c'],f2:[1,2,3],f3:[true,false]}", e);
        s = "f1=a%2C%0D%0Ab%2C%0D%0Ac%0D%0A&f2=1%2C%0D%0A2%2C%0D%0A3%0D%0A&f3=true%2C%0D%0Afalse%0D%0A";
        e = (E)p.parse(s, E.class);
        TestUtils.assertObjectEquals("{f1:['a','b','c'],f2:[1,2,3],f3:[true,false]}", e);
    }

    @Test
    public void testMultiPartParametersOnBeansViaProperty() throws Exception {
        UrlEncodingParser p = UrlEncodingParser.create().expandedParams(true).build();
        String in = "f01=a&f01=b&f02=c&f02=d&f03=1&f03=2&f04=3&f04=4&f05=@(e,f)&f05=@(g,h)&f06=@(i,j)&f06=@(k,l)&f07=(a=a,b=1,c=true)&f07=(a=b,b=2,c=false)&f08=(a=a,b=1,c=true)&f08=(a=b,b=2,c=false)&f09=@((a=a,b=1,c=true))&f09=@((a=b,b=2,c=false))&f10=@((a=a,b=1,c=true))&f10=@((a=b,b=2,c=false))&f11=a&f11=b&f12=c&f12=d&f13=1&f13=2&f14=3&f14=4&f15=@(e,f)&f15=@(g,h)&f16=@(i,j)&f16=@(k,l)&f17=(a=a,b=1,c=true)&f17=(a=b,b=2,c=false)&f18=(a=a,b=1,c=true)&f18=(a=b,b=2,c=false)&f19=@((a=a,b=1,c=true))&f19=@((a=b,b=2,c=false))&f20=@((a=a,b=1,c=true))&f20=@((a=b,b=2,c=false))";
        DTOs.B t = (DTOs.B)p.parse(in, DTOs.B.class);
        String e = "{f01:['a','b'],f02:['c','d'],f03:[1,2],f04:[3,4],f05:[['e','f'],['g','h']],f06:[['i','j'],['k','l']],f07:[{a:'a',b:1,c:true},{a:'b',b:2,c:false}],f08:[{a:'a',b:1,c:true},{a:'b',b:2,c:false}],f09:[[{a:'a',b:1,c:true}],[{a:'b',b:2,c:false}]],f10:[[{a:'a',b:1,c:true}],[{a:'b',b:2,c:false}]],f11:['a','b'],f12:['c','d'],f13:[1,2],f14:[3,4],f15:[['e','f'],['g','h']],f16:[['i','j'],['k','l']],f17:[{a:'a',b:1,c:true},{a:'b',b:2,c:false}],f18:[{a:'a',b:1,c:true},{a:'b',b:2,c:false}],f19:[[{a:'a',b:1,c:true}],[{a:'b',b:2,c:false}]],f20:[[{a:'a',b:1,c:true}],[{a:'b',b:2,c:false}]]}";
        TestUtils.assertSortedObjectEquals(e, t);
    }

    @Test
    public void testMultiPartParametersOnBeansViaProperty_usingConfig() throws Exception {
        UrlEncodingParser p = UrlEncodingParser.create().expandedParams(true).applyAnnotations(new Class[]{DTOs2.Annotations.class}).build();
        String in = "f01=a&f01=b&f02=c&f02=d&f03=1&f03=2&f04=3&f04=4&f05=@(e,f)&f05=@(g,h)&f06=@(i,j)&f06=@(k,l)&f07=(a=a,b=1,c=true)&f07=(a=b,b=2,c=false)&f08=(a=a,b=1,c=true)&f08=(a=b,b=2,c=false)&f09=@((a=a,b=1,c=true))&f09=@((a=b,b=2,c=false))&f10=@((a=a,b=1,c=true))&f10=@((a=b,b=2,c=false))&f11=a&f11=b&f12=c&f12=d&f13=1&f13=2&f14=3&f14=4&f15=@(e,f)&f15=@(g,h)&f16=@(i,j)&f16=@(k,l)&f17=(a=a,b=1,c=true)&f17=(a=b,b=2,c=false)&f18=(a=a,b=1,c=true)&f18=(a=b,b=2,c=false)&f19=@((a=a,b=1,c=true))&f19=@((a=b,b=2,c=false))&f20=@((a=a,b=1,c=true))&f20=@((a=b,b=2,c=false))";
        DTOs2.B t = (DTOs2.B)p.parse(in, DTOs2.B.class);
        String e = "{f01:['a','b'],f02:['c','d'],f03:[1,2],f04:[3,4],f05:[['e','f'],['g','h']],f06:[['i','j'],['k','l']],f07:[{a:'a',b:1,c:true},{a:'b',b:2,c:false}],f08:[{a:'a',b:1,c:true},{a:'b',b:2,c:false}],f09:[[{a:'a',b:1,c:true}],[{a:'b',b:2,c:false}]],f10:[[{a:'a',b:1,c:true}],[{a:'b',b:2,c:false}]],f11:['a','b'],f12:['c','d'],f13:[1,2],f14:[3,4],f15:[['e','f'],['g','h']],f16:[['i','j'],['k','l']],f17:[{a:'a',b:1,c:true},{a:'b',b:2,c:false}],f18:[{a:'a',b:1,c:true},{a:'b',b:2,c:false}],f19:[[{a:'a',b:1,c:true}],[{a:'b',b:2,c:false}]],f20:[[{a:'a',b:1,c:true}],[{a:'b',b:2,c:false}]]}";
        TestUtils.assertSortedObjectEquals(e, t);
    }

    @Test
    public void testMultiPartParametersOnBeansViaAnnotationOnClass() throws Exception {
        UrlEncodingParser p = UrlEncodingParser.DEFAULT;
        String in = "f01=a&f01=b&f02=c&f02=d&f03=1&f03=2&f04=3&f04=4&f05=@(e,f)&f05=@(g,h)&f06=@(i,j)&f06=@(k,l)&f07=(a=a,b=1,c=true)&f07=(a=b,b=2,c=false)&f08=(a=a,b=1,c=true)&f08=(a=b,b=2,c=false)&f09=@((a=a,b=1,c=true))&f09=@((a=b,b=2,c=false))&f10=@((a=a,b=1,c=true))&f10=@((a=b,b=2,c=false))&f11=a&f11=b&f12=c&f12=d&f13=1&f13=2&f14=3&f14=4&f15=@(e,f)&f15=@(g,h)&f16=@(i,j)&f16=@(k,l)&f17=(a=a,b=1,c=true)&f17=(a=b,b=2,c=false)&f18=(a=a,b=1,c=true)&f18=(a=b,b=2,c=false)&f19=@((a=a,b=1,c=true))&f19=@((a=b,b=2,c=false))&f20=@((a=a,b=1,c=true))&f20=@((a=b,b=2,c=false))";
        DTOs.C t = (DTOs.C)p.parse(in, DTOs.C.class);
        String e = "{f01:['a','b'],f02:['c','d'],f03:[1,2],f04:[3,4],f05:[['e','f'],['g','h']],f06:[['i','j'],['k','l']],f07:[{a:'a',b:1,c:true},{a:'b',b:2,c:false}],f08:[{a:'a',b:1,c:true},{a:'b',b:2,c:false}],f09:[[{a:'a',b:1,c:true}],[{a:'b',b:2,c:false}]],f10:[[{a:'a',b:1,c:true}],[{a:'b',b:2,c:false}]],f11:['a','b'],f12:['c','d'],f13:[1,2],f14:[3,4],f15:[['e','f'],['g','h']],f16:[['i','j'],['k','l']],f17:[{a:'a',b:1,c:true},{a:'b',b:2,c:false}],f18:[{a:'a',b:1,c:true},{a:'b',b:2,c:false}],f19:[[{a:'a',b:1,c:true}],[{a:'b',b:2,c:false}]],f20:[[{a:'a',b:1,c:true}],[{a:'b',b:2,c:false}]]}";
        TestUtils.assertSortedObjectEquals(e, t);
    }

    @Test
    public void testMultiPartParametersOnBeansViaAnnotationOnClass_usingConfig() throws Exception {
        UrlEncodingParser p = UrlEncodingParser.DEFAULT.builder().applyAnnotations(new Class[]{DTOs2.Annotations.class}).build();
        String in = "f01=a&f01=b&f02=c&f02=d&f03=1&f03=2&f04=3&f04=4&f05=@(e,f)&f05=@(g,h)&f06=@(i,j)&f06=@(k,l)&f07=(a=a,b=1,c=true)&f07=(a=b,b=2,c=false)&f08=(a=a,b=1,c=true)&f08=(a=b,b=2,c=false)&f09=@((a=a,b=1,c=true))&f09=@((a=b,b=2,c=false))&f10=@((a=a,b=1,c=true))&f10=@((a=b,b=2,c=false))&f11=a&f11=b&f12=c&f12=d&f13=1&f13=2&f14=3&f14=4&f15=@(e,f)&f15=@(g,h)&f16=@(i,j)&f16=@(k,l)&f17=(a=a,b=1,c=true)&f17=(a=b,b=2,c=false)&f18=(a=a,b=1,c=true)&f18=(a=b,b=2,c=false)&f19=@((a=a,b=1,c=true))&f19=@((a=b,b=2,c=false))&f20=@((a=a,b=1,c=true))&f20=@((a=b,b=2,c=false))";
        DTOs2.C t = (DTOs2.C)p.parse(in, DTOs2.C.class);
        String e = "{f01:['a','b'],f02:['c','d'],f03:[1,2],f04:[3,4],f05:[['e','f'],['g','h']],f06:[['i','j'],['k','l']],f07:[{a:'a',b:1,c:true},{a:'b',b:2,c:false}],f08:[{a:'a',b:1,c:true},{a:'b',b:2,c:false}],f09:[[{a:'a',b:1,c:true}],[{a:'b',b:2,c:false}]],f10:[[{a:'a',b:1,c:true}],[{a:'b',b:2,c:false}]],f11:['a','b'],f12:['c','d'],f13:[1,2],f14:[3,4],f15:[['e','f'],['g','h']],f16:[['i','j'],['k','l']],f17:[{a:'a',b:1,c:true},{a:'b',b:2,c:false}],f18:[{a:'a',b:1,c:true},{a:'b',b:2,c:false}],f19:[[{a:'a',b:1,c:true}],[{a:'b',b:2,c:false}]],f20:[[{a:'a',b:1,c:true}],[{a:'b',b:2,c:false}]]}";
        TestUtils.assertSortedObjectEquals(e, t);
    }

    public static class E {
        public String[] f1;
        public int[] f2;
        public boolean[] f3;
    }

    public static class D2 {
        public String f2a;
        public String f2b;
    }

    public static class D1 {
        public String f1a;
        public String f1b;
    }

    public static class D {
        public D1 f1;
        public D2 f2;
    }

    public static class C1 {
        public String[] f1;
    }

    public static class C {
        public int[] f1;
        public String[] f2;
        public boolean[] f3;
        public String[] f4;
        public String[] f5;
    }

    public static class A {
        public String f1;
        public int f2;
    }
}

