/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.urlencoding;

import java.util.function.Function;
import org.apache.juneau.XVar;
import org.apache.juneau.reflect.AnnotationList;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.svl.VarResolver;
import org.apache.juneau.svl.VarResolverSession;
import org.apache.juneau.urlencoding.UrlEncodingParser;
import org.apache.juneau.urlencoding.UrlEncodingParserSession;
import org.apache.juneau.urlencoding.UrlEncodingSerializer;
import org.apache.juneau.urlencoding.UrlEncodingSerializerSession;
import org.apache.juneau.urlencoding.annotation.UrlEncodingConfig;
import org.junit.Assert;
import org.junit.Test;

public class UrlEncodingConfigAnnotationTest {
    private static final Function<Object, String> TO_STRING = new Function<Object, String>(){

        @Override
        public String apply(Object t) {
            return t.toString();
        }
    };
    static VarResolverSession sr = VarResolver.create().vars(new Class[]{XVar.class}).build().createSession();
    static ClassInfo a = ClassInfo.of(A.class);
    static ClassInfo b = ClassInfo.of(B.class);
    static ClassInfo c = ClassInfo.of(C.class);

    private static void check(String expected, Object o) {
        Assert.assertEquals((Object)expected, (Object)TO_STRING.apply(o));
    }

    @Test
    public void basicSerializer() throws Exception {
        AnnotationList al = a.getAnnotationList(null);
        UrlEncodingSerializerSession x = UrlEncodingSerializer.create().applyAnnotations(al, sr).build().createSession();
        UrlEncodingConfigAnnotationTest.check("true", x.isExpandedParams());
    }

    @Test
    public void basicParser() throws Exception {
        AnnotationList al = a.getAnnotationList(null);
        UrlEncodingParserSession x = UrlEncodingParser.create().applyAnnotations(al, sr).build().createSession();
        UrlEncodingConfigAnnotationTest.check("true", x.isExpandedParams());
    }

    @Test
    public void noValuesSerializer() throws Exception {
        AnnotationList al = b.getAnnotationList(null);
        UrlEncodingSerializerSession x = UrlEncodingSerializer.create().applyAnnotations(al, sr).build().createSession();
        UrlEncodingConfigAnnotationTest.check("false", x.isExpandedParams());
    }

    @Test
    public void noValuesParser() throws Exception {
        AnnotationList al = b.getAnnotationList(null);
        UrlEncodingParserSession x = UrlEncodingParser.create().applyAnnotations(al, sr).build().createSession();
        UrlEncodingConfigAnnotationTest.check("false", x.isExpandedParams());
    }

    @Test
    public void noAnnotationSerializer() throws Exception {
        AnnotationList al = c.getAnnotationList(null);
        UrlEncodingSerializerSession x = UrlEncodingSerializer.create().applyAnnotations(al, sr).build().createSession();
        UrlEncodingConfigAnnotationTest.check("false", x.isExpandedParams());
    }

    @Test
    public void noAnnotationParser() throws Exception {
        AnnotationList al = c.getAnnotationList(null);
        UrlEncodingParserSession x = UrlEncodingParser.create().applyAnnotations(al, sr).build().createSession();
        UrlEncodingConfigAnnotationTest.check("false", x.isExpandedParams());
    }

    static class C {
        C() {
        }
    }

    @UrlEncodingConfig
    static class B {
        B() {
        }
    }

    @UrlEncodingConfig(expandedParams="$X{true}")
    static class A {
        A() {
        }
    }
}

