/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.urlencoding;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.juneau.ObjectList;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.ParserListener;
import org.apache.juneau.parser.ParserSession;
import org.apache.juneau.parser.ReaderParser;
import org.apache.juneau.testutils.TestUtils;
import org.apache.juneau.urlencoding.UrlEncodingParser;
import org.apache.juneau.urlencoding.UrlEncodingSerializer;
import org.junit.Assert;
import org.junit.Test;

public class CommonParser_UrlEncodingTest {
    ReaderParser p = UrlEncodingParser.create().dictionary(new Class[]{A1.class}).build();

    @Test
    public void testFromSerializer() throws Exception {
        Map m = null;
        String in = "a=1";
        m = (Map)this.p.parse(in, Object.class);
        Assert.assertEquals((Object)1, m.get("a"));
        in = "a=1&b='foo+bar'";
        m = (Map)this.p.parse(in, Object.class);
        Assert.assertEquals((Object)1, m.get("a"));
        Assert.assertEquals((Object)"foo bar", m.get("b"));
        in = "a=1&b='foo+bar'&c=false";
        m = (Map)this.p.parse(in, Object.class);
        Assert.assertEquals((Object)1, m.get("a"));
        Assert.assertEquals((Object)"foo bar", m.get("b"));
        Assert.assertEquals((Object)false, m.get("c"));
        in = "a=1&b='foo%20bar'&c=false";
        m = (Map)this.p.parse(in, Object.class);
        Assert.assertEquals((Object)1, m.get("a"));
        Assert.assertEquals((Object)"foo bar", m.get("b"));
        Assert.assertEquals((Object)false, m.get("c"));
        ObjectMap jm = (ObjectMap)this.p.parse("x=@((attribute=value),(attribute=~'value~'))", Object.class);
        Assert.assertEquals((Object)"value", (Object)jm.getObjectList("x").getObjectMap(0).getString("attribute"));
        Assert.assertEquals((Object)"'value'", (Object)jm.getObjectList("x").getObjectMap(1).getString("attribute"));
        ObjectList jl = (ObjectList)this.p.parse("_value=@((attribute=value),(attribute=~'value~'))", Object.class);
        Assert.assertEquals((Object)"value", (Object)jl.getObjectMap(0).getString("attribute"));
        Assert.assertEquals((Object)"'value'", (Object)jl.getObjectMap(1).getString("attribute"));
        A1 b = new A1();
        A2 tl = new A2();
        tl.add(new A3("name0", "value0"));
        tl.add(new A3("name1", "value1"));
        b.list = tl;
        in = UrlEncodingSerializer.create().addBeanTypes(true).addRootType().build().serialize((Object)b);
        b = (A1)this.p.parse(in, Object.class);
        Assert.assertEquals((Object)"value1", (Object)((A3)b.list.get((int)1)).value);
        in = UrlEncodingSerializer.DEFAULT.serialize((Object)b);
        b = (A1)this.p.parse(in, A1.class);
        Assert.assertEquals((Object)"value1", (Object)((A3)b.list.get((int)1)).value);
    }

    @Test
    public void testCorrectHandlingOfUnknownProperties() throws Exception {
        UrlEncodingParser p = UrlEncodingParser.create().ignoreUnknownBeanProperties().build();
        String in = "a=1&unknown=3&b=2";
        B t = (B)p.parse(in, B.class);
        Assert.assertEquals((long)t.a, (long)1L);
        Assert.assertEquals((long)t.b, (long)2L);
        try {
            p = UrlEncodingParser.DEFAULT;
            p.parse(in, B.class);
            Assert.fail((String)"Exception expected");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    @Test
    public void testCollectionPropertiesWithNoSetters() throws Exception {
        UrlEncodingParser p = UrlEncodingParser.DEFAULT;
        String json = "ints=@(1,2,3)&beans=@((a=1,b=2))";
        C t = (C)p.parse(json, C.class);
        Assert.assertEquals((long)t.getInts().size(), (long)3L);
        Assert.assertEquals((long)t.getBeans().get((int)0).b, (long)2L);
    }

    @Test
    public void testParserListeners() throws Exception {
        UrlEncodingParser p = UrlEncodingParser.create().ignoreUnknownBeanProperties().listener(MyParserListener.class).build();
        String in = "a=1&unknownProperty=foo&b=2";
        p.parse(in, B.class);
        Assert.assertEquals((long)1L, (long)MyParserListener.events.size());
        Assert.assertEquals((Object)"unknownProperty, line 1, column 4", (Object)MyParserListener.events.get(0));
    }

    @Test
    public void testCollections() throws Exception {
        UrlEncodingSerializer s = UrlEncodingSerializer.DEFAULT;
        UrlEncodingParser p = UrlEncodingParser.DEFAULT;
        Object l = new ObjectList(new Object[]{"foo", "bar"});
        Assert.assertEquals((Object)"0=foo&1=bar", (Object)s.serialize(l));
        String in = "0=foo&1=bar";
        l = (List)p.parse(in, LinkedList.class, new Type[]{String.class});
        TestUtils.assertObjectEquals("['foo','bar']", l);
    }

    public static class MyParserListener
    extends ParserListener {
        static final List<String> events = new LinkedList<String>();

        public <T> void onUnknownBeanProperty(ParserSession session, String propertyName, Class<T> beanClass, T bean) {
            events.add(propertyName + ", " + session.getPosition());
        }
    }

    public static class C {
        private Collection<Integer> ints = new LinkedList<Integer>();
        private List<B> beans = new LinkedList<B>();

        public Collection<Integer> getInts() {
            return this.ints;
        }

        public List<B> getBeans() {
            return this.beans;
        }
    }

    public static class B {
        public int a;
        public int b;
    }

    public static class A3 {
        public String name;
        public String value;

        public A3() {
        }

        public A3(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }

    public static class A2
    extends LinkedList<A3> {
    }

    @Bean(typeName="A1")
    public static class A1 {
        public A2 list;
    }
}

