/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.uon;

import org.apache.juneau.ObjectMap;
import org.apache.juneau.uon.UonSerializer;
import org.junit.Assert;
import org.junit.Test;

public class UonSerializerTest {
    static UonSerializer s = UonSerializer.DEFAULT_ENCODING;
    static UonSerializer su = UonSerializer.DEFAULT;
    static UonSerializer sr = UonSerializer.DEFAULT_READABLE;

    @Test
    public void testBasic() throws Exception {
        Object t = "a";
        Assert.assertEquals((Object)"a", (Object)s.serialize(t));
        Assert.assertEquals((Object)"a", (Object)su.serialize(t));
        Assert.assertEquals((Object)"a", (Object)sr.serialize(t));
        t = new ObjectMap((CharSequence)"{a:'a'}");
        Assert.assertEquals((Object)"(a=a)", (Object)s.serialize(t));
        Assert.assertEquals((Object)"(a=a)", (Object)su.serialize(t));
        Assert.assertEquals((Object)"(\n\ta=a\n)", (Object)sr.serialize(t));
        t = new ObjectMap((CharSequence)"{a:'b',c:123,d:false,e:true,f:null}");
        Assert.assertEquals((Object)"(a=b,c=123,d=false,e=true,f=null)", (Object)s.serialize(t));
        Assert.assertEquals((Object)"(a=b,c=123,d=false,e=true,f=null)", (Object)su.serialize(t));
        Assert.assertEquals((Object)"(\n\ta=b,\n\tc=123,\n\td=false,\n\te=true,\n\tf=null\n)", (Object)sr.serialize(t));
        t = new ObjectMap((CharSequence)"{a:{a:'b',c:123,d:false,e:true,f:null}}");
        Assert.assertEquals((Object)"(a=(a=b,c=123,d=false,e=true,f=null))", (Object)s.serialize(t));
        Assert.assertEquals((Object)"(a=(a=b,c=123,d=false,e=true,f=null))", (Object)su.serialize(t));
        Assert.assertEquals((Object)"(\n\ta=(\n\t\ta=b,\n\t\tc=123,\n\t\td=false,\n\t\te=true,\n\t\tf=null\n\t)\n)", (Object)sr.serialize(t));
        t = new ObjectMap((CharSequence)"{a:'b',c:'123',d:'false',e:'true',f:'null'}");
        Assert.assertEquals((Object)"(a=b,c='123',d='false',e='true',f='null')", (Object)s.serialize(t));
        Assert.assertEquals((Object)"(a=b,c='123',d='false',e='true',f='null')", (Object)su.serialize(t));
        Assert.assertEquals((Object)"(\n\ta=b,\n\tc='123',\n\td='false',\n\te='true',\n\tf='null'\n)", (Object)sr.serialize(t));
        t = null;
        Assert.assertEquals((Object)"null", (Object)s.serialize(t));
        Assert.assertEquals((Object)"null", (Object)su.serialize(t));
        Assert.assertEquals((Object)"null", (Object)sr.serialize(t));
        t = new ObjectMap((CharSequence)"{null:null}");
        Assert.assertEquals((Object)"(null=null)", (Object)s.serialize(t));
        Assert.assertEquals((Object)"(null=null)", (Object)su.serialize(t));
        Assert.assertEquals((Object)"(\n\tnull=null\n)", (Object)sr.serialize(t));
        t = new ObjectMap((CharSequence)"{null:{null:null}}");
        Assert.assertEquals((Object)"(null=(null=null))", (Object)s.serialize(t));
        Assert.assertEquals((Object)"(null=(null=null))", (Object)su.serialize(t));
        Assert.assertEquals((Object)"(\n\tnull=(\n\t\tnull=null\n\t)\n)", (Object)sr.serialize(t));
        t = new String[]{};
        Assert.assertEquals((Object)"@()", (Object)s.serialize(t));
        Assert.assertEquals((Object)"@()", (Object)su.serialize(t));
        Assert.assertEquals((Object)"@()", (Object)sr.serialize(t));
        t = new ObjectMap((CharSequence)"{x:[]}");
        Assert.assertEquals((Object)"(x=@())", (Object)s.serialize(t));
        Assert.assertEquals((Object)"(x=@())", (Object)su.serialize(t));
        Assert.assertEquals((Object)"(\n\tx=@()\n)", (Object)sr.serialize(t));
        t = new String[1][0];
        Assert.assertEquals((Object)"@(@())", (Object)s.serialize(t));
        Assert.assertEquals((Object)"@(@())", (Object)su.serialize(t));
        Assert.assertEquals((Object)"@(\n\t@()\n)", (Object)sr.serialize(t));
        t = new String[]{""};
        Assert.assertEquals((Object)"@('')", (Object)s.serialize(t));
        Assert.assertEquals((Object)"@('')", (Object)su.serialize(t));
        Assert.assertEquals((Object)"@(\n\t''\n)", (Object)sr.serialize(t));
        t = new ObjectMap((CharSequence)"{x:['']}");
        Assert.assertEquals((Object)"(x=@(''))", (Object)s.serialize(t));
        Assert.assertEquals((Object)"(x=@(''))", (Object)su.serialize(t));
        Assert.assertEquals((Object)"(\n\tx=@(\n\t\t''\n\t)\n)", (Object)sr.serialize(t));
        t = new String[]{"", "", ""};
        Assert.assertEquals((Object)"@('','','')", (Object)s.serialize(t));
        Assert.assertEquals((Object)"@('','','')", (Object)su.serialize(t));
        Assert.assertEquals((Object)"@(\n\t'',\n\t'',\n\t''\n)", (Object)sr.serialize(t));
        t = "\u0000";
        Assert.assertEquals((Object)"%00", (Object)s.serialize(t));
        Assert.assertEquals((Object)"\u0000", (Object)su.serialize(t));
        Assert.assertEquals((Object)"\u0000", (Object)sr.serialize(t));
        t = new ObjectMap((CharSequence)"{'\u0000':'\u0000'}");
        Assert.assertEquals((Object)"(%00=%00)", (Object)s.serialize(t));
        Assert.assertEquals((Object)"(\u0000=\u0000)", (Object)su.serialize(t));
        Assert.assertEquals((Object)"(\n\t\u0000=\u0000\n)", (Object)sr.serialize(t));
        t = false;
        Assert.assertEquals((Object)"false", (Object)s.serialize(t));
        Assert.assertEquals((Object)"false", (Object)su.serialize(t));
        Assert.assertEquals((Object)"false", (Object)sr.serialize(t));
        t = new ObjectMap((CharSequence)"{x:false}");
        Assert.assertEquals((Object)"(x=false)", (Object)s.serialize(t));
        Assert.assertEquals((Object)"(x=false)", (Object)su.serialize(t));
        Assert.assertEquals((Object)"(\n\tx=false\n)", (Object)sr.serialize(t));
        t = 123;
        Assert.assertEquals((Object)"123", (Object)s.serialize(t));
        Assert.assertEquals((Object)"123", (Object)su.serialize(t));
        Assert.assertEquals((Object)"123", (Object)sr.serialize(t));
        t = new ObjectMap((CharSequence)"{x:123}");
        Assert.assertEquals((Object)"(x=123)", (Object)s.serialize(t));
        Assert.assertEquals((Object)"(x=123)", (Object)su.serialize(t));
        Assert.assertEquals((Object)"(\n\tx=123\n)", (Object)sr.serialize(t));
        t = "x;/?:@-_.!*'";
        Assert.assertEquals((Object)"x;/?:@-_.!*~'", (Object)s.serialize(t));
        Assert.assertEquals((Object)"x;/?:@-_.!*~'", (Object)su.serialize(t));
        Assert.assertEquals((Object)"x;/?:@-_.!*~'", (Object)sr.serialize(t));
        t = new ObjectMap((CharSequence)"{x:'x;/?:@-_.!*\\''}");
        Assert.assertEquals((Object)"(x=x;/?:@-_.!*~')", (Object)s.serialize(t));
        Assert.assertEquals((Object)"(x=x;/?:@-_.!*~')", (Object)su.serialize(t));
        Assert.assertEquals((Object)"(\n\tx=x;/?:@-_.!*~'\n)", (Object)sr.serialize(t));
        t = "x{}|\\^[]`<>#%\"&+";
        Assert.assertEquals((Object)"x%7B%7D%7C%5C%5E%5B%5D%60%3C%3E%23%25%22%26%2B", (Object)s.serialize(t));
        Assert.assertEquals((Object)"x{}|\\^[]`<>#%\"&+", (Object)su.serialize(t));
        Assert.assertEquals((Object)"x{}|\\^[]`<>#%\"&+", (Object)sr.serialize(t));
        t = new ObjectMap((CharSequence)"{'x{}|\\\\^[]`<>#%\"&+':'x{}|\\\\^[]`<>#%\"&+'}");
        Assert.assertEquals((Object)"(x%7B%7D%7C%5C%5E%5B%5D%60%3C%3E%23%25%22%26%2B=x%7B%7D%7C%5C%5E%5B%5D%60%3C%3E%23%25%22%26%2B)", (Object)s.serialize(t));
        Assert.assertEquals((Object)"(x{}|\\^[]`<>#%\"&+=x{}|\\^[]`<>#%\"&+)", (Object)su.serialize(t));
        Assert.assertEquals((Object)"(\n\tx{}|\\^[]`<>#%\"&+=x{}|\\^[]`<>#%\"&+\n)", (Object)sr.serialize(t));
        t = "x$,()~";
        Assert.assertEquals((Object)"'x$,()~~'", (Object)s.serialize(t));
        Assert.assertEquals((Object)"'x$,()~~'", (Object)su.serialize(t));
        Assert.assertEquals((Object)"'x$,()~~'", (Object)sr.serialize(t));
        t = new ObjectMap((CharSequence)"{'x$,()~':'x$,()~'}");
        Assert.assertEquals((Object)"('x$,()~~'='x$,()~~')", (Object)s.serialize(t));
        Assert.assertEquals((Object)"('x$,()~~'='x$,()~~')", (Object)su.serialize(t));
        Assert.assertEquals((Object)"(\n\t'x$,()~~'='x$,()~~'\n)", (Object)sr.serialize(t));
        t = new ObjectMap((CharSequence)"{'x$,()~':{'x$,()~':'x$,()~'}}");
        Assert.assertEquals((Object)"('x$,()~~'=('x$,()~~'='x$,()~~'))", (Object)s.serialize(t));
        Assert.assertEquals((Object)"('x$,()~~'=('x$,()~~'='x$,()~~'))", (Object)su.serialize(t));
        Assert.assertEquals((Object)"(\n\t'x$,()~~'=(\n\t\t'x$,()~~'='x$,()~~'\n\t)\n)", (Object)sr.serialize(t));
        t = "x=";
        Assert.assertEquals((Object)"'x='", (Object)s.serialize(t));
        Assert.assertEquals((Object)"'x='", (Object)su.serialize(t));
        Assert.assertEquals((Object)"'x='", (Object)sr.serialize(t));
        t = new ObjectMap((CharSequence)"{'x=':'x='}");
        Assert.assertEquals((Object)"('x='='x=')", (Object)s.serialize(t));
        Assert.assertEquals((Object)"('x='='x=')", (Object)su.serialize(t));
        Assert.assertEquals((Object)"(\n\t'x='='x='\n)", (Object)sr.serialize(t));
        t = new ObjectMap((CharSequence)"{'x=':{'x=':'x='}}");
        Assert.assertEquals((Object)"('x='=('x='='x='))", (Object)s.serialize(t));
        Assert.assertEquals((Object)"('x='=('x='='x='))", (Object)su.serialize(t));
        Assert.assertEquals((Object)"(\n\t'x='=(\n\t\t'x='='x='\n\t)\n)", (Object)sr.serialize(t));
        t = "()";
        Assert.assertEquals((Object)"'()'", (Object)s.serialize(t));
        Assert.assertEquals((Object)"'()'", (Object)su.serialize(t));
        Assert.assertEquals((Object)"'()'", (Object)sr.serialize(t));
        t = new ObjectMap((CharSequence)"{'()':'()'}");
        Assert.assertEquals((Object)"('()'='()')", (Object)s.serialize(t));
        Assert.assertEquals((Object)"('()'='()')", (Object)su.serialize(t));
        Assert.assertEquals((Object)"(\n\t'()'='()'\n)", (Object)sr.serialize(t));
        t = "$a";
        Assert.assertEquals((Object)"$a", (Object)s.serialize(t));
        Assert.assertEquals((Object)"$a", (Object)su.serialize(t));
        Assert.assertEquals((Object)"$a", (Object)sr.serialize(t));
        t = new ObjectMap((CharSequence)"{$a:'$a'}");
        Assert.assertEquals((Object)"($a=$a)", (Object)s.serialize(t));
        Assert.assertEquals((Object)"($a=$a)", (Object)su.serialize(t));
        Assert.assertEquals((Object)"(\n\t$a=$a\n)", (Object)sr.serialize(t));
        t = "";
        Assert.assertEquals((Object)"''", (Object)s.serialize(t));
        Assert.assertEquals((Object)"''", (Object)su.serialize(t));
        Assert.assertEquals((Object)"''", (Object)sr.serialize(t));
        t = new ObjectMap((CharSequence)"{'':''}");
        Assert.assertEquals((Object)"(''='')", (Object)s.serialize(t));
        Assert.assertEquals((Object)"(''='')", (Object)su.serialize(t));
        Assert.assertEquals((Object)"(\n\t''=''\n)", (Object)sr.serialize(t));
        t = new ObjectMap((CharSequence)"{'':{'':''}}");
        Assert.assertEquals((Object)"(''=(''=''))", (Object)s.serialize(t));
        Assert.assertEquals((Object)"(''=(''=''))", (Object)su.serialize(t));
        Assert.assertEquals((Object)"(\n\t''=(\n\t\t''=''\n\t)\n)", (Object)sr.serialize(t));
        t = "\n";
        Assert.assertEquals((Object)"'%0A'", (Object)s.serialize(t));
        Assert.assertEquals((Object)"'\n'", (Object)su.serialize(t));
        Assert.assertEquals((Object)"'\n'", (Object)sr.serialize(t));
        t = new ObjectMap((CharSequence)"{'\n':'\n'}");
        Assert.assertEquals((Object)"('%0A'='%0A')", (Object)s.serialize(t));
        Assert.assertEquals((Object)"('\n'='\n')", (Object)su.serialize(t));
        Assert.assertEquals((Object)"(\n\t'\n'='\n'\n)", (Object)sr.serialize(t));
        t = new ObjectMap((CharSequence)"{'\n':{'\n':'\n'}}");
        Assert.assertEquals((Object)"('%0A'=('%0A'='%0A'))", (Object)s.serialize(t));
        Assert.assertEquals((Object)"('\n'=('\n'='\n'))", (Object)su.serialize(t));
        Assert.assertEquals((Object)"(\n\t'\n'=(\n\t\t'\n'='\n'\n\t)\n)", (Object)sr.serialize(t));
    }

    @Test
    public void testUnicodeChars() throws Exception {
        String t = "\u00a2";
        Assert.assertEquals((Object)"%C2%A2", (Object)s.serialize((Object)t));
        Assert.assertEquals((Object)"\u00a2", (Object)su.serialize((Object)t));
        Assert.assertEquals((Object)"\u00a2", (Object)sr.serialize((Object)t));
        t = new ObjectMap((CharSequence)"{'\u00a2':'\u00a2'}");
        Assert.assertEquals((Object)"(%C2%A2=%C2%A2)", (Object)s.serialize((Object)t));
        Assert.assertEquals((Object)"(\u00a2=\u00a2)", (Object)su.serialize((Object)t));
        Assert.assertEquals((Object)"(\n\t\u00a2=\u00a2\n)", (Object)sr.serialize((Object)t));
        t = new ObjectMap((CharSequence)"{'\u00a2':{'\u00a2':'\u00a2'}}");
        Assert.assertEquals((Object)"(%C2%A2=(%C2%A2=%C2%A2))", (Object)s.serialize((Object)t));
        Assert.assertEquals((Object)"(\u00a2=(\u00a2=\u00a2))", (Object)su.serialize((Object)t));
        Assert.assertEquals((Object)"(\n\t\u00a2=(\n\t\t\u00a2=\u00a2\n\t)\n)", (Object)sr.serialize((Object)t));
        t = "\u20ac";
        Assert.assertEquals((Object)"%E2%82%AC", (Object)s.serialize((Object)t));
        Assert.assertEquals((Object)"\u20ac", (Object)su.serialize((Object)t));
        Assert.assertEquals((Object)"\u20ac", (Object)sr.serialize((Object)t));
        t = new ObjectMap((CharSequence)"{'\u20ac':'\u20ac'}");
        Assert.assertEquals((Object)"(%E2%82%AC=%E2%82%AC)", (Object)s.serialize((Object)t));
        Assert.assertEquals((Object)"(\u20ac=\u20ac)", (Object)su.serialize((Object)t));
        Assert.assertEquals((Object)"(\n\t\u20ac=\u20ac\n)", (Object)sr.serialize((Object)t));
        t = new ObjectMap((CharSequence)"{'\u20ac':{'\u20ac':'\u20ac'}}");
        Assert.assertEquals((Object)"(%E2%82%AC=(%E2%82%AC=%E2%82%AC))", (Object)s.serialize((Object)t));
        Assert.assertEquals((Object)"(\u20ac=(\u20ac=\u20ac))", (Object)su.serialize((Object)t));
        Assert.assertEquals((Object)"(\n\t\u20ac=(\n\t\t\u20ac=\u20ac\n\t)\n)", (Object)sr.serialize((Object)t));
        t = "\ud852\udf62";
        Assert.assertEquals((Object)"%F0%A4%AD%A2", (Object)s.serialize((Object)t));
        Assert.assertEquals((Object)"\ud852\udf62", (Object)su.serialize((Object)t));
        Assert.assertEquals((Object)"\ud852\udf62", (Object)sr.serialize((Object)t));
        t = new ObjectMap((CharSequence)"{'\ud852\udf62':'\ud852\udf62'}");
        Assert.assertEquals((Object)"(%F0%A4%AD%A2=%F0%A4%AD%A2)", (Object)s.serialize((Object)t));
        Assert.assertEquals((Object)"(\ud852\udf62=\ud852\udf62)", (Object)su.serialize((Object)t));
        Assert.assertEquals((Object)"(\n\t\ud852\udf62=\ud852\udf62\n)", (Object)sr.serialize((Object)t));
        t = new ObjectMap((CharSequence)"{'\ud852\udf62':{'\ud852\udf62':'\ud852\udf62'}}");
        Assert.assertEquals((Object)"(%F0%A4%AD%A2=(%F0%A4%AD%A2=%F0%A4%AD%A2))", (Object)s.serialize((Object)t));
        Assert.assertEquals((Object)"(\ud852\udf62=(\ud852\udf62=\ud852\udf62))", (Object)su.serialize((Object)t));
        Assert.assertEquals((Object)"(\n\t\ud852\udf62=(\n\t\t\ud852\udf62=\ud852\udf62\n\t)\n)", (Object)sr.serialize((Object)t));
    }
}

