/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.uon;

import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.juneau.CloseableStringReader;
import org.apache.juneau.ObjectList;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.testutils.TestUtils;
import org.apache.juneau.uon.UonParser;
import org.junit.Assert;
import org.junit.Test;

public class UonParserTest {
    static UonParser p = UonParser.DEFAULT;
    static UonParser pe = UonParser.DEFAULT_DECODING;

    @Test
    public void testBasic() throws Exception {
        String t = "a";
        Assert.assertEquals((Object)"a", (Object)p.parse(t, String.class));
        Assert.assertEquals((Object)"a", (Object)p.parse(t, Object.class));
        Assert.assertEquals((Object)"a", (Object)pe.parse(t, String.class));
        t = "'a'";
        Assert.assertEquals((Object)"a", (Object)p.parse(t, String.class));
        Assert.assertEquals((Object)"a", (Object)p.parse(t, Object.class));
        t = " 'a' ";
        Assert.assertEquals((Object)"a", (Object)p.parse(t, String.class));
        t = "(a=a)";
        Assert.assertEquals((Object)"a", ((Map)p.parse(t, Map.class)).get("a"));
        Assert.assertEquals((Object)"a", ((Map)pe.parse(t, Map.class)).get("a"));
        t = "('a'='a')";
        Assert.assertEquals((Object)"a", ((Map)p.parse(t, Map.class)).get("a"));
        Assert.assertEquals((Object)"a", ((Map)pe.parse(t, Map.class)).get("a"));
        t = "(a=b,c=123,d=false,e=true,f=null)";
        Map m = (Map)p.parse(t, Map.class);
        Assert.assertEquals((Object)"b", m.get("a"));
        Assert.assertTrue((boolean)(m.get("c") instanceof Number));
        Assert.assertEquals((Object)123, m.get("c"));
        Assert.assertTrue((boolean)(m.get("d") instanceof Boolean));
        Assert.assertEquals((Object)Boolean.FALSE, m.get("d"));
        Assert.assertTrue((boolean)(m.get("e") instanceof Boolean));
        Assert.assertEquals((Object)Boolean.TRUE, m.get("e"));
        m = (Map)pe.parse(t, Map.class);
        Assert.assertNull(m.get("f"));
        t = "(a=true)";
        m = (Map)p.parse(t, HashMap.class, new Type[]{String.class, Boolean.class});
        Assert.assertTrue((boolean)(m.get("a") instanceof Boolean));
        Assert.assertEquals((Object)"true", (Object)m.get("a").toString());
        t = "null";
        Assert.assertNull((Object)p.parse(t, Object.class));
        Assert.assertNull((Object)pe.parse(t, Object.class));
        t = "(null=null)";
        m = (Map)p.parse(t, Map.class);
        Assert.assertTrue((boolean)m.containsKey(null));
        Assert.assertNull(m.get(null));
        m = (Map)pe.parse(t, Map.class);
        Assert.assertTrue((boolean)m.containsKey(null));
        Assert.assertNull(m.get(null));
        t = " ( null = null ) ";
        m = (Map)p.parse(t, Map.class);
        Assert.assertTrue((boolean)m.containsKey(null));
        Assert.assertNull(m.get(null));
        m = (Map)pe.parse(t, Map.class);
        Assert.assertTrue((boolean)m.containsKey(null));
        Assert.assertNull(m.get(null));
        t = "(null=(null=null))";
        m = (Map)p.parse(t, Map.class);
        Assert.assertTrue((boolean)((Map)m.get(null)).containsKey(null));
        Assert.assertNull(((Map)m.get(null)).get(null));
        m = (Map)pe.parse(t, Map.class);
        Assert.assertTrue((boolean)((Map)m.get(null)).containsKey(null));
        Assert.assertNull(((Map)m.get(null)).get(null));
        t = "@()";
        List l = (List)p.parse(t, Object.class);
        Assert.assertTrue((boolean)l.isEmpty());
        t = " @( ) ";
        l = (List)p.parse(t, List.class);
        Assert.assertTrue((boolean)l.isEmpty());
        t = "(x=@())";
        m = (Map)p.parse(t, HashMap.class, new Type[]{String.class, List.class});
        Assert.assertTrue((boolean)m.containsKey("x"));
        Assert.assertTrue((boolean)((List)m.get("x")).isEmpty());
        m = (Map)p.parse(t, Object.class);
        Assert.assertTrue((boolean)m.containsKey("x"));
        Assert.assertTrue((boolean)((List)m.get("x")).isEmpty());
        t = " ( x = @( ) )";
        m = (Map)p.parse(t, HashMap.class, new Type[]{String.class, List.class});
        Assert.assertTrue((boolean)m.containsKey("x"));
        Assert.assertTrue((boolean)((List)m.get("x")).isEmpty());
        t = "@(@())";
        l = (List)p.parse(t, Object.class);
        Assert.assertTrue((l.size() == 1 ? 1 : 0) != 0);
        l = (List)l.get(0);
        Assert.assertTrue((boolean)l.isEmpty());
        t = " @( @( ) ) ";
        l = (List)p.parse(t, LinkedList.class, new Type[]{List.class});
        Assert.assertTrue((l.size() == 1 ? 1 : 0) != 0);
        l = (List)l.get(0);
        Assert.assertTrue((boolean)l.isEmpty());
        t = "@('')";
        l = (List)p.parse(t, Object.class);
        Assert.assertTrue((l.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"", l.get(0));
        t = " @( '' ) ";
        l = (List)p.parse(t, List.class, new Type[]{String.class});
        Assert.assertTrue((l.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"", l.get(0));
        t = "(''=@(''))";
        m = (Map)p.parse(t, Object.class);
        Assert.assertEquals((Object)"", ((List)m.get("")).get(0));
        t = " ( '' = @( '' ) ) ";
        m = (Map)p.parse(t, HashMap.class, new Type[]{String.class, List.class});
        Assert.assertEquals((Object)"", ((List)m.get("")).get(0));
        t = "@('','','')";
        l = (List)p.parse(t, Object.class);
        Assert.assertTrue((l.size() == 3 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"", l.get(0));
        Assert.assertEquals((Object)"", l.get(1));
        Assert.assertEquals((Object)"", l.get(2));
        t = " @( '' , '' , '' ) ";
        l = (List)p.parse(t, List.class, new Type[]{Object.class});
        Assert.assertTrue((l.size() == 3 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"", l.get(0));
        Assert.assertEquals((Object)"", l.get(1));
        Assert.assertEquals((Object)"", l.get(2));
        t = "'\u0000'";
        Assert.assertEquals((Object)"\u0000", (Object)p.parse(t, Object.class));
        t = " '\u0000' ";
        Assert.assertEquals((Object)"\u0000", (Object)p.parse(t, String.class));
        Assert.assertEquals((Object)"\u0000", (Object)p.parse(t, Object.class));
        t = "('\u0000'='\u0000')";
        m = (Map)p.parse(t, Object.class);
        Assert.assertTrue((m.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"\u0000", m.get("\u0000"));
        t = " ( '\u0000' = '\u0000' ) ";
        m = (Map)p.parse(t, HashMap.class, new Type[]{String.class, String.class});
        Assert.assertTrue((m.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"\u0000", m.get("\u0000"));
        m = (Map)p.parse(t, HashMap.class, new Type[]{String.class, Object.class});
        Assert.assertTrue((m.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"\u0000", m.get("\u0000"));
        t = "false";
        Boolean b = (Boolean)p.parse(t, Object.class);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)b);
        b = (Boolean)p.parse(t, Boolean.class);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)b);
        t = " false ";
        b = (Boolean)p.parse(t, Boolean.class);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)b);
        t = "(x=false)";
        m = (Map)p.parse(t, Object.class);
        Assert.assertEquals((Object)Boolean.FALSE, m.get("x"));
        t = " ( x = false ) ";
        m = (Map)p.parse(t, HashMap.class, new Type[]{String.class, Object.class});
        Assert.assertEquals((Object)Boolean.FALSE, m.get("x"));
        t = "123";
        Integer i = (Integer)p.parse(t, Object.class);
        Assert.assertEquals((long)123L, (long)i.intValue());
        i = (Integer)p.parse(t, Integer.class);
        Assert.assertEquals((long)123L, (long)i.intValue());
        Double d = (Double)p.parse(t, Double.class);
        Assert.assertEquals((long)123L, (long)d.intValue());
        Float f = (Float)p.parse(t, Float.class);
        Assert.assertEquals((long)123L, (long)f.intValue());
        t = " 123 ";
        i = (Integer)p.parse(t, Integer.class);
        Assert.assertEquals((long)123L, (long)i.intValue());
        t = "(x=123)";
        m = (Map)p.parse(t, Object.class);
        Assert.assertEquals((long)123L, (long)((Integer)m.get("x")).intValue());
        t = " ( x = 123 ) ";
        m = (Map)p.parse(t, HashMap.class, new Type[]{String.class, Number.class});
        Assert.assertEquals((long)123L, (long)((Integer)m.get("x")).intValue());
        m = (Map)p.parse(t, HashMap.class, new Type[]{String.class, Double.class});
        Assert.assertEquals((long)123L, (long)((Double)m.get("x")).intValue());
        t = "x;/?:@-_.!*~'";
        Assert.assertEquals((Object)"x;/?:@-_.!*'", (Object)p.parse(t, Object.class));
        Assert.assertEquals((Object)"x;/?:@-_.!*'", (Object)pe.parse(t, Object.class));
        t = "(x;/?:@-_.!*~'=x;/?:@-_.!*~')";
        m = (Map)p.parse(t, Object.class);
        Assert.assertEquals((Object)"x;/?:@-_.!*'", m.get("x;/?:@-_.!*'"));
        m = (Map)p.parse(t, HashMap.class, new Type[]{String.class, Object.class});
        Assert.assertEquals((Object)"x;/?:@-_.!*'", m.get("x;/?:@-_.!*'"));
        m = (Map)p.parse(t, HashMap.class, new Type[]{String.class, String.class});
        Assert.assertEquals((Object)"x;/?:@-_.!*'", m.get("x;/?:@-_.!*'"));
        t = "x{}|\\^[]`<>#%\"&+";
        Assert.assertEquals((Object)"x{}|\\^[]`<>#%\"&+", (Object)p.parse(t, Object.class));
        Assert.assertEquals((Object)"x{}|\\^[]`<>#%\"&+", (Object)p.parse(t, String.class));
        try {
            Assert.assertEquals((Object)"x{}|\\^[]`<>#%\"&+", (Object)pe.parse(t, Object.class));
            Assert.fail((String)"Expected parse exception from invalid hex sequence.");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        t = "x%7B%7D%7C%5C%5E%5B%5D%60%3C%3E%23%25%22%26%2B";
        Assert.assertEquals((Object)"x{}|\\^[]`<>#%\"&+", (Object)pe.parse(t, Object.class));
        Assert.assertEquals((Object)"x{}|\\^[]`<>#%\"&+", (Object)pe.parse(t, String.class));
        t = "(x{}|\\^[]`<>#%\"&+=x{}|\\^[]`<>#%\"&+)";
        m = (Map)p.parse(t, Object.class);
        Assert.assertEquals((Object)"x{}|\\^[]`<>#%\"&+", m.get("x{}|\\^[]`<>#%\"&+"));
        try {
            m = (Map)pe.parse(t, Object.class);
            Assert.fail((String)"Expected parse exception from invalid hex sequence.");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        t = "(x%7B%7D%7C%5C%5E%5B%5D%60%3C%3E%23%25%22%26%2B=x%7B%7D%7C%5C%5E%5B%5D%60%3C%3E%23%25%22%26%2B)";
        m = (Map)pe.parse(t, Object.class);
        Assert.assertEquals((Object)"x{}|\\^[]`<>#%\"&+", m.get("x{}|\\^[]`<>#%\"&+"));
        t = "'x$,()~''";
        Assert.assertEquals((Object)"x$,()'", (Object)p.parse(t, Object.class));
        t = " 'x$,()~'' ";
        Assert.assertEquals((Object)"x$,()'", (Object)p.parse(t, Object.class));
        t = "('x$,()~''='x$,()~'')";
        m = (Map)p.parse(t, Object.class);
        Assert.assertEquals((Object)"x$,()'", m.get("x$,()'"));
        t = " ( 'x$,()~'' = 'x$,()~'' ) ";
        m = (Map)p.parse(t, Object.class);
        Assert.assertEquals((Object)"x$,()'", m.get("x$,()'"));
        t = "x=";
        Assert.assertEquals((Object)"x=", (Object)p.parse(t, Object.class));
        t = "x%3D";
        Assert.assertEquals((Object)"x=", (Object)pe.parse(t, Object.class));
        t = "('x='='x=')";
        m = (Map)p.parse(t, Object.class);
        Assert.assertEquals((Object)"x=", m.get("x="));
        t = "('x='='x=')";
        m = (Map)p.parse(t, Object.class);
        Assert.assertEquals((Object)"x=", m.get("x="));
        t = " ( 'x=' = 'x=' ) ";
        m = (Map)p.parse(t, Object.class);
        Assert.assertEquals((Object)"x=", m.get("x="));
        t = "('x='='x=')";
        m = (Map)p.parse(t, HashMap.class, new Type[]{String.class, Object.class});
        Assert.assertEquals((Object)"x=", m.get("x="));
        t = " ( 'x=' = 'x=' ) ";
        m = (Map)p.parse(t, HashMap.class, new Type[]{String.class, Object.class});
        Assert.assertEquals((Object)"x=", m.get("x="));
        t = "('x%3D'='x%3D')";
        m = (Map)pe.parse(t, Object.class);
        Assert.assertEquals((Object)"x=", m.get("x="));
        t = " ( 'x%3D' = 'x%3D' ) ";
        m = (Map)pe.parse(t, Object.class);
        Assert.assertEquals((Object)"x=", m.get("x="));
        t = "'()'";
        Assert.assertEquals((Object)"()", (Object)p.parse(t, Object.class));
        Assert.assertEquals((Object)"()", (Object)p.parse(t, String.class));
        t = " '()' ";
        Assert.assertEquals((Object)"()", (Object)p.parse(t, Object.class));
        Assert.assertEquals((Object)"()", (Object)p.parse(t, String.class));
        t = "('()'='()')";
        m = (Map)p.parse(t, Object.class);
        Assert.assertEquals((Object)"()", m.get("()"));
        t = " ( '()' = '()' ) ";
        m = (Map)p.parse(t, HashMap.class, new Type[]{String.class, Object.class});
        Assert.assertEquals((Object)"()", m.get("()"));
        t = "$a";
        Assert.assertEquals((Object)"$a", (Object)p.parse(t, Object.class));
        t = "'$a'";
        Assert.assertEquals((Object)"$a", (Object)p.parse(t, Object.class));
        t = "($a=$a)";
        m = (Map)p.parse(t, Object.class);
        Assert.assertEquals((Object)"$a", m.get("$a"));
        t = " ( $a = $a ) ";
        m = (Map)p.parse(t, Object.class);
        Assert.assertEquals((Object)"$a", m.get("$a"));
        t = "('$a'='$a')";
        m = (Map)p.parse(t, HashMap.class, new Type[]{String.class, Object.class});
        Assert.assertEquals((Object)"$a", m.get("$a"));
        t = " ( '$a' = '$a' ) ";
        m = (Map)p.parse(t, HashMap.class, new Type[]{String.class, Object.class});
        Assert.assertEquals((Object)"$a", m.get("$a"));
        t = "";
        Assert.assertEquals((Object)"", (Object)p.parse(t, Object.class));
        Assert.assertEquals((Object)"", (Object)pe.parse(t, Object.class));
        t = "(=)";
        m = (Map)p.parse(t, Object.class);
        Assert.assertEquals((Object)"", m.get(""));
        t = "(''='')";
        m = (Map)p.parse(t, HashMap.class, new Type[]{String.class, Object.class});
        Assert.assertEquals((Object)"", m.get(""));
        t = "(=(=))";
        m = (Map)p.parse(t, Object.class);
        Assert.assertEquals((Object)"", ((Map)m.get("")).get(""));
        t = " ( = ( = ) ) ";
        m = (Map)p.parse(t, HashMap.class, new Type[]{String.class, HashMap.class});
        Assert.assertEquals((Object)"", ((Map)m.get("")).get(""));
        t = "'%0A'";
        Assert.assertEquals((Object)"\n", (Object)pe.parse(t, Object.class));
        Assert.assertEquals((Object)"%0A", (Object)p.parse(t, Object.class));
        t = "('%0A'='%0A')";
        m = (Map)pe.parse(t, Object.class);
        Assert.assertEquals((Object)"\n", m.get("\n"));
        m = (Map)p.parse(t, Object.class);
        Assert.assertEquals((Object)"%0A", m.get("%0A"));
        t = "('%0A'=('%0A'='%0A'))";
        m = (Map)pe.parse(t, Object.class);
        Assert.assertEquals((Object)"\n", ((Map)m.get("\n")).get("\n"));
    }

    @Test
    public void testUnicodeChars() throws Exception {
        String t = "\u00a2";
        Assert.assertEquals((Object)"\u00a2", (Object)p.parse(t, Object.class));
        Assert.assertEquals((Object)"\u00a2", (Object)p.parse(t, String.class));
        t = "%C2%A2";
        Assert.assertEquals((Object)"\u00a2", (Object)pe.parse(t, Object.class));
        Assert.assertEquals((Object)"\u00a2", (Object)pe.parse(t, String.class));
        t = "(\u00a2=\u00a2)";
        Map m = (Map)p.parse(t, Object.class);
        Assert.assertEquals((Object)"\u00a2", m.get("\u00a2"));
        t = "(%C2%A2=%C2%A2)";
        m = (Map)pe.parse(t, Object.class);
        Assert.assertEquals((Object)"\u00a2", m.get("\u00a2"));
        t = "(\u00a2=(\u00a2=\u00a2))";
        m = (Map)p.parse(t, Object.class);
        Assert.assertEquals((Object)"\u00a2", ((Map)m.get("\u00a2")).get("\u00a2"));
        t = "(%C2%A2=(%C2%A2=%C2%A2))";
        m = (Map)pe.parse(t, Object.class);
        Assert.assertEquals((Object)"\u00a2", ((Map)m.get("\u00a2")).get("\u00a2"));
        t = "\u20ac";
        Assert.assertEquals((Object)"\u20ac", (Object)p.parse(t, Object.class));
        Assert.assertEquals((Object)"\u20ac", (Object)p.parse(t, String.class));
        t = "%E2%82%AC";
        Assert.assertEquals((Object)"\u20ac", (Object)pe.parse(t, Object.class));
        Assert.assertEquals((Object)"\u20ac", (Object)pe.parse(t, String.class));
        t = "(\u20ac=\u20ac)";
        m = (Map)p.parse(t, Object.class);
        Assert.assertEquals((Object)"\u20ac", m.get("\u20ac"));
        t = "(%E2%82%AC=%E2%82%AC)";
        m = (Map)pe.parse(t, Object.class);
        Assert.assertEquals((Object)"\u20ac", m.get("\u20ac"));
        t = "(\u20ac=(\u20ac=\u20ac))";
        m = (Map)p.parse(t, Object.class);
        Assert.assertEquals((Object)"\u20ac", ((Map)m.get("\u20ac")).get("\u20ac"));
        t = "(%E2%82%AC=(%E2%82%AC=%E2%82%AC))";
        m = (Map)pe.parse(t, Object.class);
        Assert.assertEquals((Object)"\u20ac", ((Map)m.get("\u20ac")).get("\u20ac"));
        t = "\ud852\udf62";
        Assert.assertEquals((Object)"\ud852\udf62", (Object)p.parse(t, Object.class));
        Assert.assertEquals((Object)"\ud852\udf62", (Object)p.parse(t, String.class));
        t = "%F0%A4%AD%A2";
        Assert.assertEquals((Object)"\ud852\udf62", (Object)pe.parse(t, Object.class));
        Assert.assertEquals((Object)"\ud852\udf62", (Object)pe.parse(t, String.class));
        t = "(\ud852\udf62=\ud852\udf62)";
        m = (Map)p.parse(t, Object.class);
        Assert.assertEquals((Object)"\ud852\udf62", m.get("\ud852\udf62"));
        t = "(%F0%A4%AD%A2=%F0%A4%AD%A2)";
        m = (Map)pe.parse(t, Object.class);
        Assert.assertEquals((Object)"\ud852\udf62", m.get("\ud852\udf62"));
        t = "(\ud852\udf62=(\ud852\udf62=\ud852\udf62))";
        m = (Map)p.parse(t, Object.class);
        Assert.assertEquals((Object)"\ud852\udf62", ((Map)m.get("\ud852\udf62")).get("\ud852\udf62"));
        t = "(%F0%A4%AD%A2=(%F0%A4%AD%A2=%F0%A4%AD%A2))";
        m = (Map)pe.parse(t, Object.class);
        Assert.assertEquals((Object)"\ud852\udf62", ((Map)m.get("\ud852\udf62")).get("\ud852\udf62"));
    }

    @Test
    public void testSimpleBean() throws Exception {
        UonParser p = UonParser.DEFAULT;
        String s = "(f1=foo,f2=123)";
        A t = (A)p.parse(s, A.class);
        Assert.assertEquals((Object)"foo", (Object)t.f1);
        Assert.assertEquals((long)123L, (long)t.f2);
    }

    @Test
    public void testStreamsAutoClose() throws Exception {
        UonParser p = UonParser.DEFAULT.builder().autoCloseStreams().build();
        Reader r = this.reader("(foo=bar)(foo=bar)");
        Object x = p.parse((Object)r, ObjectMap.class);
        TestUtils.assertObjectEquals("{foo:'bar'}", x);
        try {
            x = p.parse((Object)r, ObjectMap.class);
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Reader is closed"));
        }
    }

    @Test
    public void testMultipleObjectsInStream() throws Exception {
        UonParser p = UonParser.create().unbuffered().build();
        Reader r = this.reader("(foo=bar)(baz=qux)");
        Object x = p.parse((Object)r, ObjectMap.class);
        TestUtils.assertObjectEquals("{foo:'bar'}", x);
        x = p.parse((Object)r, ObjectMap.class);
        TestUtils.assertObjectEquals("{baz:'qux'}", x);
        r = this.reader("@(123)@(456)");
        x = p.parse((Object)r, ObjectList.class);
        TestUtils.assertObjectEquals("[123]", x);
        x = p.parse((Object)r, ObjectList.class);
        TestUtils.assertObjectEquals("[456]", x);
    }

    private Reader reader(String in) {
        return new CloseableStringReader(in);
    }

    public static class A {
        public String f1;
        public int f2;
    }
}

