/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.uon;

import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.apache.juneau.parser.ParserPipe;
import org.apache.juneau.testutils.TestUtils;
import org.apache.juneau.uon.UonReader;
import org.junit.Assert;
import org.junit.Test;

public class UonParserReaderTest {
    @Test
    public void testBasic() throws Exception {
        UonReader r = this.r("f", true);
        Assert.assertEquals((long)102L, (long)r.read());
        Assert.assertEquals((long)-1L, (long)r.read());
        r = this.r("%66", true);
        Assert.assertEquals((long)102L, (long)r.read());
        Assert.assertEquals((long)-1L, (long)r.read());
        r = this.r("%7D", true);
        Assert.assertEquals((long)125L, (long)r.read());
        Assert.assertEquals((long)-1L, (long)r.read());
        r = this.r("%7D%7D", true);
        Assert.assertEquals((long)125L, (long)r.read());
        Assert.assertEquals((long)125L, (long)r.read());
        Assert.assertEquals((long)-1L, (long)r.read());
        r = this.r("%00%00", true);
        r.mark();
        Assert.assertEquals((long)0L, (long)r.read());
        Assert.assertEquals((long)0L, (long)r.read());
        Assert.assertEquals((Object)"\u0000\u0000", (Object)r.getMarked());
        Assert.assertEquals((long)-1L, (long)r.read());
        String in = this.escape("\u0080");
        r = this.r(in, true);
        Assert.assertEquals((long)128L, (long)r.read());
        Assert.assertEquals((long)-1L, (long)r.read());
        in = this.escape("\u0800");
        r = this.r(in, true);
        Assert.assertEquals((long)2048L, (long)r.read());
        Assert.assertEquals((long)-1L, (long)r.read());
        in = this.escape("\uffff");
        r = this.r(in, true);
        Assert.assertEquals((long)65535L, (long)r.read());
        Assert.assertEquals((long)-1L, (long)r.read());
        String s = "\u00a2";
        r = this.r(this.escape(s), true);
        Assert.assertEquals((long)s.codePointAt(0), (long)r.read());
        Assert.assertEquals((long)-1L, (long)r.read());
        s = "\u20ac";
        r = this.r(this.escape(s), true);
        Assert.assertEquals((long)s.codePointAt(0), (long)r.readCodePoint());
        Assert.assertEquals((long)-1L, (long)r.read());
        s = "\ud852\udf62";
        r = this.r(this.escape(s), true);
        Assert.assertEquals((long)s.codePointAt(0), (long)r.readCodePoint());
        Assert.assertEquals((long)-1L, (long)r.read());
        s = "\ud852\udf62\ud852\udf62";
        r = this.r(this.escape(s), true);
        Assert.assertEquals((long)s.codePointAt(0), (long)r.readCodePoint());
        Assert.assertEquals((long)s.codePointAt(2), (long)r.readCodePoint());
        Assert.assertEquals((long)-1L, (long)r.read());
        s = "\u00a2\u20ac\ud852\udf62\u00a2\u20ac\ud852\udf62";
        in = this.escape(s);
        r = this.r(in, true);
        Assert.assertEquals((long)s.codePointAt(0), (long)r.readCodePoint());
        Assert.assertEquals((long)s.codePointAt(1), (long)r.readCodePoint());
        Assert.assertEquals((long)s.codePointAt(2), (long)r.readCodePoint());
        Assert.assertEquals((long)s.codePointAt(4), (long)r.readCodePoint());
        Assert.assertEquals((long)s.codePointAt(5), (long)r.readCodePoint());
        Assert.assertEquals((long)s.codePointAt(6), (long)r.readCodePoint());
        Assert.assertEquals((long)-1L, (long)r.read());
        s = "\u00a2\u20ac\ud852\udf62\u00a2\u20ac\ud852\udf62";
        in = this.escape(s);
        r = this.r(in, true);
        char[] buff = new char[2];
        int i = r.read(buff, 0, buff.length);
        String s2 = new String(buff, 0, i);
        Assert.assertEquals((Object)"\u00a2", (Object)s2);
        i = r.read(buff, 0, buff.length);
        s2 = new String(buff, 0, i);
        Assert.assertEquals((Object)"\u20ac", (Object)s2);
        i = r.read(buff, 0, buff.length);
        s2 = new String(buff, 0, i);
        Assert.assertEquals((Object)"\ud852\udf62", (Object)s2);
        i = r.read(buff, 0, buff.length);
        s2 = new String(buff, 0, i);
        Assert.assertEquals((Object)"\u00a2", (Object)s2);
        i = r.read(buff, 0, buff.length);
        s2 = new String(buff, 0, i);
        Assert.assertEquals((Object)"\u20ac", (Object)s2);
        i = r.read(buff, 0, buff.length);
        s2 = new String(buff, 0, i);
        Assert.assertEquals((Object)"\ud852\udf62", (Object)s2);
        i = r.read(buff, 0, buff.length);
        Assert.assertEquals((long)-1L, (long)i);
        s = "\u00a2\u20ac\ud852\udf62\u00a2\u20ac\ud852\udf62";
        in = this.escape(s);
        r = this.r(in, true);
        buff = new char[3];
        i = r.read(buff, 0, buff.length);
        s2 = new String(buff, 0, i);
        Assert.assertEquals((Object)"\u00a2\u20ac", (Object)s2);
        i = r.read(buff, 0, buff.length);
        s2 = new String(buff, 0, i);
        Assert.assertEquals((Object)"\ud852\udf62", (Object)s2);
        i = r.read(buff, 0, buff.length);
        s2 = new String(buff, 0, i);
        Assert.assertEquals((Object)"\u00a2\u20ac", (Object)s2);
        i = r.read(buff, 0, buff.length);
        s2 = new String(buff, 0, i);
        Assert.assertEquals((Object)"\ud852\udf62", (Object)s2);
        i = r.read(buff, 0, buff.length);
        Assert.assertEquals((long)-1L, (long)i);
        s = "\u00a2\u20ac\ud852\udf62\u00a2\u20ac\ud852\udf62";
        in = this.escape(s);
        r = this.r(in, true);
        buff = new char[4];
        i = r.read(buff, 0, buff.length);
        s2 = new String(buff, 0, i);
        Assert.assertEquals((Object)"\u00a2\u20ac\ud852\udf62", (Object)s2);
        i = r.read(buff, 0, buff.length);
        s2 = new String(buff, 0, i);
        Assert.assertEquals((Object)"\u00a2\u20ac\ud852\udf62", (Object)s2);
        i = r.read(buff, 0, buff.length);
        Assert.assertEquals((long)-1L, (long)i);
        s = "x\u00a2\u20ac\ud852\udf62x\u00a2\u20ac\ud852\udf62";
        in = "x" + this.escape("\u00a2\u20ac\ud852\udf62") + "x" + this.escape("\u00a2\u20ac\ud852\udf62");
        r = new UonReader(new ParserPipe((Object)new SlowStringReader(in)), true);
        Assert.assertEquals((long)s.codePointAt(0), (long)r.readCodePoint());
        Assert.assertEquals((long)s.codePointAt(1), (long)r.readCodePoint());
        Assert.assertEquals((long)s.codePointAt(2), (long)r.readCodePoint());
        Assert.assertEquals((long)s.codePointAt(3), (long)r.readCodePoint());
        Assert.assertEquals((long)s.codePointAt(5), (long)r.readCodePoint());
        Assert.assertEquals((long)s.codePointAt(6), (long)r.readCodePoint());
        Assert.assertEquals((long)s.codePointAt(7), (long)r.readCodePoint());
        Assert.assertEquals((long)s.codePointAt(8), (long)r.readCodePoint());
        Assert.assertEquals((long)-1L, (long)r.readCodePoint());
    }

    private String escape(String s) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        byte[] b = s.getBytes("UTF-8");
        for (int i = 0; i < b.length; ++i) {
            sb.append('%').append(TestUtils.toHex(b[i]));
        }
        return sb.toString();
    }

    private UonReader r(String in, boolean decodeChars) throws Exception {
        return new UonReader(new ParserPipe((Object)in), decodeChars);
    }

    private static class SlowStringReader
    extends Reader {
        String s;
        int i = 0;

        SlowStringReader(String s) {
            this.s = s;
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            if (this.i >= this.s.length()) {
                return -1;
            }
            cbuf[off] = this.s.charAt(this.i++);
            return 1;
        }

        @Override
        public void close() throws IOException {
        }
    }
}

