/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.uon;

import java.util.function.Function;
import org.apache.juneau.XVar;
import org.apache.juneau.reflect.AnnotationList;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.svl.VarResolver;
import org.apache.juneau.svl.VarResolverSession;
import org.apache.juneau.uon.UonParser;
import org.apache.juneau.uon.UonParserSession;
import org.apache.juneau.uon.UonSerializer;
import org.apache.juneau.uon.UonSerializerSession;
import org.apache.juneau.uon.annotation.UonConfig;
import org.junit.Assert;
import org.junit.Test;

public class UonConfigAnnotationTest {
    private static final Function<Object, String> TO_STRING = new Function<Object, String>(){

        @Override
        public String apply(Object t) {
            return t.toString();
        }
    };
    static VarResolverSession sr = VarResolver.create().vars(new Class[]{XVar.class}).build().createSession();
    static ClassInfo a = ClassInfo.of(A.class);
    static ClassInfo b = ClassInfo.of(B.class);
    static ClassInfo c = ClassInfo.of(C.class);

    private static void check(String expected, Object o) {
        Assert.assertEquals((Object)expected, (Object)TO_STRING.apply(o));
    }

    @Test
    public void basicSerializer() throws Exception {
        AnnotationList al = a.getAnnotationList(null);
        UonSerializerSession x = UonSerializer.create().applyAnnotations(al, sr).build().createSession();
        UonConfigAnnotationTest.check("true", x.isAddBeanTypes());
        UonConfigAnnotationTest.check("true", x.isEncoding());
        UonConfigAnnotationTest.check("UON", x.getParamFormat());
    }

    @Test
    public void basicParser() throws Exception {
        AnnotationList al = a.getAnnotationList(null);
        UonParserSession x = UonParser.create().applyAnnotations(al, sr).build().createSession();
        UonConfigAnnotationTest.check("true", x.isDecoding());
        UonConfigAnnotationTest.check("true", x.isValidateEnd());
    }

    @Test
    public void noValuesSerializer() throws Exception {
        AnnotationList al = b.getAnnotationList(null);
        UonSerializerSession x = UonSerializer.create().applyAnnotations(al, sr).build().createSession();
        UonConfigAnnotationTest.check("false", x.isAddBeanTypes());
        UonConfigAnnotationTest.check("false", x.isEncoding());
        UonConfigAnnotationTest.check("UON", x.getParamFormat());
    }

    @Test
    public void noValuesParser() throws Exception {
        AnnotationList al = b.getAnnotationList(null);
        UonParserSession x = UonParser.create().applyAnnotations(al, sr).build().createSession();
        UonConfigAnnotationTest.check("false", x.isDecoding());
        UonConfigAnnotationTest.check("false", x.isValidateEnd());
    }

    @Test
    public void noAnnotationSerializer() throws Exception {
        AnnotationList al = c.getAnnotationList(null);
        UonSerializerSession x = UonSerializer.create().applyAnnotations(al, sr).build().createSession();
        UonConfigAnnotationTest.check("false", x.isAddBeanTypes());
        UonConfigAnnotationTest.check("false", x.isEncoding());
        UonConfigAnnotationTest.check("UON", x.getParamFormat());
    }

    @Test
    public void noAnnotationParser() throws Exception {
        AnnotationList al = c.getAnnotationList(null);
        UonParserSession x = UonParser.create().applyAnnotations(al, sr).build().createSession();
        UonConfigAnnotationTest.check("false", x.isDecoding());
        UonConfigAnnotationTest.check("false", x.isValidateEnd());
    }

    static class C {
        C() {
        }
    }

    @UonConfig
    static class B {
        B() {
        }
    }

    @UonConfig(addBeanTypes="$X{true}", decoding="$X{true}", encoding="$X{true}", paramFormat="$X{UON}", validateEnd="$X{true}")
    static class A {
        A() {
        }
    }
}

