/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.transforms;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanSession;
import org.apache.juneau.BeanSessionArgs;
import org.apache.juneau.testutils.TestUtils;
import org.apache.juneau.transform.StringSwap;
import org.apache.juneau.transforms.RoundTripStringSwapTest;
import org.apache.juneau.transforms.TemporalCalendarSwap;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TemporalCalendarSwapTest
extends RoundTripStringSwapTest<Calendar> {
    private static BeanSession BS_DEFAULT = BeanContext.DEFAULT.createBeanSession();
    private static BeanSession BS_PST = BeanContext.DEFAULT.createBeanSession(BeanSessionArgs.create().timeZone(TimeZone.getTimeZone("PST")));
    private static GregorianCalendar T_Calendar = GregorianCalendar.from(ZonedDateTime.from(DateTimeFormatter.ISO_ZONED_DATE_TIME.parse("2012-12-21T12:34:56Z")));

    @BeforeClass
    public static void beforeClass() {
        TestUtils.setTimeZone("GMT-5");
    }

    @AfterClass
    public static void afterClass() {
        TestUtils.unsetTimeZone();
    }

    public TemporalCalendarSwapTest(String label, Calendar o, StringSwap<Calendar> s, String r, BeanSession bs) throws Exception {
        super(label, o, s, r, bs);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getPairs() {
        return Arrays.asList({"[0] BasicIsoDate, Default timezone", T_Calendar, new TemporalCalendarSwap.BasicIsoDate(), "20121221-0500", BS_DEFAULT}, {"[1] BasicIsoDate, Pacific timezone", T_Calendar, new TemporalCalendarSwap.BasicIsoDate(), "20121221-0500", BS_PST}, {"[2] IsoDate, Default timezone", T_Calendar, new TemporalCalendarSwap.IsoDate(), "2012-12-21-05:00", BS_DEFAULT}, {"[3] IsoDate, Pacific timezone", T_Calendar, new TemporalCalendarSwap.IsoDate(), "2012-12-21-05:00", BS_PST}, {"[4] IsoDateTime, Default timezone", T_Calendar, new TemporalCalendarSwap.IsoDateTime(), "2012-12-21T07:34:56-05:00[GMT-05:00]", BS_DEFAULT}, {"[5] IsoDateTime, Pacific timezone", T_Calendar, new TemporalCalendarSwap.IsoDateTime(), "2012-12-21T07:34:56-05:00[GMT-05:00]", BS_PST}, {"[6] IsoInstant, Default timezone", T_Calendar, new TemporalCalendarSwap.IsoInstant(), "2012-12-21T12:34:56Z", BS_DEFAULT}, {"[7] IsoInstant, Pacific timezone", T_Calendar, new TemporalCalendarSwap.IsoInstant(), "2012-12-21T12:34:56Z", BS_PST}, {"[8] IsoLocalDate, Default timezone", T_Calendar, new TemporalCalendarSwap.IsoLocalDate(), "2012-12-21", BS_DEFAULT}, {"[9] IsoLocalDate, Pacific timezone", T_Calendar, new TemporalCalendarSwap.IsoLocalDate(), "2012-12-21", BS_PST}, {"[10] IsoLocalDateTime, Default timezone", T_Calendar, new TemporalCalendarSwap.IsoLocalDateTime(), "2012-12-21T07:34:56", BS_DEFAULT}, {"[11] IsoLocalDateTime, Pacific timezone", T_Calendar, new TemporalCalendarSwap.IsoLocalDateTime(), "2012-12-21T07:34:56", BS_PST}, {"[12] IsoLocalTime, Default timezone", T_Calendar, new TemporalCalendarSwap.IsoLocalTime(), "07:34:56", BS_DEFAULT}, {"[13] IsoLocalTime, Pacific timezone", T_Calendar, new TemporalCalendarSwap.IsoLocalTime(), "07:34:56", BS_PST}, {"[14] IsoOffsetDate, Default timezone", T_Calendar, new TemporalCalendarSwap.IsoOffsetDate(), "2012-12-21-05:00", BS_DEFAULT}, {"[15] IsoOffsetDate, Pacific timezone", T_Calendar, new TemporalCalendarSwap.IsoOffsetDate(), "2012-12-21-05:00", BS_PST}, {"[16] IsoOffsetDateTime, Default timezone", T_Calendar, new TemporalCalendarSwap.IsoOffsetDateTime(), "2012-12-21T07:34:56-05:00", BS_DEFAULT}, {"[17] IsoOffsetDateTime, Pacific timezone", T_Calendar, new TemporalCalendarSwap.IsoOffsetDateTime(), "2012-12-21T07:34:56-05:00", BS_PST}, {"[18] IsoOffsetTime, Default timezone", T_Calendar, new TemporalCalendarSwap.IsoOffsetTime(), "07:34:56-05:00", BS_DEFAULT}, {"[19] IsoOffsetTime, Pacific timezone", T_Calendar, new TemporalCalendarSwap.IsoOffsetTime(), "07:34:56-05:00", BS_PST}, {"[20] IsoOrdinalDate, Default timezone", T_Calendar, new TemporalCalendarSwap.IsoOrdinalDate(), "2012-356-05:00", BS_DEFAULT}, {"[21] IsoOrdinalDate, Pacific timezone", T_Calendar, new TemporalCalendarSwap.IsoOrdinalDate(), "2012-356-05:00", BS_PST}, {"[22] IsoTime, Default timezone", T_Calendar, new TemporalCalendarSwap.IsoTime(), "07:34:56-05:00", BS_DEFAULT}, {"[23] IsoTime, Pacific timezone", T_Calendar, new TemporalCalendarSwap.IsoTime(), "07:34:56-05:00", BS_PST}, {"[24] IsoWeekDate, Default timezone", T_Calendar, new TemporalCalendarSwap.IsoWeekDate(), "2012-W51-5-05:00", BS_DEFAULT}, {"[25] IsoWeekDate, Pacific timezone", T_Calendar, new TemporalCalendarSwap.IsoWeekDate(), "2012-W51-5-05:00", BS_PST}, {"[26] IsoZonedDateTime, Default timezone", T_Calendar, new TemporalCalendarSwap.IsoZonedDateTime(), "2012-12-21T07:34:56-05:00[GMT-05:00]", BS_DEFAULT}, {"[27] IsoZonedDateTime, Pacific timezone", T_Calendar, new TemporalCalendarSwap.IsoZonedDateTime(), "2012-12-21T07:34:56-05:00[GMT-05:00]", BS_PST}, {"[28] Rfc1123DateTime, Default timezone", T_Calendar, new TemporalCalendarSwap.Rfc1123DateTime(), "Fri, 21 Dec 2012 07:34:56 -0500", BS_DEFAULT}, {"[29] Rfc1123DateTime, Pacific timezone", T_Calendar, new TemporalCalendarSwap.Rfc1123DateTime(), "Fri, 21 Dec 2012 07:34:56 -0500", BS_PST}, {"[30] YEAR, Default timezone", T_Calendar, new TemporalCalendarSwap("uuuu"), "2012", BS_DEFAULT}, {"[31] YEAR, Pacific timezone", T_Calendar, new TemporalCalendarSwap("uuuu"), "2012", BS_DEFAULT}, {"[32] BasicIsoDate, null", null, new TemporalCalendarSwap.BasicIsoDate(), null, BS_DEFAULT});
    }

    static {
        T_Calendar.setTimeZone(TimeZone.getTimeZone("GMT-5"));
    }
}

