/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.transforms;

import org.apache.juneau.BeanSession;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.transform.StringSwap;
import org.junit.Assert;
import org.junit.Test;

public abstract class RoundTripStringSwapTest<T> {
    private final String label;
    private final T o;
    private final StringSwap<T> ss;
    private final String expected;
    private final BeanSession bs;

    public RoundTripStringSwapTest(String label, T o, StringSwap<T> ss, String expected, BeanSession bs) throws Exception {
        this.label = label;
        this.o = o;
        this.ss = ss;
        this.expected = expected;
        this.bs = bs;
    }

    @Test
    public void testSwap() throws Exception {
        String s = this.ss.swap(this.bs, this.o);
        if (!StringUtils.isEquals((String)this.expected, (String)s)) {
            if (this.expected.isEmpty()) {
                if (!this.label.startsWith("[]")) {
                    System.err.println(this.label.substring(0, this.label.indexOf(93) + 1) + " " + s);
                }
                Assert.fail();
            } else {
                this.fail("Test [{0} swap] failed.  Expected=[{1}], Actual=[{2}]", this.label, this.expected, s);
            }
        }
    }

    @Test
    public void testUnswap() throws Exception {
        Object o2;
        String s2;
        String s = this.ss.swap(this.bs, this.o);
        if (!StringUtils.isEquals((String)s, (String)(s2 = this.ss.swap(this.bs, o2 = this.ss.unswap(this.bs, s, this.bs.getClassMetaForObject(this.o)))))) {
            if (this.expected.isEmpty()) {
                Assert.fail();
            }
            System.err.println("s=[" + s + "], o=[" + this.o + "], o.type=[" + this.o.getClass().getName() + "], o2=[" + o2 + "], o2.type=[" + o2.getClass().getName() + "]");
            this.fail("Test [{0} unswap] failed.  Expected=[{1}], Actual=[{2}]", this.label, s, s2);
        }
    }

    private void fail(String msg, Object ... args) {
        String s = StringUtils.format((String)msg, (Object[])args);
        System.err.println(s);
        Assert.fail((String)s);
    }
}

